/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class WallpadHSPlatformDeviceData
extends wallpaddbmgr {
    private static final String TAG = "HSPlatformDeviceData";
    public static final String HSPlatformDeviceAdd_BR = "HS_PLATFORM_DEVICE_ADD_BR";
    public static final int AUTH_NUMBER = 2;
    public static final int ADD_FINISH = 3;
    public static final String HSPlatformDeviceCertif_BR = "HS_PLATFORM_DEVICE_CERTIF_BR";
    public static final int CERTIFICATE_FINISH = 3;
    public static final String HSPlatformDeviceDel_BR = "HS_PLATFORM_DEVICE_DEL_BR";
    public static final String HSPlatformDeviceCancel_BR = "HS_PLATFORM_DEVICE_CANCEL_BR";

    public WallpadHSPlatformDeviceData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("HSPlatformDeviceDB")) {
            try {
                Log.i((String)TAG, (String)"[Create] CreateHSPlarformDeviceDB");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table HSPlatformDeviceDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, uid text, name text, id text, certification INTEGER, regdate DATE DEFAULT (datetime('now','localtime')));");
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Create] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    public int Register(String Uid, String Name, String Id) {
        if (Uid == null) {
            Log.w((String)TAG, (String)"[Update] Param - Uid  is null !!!");
            return -1;
        }
        if (Name == null) {
            Log.w((String)TAG, (String)"[Update] Param - Name  is null !!!");
            return -2;
        }
        if (Id == null) {
            Log.w((String)TAG, (String)"[Update] Param - Id  is null !!!");
            return -3;
        }
        int ret = 0;
        int ExistId = this.isExistHSPlatformDevice(Uid);
        if (ExistId > 0) {
            Log.w((String)TAG, (String)"[Register] isExistHSPlatformDevice - Find !!!");
            this.DeleteEachUid(Uid);
        }
        ContentValues values = new ContentValues();
        values.put("uid", Uid);
        values.put("name", Name);
        values.put("id", Id);
        if (this.wdb != null) {
            ret = (int)this.wdb.insert("HSPlatformDeviceDB", null, values);
        }
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public void setCertifiCation(String Uid, int nSet) {
        if (Uid == null) {
            Log.w((String)TAG, (String)"[setCertifiCation] Param - Uid  is null !!!");
            return;
        }
        String sqlStr = "UPDATE HSPlatformDeviceDB set certification = '" + nSet + "' where uid = \"" + Uid + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void DeleteEachUid(String Uid) {
        if (Uid == null) {
            Log.w((String)TAG, (String)"[Update] Param - Uid  is null !!!");
            return;
        }
        String sqlStr = "DELETE FROM HSPlatformDeviceDB where uid=\"" + Uid + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void DeleteEachName(String name) {
        if (name == null) {
            Log.w((String)TAG, (String)"[Update] Param - name  is null !!!");
            return;
        }
        String sqlStr = "DELETE FROM HSPlatformDeviceDB where name=\"" + name + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void UnRegisterAll() {
        String sqlStr = "DELETE FROM HSPlatformDeviceDB;";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public int isExistHSPlatformDevice(String Uid) {
        String query = "select count(*) from HSPlatformDeviceDB where uid=\"" + Uid + "\";";
        String getdata = null;
        if (Uid == null) {
            Log.w((String)TAG, (String)"[isExistHSPlatformDevice] Param - Uid  is null !!!");
            return -10;
        }
        try {
            Cursor cursor;
            if (this.wdb != null && (cursor = this.wdb.rawQuery(query, null)) != null) {
                while (cursor.moveToNext()) {
                    getdata = cursor.getString(0).trim();
                }
                cursor.close();
                return Integer.parseInt(getdata);
            }
            return -999;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -999;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", TAG, e);
            return -999;
        }
    }

    public List<HSPlatformDeviceClass> GetHSPlatformDeviceData() {
        ArrayList<HSPlatformDeviceClass> SyncData = new ArrayList<HSPlatformDeviceClass>();
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select seqnum, uid, name, id, certification, regdate from HSPlatformDeviceDB order by regdate asc;", null);
            try {
                while (cursor.moveToNext()) {
                    HSPlatformDeviceClass getdata = new HSPlatformDeviceClass();
                    getdata.seq = cursor.getInt(0);
                    getdata.Uid = cursor.getString(1);
                    getdata.Name = cursor.getString(2);
                    getdata.Id = cursor.getString(3);
                    getdata.certification = cursor.getInt(4);
                    getdata.regdate = cursor.getString(5);
                    SyncData.add(getdata);
                }
                cursor.close();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                SyncData.clear();
                return null;
            }
            catch (Exception e) {
                cursor.close();
                SyncData.clear();
                Log.e((String)TAG, (String)"[GetHSPlatformDeviceData] Exception Error");
                LogUtil.errorLogInfo("", TAG, e);
                return null;
            }
        }
        return SyncData;
    }

    public String ToDebugHSPlatformDeviceData(List<HSPlatformDeviceClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "HSPlatformDeviceClass\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            HSPlatformDeviceClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString();
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public static class HSPlatformDeviceClass {
        public int seq = -1;
        public String Uid = null;
        public String Name = null;
        public String Id = null;
        public int certification = 0;
        public String regdate = null;

        public String ToDebugString() {
            String retStr = "==========================\r\nseq             : " + this.seq + "\r\n==========================\r\nUid            : " + this.Uid + "\r\nName           : " + this.Name + "\r\nId             : " + this.Id + "\r\ncertification  : " + this.certification + "\r\nregdate        : " + this.regdate + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }
}

