/*
 * Decompiled with CFR 0.152.
 */
package de.re.easymodbus.server;

import de.re.easymodbus.server.ModbusServer;
import de.re.easymodbus.server.ProcessReceivedDataThread;
import java.io.InputStream;
import java.net.Socket;

class ClientConnectionThread
extends Thread {
    private Socket socket;
    private byte[] inBuffer = new byte[1024];
    ModbusServer easyModbusTCPServer;

    public ClientConnectionThread(Socket socket, ModbusServer easyModbusTCPServer) {
        this.easyModbusTCPServer = easyModbusTCPServer;
        this.socket = socket;
    }

    @Override
    public void run() {
        this.easyModbusTCPServer.setNumberOfConnectedClients(this.easyModbusTCPServer.getNumberOfConnectedClients() + 1);
        try {
            this.socket.setSoTimeout(this.easyModbusTCPServer.getClientConnectionTimeout());
            InputStream inputStream = this.socket.getInputStream();
            while (this.socket.isConnected() & !this.socket.isClosed() & this.easyModbusTCPServer.getServerRunning()) {
                int numberOfBytes = inputStream.read(this.inBuffer);
                if (numberOfBytes > 4) {
                    new ProcessReceivedDataThread(this.inBuffer, this.easyModbusTCPServer, this.socket).start();
                }
                Thread.sleep(5L);
            }
            this.easyModbusTCPServer.setNumberOfConnectedClients(this.easyModbusTCPServer.getNumberOfConnectedClients() - 1);
            this.socket.close();
        }
        catch (Exception e) {
            this.easyModbusTCPServer.setNumberOfConnectedClients(this.easyModbusTCPServer.getNumberOfConnectedClients() - 1);
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
    }
}

