/*
 * Decompiled with CFR 0.152.
 */
package bssoft.stack.sip;

import bssoft.stack.sip.SIPStack;
import java.util.StringTokenizer;

public class SIPHeader {
    public String header = null;
    public String headerValue = null;
    public int headerType = SIPStack.SIP_HEADERTYPE_NONE;
    public boolean flag = false;

    public SIPHeader(String message, int headerType) {
        String compactKeyWord = null;
        if (message != null) {
            int iE;
            int iS;
            String keyWord;
            if (headerType == SIPStack.SIP_HEADERTYPE_ACCEPT) {
                keyWord = "Accept: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ACCEPTENCODING) {
                keyWord = "Accept-Encoding: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ACCEPTLANGUAGE) {
                keyWord = "Accept-Language: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ALERTINFO) {
                keyWord = "Alert-Info: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ALLOW) {
                keyWord = "Allow: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ALLOWEVENTS) {
                keyWord = "Allow-Events: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_AUTHENTICATIONINFO) {
                keyWord = "Authentication-Info: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_AUTHORIZATION) {
                keyWord = "Authorization: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CALLID) {
                keyWord = "Call-ID: ";
                compactKeyWord = "i: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CALLINFO) {
                keyWord = "Call-Info: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CONTACT) {
                keyWord = "Contact: ";
                compactKeyWord = "m: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CONTENTDISPOSITION) {
                keyWord = "Content-Disposition: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CONTENTENCODING) {
                keyWord = "Content-Encoding: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CONTENTLANGUAGE) {
                keyWord = "Content-Language: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CONTENTLENGTH) {
                keyWord = "Content-Length: ";
                compactKeyWord = "l: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CONTENTTYPE) {
                keyWord = "Content-Type: ";
                compactKeyWord = "c: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_CSEQ) {
                keyWord = "CSeq: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_DATE) {
                keyWord = "Date: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_EVENT) {
                keyWord = "Event: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ERRORINFO) {
                keyWord = "Error-Info: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_EXPIRES) {
                keyWord = "Expires: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_FROM) {
                keyWord = "From: ";
                compactKeyWord = "f: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_INREPLYTO) {
                keyWord = "In-Reply-To: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_MAXFORWARDS) {
                keyWord = "Max-Forwards: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_MINEXPIRES) {
                keyWord = "Min-Expires: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_MIMEVERSION) {
                keyWord = "MIME-Version: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ORGANIZATION) {
                keyWord = "Organization: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_PRIORITY) {
                keyWord = "Priority: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE) {
                keyWord = "Proxy-Authenticate: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_PROXYAUTHORIZATION) {
                keyWord = "Proxy-Authorization: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_PROXYREQUIRE) {
                keyWord = "Proxy-Require: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_PASSERTEDIDENTITY) {
                keyWord = "P-Asserted-Identity: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_RECORDROUTE) {
                keyWord = "Record-Route: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_REPLYTO) {
                keyWord = "Reply-To: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_REQUIRE) {
                keyWord = "Require: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_RETRYAFTER) {
                keyWord = "Retry-After: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_ROUTE) {
                keyWord = "Route: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_SERVER) {
                keyWord = "Server: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_SUBJECT) {
                keyWord = "Subject: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_SUPPORTED) {
                keyWord = "Supported: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_TIMESTAMP) {
                keyWord = "Timestamp: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_TO) {
                keyWord = "To: ";
                compactKeyWord = "t: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_UNSUPPORTED) {
                keyWord = "Unsupported: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_USERAGENT) {
                keyWord = "User-Agent: ";
            } else if (headerType == SIPStack.SIP_HEADERTYPE_VIA) {
                keyWord = "Via: ";
                compactKeyWord = "v: ";
            } else {
                keyWord = headerType == SIPStack.SIP_HEADERTYPE_WARNING ? "Warning: " : (headerType == SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE ? "WWW-Authenticate: " : (headerType == SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE ? "Www-Authenticate: " : null));
            }
            if (keyWord != null) {
                iS = message.indexOf(keyWord);
                iE = 0;
                if (iS >= 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS);
                    if (iE > 0) {
                        this.header = message.substring(iS, iE);
                        this.headerValue = message.substring(iS + keyWord.length(), iE);
                        this.headerType = headerType;
                        this.flag = true;
                    }
                } else {
                    this.flag = false;
                }
            }
            if (!this.flag && compactKeyWord != null) {
                iS = message.indexOf(compactKeyWord);
                iE = 0;
                if (iS >= 0) {
                    iE = message.indexOf(SIPStack.SIP_LINE_END, iS);
                    if (iE > 0) {
                        this.header = message.substring(iS, iE);
                        this.headerValue = message.substring(iS + compactKeyWord.length(), iE);
                        this.headerType = headerType;
                        this.flag = true;
                    }
                } else {
                    this.flag = false;
                }
            }
        }
    }

    public int callSequenceNumber() {
        int seqCode = 0;
        if (this.headerType == SIPStack.SIP_HEADERTYPE_CSEQ && this.header != null && this.header.length() > 0) {
            StringTokenizer tokenArray = new StringTokenizer(this.header, " ", true);
            int tokenCount = 0;
            while (tokenArray.hasMoreTokens()) {
                String token = tokenArray.nextToken();
                if (token.length() <= 0 || token.compareTo(" ") == 0 || ++tokenCount != 2) continue;
                seqCode = Integer.parseInt(token);
                break;
            }
        }
        return seqCode;
    }

    public String getTag() {
        String tag = null;
        if ((this.headerType == SIPStack.SIP_HEADERTYPE_FROM || this.headerType == SIPStack.SIP_HEADERTYPE_TO) && this.header != null && this.header.length() > 0) {
            StringTokenizer tokenArray = new StringTokenizer(this.header, ";", true);
            while (tokenArray.hasMoreTokens()) {
                String token = tokenArray.nextToken();
                if (token.length() <= 0 || !token.startsWith("tag=")) continue;
                tag = token.substring(4);
                break;
            }
        }
        return tag;
    }

    public String getId() {
        String id = "";
        if ((this.headerType == SIPStack.SIP_HEADERTYPE_FROM || this.headerType == SIPStack.SIP_HEADERTYPE_TO) && this.header != null && this.header.length() > 0) {
            int iS = 0;
            int iE = 0;
            iS = this.header.indexOf("sip:");
            if (iS > 0 && (iE = this.header.indexOf("@", iS)) > 0) {
                id = this.header.substring(iS + 4, iE).trim();
            }
        }
        return id;
    }

    public String getFieldValue(String fieldName) {
        if (this.headerValue == null || this.headerValue.length() <= 0) {
            return null;
        }
        if (fieldName == null || fieldName.length() <= 0) {
            return null;
        }
        StringTokenizer tokenArray = new StringTokenizer(this.headerValue, ";><", true);
        String keyWord = String.valueOf(fieldName) + "=";
        String fieldValue = null;
        while (tokenArray.hasMoreTokens()) {
            String token = tokenArray.nextToken().trim();
            if (token.length() <= 0 || !token.startsWith(keyWord)) continue;
            fieldValue = token.substring(keyWord.length());
            break;
        }
        return fieldValue;
    }
}

