/*
 * Decompiled with CFR 0.152.
 */
package de.re.easymodbus.modbusclient.gui;

import de.re.easymodbus.modbusclient.ModbusClient;
import de.re.easymodbus.modbusclient.ReceiveDataChangedListener;
import de.re.easymodbus.modbusclient.SendDataChangedListener;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class EasyModbusTcpClient
extends JFrame
implements ReceiveDataChangedListener,
SendDataChangedListener {
    JComboBox comboBox;
    private ModbusClient modbusClient;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JList<String> jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextField jTextFieldIPAddress;
    private JTextField jTextFieldNumberOfValues;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldStartingAddress;
    private JPanel jpModbusTCP;
    private JPanel jpModbusRTU;
    private JLabel lblComport;
    private JTextField txtCom;
    private JTextField textField_1;
    private JLabel lblSlaveid;

    public EasyModbusTcpClient() {
        this.initComponents();
        this.modbusClient = new ModbusClient();
        this.modbusClient.addReveiveDataChangedListener(this);
        this.modbusClient.addSendDataChangedListener(this);
    }

    @Override
    public void ReceiveDataChanged() {
        this.jTextArea1.append("Rx:");
        int i = 0;
        while (i < this.modbusClient.receiveData.length) {
            this.jTextArea1.append(" ");
            if (this.modbusClient.receiveData[i] < 16) {
                this.jTextArea1.append("0");
            }
            this.jTextArea1.append(Integer.toHexString(this.modbusClient.receiveData[i]));
            ++i;
        }
        this.jTextArea1.append("\n");
    }

    @Override
    public void SendDataChanged() {
        this.jTextArea1.append("Tx:");
        int i = 0;
        while (i < this.modbusClient.sendData.length) {
            this.jTextArea1.append(" ");
            if (this.modbusClient.sendData[i] < 16) {
                this.jTextArea1.append("0");
            }
            this.jTextArea1.append(Integer.toHexString(this.modbusClient.sendData[i]));
            ++i;
        }
        this.jTextArea1.append("\n");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextFieldStartingAddress = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldNumberOfValues = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setToolTipText("");
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EasyModbusTcpClient.this.jLabel1MouseClicked(evt);
            }
        });
        this.jButton1.setText("Read Coils - FC1");
        this.jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EasyModbusTcpClient.this.jButton1MouseClicked(evt);
            }
        });
        this.jButton2.setText("Read Discrete Inputs - FC2");
        this.jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EasyModbusTcpClient.this.jButton2MouseClicked(evt);
            }
        });
        this.jButton3.setText("Read Holding Registers - FC3");
        this.jButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EasyModbusTcpClient.this.jButton3MouseClicked(evt);
            }
        });
        this.jButton4.setText("Read Input Registers - FC4");
        this.jButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EasyModbusTcpClient.this.jButton4MouseClicked(evt);
            }
        });
        this.jLabel5.setText("Starting Address");
        this.jTextFieldStartingAddress.setText("1");
        this.jLabel6.setText("Number of Values");
        this.jTextFieldNumberOfValues.setText("1");
        this.jScrollPane1.setViewportView(this.jList1);
        this.jLabel2.setForeground(new Color(0, 0, 204));
        this.jLabel2.setText("http://www.EasyModbusTCP.net");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jTextFieldStartingAddress, -2, 48, -2).addComponent(this.jTextFieldNumberOfValues, -2, 48, -2)).addGap(10).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addComponent(this.jLabel2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21).addComponent(this.jLabel2).addGap(46).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldStartingAddress, -2, -1, -2).addGap(18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNumberOfValues, -2, -1, -2)).addComponent(this.jScrollPane1, -2, 155, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setLayout(jPanel1Layout);
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if ((String)arg0.getItem() == "Modbus TCP") {
                    EasyModbusTcpClient.this.modbusClient = new ModbusClient();
                    EasyModbusTcpClient.this.jpModbusTCP.setVisible(true);
                    EasyModbusTcpClient.this.jpModbusRTU.setVisible(false);
                } else {
                    EasyModbusTcpClient.this.modbusClient = new ModbusClient();
                    EasyModbusTcpClient.this.jpModbusRTU.setVisible(true);
                    EasyModbusTcpClient.this.jpModbusTCP.setVisible(false);
                }
            }
        });
        this.comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Modbus TCP", "Modbus RTU"}));
        this.jpModbusTCP = new JPanel();
        this.jpModbusRTU = new JPanel();
        this.jpModbusRTU.setVisible(false);
        this.lblComport = new JLabel();
        this.lblComport.setText("COM-Port");
        this.txtCom = new JTextField();
        this.txtCom.setToolTipText("");
        this.txtCom.setText("COM1");
        this.textField_1 = new JTextField();
        this.textField_1.setText("1");
        this.lblSlaveid = new JLabel();
        this.lblSlaveid.setText("Slave-ID");
        GroupLayout gl_jpModbusRTU = new GroupLayout(this.jpModbusRTU);
        gl_jpModbusRTU.setHorizontalGroup(gl_jpModbusRTU.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 174, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, gl_jpModbusRTU.createSequentialGroup().addContainerGap().addGroup(gl_jpModbusRTU.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblComport).addComponent(this.txtCom, -2, 108, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_jpModbusRTU.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_jpModbusRTU.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSlaveid, -1, 46, Short.MAX_VALUE)).addComponent(this.textField_1, -2, 46, -2)).addContainerGap()));
        gl_jpModbusRTU.setVerticalGroup(gl_jpModbusRTU.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 51, Short.MAX_VALUE).addGroup(gl_jpModbusRTU.createSequentialGroup().addGroup(gl_jpModbusRTU.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblComport).addComponent(this.lblSlaveid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_jpModbusRTU.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textField_1, -2, -1, -2).addComponent(this.txtCom, -2, -1, -2)).addContainerGap()));
        this.jpModbusRTU.setLayout(gl_jpModbusRTU);
        this.jTextArea1 = new JTextArea();
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(new Color(204, 204, 204));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.comboBox, -2, 174, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -1, 174, Short.MAX_VALUE)).addComponent(this.jButton2, -1, 174, Short.MAX_VALUE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, -1, -1, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jpModbusTCP, -2, 174, -2)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jpModbusRTU, -2, 174, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextArea1))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(11).addComponent(this.comboBox, -2, -1, -2).addGap(7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jpModbusTCP, -2, -1, -2).addGap(2).addComponent(this.jpModbusRTU, -2, 51, -2).addGap(18).addComponent(this.jButton1).addGap(11).addComponent(this.jButton2).addGap(11).addComponent(this.jButton3).addGap(11).addComponent(this.jButton4))).addGap(6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jScrollPane2, -2, 103, -2).addComponent(this.jTextArea1, -2, 101, -2))));
        this.jLabel3 = new JLabel();
        this.jLabel3.setText("IP-Address");
        this.jLabel4 = new JLabel();
        this.jLabel4.setText("Port");
        this.jTextFieldIPAddress = new JTextField();
        this.jTextFieldIPAddress.setText("127.0.0.1");
        this.jTextFieldIPAddress.setToolTipText("");
        this.jTextFieldPort = new JTextField();
        this.jTextFieldPort.setText("502");
        GroupLayout gl_jpModbusTCP = new GroupLayout(this.jpModbusTCP);
        gl_jpModbusTCP.setHorizontalGroup(gl_jpModbusTCP.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_jpModbusTCP.createSequentialGroup().addContainerGap().addGroup(gl_jpModbusTCP.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_jpModbusTCP.createSequentialGroup().addComponent(this.jLabel3).addGap(75)).addGroup(gl_jpModbusTCP.createSequentialGroup().addComponent(this.jTextFieldIPAddress, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(gl_jpModbusTCP.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPort, -2, 46, -2).addComponent(this.jLabel4)).addContainerGap()));
        gl_jpModbusTCP.setVerticalGroup(gl_jpModbusTCP.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_jpModbusTCP.createSequentialGroup().addGroup(gl_jpModbusTCP.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_jpModbusTCP.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPort, -2, -1, -2).addComponent(this.jTextFieldIPAddress, -2, -1, -2)).addContainerGap()));
        this.jpModbusTCP.setLayout(gl_jpModbusTCP);
        this.getContentPane().setLayout(groupLayout);
        this.pack();
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI("www.easymodbustcp.net"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void jButton1MouseClicked(MouseEvent evt) {
        if (!this.modbusClient.isConnected()) {
            if (this.comboBox.getSelectedItem() == "Modbus TCP") {
                this.modbusClient.setipAddress(this.jTextFieldIPAddress.getText());
                this.modbusClient.setPort(Integer.valueOf(this.jTextFieldPort.getText()));
                try {
                    this.modbusClient.Connect();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            } else {
                try {
                    this.modbusClient.setUnitIdentifier((byte)1);
                    this.modbusClient.Connect(this.txtCom.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            }
        }
        DefaultListModel<Boolean> listModel = new DefaultListModel<Boolean>();
        int startingAddress = Integer.valueOf(this.jTextFieldStartingAddress.getText()) - 1;
        int numberOfValues = Integer.valueOf(this.jTextFieldNumberOfValues.getText());
        try {
            boolean[] serverResponse = this.modbusClient.ReadCoils(startingAddress, numberOfValues);
            int i = 0;
            while (i < serverResponse.length) {
                listModel.addElement(serverResponse[i]);
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Server response error", "Connection failed", 2);
        }
        this.jList1.setModel(listModel);
    }

    private void jButton2MouseClicked(MouseEvent evt) {
        if (!this.modbusClient.isConnected()) {
            if (this.comboBox.getSelectedItem() == "Modbus TCP") {
                this.modbusClient.setipAddress(this.jTextFieldIPAddress.getText());
                this.modbusClient.setPort(Integer.valueOf(this.jTextFieldPort.getText()));
                try {
                    this.modbusClient.setUnitIdentifier((byte)1);
                    this.modbusClient.Connect();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            } else {
                try {
                    this.modbusClient.Connect(this.txtCom.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            }
        }
        DefaultListModel<Boolean> listModel = new DefaultListModel<Boolean>();
        int startingAddress = Integer.valueOf(this.jTextFieldStartingAddress.getText()) - 1;
        int numberOfValues = Integer.valueOf(this.jTextFieldNumberOfValues.getText());
        try {
            boolean[] serverResponse = this.modbusClient.ReadDiscreteInputs(startingAddress, numberOfValues);
            int i = 0;
            while (i < serverResponse.length) {
                listModel.addElement(serverResponse[i]);
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Server response error ", "Connection failed", 2);
        }
        this.jList1.setModel(listModel);
    }

    private void jButton3MouseClicked(MouseEvent evt) {
        if (!this.modbusClient.isConnected()) {
            if (this.comboBox.getSelectedItem() == "Modbus TCP") {
                this.modbusClient.setipAddress(this.jTextFieldIPAddress.getText());
                this.modbusClient.setPort(Integer.valueOf(this.jTextFieldPort.getText()));
                try {
                    this.modbusClient.Connect();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            } else {
                try {
                    this.modbusClient.Connect(this.txtCom.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            }
        }
        DefaultListModel<Integer> listModel = new DefaultListModel<Integer>();
        int startingAddress = Integer.valueOf(this.jTextFieldStartingAddress.getText()) - 1;
        int numberOfValues = Integer.valueOf(this.jTextFieldNumberOfValues.getText());
        try {
            int[] serverResponse = this.modbusClient.ReadHoldingRegisters(startingAddress, numberOfValues);
            int i = 0;
            while (i < serverResponse.length) {
                listModel.addElement(serverResponse[i]);
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Server response error", "Connection failed", 2);
        }
        this.jList1.setModel(listModel);
    }

    private void jButton4MouseClicked(MouseEvent evt) {
        if (!this.modbusClient.isConnected()) {
            if (this.comboBox.getSelectedItem() == "Modbus TCP") {
                this.modbusClient.setipAddress(this.jTextFieldIPAddress.getText());
                this.modbusClient.setPort(Integer.valueOf(this.jTextFieldPort.getText()));
                try {
                    this.modbusClient.Connect();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            } else {
                try {
                    this.modbusClient.Connect(this.txtCom.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Connection failed", "Connection failed", 2);
                }
            }
        }
        DefaultListModel<Integer> listModel = new DefaultListModel<Integer>();
        int startingAddress = Integer.valueOf(this.jTextFieldStartingAddress.getText()) - 1;
        int numberOfValues = Integer.valueOf(this.jTextFieldNumberOfValues.getText());
        try {
            int[] serverResponse = this.modbusClient.ReadInputRegisters(startingAddress, numberOfValues);
            int i = 0;
            while (i < serverResponse.length) {
                listModel.addElement(serverResponse[i]);
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Server response error", "Connection failed", 2);
        }
        this.jList1.setModel(listModel);
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(EasyModbusTcpClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(EasyModbusTcpClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(EasyModbusTcpClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(EasyModbusTcpClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EasyModbusTcpClient().setVisible(true);
            }
        });
    }
}

