/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.wallpadsupport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import kr.co.icontrols.wallpadsupport.WpadImageView;
import kr.co.icontrols.wallpadsupport.WpadScale;
import kr.co.icontrols.wallpadsupport.WpadUtil;

@SuppressLint(value={"ViewConstructor", "Recycle"})
public class WpadTextView
extends TextView {
    private boolean Create = false;
    private boolean mTouch = false;
    private int mButtonEvent = 1;
    private WpadImageView mButtonEventLinkImageView = null;
    private WpadTextView mButtonEventLinkTextView = null;

    public boolean getTouch() {
        return this.mTouch;
    }

    public WpadTextView(Context context, boolean touchUse, int w, int h, int gravity, int color2, int size, boolean bold, int Id) {
        super(context);
        this.mTouch = touchUse;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(WpadScale.getWidth(w), WpadScale.getHeight(h));
        super.setLayoutParams((ViewGroup.LayoutParams)params);
        switch (gravity) {
            case 3: 
            case 5: 
            case 17: {
                this.setGravity(gravity | 0x10);
                break;
            }
            default: {
                this.setGravity(gravity);
            }
        }
        this.setTextColor(color2);
        this.setTextSize(0, size);
        if (bold) {
            this.setTypeface(null, 1);
        } else {
            this.setTypeface(null, 0);
        }
        this.setId(Id);
        this.Create = true;
    }

    public void setTextSize(float size) {
        super.setTextSize(WpadScale.getWidth(size));
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, WpadScale.getWidth(size));
    }

    public MotionEvent setTouchFilter(MotionEvent event) {
        if (!this.Create) {
            event.setAction(-1);
            return event;
        }
        if (!this.mTouch) {
            event.setAction(-2);
            return event;
        }
        int MoveEvent = event.getAction();
        if (this.mTouch) {
            if (this.mButtonEvent == 3) {
                if (MoveEvent == 1) {
                    this.mButtonEvent = 1;
                    event.setAction(3);
                    this.sendButtonEventPass(1, true);
                    return event;
                }
                event.setAction(-3);
                return event;
            }
            if (this.mButtonEvent == 0 && MoveEvent == 2) {
                if (WpadUtil.PointerCancelCheck((View)this, event)) {
                    event.setAction(3);
                } else {
                    event.setAction(-4);
                    return event;
                }
            }
            MoveEvent = event.getAction();
            boolean RetToucheventOn = false;
            if (MoveEvent == 3) {
                this.mButtonEvent = MoveEvent;
            } else if (MoveEvent == 0) {
                if (this.mButtonEvent == 1) {
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                }
            } else if (MoveEvent == 1 && this.mButtonEvent == 0) {
                this.mButtonEvent = MoveEvent;
                RetToucheventOn = true;
            }
            if (!RetToucheventOn) {
                event.setAction(-5);
            }
        } else {
            event.setAction(-6);
        }
        if (MoveEvent == 0 || MoveEvent == 1) {
            this.sendButtonEventPass(MoveEvent, false);
        } else if (MoveEvent == 3) {
            this.sendButtonEventPass(2, true);
        }
        return event;
    }

    public boolean setButtonEvent(int MoveEvent, boolean PointerCancel) {
        if (!this.mTouch) {
            return false;
        }
        long Time = SystemClock.uptimeMillis();
        float x = 0.0f;
        float y = 0.0f;
        if (PointerCancel) {
            x = -1.0f;
            y = -1.0f;
        }
        MotionEvent sendevent = MotionEvent.obtain((long)Time, (long)Time, (int)MoveEvent, (float)x, (float)y, (int)0);
        this.dispatchTouchEvent(sendevent);
        return true;
    }

    public boolean setButtonEventLink(WpadImageView TargetImageView) {
        if (!this.mTouch) {
            return false;
        }
        if (this.mButtonEventLinkImageView != null && TargetImageView == null && this.mButtonEvent == 1) {
            this.mButtonEventLinkImageView.setButtonEvent(1, true);
        }
        this.mButtonEventLinkImageView = TargetImageView;
        return true;
    }

    public boolean setButtonEventLink(WpadTextView TargetTextView) {
        if (!this.mTouch) {
            return false;
        }
        if (this.mButtonEventLinkTextView != null && TargetTextView == null && this.mButtonEvent == 1) {
            this.mButtonEventLinkTextView.setButtonEvent(1, true);
        }
        this.mButtonEventLinkTextView = TargetTextView;
        return true;
    }

    private void sendButtonEventPass(int MoveEvent, boolean PointerCancel) {
        if (this.mButtonEventLinkImageView != null) {
            this.mButtonEventLinkImageView.setButtonEvent(MoveEvent, PointerCancel);
        }
        if (this.mButtonEventLinkTextView != null) {
            this.mButtonEventLinkTextView.setButtonEvent(MoveEvent, PointerCancel);
        }
    }
}

