/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.wallpadsupport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import kr.co.icontrols.wallpadsupport.LogUtil;
import kr.co.icontrols.wallpadsupport.Version;
import kr.co.icontrols.wallpadsupport.WpadActivity;
import kr.co.icontrols.wallpadsupport.WpadImageView;
import kr.co.icontrols.wallpadsupport.WpadSound;
import kr.co.icontrols.wallpadsupport.WpadTextView;
import kr.co.icontrols.wallpadsupport.WpadUtil;

@SuppressLint(value={"ViewConstructor"})
public class WpadScreen {
    private String TAG = "WpadScreen";
    private Context mContext;
    private RelativeLayout mLayout;
    private WpadSound mSound;
    private boolean mOnTouch;

    public Context getContext() {
        return this.mContext;
    }

    public RelativeLayout getLayout() {
        return this.mLayout;
    }

    public WpadScreen(Context context, RelativeLayout layout2) {
        this.mContext = context;
        this.mLayout = layout2;
        this.mSound = ((WpadActivity)this.getContext()).Sound();
        this.mOnTouch = ((WpadActivity)this.getContext()).getOnTouch();
    }

    protected void onClose() {
    }

    public void Close() {
        try {
            this.onClose();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - Close : " + e));
        }
    }

    protected void finish() {
        ((WpadActivity)this.getContext()).finish();
    }

    public WpadSound Sound() {
        return this.mSound;
    }

    public void setSoundNoRelease(boolean set) {
        ((WpadActivity)this.getContext()).setSoundNoRelease(set);
    }

    protected void onKeyDown(int keyCode, KeyEvent event) {
    }

    public void KeyDown(int keyCode, KeyEvent event) {
        try {
            this.onKeyDown(keyCode, event);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - onKeyDown : " + e));
        }
    }

    protected void onKeyUp(int keyCode, KeyEvent event) {
    }

    public void KeyUp(int keyCode, KeyEvent event) {
        try {
            this.onKeyUp(keyCode, event);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - onKeyUp : " + e));
        }
    }

    protected boolean setFinishTimerCreate(int nFinishTime) {
        return ((WpadActivity)this.getContext()).setFinishTimerCreate(nFinishTime);
    }

    protected boolean setFinishTimerReset() {
        WpadActivity cfr_ignored_0 = (WpadActivity)this.getContext();
        return WpadActivity.setFinishTimerReset();
    }

    protected boolean setFinishTimerDestroy() {
        return ((WpadActivity)this.getContext()).setFinishTimerDestroy();
    }

    protected int addBrActionFilter(String action) {
        return ((WpadActivity)this.getContext()).addBrActionFilter(action);
    }

    protected int removeBrActionFilter(String action) {
        return ((WpadActivity)this.getContext()).removeBrActionFilter(action);
    }

    protected void onBrReceive(Intent intent) {
    }

    public void BrReceive(Intent intent) {
        try {
            this.onBrReceive(intent);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - BrReceive : " + e));
        }
    }

    protected void setOnTouch(boolean set) {
        this.mOnTouch = set;
        ((WpadActivity)this.getContext()).setOnTouch(set);
    }

    protected boolean getOnTouch() {
        return this.mOnTouch;
    }

    protected void onTouchEvent(View v, MotionEvent event) {
        if (Version.bResidentSafetyCheck && event.getAction() == 1) {
            this.sendScreenTouchedBR();
        }
    }

    private void TouchEvent(View v, MotionEvent event) {
        try {
            this.onTouchEvent(v, event);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - TouchEvent (" + v.getId() + ", " + event.getAction() + ") " + e));
        }
    }

    public void ViewRegistration(RelativeLayout ParentsLayout, WpadImageView nImageView, int MarginLeft, int MarginTop) {
        if (ParentsLayout == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadImageView) - Param. ParentsLayout is null !!!");
            return;
        }
        if (nImageView == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadImageView) - Param. nImageView is null !!!");
            return;
        }
        WpadUtil.ViewRegistration(ParentsLayout, nImageView, MarginLeft, MarginTop);
        if (nImageView.getTouchKind() != 0) {
            this.TouchRegistration(nImageView);
        }
    }

    public void ViewMove(WpadImageView nImageView, int MarginLeft, int MarginTop) {
        if (nImageView == null) {
            Log.e((String)this.TAG, (String)"ViewMove (nImageView) - Param. nTextView is null !!!");
            return;
        }
        WpadUtil.ViewMove(nImageView, MarginLeft, MarginTop);
    }

    public void ViewRegistration(RelativeLayout ParentsLayout, WpadTextView nTextView, int MarginLeft, int MarginTop) {
        if (ParentsLayout == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadTextView) - Param. ParentsLayout is null !!!");
            return;
        }
        if (nTextView == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadTextView) - Param. nTextView is null !!!");
            return;
        }
        WpadUtil.ViewRegistration(ParentsLayout, nTextView, MarginLeft, MarginTop);
        if (nTextView.getTouch()) {
            this.TouchRegistration(nTextView);
        }
    }

    public void ViewMove(WpadTextView nTextView, int MarginLeft, int MarginTop) {
        if (nTextView == null) {
            Log.e((String)this.TAG, (String)"ViewMove (WpadTextView) - Param. nTextView is null !!!");
            return;
        }
        WpadUtil.ViewMove(nTextView, MarginLeft, MarginTop);
    }

    private void TouchRegistration(WpadImageView nImageView) {
        final WpadImageView TargetWpadImageView = nImageView;
        TargetWpadImageView.setOnTouchListener(new View.OnTouchListener(){
            boolean LongKeyEnable = false;
            int LongKeyCount = 0;
            Handler LongKeyHandler = null;

            @SuppressLint(value={"HandlerLeak"})
            public boolean onTouch(final View v, final MotionEvent event) {
                if (!WpadScreen.this.getOnTouch()) {
                    return false;
                }
                MotionEvent filterEvent = TargetWpadImageView.setTouchFilterNChangeImage(event);
                if (filterEvent.getAction() >= 0) {
                    WpadActivity.setFinishTimerReset();
                    if (!this.LongKeyEnable) {
                        WpadScreen.this.TouchEvent(v, event);
                    }
                    if (TargetWpadImageView.getTouchKind() == 2) {
                        int MoveEvent = event.getAction();
                        if (MoveEvent == 0) {
                            this.LongKeyHandler = new Handler(){

                                @SuppressLint(value={"HandlerLeak"})
                                public void handleMessage(Message msg) {
                                    if (msg.what == 0) {
                                        if (TargetWpadImageView.getButtonEventOff()) {
                                            if (LongKeyHandler != null) {
                                                LongKeyHandler.removeMessages(0);
                                                LongKeyHandler.removeMessages(1);
                                                LongKeyHandler = null;
                                            }
                                            if (LongKeyEnable) {
                                                event.setAction(6);
                                                WpadScreen.this.TouchEvent(v, event);
                                            }
                                            LongKeyEnable = false;
                                        } else {
                                            LongKeyEnable = true;
                                            event.setAction(5);
                                            WpadScreen.this.TouchEvent(v, event);
                                            LongKeyCount = 1;
                                            if (LongKeyHandler != null) {
                                                LongKeyHandler.sendEmptyMessageDelayed(1, 500L);
                                            }
                                        }
                                    } else if (msg.what == 1) {
                                        if (TargetWpadImageView.getButtonEventOff()) {
                                            if (LongKeyHandler != null) {
                                                LongKeyHandler.removeMessages(0);
                                                LongKeyHandler.removeMessages(1);
                                                LongKeyHandler = null;
                                            }
                                            if (LongKeyEnable) {
                                                event.setAction(6);
                                                WpadScreen.this.TouchEvent(v, event);
                                            }
                                            LongKeyEnable = false;
                                        } else {
                                            event.setAction(5);
                                            WpadScreen.this.TouchEvent(v, event);
                                            if (LongKeyHandler != null) {
                                                if (++LongKeyCount < 2) {
                                                    LongKeyHandler.sendEmptyMessageDelayed(1, 500L);
                                                } else {
                                                    LongKeyHandler.sendEmptyMessageDelayed(1, 150L);
                                                }
                                            }
                                        }
                                    } else {
                                        LongKeyHandler = null;
                                    }
                                }
                            };
                            this.LongKeyHandler.sendEmptyMessageDelayed(0, 500L);
                        } else if ((MoveEvent == 1 || MoveEvent == 3 || MoveEvent == -100) && this.LongKeyHandler != null) {
                            this.LongKeyHandler.removeMessages(0);
                            this.LongKeyHandler.removeMessages(1);
                            this.LongKeyHandler = null;
                            if (this.LongKeyEnable && MoveEvent == 1) {
                                event.setAction(6);
                                WpadScreen.this.TouchEvent(v, event);
                            }
                            this.LongKeyEnable = false;
                        }
                    }
                }
                return true;
            }
        });
    }

    private void TouchRegistration(WpadTextView nTextView) {
        final WpadTextView TargetWpadTextView = nTextView;
        TargetWpadTextView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!WpadScreen.this.getOnTouch()) {
                    return false;
                }
                MotionEvent filterEvent = TargetWpadTextView.setTouchFilter(event);
                if (filterEvent.getAction() >= 0) {
                    WpadActivity.setFinishTimerReset();
                    WpadScreen.this.TouchEvent(v, event);
                }
                return true;
            }
        });
    }

    protected boolean setChangeScreen(int nScreenId) {
        return ((WpadActivity)this.getContext()).ChangeScreen(nScreenId);
    }

    protected boolean setChangeScreen(int nScreenId, Intent intent) {
        return ((WpadActivity)this.getContext()).ChangeScreen(nScreenId, intent);
    }

    protected Intent getScreenIntent() {
        return ((WpadActivity)this.getContext()).getScreenIntent();
    }

    public void setResult(int resultCode, Intent data) {
        ((WpadActivity)this.getContext()).setResult(resultCode, data);
    }

    public void setPopupResult(Intent data) {
        ((WpadActivity)this.getContext()).setResult(10000, data);
    }

    protected void onPopupResult(Intent data) {
    }

    public void PopupResult(Intent data) {
        try {
            this.onPopupResult(data);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PopupResult   " + e));
        }
    }

    protected void onOutSideTouchExit() {
    }

    public void OutSideTouchExit() {
        try {
            this.onOutSideTouchExit();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - PopupResult   " + e));
        }
    }

    public void sendScreenTouchedBR() {
        try {
            Intent mIntent = new Intent();
            mIntent.setAction("NOTIFY_ACNAME_RESIDENT_SAFETY_CHECK");
            mIntent.putExtra("KIND", 4001);
            this.getContext().sendBroadcast(mIntent);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"[Exception] sendScreenTouchedBR()");
            LogUtil.errorLogInfo("", this.TAG, e);
        }
    }
}

