/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.wallpadsupport;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;
import kr.co.icontrols.wallpadsupport.LogUtil;
import kr.co.icontrols.wallpadsupport.Version;
import kr.co.icontrols.wallpadsupport.WpadImageView;
import kr.co.icontrols.wallpadsupport.WpadScale;
import kr.co.icontrols.wallpadsupport.WpadScreen;
import kr.co.icontrols.wallpadsupport.WpadSound;
import kr.co.icontrols.wallpadsupport.WpadTextView;
import kr.co.icontrols.wallpadsupport.WpadUtil;

public class WpadActivity
extends Activity {
    private String TAG = "WpadActivity";
    private Context mContext;
    private boolean mOnTouch = false;
    private WpadScreen mCurrentScreen = null;
    private Intent mNextScreenIntent = null;
    private boolean mNextScreenIntentLive = false;
    private WpadSound mSound = null;
    private boolean mSoundNoRelease = false;
    private List<String> mBrActionList = null;
    private BroadcastReceiver mWpadNotifyBR = null;
    private boolean mFinishBrEnable = false;
    private final String BR_APP_FINISH = "kr.co.icontrols.wallpad.BR_APP_FINISH";
    private static boolean mFinishTimerEnable = false;
    private static CountDownTimer mFinishTimer = null;
    private int mFinishTime = 0;
    public static final int POPUP_RESULT_OK = 10000;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this;
        WpadScale.Initializing((Context)this);
        this.mSound = new WpadSound((Context)this);
        this.mSoundNoRelease = false;
        this.mOnTouch = true;
        this.mBrActionList = new ArrayList<String>();
        this.mBrActionList.clear();
        this.mWpadNotifyBR = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String ActionName = intent.getAction();
                if (ActionName.equals("kr.co.icontrols.wallpad.BR_APP_FINISH")) {
                    Log.i((String)WpadActivity.this.TAG, (String)"finish - BR_APP_FINISH");
                    WpadActivity.this.finish();
                } else {
                    WpadActivity.this.BrReceive(intent);
                }
            }
        };
        this.setFinishBrEnable(true);
        Intent intent = this.getIntent();
        Intent PopupScreenDataIntent = (Intent)intent.getParcelableExtra("PopupScreenDataIntent");
        if (PopupScreenDataIntent != null) {
            this.setScreenIntent(PopupScreenDataIntent);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (!this.mBrActionList.isEmpty() && this.mWpadNotifyBR != null) {
            try {
                this.unregisterReceiver(this.mWpadNotifyBR);
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", this.TAG, re);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("[ExceptionError] - onDestroy->unregisterReceiver : " + e));
            }
        }
        if (!this.mSoundNoRelease) {
            this.mSound.Release();
            Log.i((String)this.TAG, (String)"onDestroy - Step 2-1");
        }
    }

    protected void onResume() {
        super.onResume();
        if (mFinishTimerEnable && this.mFinishTime > 0) {
            this.setFinishTimerCreate(this.mFinishTime);
        }
    }

    protected void onPause() {
        super.onPause();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    public void setCurrentScreen(WpadScreen screen) {
        if (screen == null && this.mCurrentScreen != null) {
            this.mCurrentScreen.Close();
        }
        this.mCurrentScreen = screen;
        if (!this.mNextScreenIntentLive) {
            this.mNextScreenIntent = null;
        }
        this.mNextScreenIntentLive = false;
    }

    public WpadScreen getCurrentScreen() {
        return this.mCurrentScreen;
    }

    protected boolean onChangeScreen(int nScreenId) {
        return true;
    }

    public boolean ChangeScreen(int nScreenId) {
        boolean bRet = false;
        try {
            bRet = this.onChangeScreen(nScreenId);
            this.mNextScreenIntentLive = false;
            this.mNextScreenIntent = null;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - ChangeScreen : " + e));
        }
        return bRet;
    }

    public boolean ChangeScreen(int nScreenId, Intent intent) {
        boolean bRet = false;
        if (intent != null) {
            this.mNextScreenIntentLive = true;
            this.mNextScreenIntent = new Intent(intent);
        } else {
            this.mNextScreenIntentLive = false;
            this.mNextScreenIntent = null;
        }
        try {
            bRet = this.onChangeScreen(nScreenId);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - ChangeScreen : " + e));
        }
        return bRet;
    }

    public Intent getScreenIntent() {
        return this.mNextScreenIntent;
    }

    public void setScreenIntent(Intent intent) {
        if (intent != null) {
            this.mNextScreenIntentLive = true;
            this.mNextScreenIntent = new Intent(intent);
        } else {
            this.mNextScreenIntentLive = false;
            this.mNextScreenIntent = null;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 10000 && this.mCurrentScreen != null) {
            this.mCurrentScreen.PopupResult(data);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (Version.bResidentSafetyCheck && event.getAction() == 1) {
            this.sendScreenTouchedBR();
        }
        if (event.getAction() == 0 && this.mCurrentScreen != null) {
            try {
                this.mCurrentScreen.OutSideTouchExit();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", this.TAG, re);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("[ExceptionError] - onTouchEvent ->  mCurrentScreen.OutSideTouchExit() : " + e));
            }
        }
        return super.onTouchEvent(event);
    }

    public WpadSound Sound() {
        return this.mSound;
    }

    public void setSoundNoRelease(boolean set) {
        this.mSoundNoRelease = set;
    }

    protected Menu getIntentParsingMenu(Intent intent) {
        if (intent == null) {
            Log.e((String)this.TAG, (String)"[getIntentMunu] - Param. intent is null !!!");
            return null;
        }
        Menu retMenu = new Menu();
        try {
            retMenu.StartId = intent.getIntExtra("MENU_START_ID", -100);
            retMenu.Opiton = intent.getIntExtra("MENU_START_OPTION", -100);
            if (retMenu.StartId == -100 && retMenu.Opiton == -100) {
                Log.e((String)this.TAG, (String)"[getIntentMunu] - getIntExtra & getIntArrayExtra is null !!!");
                return null;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
            return null;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"[getIntentMunu] - [Exception Error] intent.get... ");
            Log.e((String)this.TAG, (String)("[getIntentMunu] - " + e.toString()));
            return null;
        }
        Log.i((String)this.TAG, (String)("[getIntentMunu] StartId = " + retMenu.StartId));
        Log.i((String)this.TAG, (String)("[getIntentMunu] Opiton  = " + retMenu.Opiton));
        return retMenu;
    }

    protected void onBrReceive(Intent intent) {
    }

    private void BrReceive(Intent intent) {
        try {
            this.onBrReceive(intent);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - onBrReceive : " + e));
        }
        if (this.mCurrentScreen != null) {
            this.mCurrentScreen.BrReceive(intent);
        }
    }

    protected int addBrActionFilter(String action) {
        if (action == null) {
            Log.w((String)this.TAG, (String)"[addBrActionFilter] - param - action is null");
            return -1;
        }
        if (this.mBrActionList.contains(action)) {
            Log.w((String)this.TAG, (String)("[addBrActionFilter] - add to [" + action + "] has already been added."));
            return -2;
        }
        this.mBrActionList.add(action);
        IntentFilter filter = new IntentFilter();
        filter.addAction(action);
        this.registerReceiver(this.mWpadNotifyBR, filter);
        return 0;
    }

    protected int removeBrActionFilter(String action) {
        if (!this.mBrActionList.contains(action)) {
            Log.w((String)this.TAG, (String)("[removeBrActionFilter] - remove requested [" + action + "] is not."));
            return -1;
        }
        this.mBrActionList.remove(action);
        this.unregisterReceiver(this.mWpadNotifyBR);
        if (!this.mBrActionList.isEmpty()) {
            String getAction = null;
            IntentFilter filter = new IntentFilter();
            try {
                for (int i = 0; i < this.mBrActionList.size(); ++i) {
                    getAction = this.mBrActionList.get(i);
                    filter.addAction(getAction);
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", this.TAG, re);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"[removeBrActionFilter] - [Exception Error] BrActionList.get()");
                Log.e((String)this.TAG, (String)("[removeBrActionFilter] - " + e.toString()));
            }
            this.registerReceiver(this.mWpadNotifyBR, filter);
        } else {
            Log.d((String)this.TAG, (String)"[removeBrActionFilter] - BrActionList is Empty !!!");
        }
        return 0;
    }

    protected boolean setFinishBrEnable(boolean Enable) {
        if (Enable) {
            if (this.addBrActionFilter("kr.co.icontrols.wallpad.BR_APP_FINISH") < 0) {
                this.mFinishBrEnable = false;
                return false;
            }
            this.mFinishBrEnable = true;
        } else {
            this.mFinishBrEnable = false;
            if (this.removeBrActionFilter("kr.co.icontrols.wallpad.BR_APP_FINISH") < 0) {
                return false;
            }
        }
        return true;
    }

    protected boolean getFinishBrEnable() {
        return this.mFinishBrEnable;
    }

    public static boolean getFinishTimerEnable() {
        return mFinishTimerEnable;
    }

    protected boolean setFinishTimerCreate(int nFinishTime) {
        Log.d((String)"WpadActivity", (String)("setFinishTimerStart - nFinishTime : " + nFinishTime + " Sec"));
        this.mFinishTime = nFinishTime;
        if (nFinishTime <= 0) {
            Log.e((String)this.TAG, (String)("setFinishTimerCreate - param : nFinishTime - Out of range !!! (" + nFinishTime + ")"));
            mFinishTimerEnable = false;
            return false;
        }
        if (mFinishTimer != null) {
            mFinishTimer.cancel();
        }
        mFinishTimer = new CountDownTimer(this.mFinishTime * 1000, 1000L){

            public void onFinish() {
                Log.d((String)WpadActivity.this.TAG, (String)"FinishTimer - onFinish !!!");
                WpadActivity.this.finish();
            }

            public void onTick(long arg0) {
                long RemainingTime = arg0 / 1000L;
                if (RemainingTime <= 10L) {
                    Log.d((String)WpadActivity.this.TAG, (String)("FinishTimer - onTick (" + RemainingTime + " sec)"));
                }
            }
        };
        mFinishTimer.cancel();
        mFinishTimer.start();
        mFinishTimerEnable = true;
        return true;
    }

    protected static boolean setFinishTimerReset() {
        if (mFinishTimerEnable) {
            if (mFinishTimer != null) {
                mFinishTimer.cancel();
                mFinishTimer.start();
            }
            return true;
        }
        return false;
    }

    protected boolean setFinishTimerDestroy() {
        mFinishTimerEnable = false;
        if (mFinishTimer != null) {
            Log.d((String)this.TAG, (String)"setFinishTimerDestroy");
            mFinishTimer.cancel();
            mFinishTimer = null;
            return true;
        }
        return false;
    }

    public void setOnTouch(boolean set) {
        this.mOnTouch = set;
    }

    public boolean getOnTouch() {
        return this.mOnTouch;
    }

    protected void onTouchEvent(View v, MotionEvent event) {
    }

    private void TouchEvent(View v, MotionEvent event) {
        if (Version.bResidentSafetyCheck && event.getAction() == 1) {
            this.sendScreenTouchedBR();
        }
        try {
            this.onTouchEvent(v, event);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[ExceptionError] - TouchEvent (" + v.getId() + ", " + event.getAction() + ") " + e));
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        super.onKeyDown(keyCode, event);
        if (this.mCurrentScreen != null) {
            this.mCurrentScreen.KeyDown(keyCode, event);
        }
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        super.onKeyUp(keyCode, event);
        if (this.mCurrentScreen != null) {
            this.mCurrentScreen.KeyUp(keyCode, event);
        }
        return false;
    }

    protected void setAllLayoutRegistration(RelativeLayout layout2) {
        layout2.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!WpadActivity.this.mOnTouch) {
                    return false;
                }
                if (event.getAction() == 1) {
                    WpadActivity.setFinishTimerReset();
                }
                return true;
            }
        });
    }

    protected void ViewRegistration(RelativeLayout ParentsLayout, WpadImageView nImageView, int MarginLeft, int MarginTop) {
        if (ParentsLayout == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadImageView) - Param. ParentsLayout is null !!!");
            return;
        }
        if (nImageView == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadImageView) - Param. nImageView is null !!!");
            return;
        }
        WpadUtil.ViewRegistration(ParentsLayout, nImageView, MarginLeft, MarginTop);
        if (nImageView.getTouchKind() != 0) {
            this.TouchRegistration(nImageView);
        }
    }

    protected void ViewMove(WpadImageView nImageView, int MarginLeft, int MarginTop) {
        if (nImageView == null) {
            Log.e((String)this.TAG, (String)"ViewMove (nImageView) - Param. nTextView is null !!!");
            return;
        }
        WpadUtil.ViewMove(nImageView, MarginLeft, MarginTop);
    }

    protected void ViewRegistration(RelativeLayout ParentsLayout, WpadTextView nTextView, int MarginLeft, int MarginTop) {
        if (ParentsLayout == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadTextView) - Param. ParentsLayout is null !!!");
            return;
        }
        if (nTextView == null) {
            Log.e((String)this.TAG, (String)"ViewRegistration (WpadTextView) - Param. nTextView is null !!!");
            return;
        }
        WpadUtil.ViewRegistration(ParentsLayout, nTextView, MarginLeft, MarginTop);
        if (nTextView.getTouch()) {
            this.TouchRegistration(nTextView);
        }
    }

    protected void ViewMove(WpadTextView nTextView, int MarginLeft, int MarginTop) {
        if (nTextView == null) {
            Log.e((String)this.TAG, (String)"ViewMove (WpadTextView) - Param. nTextView is null !!!");
            return;
        }
        WpadUtil.ViewMove(nTextView, MarginLeft, MarginTop);
    }

    protected void TouchCancel(WpadImageView nImageView) {
        WpadImageView TargetWpadImageView = nImageView;
        TargetWpadImageView.setOnTouchListener(null);
    }

    public void TouchRegistration(WpadImageView nImageView) {
        final WpadImageView TargetWpadImageView = nImageView;
        TargetWpadImageView.setOnTouchListener(new View.OnTouchListener(){
            boolean LongKeyEnable = false;
            int LongKeyCount = 0;
            Handler LongKeyHandler = null;

            @SuppressLint(value={"HandlerLeak"})
            public boolean onTouch(final View v, final MotionEvent event) {
                if (!WpadActivity.this.getOnTouch()) {
                    return false;
                }
                MotionEvent filterEvent = TargetWpadImageView.setTouchFilterNChangeImage(event);
                if (filterEvent.getAction() >= 0) {
                    WpadActivity.setFinishTimerReset();
                    if (!this.LongKeyEnable) {
                        WpadActivity.this.TouchEvent(v, event);
                    }
                    if (TargetWpadImageView.getTouchKind() == 2) {
                        int MoveEvent = event.getAction();
                        if (MoveEvent == 0) {
                            this.LongKeyHandler = new Handler(){

                                @SuppressLint(value={"HandlerLeak"})
                                public void handleMessage(Message msg) {
                                    if (msg.what == 0) {
                                        if (TargetWpadImageView.getButtonEventOff()) {
                                            if (LongKeyHandler != null) {
                                                LongKeyHandler.removeMessages(0);
                                                LongKeyHandler.removeMessages(1);
                                                LongKeyHandler = null;
                                            }
                                            if (LongKeyEnable) {
                                                event.setAction(6);
                                                WpadActivity.this.TouchEvent(v, event);
                                            }
                                            LongKeyEnable = false;
                                        } else {
                                            LongKeyEnable = true;
                                            event.setAction(5);
                                            WpadActivity.this.TouchEvent(v, event);
                                            LongKeyCount = 1;
                                            if (LongKeyHandler != null) {
                                                LongKeyHandler.sendEmptyMessageDelayed(1, 500L);
                                            }
                                        }
                                    } else if (msg.what == 1) {
                                        if (TargetWpadImageView.getButtonEventOff()) {
                                            if (LongKeyHandler != null) {
                                                LongKeyHandler.removeMessages(0);
                                                LongKeyHandler.removeMessages(1);
                                                LongKeyHandler = null;
                                            }
                                            if (LongKeyEnable) {
                                                event.setAction(6);
                                                WpadActivity.this.TouchEvent(v, event);
                                            }
                                            LongKeyEnable = false;
                                        } else {
                                            event.setAction(5);
                                            WpadActivity.this.TouchEvent(v, event);
                                            if (LongKeyHandler != null) {
                                                if (++LongKeyCount < 2) {
                                                    LongKeyHandler.sendEmptyMessageDelayed(1, 500L);
                                                } else {
                                                    LongKeyHandler.sendEmptyMessageDelayed(1, 150L);
                                                }
                                            }
                                        }
                                    } else {
                                        LongKeyHandler = null;
                                    }
                                }
                            };
                            this.LongKeyHandler.sendEmptyMessageDelayed(0, 500L);
                        } else if ((MoveEvent == 1 || MoveEvent == 3 || MoveEvent == -100) && this.LongKeyHandler != null) {
                            this.LongKeyHandler.removeMessages(0);
                            this.LongKeyHandler.removeMessages(1);
                            this.LongKeyHandler = null;
                            if (this.LongKeyEnable && MoveEvent == 1) {
                                event.setAction(6);
                                WpadActivity.this.TouchEvent(v, event);
                            }
                            this.LongKeyEnable = false;
                        }
                    }
                }
                return true;
            }
        });
    }

    private void TouchRegistration(WpadTextView nTextView) {
        final WpadTextView TargetWpadTextView = nTextView;
        TargetWpadTextView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!WpadActivity.this.mOnTouch) {
                    return false;
                }
                MotionEvent filterEvent = TargetWpadTextView.setTouchFilter(event);
                if (filterEvent.getAction() >= 0) {
                    WpadActivity.setFinishTimerReset();
                    WpadActivity.this.TouchEvent(v, event);
                }
                return true;
            }
        });
    }

    protected void WindowReSize(int w, int h, boolean softkeyhide) {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        try {
            lp.copyFrom(this.getWindow().getAttributes());
            lp.width = w;
            lp.height = h;
            if (softkeyhide) {
                lp.systemUiVisibility = 2;
            }
            this.getWindow().setAttributes(lp);
            this.getWindow().addFlags(128);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("[Exception Error] [WindowReSize] - Param 'window' Check!!! " + e));
        }
    }

    public String getAppVersion() {
        String version;
        try {
            PackageInfo i = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            version = i.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        return version;
    }

    public void AppVersionLogOut() {
        Log.i((String)"Version", (String)("<><><><>  Applications   Version = [" + this.getAppVersion() + "] <><><><>"));
        Version.LogOut();
    }

    public void sendScreenTouchedBR() {
        try {
            Intent mIntent = new Intent();
            mIntent.setAction("NOTIFY_ACNAME_RESIDENT_SAFETY_CHECK");
            mIntent.putExtra("KIND", 4001);
            this.sendBroadcast(mIntent);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", this.TAG, re);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"[Exception] sendScreenTouchedBR()");
            LogUtil.errorLogInfo("", this.TAG, e);
        }
    }

    public class Menu {
        public int StartId;
        public int Opiton;

        public Menu() {
            this.StartId = 1;
            this.Opiton = -1;
        }

        public Menu(int listCount) {
            if (listCount <= 0) {
                return;
            }
            this.StartId = 1;
            this.Opiton = -1;
        }

        public int getStartId() {
            return this.StartId;
        }

        public int getOpiton() {
            return this.Opiton;
        }
    }
}

