/*
 * Decompiled with CFR 0.152.
 */
package co.kr.cctv;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import co.kr.cctv.CctvPlayerEventListener;
import co.kr.cctv.CctvPlayerException;
import com.nova.cam.common.player.FFMpeg;

public class FFMpegView
extends SurfaceView
implements SurfaceHolder.Callback {
    public boolean test_flag = false;
    public int CONNECTION_TIMEOUT = 11000;
    public static final int POSITION_UPPER_LEFT = 9;
    public static final int POSITION_UPPER_RIGHT = 3;
    public static final int POSITION_LOWER_LEFT = 12;
    public static final int POSITION_LOWER_RIGHT = 6;
    public static final int SIZE_STANDARD = 1;
    public static final int SIZE_BEST_FIT = 4;
    public static final int SIZE_FULLSCREEN = 8;
    private int ffHandle = 0;
    private FFMpegReadThread readThread;
    private FFMpegVideoThread videoThread;
    private FFMpegAudioThread audioThread;
    private boolean showFps = false;
    private boolean mRun = false;
    private boolean surfaceDone = false;
    private Paint overlayPaint;
    private int overlayTextColor;
    private int overlayBackgroundColor;
    private int ovlPos;
    private int dispWidth;
    private int dispHeight;
    private int displayMode;
    private SurfaceHolder mSurfaceHolder;
    private CctvPlayerEventListener cctvPlayerEventListener;
    final Handler handler = new Handler();
    private Context cont;
    private Bitmap bmNow;

    public void setCctvEventListener(CctvPlayerEventListener listener) {
        this.cctvPlayerEventListener = listener;
    }

    public Bitmap getBmNow() {
        return this.bmNow;
    }

    private void init(Context context) {
        this.cont = context;
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        this.readThread = new FFMpegReadThread();
        this.videoThread = new FFMpegVideoThread(holder, context);
        this.audioThread = new FFMpegAudioThread();
        this.setFocusable(true);
        this.overlayPaint = new Paint();
        this.overlayPaint.setTextAlign(Paint.Align.LEFT);
        this.overlayPaint.setTextSize(12.0f);
        this.overlayPaint.setTypeface(Typeface.DEFAULT);
        this.overlayTextColor = -1;
        this.overlayBackgroundColor = 0;
        this.ovlPos = 6;
        this.displayMode = 4;
        this.dispWidth = this.getWidth();
        this.dispHeight = this.getHeight();
    }

    public void startPlayback() {
        if (this.ffHandle > 0 || this.ffHandle < -8) {
            this.mRun = true;
            if (this.readThread.getState() == Thread.State.TERMINATED) {
                this.readThread = new FFMpegReadThread();
                this.readThread.start();
            } else {
                this.readThread.start();
            }
            if (this.videoThread.getState() == Thread.State.TERMINATED) {
                if (this.mSurfaceHolder != null) {
                    this.videoThread = new FFMpegVideoThread(this.mSurfaceHolder, this.cont);
                } else {
                    SurfaceHolder holder = this.getHolder();
                    holder.addCallback((SurfaceHolder.Callback)this);
                    this.videoThread = new FFMpegVideoThread(holder, this.cont);
                }
                this.videoThread.start();
            } else {
                this.videoThread.start();
            }
            if (this.audioThread.getState() == Thread.State.TERMINATED) {
                this.audioThread = new FFMpegAudioThread();
                this.audioThread.start();
            } else {
                this.audioThread.start();
            }
        }
    }

    public void stopPlayback() {
        this.mRun = false;
        try {
            this.readThread.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.videoThread.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.audioThread.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.readThread.join();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.videoThread.join();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.audioThread.join();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public FFMpegView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FFMpegView(Context context) {
        super(context);
        this.init(context);
    }

    public void setSurfaceSize(int w, int h) {
        this.videoThread.setSurfaceSize(w, h);
    }

    public void surfaceChanged(SurfaceHolder holder, int f, int w, int h) {
        this.videoThread.setSurfaceSize(w, h);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.surfaceDone = false;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.surfaceDone = true;
    }

    public void showFps(boolean b) {
        this.showFps = b;
    }

    public void setOverlayPaint(Paint p) {
        this.overlayPaint = p;
    }

    public void setOverlayTextColor(int c) {
        this.overlayTextColor = c;
    }

    public void setOverlayBackgroundColor(int c) {
        this.overlayBackgroundColor = c;
    }

    public void setOverlayPosition(int p) {
        this.ovlPos = p;
    }

    public void setDisplayMode(int s) {
        this.displayMode = s;
    }

    public int getHandle() {
        return this.ffHandle;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public final String getJniVersion() {
        return FFMpeg.getVersion();
    }

    public final int open(String fileName) {
        if (this.ffHandle > 0 || this.ffHandle < -8) {
            this.close();
        }
        long openTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - openTime < (long)this.CONNECTION_TIMEOUT) {
            if (this.test_flag) break;
            this.ffHandle = FFMpeg.openFile(fileName);
            if (this.ffHandle > 0 || this.ffHandle < -8) break;
        }
        return this.ffHandle;
    }

    public final void close() {
        this.stopPlayback();
        if (this.ffHandle > 0 || this.ffHandle < -8) {
            try {
                this.ffHandle = 0;
                FFMpeg.closeHandle(this.ffHandle);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public FFMpegReadThread getReadThread() {
        return this.readThread;
    }

    public FFMpegVideoThread getVideoThread() {
        return this.videoThread;
    }

    public FFMpegAudioThread getAudioThread() {
        return this.audioThread;
    }

    public class FFMpegAudioThread
    extends Thread {
        @Override
        public void run() {
            while (FFMpegView.this.mRun) {
                FFMpeg.getAudioData(FFMpegView.this.ffHandle);
            }
        }
    }

    public class FFMpegReadThread
    extends Thread {
        @Override
        public void run() {
            while (FFMpegView.this.mRun) {
                try {
                    final int readResult = FFMpeg.readFrameToBuffer(FFMpegView.this.ffHandle, 0x1400000);
                    if (readResult != -8) continue;
                    try {
                        FFMpegView.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                FFMpegView.this.cctvPlayerEventListener.onCctvPlayerException(new CctvPlayerException(readResult));
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    FFMpegView.this.close();
                    break;
                }
                catch (Throwable e) {
                    try {
                        FFMpegView.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                FFMpegView.this.cctvPlayerEventListener.onCctvPlayerException(new CctvPlayerException(e));
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class FFMpegVideoThread
    extends Thread {
        private int frameCounter = 0;
        private long start;
        private Bitmap ovl;

        public FFMpegVideoThread(SurfaceHolder surfaceHolder, Context context) {
            FFMpegView.this.mSurfaceHolder = surfaceHolder;
        }

        private Rect destRect(int bmw, int bmh) {
            if (FFMpegView.this.displayMode == 1) {
                int tempx = FFMpegView.this.dispWidth / 2 - bmw / 2;
                int tempy = FFMpegView.this.dispHeight / 2 - bmh / 2;
                return new Rect(tempx, tempy, bmw + tempx, bmh + tempy);
            }
            if (FFMpegView.this.displayMode == 4) {
                float bmasp = (float)bmw / (float)bmh;
                bmw = FFMpegView.this.dispWidth;
                bmh = (int)((float)FFMpegView.this.dispWidth / bmasp);
                if (bmh > FFMpegView.this.dispHeight) {
                    bmh = FFMpegView.this.dispHeight;
                    bmw = (int)((float)FFMpegView.this.dispHeight * bmasp);
                }
                int tempx = FFMpegView.this.dispWidth / 2 - bmw / 2;
                int tempy = FFMpegView.this.dispHeight / 2 - bmh / 2;
                return new Rect(tempx, tempy, bmw + tempx, bmh + tempy);
            }
            if (FFMpegView.this.displayMode == 8) {
                return new Rect(0, 0, FFMpegView.this.dispWidth, FFMpegView.this.dispHeight + 12);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSurfaceSize(int width, int height) {
            SurfaceHolder surfaceHolder = FFMpegView.this.mSurfaceHolder;
            synchronized (surfaceHolder) {
                FFMpegView.this.dispWidth = width;
                FFMpegView.this.dispHeight = height;
            }
        }

        private Bitmap makeFpsOverlay(Paint p, String text) {
            Rect b = new Rect();
            p.getTextBounds(text, 0, text.length(), b);
            int bwidth = b.width() + 2;
            int bheight = b.height() + 2;
            Bitmap bm = Bitmap.createBitmap((int)bwidth, (int)bheight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(bm);
            p.setColor(FFMpegView.this.overlayBackgroundColor);
            c.drawRect(0.0f, 0.0f, (float)bwidth, (float)bheight, p);
            p.setColor(FFMpegView.this.overlayTextColor);
            p.setTextSize(24.0f);
            c.drawText(text, (float)(-b.left + 1), (float)(bheight / 2) - (p.ascent() + p.descent()) / 2.0f + 1.0f, p);
            return bm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.start = System.currentTimeMillis();
            PorterDuffXfermode mode = new PorterDuffXfermode(PorterDuff.Mode.DST_OVER);
            if (FFMpegView.this.ffHandle > 0 || FFMpegView.this.ffHandle < -8) {
                int bmWidth = FFMpeg.getVideoWidth(FFMpegView.this.ffHandle);
                int bmHeight = FFMpeg.getVideoHeight(FFMpegView.this.ffHandle);
                if (bmWidth > 0 && bmHeight > 0) {
                    FFMpegView.this.bmNow = Bitmap.createBitmap((int)bmWidth, (int)bmHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                } else {
                    FFMpegView.this.bmNow = Bitmap.createBitmap((int)800, (int)480, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
            } else {
                FFMpegView.this.bmNow = Bitmap.createBitmap((int)800, (int)480, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            Canvas c = null;
            Paint p = new Paint();
            String fps = "";
            while (FFMpegView.this.mRun) {
                if (Thread.currentThread().isInterrupted()) break;
                if (!FFMpegView.this.surfaceDone) continue;
                try {
                    c = FFMpegView.this.mSurfaceHolder.lockCanvas();
                    SurfaceHolder surfaceHolder = FFMpegView.this.mSurfaceHolder;
                    synchronized (surfaceHolder) {
                        try {
                            int videoResult = FFMpeg.getVideoData(FFMpegView.this.ffHandle, FFMpegView.this.bmNow);
                            Rect destRect = this.destRect(FFMpegView.this.bmNow.getWidth(), FFMpegView.this.bmNow.getHeight());
                            c.drawColor(-16777216);
                            c.drawBitmap(FFMpegView.this.bmNow, null, destRect, p);
                            if (FFMpegView.this.showFps) {
                                p.setXfermode((Xfermode)mode);
                                if (this.ovl != null) {
                                    int height = (FFMpegView.this.ovlPos & 1) == 1 ? destRect.top - 10 : destRect.bottom - this.ovl.getHeight() - 10;
                                    int width = (FFMpegView.this.ovlPos & 8) == 8 ? destRect.left - 10 : destRect.right - this.ovl.getWidth() - 10;
                                    c.drawBitmap(this.ovl, (float)width, (float)height, null);
                                }
                                p.setXfermode(null);
                                if (videoResult > 0) {
                                    ++this.frameCounter;
                                }
                                if (System.currentTimeMillis() - this.start >= 1000L) {
                                    fps = String.valueOf(String.valueOf(this.frameCounter)) + " fps ";
                                    this.frameCounter = 0;
                                    this.start = System.currentTimeMillis();
                                    this.ovl = this.makeFpsOverlay(FFMpegView.this.overlayPaint, fps);
                                }
                            }
                        }
                        catch (Throwable e) {
                            try {
                                FFMpegView.this.handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        FFMpegView.this.cctvPlayerEventListener.onCctvPlayerException(new CctvPlayerException(e));
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    if (c != null) {
                        FFMpegView.this.mSurfaceHolder.unlockCanvasAndPost(c);
                    }
                }
            }
        }
    }
}

