/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class AllLightAPI
extends WallPadDevAPI {
    private final String TAG = "AllLightAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"AllLightAPI", (String)s);
    }

    public AllLightAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("AllLightAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "AllLIGHT";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        this.DebugLogOutput("getstate cmd ret : " + ret);
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 4) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.AllLightOnOff = Boolean.parseBoolean(retlist[index++]);
                this.data.Fault = Boolean.parseBoolean(retlist[index++]);
                this.data.DeviceAddress = Byte.parseByte(retlist[index++]);
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "AllLightAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"AllLightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "AllLightAPI", e);
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetAllLightOnOff(boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetAllLightOnOff", OnOff ? 1 : 0, 0, 0, 0, 0);
    }

    public static class Data {
        public boolean AllLightOnOff = false;
        public boolean Fault = false;
        public byte DeviceAddress = 0;

        public String ToDebugString() {
            String retStr = "==========================\r\nAllLightAPI\r\n==========================\r\nAllLightOnOff : " + this.AllLightOnOff + "\r\nFault         : " + this.Fault + "\r\nDeviceAddress : " + String.format("0x%02X", this.DeviceAddress) + "\r\n==========================";
            return retStr;
        }
    }
}

