/*
 * Decompiled with CFR 0.152.
 */
package de.re.easymodbus.server;

import de.re.easymodbus.server.ModbusProtocoll;
import de.re.easymodbus.server.ModbusServer;
import java.net.Socket;
import java.util.Calendar;

class ProcessReceivedDataThread
extends Thread {
    short[] inBuffer;
    ModbusServer easyModbusTCPServer;
    Socket socket;

    public ProcessReceivedDataThread(byte[] inBuffer, ModbusServer easyModbusTCPServer, Socket socket) {
        this.socket = socket;
        this.inBuffer = new short[inBuffer.length];
        int i = 0;
        while (i < inBuffer.length) {
            this.inBuffer[i] = (short)((short)inBuffer[i] & 0xFF);
            ++i;
        }
        this.easyModbusTCPServer = easyModbusTCPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ModbusServer modbusServer = this.easyModbusTCPServer;
        synchronized (modbusServer) {
            int i;
            short[] wordData = new short[1];
            short[] byteData = new short[2];
            this.easyModbusTCPServer.receiveData = new ModbusProtocoll();
            this.easyModbusTCPServer.receiveData.timeStamp = Calendar.getInstance();
            this.easyModbusTCPServer.receiveData.request = true;
            byteData[1] = this.inBuffer[0];
            byteData[0] = this.inBuffer[1];
            wordData[0] = (short)this.byteArrayToInt(byteData);
            this.easyModbusTCPServer.receiveData.transactionIdentifier = wordData[0];
            byteData[1] = this.inBuffer[2];
            byteData[0] = this.inBuffer[3];
            wordData[0] = (short)this.byteArrayToInt(byteData);
            this.easyModbusTCPServer.receiveData.protocolIdentifier = wordData[0];
            byteData[1] = this.inBuffer[4];
            byteData[0] = this.inBuffer[5];
            wordData[0] = (short)this.byteArrayToInt(byteData);
            this.easyModbusTCPServer.receiveData.length = wordData[0];
            this.easyModbusTCPServer.receiveData.unitIdentifier = (byte)this.inBuffer[6];
            this.easyModbusTCPServer.receiveData.functionCode = (byte)this.inBuffer[7];
            byteData[1] = this.inBuffer[8];
            byteData[0] = this.inBuffer[9];
            wordData[0] = (short)this.byteArrayToInt(byteData);
            this.easyModbusTCPServer.receiveData.startingAdress = wordData[0];
            if (this.easyModbusTCPServer.receiveData.functionCode <= 4) {
                byteData[1] = this.inBuffer[10];
                byteData[0] = this.inBuffer[11];
                wordData[0] = (short)this.byteArrayToInt(byteData);
                this.easyModbusTCPServer.receiveData.quantity = wordData[0];
            }
            if (this.easyModbusTCPServer.receiveData.functionCode == 5) {
                this.easyModbusTCPServer.receiveData.receiveCoilValues = new short[1];
                byteData[0] = this.inBuffer[10];
                byteData[1] = this.inBuffer[11];
                this.easyModbusTCPServer.receiveData.receiveCoilValues[0] = (short)this.byteArrayToInt(byteData);
            }
            if (this.easyModbusTCPServer.receiveData.functionCode == 6) {
                this.easyModbusTCPServer.receiveData.receiveRegisterValues = new int[1];
                byteData[1] = this.inBuffer[10];
                byteData[0] = this.inBuffer[11];
                this.easyModbusTCPServer.receiveData.receiveRegisterValues[0] = this.byteArrayToInt(byteData);
            }
            if (this.easyModbusTCPServer.receiveData.functionCode == 15) {
                byteData[1] = this.inBuffer[10];
                byteData[0] = this.inBuffer[11];
                wordData[0] = (short)this.byteArrayToInt(byteData);
                this.easyModbusTCPServer.receiveData.quantity = wordData[0];
                this.easyModbusTCPServer.receiveData.byteCount = (byte)this.inBuffer[12];
                this.easyModbusTCPServer.receiveData.receiveCoilValues = this.easyModbusTCPServer.receiveData.byteCount % 2 != 0 ? new short[this.easyModbusTCPServer.receiveData.byteCount / 2 + 1] : new short[this.easyModbusTCPServer.receiveData.byteCount / 2];
                i = 0;
                while (i < this.easyModbusTCPServer.receiveData.byteCount) {
                    this.easyModbusTCPServer.receiveData.receiveCoilValues[i / 2] = i % 2 == 1 ? (short)(this.easyModbusTCPServer.receiveData.receiveCoilValues[i / 2] + 256 * this.inBuffer[13 + i]) : this.inBuffer[13 + i];
                    ++i;
                }
            }
            if (this.easyModbusTCPServer.receiveData.functionCode == 16) {
                byteData[1] = this.inBuffer[10];
                byteData[0] = this.inBuffer[11];
                wordData[0] = (short)this.byteArrayToInt(byteData);
                this.easyModbusTCPServer.receiveData.quantity = wordData[0];
                this.easyModbusTCPServer.receiveData.byteCount = (byte)this.inBuffer[12];
                this.easyModbusTCPServer.receiveData.receiveRegisterValues = new int[this.easyModbusTCPServer.receiveData.quantity];
                i = 0;
                while (i < this.easyModbusTCPServer.receiveData.quantity) {
                    byteData[1] = this.inBuffer[13 + i * 2];
                    byteData[0] = this.inBuffer[14 + i * 2];
                    this.easyModbusTCPServer.receiveData.receiveRegisterValues[i] = byteData[0];
                    this.easyModbusTCPServer.receiveData.receiveRegisterValues[i] = this.easyModbusTCPServer.receiveData.receiveRegisterValues[i] + (byteData[1] << 8);
                    ++i;
                }
            }
            this.easyModbusTCPServer.CreateAnswer(this.socket);
            this.easyModbusTCPServer.CreateLogData();
        }
    }

    public int byteArrayToInt(short[] byteArray) {
        int returnValue = byteArray[0];
        return returnValue += 256 * byteArray[1];
    }
}

