/*
 * Decompiled with CFR 0.152.
 */
package de.re.easymodbus.modbusclient;

import de.re.easymodbus.exceptions.ConnectionException;
import de.re.easymodbus.exceptions.FunctionCodeNotSupportedException;
import de.re.easymodbus.exceptions.ModbusException;
import de.re.easymodbus.exceptions.QuantityInvalidException;
import de.re.easymodbus.exceptions.StartingAddressInvalidException;
import de.re.easymodbus.modbusclient.DateTime;
import de.re.easymodbus.modbusclient.ReceiveDataChangedListener;
import de.re.easymodbus.modbusclient.SendDataChangedListener;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ModbusClient {
    private Socket tcpClientSocket = new Socket();
    protected String ipAddress = "190.201.100.100";
    protected int port = 502;
    private byte[] transactionIdentifier = new byte[2];
    private byte[] protocolIdentifier = new byte[2];
    private byte[] length = new byte[2];
    private byte[] crc = new byte[2];
    private byte unitIdentifier = 1;
    private byte functionCode;
    private byte[] startingAddress = new byte[2];
    private byte[] quantity = new byte[2];
    private boolean udpFlag = false;
    private boolean serialflag = false;
    private int connectTimeout = 500;
    private InputStream inStream;
    private DataOutputStream outStream;
    public byte[] receiveData;
    public byte[] sendData;
    private List<ReceiveDataChangedListener> receiveDataChangedListener = new ArrayList<ReceiveDataChangedListener>();
    private List<SendDataChangedListener> sendDataChangedListener = new ArrayList<SendDataChangedListener>();
    private SerialPort serialPort;
    OutputStream out;
    InputStream in;
    CommPortIdentifier portIdentifier;

    public ModbusClient(String ipAddress, int port) {
        System.out.println("EasyModbus Client Library");
        System.out.println("Copyright (c) Stefan Rossmann Engineering Solutions");
        System.out.println("www.rossmann-engineering.de");
        System.out.println("");
        System.out.println("Creative commons license");
        System.out.println("Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0)");
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public ModbusClient() {
        System.out.println("EasyModbus Client Library");
        System.out.println("Copyright (c) Stefan Rossmann Engineering Solutions");
        System.out.println("www.rossmann-engineering.de");
        System.out.println("");
        System.out.println("Creative commons license");
        System.out.println("Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0)");
    }

    public void Connect() throws UnknownHostException, IOException {
        if (!this.udpFlag) {
            this.tcpClientSocket = new Socket(this.ipAddress, this.port);
            this.tcpClientSocket.setSoTimeout(this.connectTimeout);
            this.outStream = new DataOutputStream(this.tcpClientSocket.getOutputStream());
            this.inStream = this.tcpClientSocket.getInputStream();
        }
    }

    public void Connect(String ipAddress, int port) throws UnknownHostException, IOException {
        this.ipAddress = ipAddress;
        this.port = port;
        this.tcpClientSocket = new Socket(ipAddress, port);
        this.tcpClientSocket.setSoTimeout(this.connectTimeout);
        this.outStream = new DataOutputStream(this.tcpClientSocket.getOutputStream());
        this.inStream = this.tcpClientSocket.getInputStream();
    }

    public void Connect(String comPort) throws Exception {
        this.portIdentifier = CommPortIdentifier.getPortIdentifier((String)comPort);
        if (this.portIdentifier.isCurrentlyOwned()) {
            System.out.println("Error: Port is currently in use");
        } else {
            int timeout = 2000;
            CommPort commPort = this.portIdentifier.open(this.getClass().getName(), timeout);
            if (commPort instanceof SerialPort) {
                this.serialPort = (SerialPort)commPort;
                this.serialPort.setSerialPortParams(9600, 8, 1, 2);
                this.serialPort.enableReceiveTimeout(1000);
                this.serialPort.disableReceiveThreshold();
                this.in = this.serialPort.getInputStream();
                this.out = this.serialPort.getOutputStream();
                this.serialflag = true;
            } else {
                System.out.println("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public static float ConvertRegistersToFloat(int[] registers) throws IllegalArgumentException {
        if (registers.length != 2) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int highRegister = registers[1];
        int lowRegister = registers[0];
        byte[] highRegisterBytes = ModbusClient.toByteArray(highRegister);
        byte[] lowRegisterBytes = ModbusClient.toByteArray(lowRegister);
        byte[] floatBytes = new byte[]{highRegisterBytes[1], highRegisterBytes[0], lowRegisterBytes[1], lowRegisterBytes[0]};
        return ByteBuffer.wrap(floatBytes).getFloat();
    }

    public static double ConvertRegistersToDoublePrecisionFloat(int[] registers) throws IllegalArgumentException {
        if (registers.length != 4) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        byte[] highRegisterBytes = ModbusClient.toByteArray(registers[3]);
        byte[] highLowRegisterBytes = ModbusClient.toByteArray(registers[2]);
        byte[] lowHighRegisterBytes = ModbusClient.toByteArray(registers[1]);
        byte[] lowRegisterBytes = ModbusClient.toByteArray(registers[0]);
        byte[] doubleBytes = new byte[]{highRegisterBytes[1], highRegisterBytes[0], highLowRegisterBytes[1], highLowRegisterBytes[0], lowHighRegisterBytes[1], lowHighRegisterBytes[0], lowRegisterBytes[1], lowRegisterBytes[0]};
        return ByteBuffer.wrap(doubleBytes).getDouble();
    }

    public static double ConvertRegistersToDoublePrecisionFloat(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        if (registers.length != 4) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int[] swappedRegisters = new int[]{registers[0], registers[1], registers[2], registers[3]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[3], registers[2], registers[1], registers[0]};
        }
        return ModbusClient.ConvertRegistersToDoublePrecisionFloat(swappedRegisters);
    }

    public static float ConvertRegistersToFloat(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        int[] swappedRegisters = new int[]{registers[0], registers[1]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[1], registers[0]};
        }
        return ModbusClient.ConvertRegistersToFloat(swappedRegisters);
    }

    public static long ConvertRegistersToLong(int[] registers) throws IllegalArgumentException {
        if (registers.length != 4) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        byte[] highRegisterBytes = ModbusClient.toByteArray(registers[3]);
        byte[] highLowRegisterBytes = ModbusClient.toByteArray(registers[2]);
        byte[] lowHighRegisterBytes = ModbusClient.toByteArray(registers[1]);
        byte[] lowRegisterBytes = ModbusClient.toByteArray(registers[0]);
        byte[] longBytes = new byte[]{highRegisterBytes[1], highRegisterBytes[0], highLowRegisterBytes[1], highLowRegisterBytes[0], lowHighRegisterBytes[1], lowHighRegisterBytes[0], lowRegisterBytes[1], lowRegisterBytes[0]};
        return ByteBuffer.wrap(longBytes).getLong();
    }

    public static long ConvertRegistersToLong(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        if (registers.length != 4) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int[] swappedRegisters = new int[]{registers[0], registers[1], registers[2], registers[3]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[3], registers[2], registers[1], registers[0]};
        }
        return ModbusClient.ConvertRegistersToLong(swappedRegisters);
    }

    public static int ConvertRegistersToDouble(int[] registers) throws IllegalArgumentException {
        if (registers.length != 2) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int highRegister = registers[1];
        int lowRegister = registers[0];
        byte[] highRegisterBytes = ModbusClient.toByteArray(highRegister);
        byte[] lowRegisterBytes = ModbusClient.toByteArray(lowRegister);
        byte[] doubleBytes = new byte[]{highRegisterBytes[1], highRegisterBytes[0], lowRegisterBytes[1], lowRegisterBytes[0]};
        return ByteBuffer.wrap(doubleBytes).getInt();
    }

    public static int ConvertRegistersToDouble(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        int[] swappedRegisters = new int[]{registers[0], registers[1]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[1], registers[0]};
        }
        return ModbusClient.ConvertRegistersToDouble(swappedRegisters);
    }

    public static int[] ConvertFloatToTwoRegisters(float floatValue) {
        byte[] floatBytes = ModbusClient.toByteArray(floatValue);
        byte[] byArray = new byte[4];
        byArray[2] = floatBytes[0];
        byArray[3] = floatBytes[1];
        byte[] highRegisterBytes = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[2] = floatBytes[2];
        byArray2[3] = floatBytes[3];
        byte[] lowRegisterBytes = byArray2;
        int[] returnValue = new int[]{ByteBuffer.wrap(lowRegisterBytes).getInt(), ByteBuffer.wrap(highRegisterBytes).getInt()};
        return returnValue;
    }

    public static int[] ConvertFloatToTwoRegisters(float floatValue, RegisterOrder registerOrder) {
        int[] registerValues;
        int[] returnValue = registerValues = ModbusClient.ConvertFloatToTwoRegisters(floatValue);
        if (registerOrder == RegisterOrder.HighLow) {
            returnValue = new int[]{registerValues[1], registerValues[0]};
        }
        return returnValue;
    }

    public static int[] ConvertDoubleToTwoRegisters(int doubleValue) {
        byte[] doubleBytes = ModbusClient.toByteArrayDouble(doubleValue);
        byte[] byArray = new byte[4];
        byArray[2] = doubleBytes[0];
        byArray[3] = doubleBytes[1];
        byte[] highRegisterBytes = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[2] = doubleBytes[2];
        byArray2[3] = doubleBytes[3];
        byte[] lowRegisterBytes = byArray2;
        int[] returnValue = new int[]{ByteBuffer.wrap(lowRegisterBytes).getInt(), ByteBuffer.wrap(highRegisterBytes).getInt()};
        return returnValue;
    }

    public static int[] ConvertDoubleToTwoRegisters(int doubleValue, RegisterOrder registerOrder) {
        int[] registerValues;
        int[] returnValue = registerValues = ModbusClient.ConvertFloatToTwoRegisters(doubleValue);
        if (registerOrder == RegisterOrder.HighLow) {
            returnValue = new int[]{registerValues[1], registerValues[0]};
        }
        return returnValue;
    }

    public static String ConvertRegistersToString(int[] registers, int offset, int stringLength) {
        byte[] result = new byte[stringLength];
        byte[] registerResult = new byte[2];
        int i = 0;
        while (i < stringLength / 2) {
            registerResult = ModbusClient.toByteArray(registers[offset + i]);
            result[i * 2] = registerResult[0];
            result[i * 2 + 1] = registerResult[1];
            ++i;
        }
        return new String(result);
    }

    public static int[] ConvertStringToRegisters(String stringToConvert) {
        byte[] array = stringToConvert.getBytes();
        int[] returnarray = new int[stringToConvert.length() / 2 + stringToConvert.length() % 2];
        int i = 0;
        while (i < returnarray.length) {
            returnarray[i] = array[i * 2];
            if (i * 2 + 1 < array.length) {
                returnarray[i] = returnarray[i] | array[i * 2 + 1] << 8;
            }
            ++i;
        }
        return returnarray;
    }

    public static byte[] calculateCRC(byte[] data, int numberOfBytes, int startByte) {
        byte[] byArray = new byte[256];
        byArray[1] = -63;
        byArray[2] = -127;
        byArray[3] = 64;
        byArray[4] = 1;
        byArray[5] = -64;
        byArray[6] = -128;
        byArray[7] = 65;
        byArray[8] = 1;
        byArray[9] = -64;
        byArray[10] = -128;
        byArray[11] = 65;
        byArray[13] = -63;
        byArray[14] = -127;
        byArray[15] = 64;
        byArray[16] = 1;
        byArray[17] = -64;
        byArray[18] = -128;
        byArray[19] = 65;
        byArray[21] = -63;
        byArray[22] = -127;
        byArray[23] = 64;
        byArray[25] = -63;
        byArray[26] = -127;
        byArray[27] = 64;
        byArray[28] = 1;
        byArray[29] = -64;
        byArray[30] = -128;
        byArray[31] = 65;
        byArray[32] = 1;
        byArray[33] = -64;
        byArray[34] = -128;
        byArray[35] = 65;
        byArray[37] = -63;
        byArray[38] = -127;
        byArray[39] = 64;
        byArray[41] = -63;
        byArray[42] = -127;
        byArray[43] = 64;
        byArray[44] = 1;
        byArray[45] = -64;
        byArray[46] = -128;
        byArray[47] = 65;
        byArray[49] = -63;
        byArray[50] = -127;
        byArray[51] = 64;
        byArray[52] = 1;
        byArray[53] = -64;
        byArray[54] = -128;
        byArray[55] = 65;
        byArray[56] = 1;
        byArray[57] = -64;
        byArray[58] = -128;
        byArray[59] = 65;
        byArray[61] = -63;
        byArray[62] = -127;
        byArray[63] = 64;
        byArray[64] = 1;
        byArray[65] = -64;
        byArray[66] = -128;
        byArray[67] = 65;
        byArray[69] = -63;
        byArray[70] = -127;
        byArray[71] = 64;
        byArray[73] = -63;
        byArray[74] = -127;
        byArray[75] = 64;
        byArray[76] = 1;
        byArray[77] = -64;
        byArray[78] = -128;
        byArray[79] = 65;
        byArray[81] = -63;
        byArray[82] = -127;
        byArray[83] = 64;
        byArray[84] = 1;
        byArray[85] = -64;
        byArray[86] = -128;
        byArray[87] = 65;
        byArray[88] = 1;
        byArray[89] = -64;
        byArray[90] = -128;
        byArray[91] = 65;
        byArray[93] = -63;
        byArray[94] = -127;
        byArray[95] = 64;
        byArray[97] = -63;
        byArray[98] = -127;
        byArray[99] = 64;
        byArray[100] = 1;
        byArray[101] = -64;
        byArray[102] = -128;
        byArray[103] = 65;
        byArray[104] = 1;
        byArray[105] = -64;
        byArray[106] = -128;
        byArray[107] = 65;
        byArray[109] = -63;
        byArray[110] = -127;
        byArray[111] = 64;
        byArray[112] = 1;
        byArray[113] = -64;
        byArray[114] = -128;
        byArray[115] = 65;
        byArray[117] = -63;
        byArray[118] = -127;
        byArray[119] = 64;
        byArray[121] = -63;
        byArray[122] = -127;
        byArray[123] = 64;
        byArray[124] = 1;
        byArray[125] = -64;
        byArray[126] = -128;
        byArray[127] = 65;
        byArray[128] = 1;
        byArray[129] = -64;
        byArray[130] = -128;
        byArray[131] = 65;
        byArray[133] = -63;
        byArray[134] = -127;
        byArray[135] = 64;
        byArray[137] = -63;
        byArray[138] = -127;
        byArray[139] = 64;
        byArray[140] = 1;
        byArray[141] = -64;
        byArray[142] = -128;
        byArray[143] = 65;
        byArray[145] = -63;
        byArray[146] = -127;
        byArray[147] = 64;
        byArray[148] = 1;
        byArray[149] = -64;
        byArray[150] = -128;
        byArray[151] = 65;
        byArray[152] = 1;
        byArray[153] = -64;
        byArray[154] = -128;
        byArray[155] = 65;
        byArray[157] = -63;
        byArray[158] = -127;
        byArray[159] = 64;
        byArray[161] = -63;
        byArray[162] = -127;
        byArray[163] = 64;
        byArray[164] = 1;
        byArray[165] = -64;
        byArray[166] = -128;
        byArray[167] = 65;
        byArray[168] = 1;
        byArray[169] = -64;
        byArray[170] = -128;
        byArray[171] = 65;
        byArray[173] = -63;
        byArray[174] = -127;
        byArray[175] = 64;
        byArray[176] = 1;
        byArray[177] = -64;
        byArray[178] = -128;
        byArray[179] = 65;
        byArray[181] = -63;
        byArray[182] = -127;
        byArray[183] = 64;
        byArray[185] = -63;
        byArray[186] = -127;
        byArray[187] = 64;
        byArray[188] = 1;
        byArray[189] = -64;
        byArray[190] = -128;
        byArray[191] = 65;
        byArray[193] = -63;
        byArray[194] = -127;
        byArray[195] = 64;
        byArray[196] = 1;
        byArray[197] = -64;
        byArray[198] = -128;
        byArray[199] = 65;
        byArray[200] = 1;
        byArray[201] = -64;
        byArray[202] = -128;
        byArray[203] = 65;
        byArray[205] = -63;
        byArray[206] = -127;
        byArray[207] = 64;
        byArray[208] = 1;
        byArray[209] = -64;
        byArray[210] = -128;
        byArray[211] = 65;
        byArray[213] = -63;
        byArray[214] = -127;
        byArray[215] = 64;
        byArray[217] = -63;
        byArray[218] = -127;
        byArray[219] = 64;
        byArray[220] = 1;
        byArray[221] = -64;
        byArray[222] = -128;
        byArray[223] = 65;
        byArray[224] = 1;
        byArray[225] = -64;
        byArray[226] = -128;
        byArray[227] = 65;
        byArray[229] = -63;
        byArray[230] = -127;
        byArray[231] = 64;
        byArray[233] = -63;
        byArray[234] = -127;
        byArray[235] = 64;
        byArray[236] = 1;
        byArray[237] = -64;
        byArray[238] = -128;
        byArray[239] = 65;
        byArray[241] = -63;
        byArray[242] = -127;
        byArray[243] = 64;
        byArray[244] = 1;
        byArray[245] = -64;
        byArray[246] = -128;
        byArray[247] = 65;
        byArray[248] = 1;
        byArray[249] = -64;
        byArray[250] = -128;
        byArray[251] = 65;
        byArray[253] = -63;
        byArray[254] = -127;
        byArray[255] = 64;
        byte[] auchCRCHi = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[1] = -64;
        byArray2[2] = -63;
        byArray2[3] = 1;
        byArray2[4] = -61;
        byArray2[5] = 3;
        byArray2[6] = 2;
        byArray2[7] = -62;
        byArray2[8] = -58;
        byArray2[9] = 6;
        byArray2[10] = 7;
        byArray2[11] = -57;
        byArray2[12] = 5;
        byArray2[13] = -59;
        byArray2[14] = -60;
        byArray2[15] = 4;
        byArray2[16] = -52;
        byArray2[17] = 12;
        byArray2[18] = 13;
        byArray2[19] = -51;
        byArray2[20] = 15;
        byArray2[21] = -49;
        byArray2[22] = -50;
        byArray2[23] = 14;
        byArray2[24] = 10;
        byArray2[25] = -54;
        byArray2[26] = -53;
        byArray2[27] = 11;
        byArray2[28] = -55;
        byArray2[29] = 9;
        byArray2[30] = 8;
        byArray2[31] = -56;
        byArray2[32] = -40;
        byArray2[33] = 24;
        byArray2[34] = 25;
        byArray2[35] = -39;
        byArray2[36] = 27;
        byArray2[37] = -37;
        byArray2[38] = -38;
        byArray2[39] = 26;
        byArray2[40] = 30;
        byArray2[41] = -34;
        byArray2[42] = -33;
        byArray2[43] = 31;
        byArray2[44] = -35;
        byArray2[45] = 29;
        byArray2[46] = 28;
        byArray2[47] = -36;
        byArray2[48] = 20;
        byArray2[49] = -44;
        byArray2[50] = -43;
        byArray2[51] = 21;
        byArray2[52] = -41;
        byArray2[53] = 23;
        byArray2[54] = 22;
        byArray2[55] = -42;
        byArray2[56] = -46;
        byArray2[57] = 18;
        byArray2[58] = 19;
        byArray2[59] = -45;
        byArray2[60] = 17;
        byArray2[61] = -47;
        byArray2[62] = -48;
        byArray2[63] = 16;
        byArray2[64] = -16;
        byArray2[65] = 48;
        byArray2[66] = 49;
        byArray2[67] = -15;
        byArray2[68] = 51;
        byArray2[69] = -13;
        byArray2[70] = -14;
        byArray2[71] = 50;
        byArray2[72] = 54;
        byArray2[73] = -10;
        byArray2[74] = -9;
        byArray2[75] = 55;
        byArray2[76] = -11;
        byArray2[77] = 53;
        byArray2[78] = 52;
        byArray2[79] = -12;
        byArray2[80] = 60;
        byArray2[81] = -4;
        byArray2[82] = -3;
        byArray2[83] = 61;
        byArray2[84] = -1;
        byArray2[85] = 63;
        byArray2[86] = 62;
        byArray2[87] = -2;
        byArray2[88] = -6;
        byArray2[89] = 58;
        byArray2[90] = 59;
        byArray2[91] = -5;
        byArray2[92] = 57;
        byArray2[93] = -7;
        byArray2[94] = -8;
        byArray2[95] = 56;
        byArray2[96] = 40;
        byArray2[97] = -24;
        byArray2[98] = -23;
        byArray2[99] = 41;
        byArray2[100] = -21;
        byArray2[101] = 43;
        byArray2[102] = 42;
        byArray2[103] = -22;
        byArray2[104] = -18;
        byArray2[105] = 46;
        byArray2[106] = 47;
        byArray2[107] = -17;
        byArray2[108] = 45;
        byArray2[109] = -19;
        byArray2[110] = -20;
        byArray2[111] = 44;
        byArray2[112] = -28;
        byArray2[113] = 36;
        byArray2[114] = 37;
        byArray2[115] = -27;
        byArray2[116] = 39;
        byArray2[117] = -25;
        byArray2[118] = -26;
        byArray2[119] = 38;
        byArray2[120] = 34;
        byArray2[121] = -30;
        byArray2[122] = -29;
        byArray2[123] = 35;
        byArray2[124] = -31;
        byArray2[125] = 33;
        byArray2[126] = 32;
        byArray2[127] = -32;
        byArray2[128] = -96;
        byArray2[129] = 96;
        byArray2[130] = 97;
        byArray2[131] = -95;
        byArray2[132] = 99;
        byArray2[133] = -93;
        byArray2[134] = -94;
        byArray2[135] = 98;
        byArray2[136] = 102;
        byArray2[137] = -90;
        byArray2[138] = -89;
        byArray2[139] = 103;
        byArray2[140] = -91;
        byArray2[141] = 101;
        byArray2[142] = 100;
        byArray2[143] = -92;
        byArray2[144] = 108;
        byArray2[145] = -84;
        byArray2[146] = -83;
        byArray2[147] = 109;
        byArray2[148] = -81;
        byArray2[149] = 111;
        byArray2[150] = 110;
        byArray2[151] = -82;
        byArray2[152] = -86;
        byArray2[153] = 106;
        byArray2[154] = 107;
        byArray2[155] = -85;
        byArray2[156] = 105;
        byArray2[157] = -87;
        byArray2[158] = -88;
        byArray2[159] = 104;
        byArray2[160] = 120;
        byArray2[161] = -72;
        byArray2[162] = -71;
        byArray2[163] = 121;
        byArray2[164] = -69;
        byArray2[165] = 123;
        byArray2[166] = 122;
        byArray2[167] = -70;
        byArray2[168] = -66;
        byArray2[169] = 126;
        byArray2[170] = 127;
        byArray2[171] = -65;
        byArray2[172] = 125;
        byArray2[173] = -67;
        byArray2[174] = -68;
        byArray2[175] = 124;
        byArray2[176] = -76;
        byArray2[177] = 116;
        byArray2[178] = 117;
        byArray2[179] = -75;
        byArray2[180] = 119;
        byArray2[181] = -73;
        byArray2[182] = -74;
        byArray2[183] = 118;
        byArray2[184] = 114;
        byArray2[185] = -78;
        byArray2[186] = -77;
        byArray2[187] = 115;
        byArray2[188] = -79;
        byArray2[189] = 113;
        byArray2[190] = 112;
        byArray2[191] = -80;
        byArray2[192] = 80;
        byArray2[193] = -112;
        byArray2[194] = -111;
        byArray2[195] = 81;
        byArray2[196] = -109;
        byArray2[197] = 83;
        byArray2[198] = 82;
        byArray2[199] = -110;
        byArray2[200] = -106;
        byArray2[201] = 86;
        byArray2[202] = 87;
        byArray2[203] = -105;
        byArray2[204] = 85;
        byArray2[205] = -107;
        byArray2[206] = -108;
        byArray2[207] = 84;
        byArray2[208] = -100;
        byArray2[209] = 92;
        byArray2[210] = 93;
        byArray2[211] = -99;
        byArray2[212] = 95;
        byArray2[213] = -97;
        byArray2[214] = -98;
        byArray2[215] = 94;
        byArray2[216] = 90;
        byArray2[217] = -102;
        byArray2[218] = -101;
        byArray2[219] = 91;
        byArray2[220] = -103;
        byArray2[221] = 89;
        byArray2[222] = 88;
        byArray2[223] = -104;
        byArray2[224] = -120;
        byArray2[225] = 72;
        byArray2[226] = 73;
        byArray2[227] = -119;
        byArray2[228] = 75;
        byArray2[229] = -117;
        byArray2[230] = -118;
        byArray2[231] = 74;
        byArray2[232] = 78;
        byArray2[233] = -114;
        byArray2[234] = -113;
        byArray2[235] = 79;
        byArray2[236] = -115;
        byArray2[237] = 77;
        byArray2[238] = 76;
        byArray2[239] = -116;
        byArray2[240] = 68;
        byArray2[241] = -124;
        byArray2[242] = -123;
        byArray2[243] = 69;
        byArray2[244] = -121;
        byArray2[245] = 71;
        byArray2[246] = 70;
        byArray2[247] = -122;
        byArray2[248] = -126;
        byArray2[249] = 66;
        byArray2[250] = 67;
        byArray2[251] = -125;
        byArray2[252] = 65;
        byArray2[253] = -127;
        byArray2[254] = -128;
        byArray2[255] = 64;
        byte[] auchCRCLo = byArray2;
        short usDataLen = (short)numberOfBytes;
        byte uchCRCHi = -1;
        byte uchCRCLo = -1;
        int i = 0;
        while (usDataLen > 0) {
            usDataLen = (short)(usDataLen - 1);
            int uIndex = uchCRCLo ^ data[i + startByte];
            if (uIndex < 0) {
                uIndex += 256;
            }
            uchCRCLo = (byte)(uchCRCHi ^ auchCRCHi[uIndex]);
            uchCRCHi = auchCRCLo[uIndex];
            ++i;
        }
        byte[] returnValue = new byte[]{uchCRCLo, uchCRCHi};
        return returnValue;
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] ReadDiscreteInputs(int startingAddress, int quantity) throws ModbusException, UnknownHostException, SocketException, IOException {
        block22: {
            if (this.tcpClientSocket == null) {
                throw new ConnectionException("connection Error");
            }
            if (startingAddress > 65535 | quantity > 2000) {
                throw new IllegalArgumentException("Starting adress must be 0 - 65535; quantity must be 0 - 2000");
            }
            response = null;
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = (byte)2;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            this.quantity = ModbusClient.toByteArray(quantity);
            data = new byte[]{this.transactionIdentifier[1], this.transactionIdentifier[0], this.protocolIdentifier[1], this.protocolIdentifier[0], this.length[1], this.length[0], this.unitIdentifier, this.functionCode, this.startingAddress[1], this.startingAddress[0], this.quantity[1], this.quantity[0], this.crc[0], this.crc[1]};
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, 6, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block22;
            this.out.write(data, 6, 8);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 5 + quantity / 8 + 1;
            if (quantity % 8 == 0) {
                expectedlength = 5 + quantity / 8;
            }
            currentLength = 0;
            ** GOTO lbl42
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block0;
                    receivedUnitIdentifier = serialdata[0];
lbl42:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                serialdata = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length - 2, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 130 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 130 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting adress invalid or starting adress + quantity invalid");
        }
        if ((data[7] & 255) == 130 & data[8] == 3) {
            throw new QuantityInvalidException("Quantity invalid");
        }
        if ((data[7] & 255) == 130 & data[8] == 4) {
            throw new ModbusException("Error reading");
        }
        response = new boolean[quantity];
        i = 0;
        while (i < quantity) {
            intData = data[9 + i / 8];
            mask = (int)Math.pow(2.0, i % 8);
            response[i] = (intData = (intData & mask) / mask) > 0;
            ++i;
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] ReadCoils(int startingAddress, int quantity) throws ModbusException, UnknownHostException, SocketException, IOException {
        block22: {
            if (this.tcpClientSocket == null) {
                throw new ConnectionException("connection Error");
            }
            if (startingAddress > 65535 | quantity > 2000) {
                throw new IllegalArgumentException("Starting adress must be 0 - 65535; quantity must be 0 - 2000");
            }
            response = new boolean[quantity];
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = 1;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            this.quantity = ModbusClient.toByteArray(quantity);
            data = new byte[]{this.transactionIdentifier[1], this.transactionIdentifier[0], this.protocolIdentifier[1], this.protocolIdentifier[0], this.length[1], this.length[0], this.unitIdentifier, this.functionCode, this.startingAddress[1], this.startingAddress[0], this.quantity[1], this.quantity[0], this.crc[0], this.crc[1]};
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, 6, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block22;
            this.out.write(data, 6, 8);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 5 + quantity / 8 + 1;
            if (quantity % 8 == 0) {
                expectedlength = 5 + quantity / 8;
            }
            currentLength = 0;
            ** GOTO lbl42
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block0;
                    receivedUnitIdentifier = serialdata[0];
lbl42:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                serialdata = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 129 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 129 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting adress invalid or starting adress + quantity invalid");
        }
        if ((data[7] & 255) == 129 & data[8] == 3) {
            throw new QuantityInvalidException("Quantity invalid");
        }
        if ((data[7] & 255) == 129 & data[8] == 4) {
            throw new ModbusException("Error reading");
        }
        i = 0;
        while (i < quantity) {
            intData = data[9 + i / 8];
            mask = (int)Math.pow(2.0, i % 8);
            response[i] = (intData = (intData & mask) / mask) > 0;
            ++i;
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    public int[] ReadHoldingRegisters(int startingAddress, int quantity) throws ModbusException, UnknownHostException, SocketException, IOException {
        block22: {
            if (this.tcpClientSocket == null) {
                throw new ConnectionException("connection Error");
            }
            if (startingAddress > 65535 | quantity > 125) {
                throw new IllegalArgumentException("Starting adress must be 0 - 65535; quantity must be 0 - 125");
            }
            response = new int[quantity];
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = (byte)3;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            this.quantity = ModbusClient.toByteArray(quantity);
            data = new byte[]{this.transactionIdentifier[1], this.transactionIdentifier[0], this.protocolIdentifier[1], this.protocolIdentifier[0], this.length[1], this.length[0], this.unitIdentifier, this.functionCode, this.startingAddress[1], this.startingAddress[0], this.quantity[1], this.quantity[0], this.crc[0], this.crc[1]};
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, 6, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block22;
            this.out.write(data, 6, 8);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 5 + 2 * quantity;
            currentLength = 0;
            ** GOTO lbl40
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block0;
                    receivedUnitIdentifier = serialdata[0];
lbl40:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
            if (serialdata != null) {
                data = new byte[262];
                System.arraycopy(serialdata, 0, data, 6, serialdata.length);
            }
            i = 0;
            while (i < quantity) {
                bytes = new byte[]{data[3 + i * 2], data[3 + i * 2 + 1]};
                byteBuffer = ByteBuffer.wrap(bytes);
                response[i] = byteBuffer.getShort();
                ++i;
            }
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if (data[7] == 131 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if (data[7] == 131 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting adress invalid or starting adress + quantity invalid");
        }
        if (data[7] == 131 & data[8] == 3) {
            throw new QuantityInvalidException("Quantity invalid");
        }
        if (data[7] == 131 & data[8] == 4) {
            throw new ModbusException("Error reading");
        }
        i = 0;
        while (i < quantity) {
            bytes = new byte[]{data[9 + i * 2], data[9 + i * 2 + 1]};
            byteBuffer = ByteBuffer.wrap(bytes);
            response[i] = byteBuffer.getShort();
            ++i;
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    public int[] ReadInputRegisters(int startingAddress, int quantity) throws ModbusException, UnknownHostException, SocketException, IOException {
        block22: {
            if (this.tcpClientSocket == null) {
                throw new ConnectionException("connection Error");
            }
            if (startingAddress > 65535 | quantity > 125) {
                throw new IllegalArgumentException("Starting adress must be 0 - 65535; quantity must be 0 - 125");
            }
            response = new int[quantity];
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = (byte)4;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            this.quantity = ModbusClient.toByteArray(quantity);
            data = new byte[]{this.transactionIdentifier[1], this.transactionIdentifier[0], this.protocolIdentifier[1], this.protocolIdentifier[0], this.length[1], this.length[0], this.unitIdentifier, this.functionCode, this.startingAddress[1], this.startingAddress[0], this.quantity[1], this.quantity[0], this.crc[0], this.crc[1]};
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, 6, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block22;
            this.out.write(data, 6, 8);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 5 + 2 * quantity;
            currentLength = 0;
            ** GOTO lbl40
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block0;
                    receivedUnitIdentifier = serialdata[0];
lbl40:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
            if (serialdata != null) {
                data = new byte[262];
                System.arraycopy(serialdata, 0, data, 6, serialdata.length);
            }
            i = 0;
            while (i < quantity) {
                bytes = new byte[]{data[3 + i * 2], data[3 + i * 2 + 1]};
                byteBuffer = ByteBuffer.wrap(bytes);
                response[i] = byteBuffer.getShort();
                ++i;
            }
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
            if ((data[7] & 255) == 132 & data[8] == 1) {
                throw new FunctionCodeNotSupportedException("Function code not supported by master");
            }
            if ((data[7] & 255) == 132 & data[8] == 2) {
                throw new StartingAddressInvalidException("Starting adress invalid or starting adress + quantity invalid");
            }
            if ((data[7] & 255) == 132 & data[8] == 3) {
                throw new QuantityInvalidException("Quantity invalid");
            }
            if ((data[7] & 255) == 132 & data[8] == 4) {
                throw new ModbusException("Error reading");
            }
        }
        i = 0;
        while (i < quantity) {
            bytes = new byte[]{data[9 + i * 2], data[9 + i * 2 + 1]};
            byteBuffer = ByteBuffer.wrap(bytes);
            response[i] = byteBuffer.getShort();
            ++i;
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    public void WriteSingleCoil(int startingAddress, boolean value) throws ModbusException, UnknownHostException, SocketException, IOException {
        block19: {
            if (this.tcpClientSocket == null & this.udpFlag == false) {
                throw new ConnectionException("connection error");
            }
            coilValue = new byte[2];
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = (byte)5;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            coilValue = value != false ? ModbusClient.toByteArray(65280) : ModbusClient.toByteArray(0);
            data = new byte[]{this.transactionIdentifier[1], this.transactionIdentifier[0], this.protocolIdentifier[1], this.protocolIdentifier[0], this.length[1], this.length[0], this.unitIdentifier, this.functionCode, this.startingAddress[1], this.startingAddress[0], coilValue[1], coilValue[0], this.crc[0], this.crc[1]};
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, 6, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block19;
            this.out.write(data, 6, 8);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 8;
            currentLength = 0;
            ** GOTO lbl38
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block0;
                    receivedUnitIdentifier = serialdata[0];
lbl38:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 133 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 133 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting address invalid or starting address + quantity invalid");
        }
        if ((data[7] & 255) == 133 & data[8] == 3) {
            throw new QuantityInvalidException("quantity invalid");
        }
        if ((data[7] & 255) == 133 & data[8] == 4) {
            throw new ModbusException("error reading");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void WriteSingleRegister(int startingAddress, int value) throws ModbusException, UnknownHostException, SocketException, IOException {
        block19: {
            if (this.tcpClientSocket == null & this.udpFlag == false) {
                throw new ConnectionException("connection error");
            }
            registerValue = new byte[2];
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = (byte)6;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            registerValue = ModbusClient.toByteArray((short)value);
            data = new byte[]{this.transactionIdentifier[1], this.transactionIdentifier[0], this.protocolIdentifier[1], this.protocolIdentifier[0], this.length[1], this.length[0], this.unitIdentifier, this.functionCode, this.startingAddress[1], this.startingAddress[0], registerValue[1], registerValue[0], this.crc[0], this.crc[1]};
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, 6, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block19;
            this.out.write(data, 6, 8);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 8;
            currentLength = 0;
            ** GOTO lbl38
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block0;
                    receivedUnitIdentifier = serialdata[0];
lbl38:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 134 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 134 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting address invalid or starting address + quantity invalid");
        }
        if ((data[7] & 255) == 134 & data[8] == 3) {
            throw new QuantityInvalidException("quantity invalid");
        }
        if ((data[7] & 255) == 134 & data[8] == 4) {
            throw new ModbusException("error reading");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void WriteMultipleCoils(int startingAddress, boolean[] values) throws ModbusException, UnknownHostException, SocketException, IOException {
        block22: {
            byteCount = (byte)(values.length / 8 + 1);
            if (values.length % 8 == 0) {
                byteCount = (byte)(byteCount - 1);
            }
            quantityOfOutputs = ModbusClient.toByteArray(values.length);
            singleCoilValue = 0;
            if (this.tcpClientSocket == null & this.udpFlag == false) {
                throw new ConnectionException("connection error");
            }
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(7 + (values.length / 8 + 1));
            this.functionCode = (byte)15;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            data = new byte[16 + byteCount - 1];
            data[0] = this.transactionIdentifier[1];
            data[1] = this.transactionIdentifier[0];
            data[2] = this.protocolIdentifier[1];
            data[3] = this.protocolIdentifier[0];
            data[4] = this.length[1];
            data[5] = this.length[0];
            data[6] = this.unitIdentifier;
            data[7] = this.functionCode;
            data[8] = this.startingAddress[1];
            data[9] = this.startingAddress[0];
            data[10] = quantityOfOutputs[1];
            data[11] = quantityOfOutputs[0];
            data[12] = byteCount;
            i = 0;
            while (i < values.length) {
                if (i % 8 == 0) {
                    singleCoilValue = 0;
                }
                CoilValue = values[i] != false ? 1 : 0;
                data[13 + i / 8] = singleCoilValue = (int)((byte)(CoilValue << i % 8 | singleCoilValue));
                ++i;
            }
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, data.length - 8, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block22;
            this.out.write(data, 6, 9 + byteCount);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 8;
            currentLength = 0;
            ** GOTO lbl62
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block1;
                    receivedUnitIdentifier = serialdata[0];
lbl62:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 143 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 143 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting address invalid or starting address + quantity invalid");
        }
        if ((data[7] & 255) == 143 & data[8] == 3) {
            throw new QuantityInvalidException("quantity invalid");
        }
        if ((data[7] & 255) == 143 & data[8] == 4) {
            throw new ModbusException("error reading");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void WriteMultipleRegisters(int startingAddress, int[] values) throws ModbusException, UnknownHostException, SocketException, IOException {
        block20: {
            byteCount = (byte)(values.length * 2);
            quantityOfOutputs = ModbusClient.toByteArray(values.length);
            if (this.tcpClientSocket == null & this.udpFlag == false) {
                throw new ConnectionException("connection error");
            }
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(7 + values.length * 2);
            this.functionCode = (byte)16;
            this.startingAddress = ModbusClient.toByteArray(startingAddress);
            data = new byte[15 + values.length * 2];
            data[0] = this.transactionIdentifier[1];
            data[1] = this.transactionIdentifier[0];
            data[2] = this.protocolIdentifier[1];
            data[3] = this.protocolIdentifier[0];
            data[4] = this.length[1];
            data[5] = this.length[0];
            data[6] = this.unitIdentifier;
            data[7] = this.functionCode;
            data[8] = this.startingAddress[1];
            data[9] = this.startingAddress[0];
            data[10] = quantityOfOutputs[1];
            data[11] = quantityOfOutputs[0];
            data[12] = byteCount;
            i = 0;
            while (i < values.length) {
                singleRegisterValue = ModbusClient.toByteArray(values[i]);
                data[13 + i * 2] = singleRegisterValue[1];
                data[14 + i * 2] = singleRegisterValue[0];
                ++i;
            }
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, data.length - 8, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block20;
            this.out.write(data, 6, 9 + byteCount);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 8;
            currentLength = 0;
            ** GOTO lbl58
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block1;
                    receivedUnitIdentifier = serialdata[0];
lbl58:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 144 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 144 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting address invalid or starting address + quantity invalid");
        }
        if ((data[7] & 255) == 144 & data[8] == 3) {
            throw new QuantityInvalidException("quantity invalid");
        }
        if ((data[7] & 255) == 144 & data[8] == 4) {
            throw new ModbusException("error reading");
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] ReadWriteMultipleRegisters(int startingAddressRead, int quantityRead, int startingAddressWrite, int[] values) throws ModbusException, UnknownHostException, SocketException, IOException {
        block22: {
            startingAddressReadLocal = new byte[2];
            quantityReadLocal = new byte[2];
            startingAddressWriteLocal = new byte[2];
            quantityWriteLocal = new byte[2];
            writeByteCountLocal = 0;
            if (this.tcpClientSocket == null & this.udpFlag == false) {
                throw new ConnectionException("connection error");
            }
            if (startingAddressRead > 65535 | quantityRead > 125 | startingAddressWrite > 65535 | values.length > 121) {
                throw new IllegalArgumentException("Starting address must be 0 - 65535; quantity must be 0 - 125");
            }
            this.transactionIdentifier = ModbusClient.toByteArray(1);
            this.protocolIdentifier = ModbusClient.toByteArray(0);
            this.length = ModbusClient.toByteArray(6);
            this.functionCode = (byte)23;
            startingAddressReadLocal = ModbusClient.toByteArray(startingAddressRead);
            quantityReadLocal = ModbusClient.toByteArray(quantityRead);
            startingAddressWriteLocal = ModbusClient.toByteArray(startingAddressWrite);
            quantityWriteLocal = ModbusClient.toByteArray(values.length);
            writeByteCountLocal = (byte)(values.length * 2);
            data = new byte[19 + values.length * 2];
            data[0] = this.transactionIdentifier[1];
            data[1] = this.transactionIdentifier[0];
            data[2] = this.protocolIdentifier[1];
            data[3] = this.protocolIdentifier[0];
            data[4] = this.length[1];
            data[5] = this.length[0];
            data[6] = this.unitIdentifier;
            data[7] = this.functionCode;
            data[8] = startingAddressReadLocal[1];
            data[9] = startingAddressReadLocal[0];
            data[10] = quantityReadLocal[1];
            data[11] = quantityReadLocal[0];
            data[12] = startingAddressWriteLocal[1];
            data[13] = startingAddressWriteLocal[0];
            data[14] = quantityWriteLocal[1];
            data[15] = quantityWriteLocal[0];
            data[16] = writeByteCountLocal;
            i = 0;
            while (i < values.length) {
                singleRegisterValue = ModbusClient.toByteArray(values[i]);
                data[17 + i * 2] = singleRegisterValue[1];
                data[18 + i * 2] = singleRegisterValue[0];
                ++i;
            }
            if (this.serialflag) {
                this.crc = ModbusClient.calculateCRC(data, data.length - 8, 6);
                data[data.length - 2] = this.crc[0];
                data[data.length - 1] = this.crc[1];
            }
            serialdata = null;
            if (!this.serialflag) break block22;
            this.out.write(data, 6, 13 + writeByteCountLocal);
            dateTimeSend = DateTime.getDateTimeTicks();
            receivedUnitIdentifier = -1;
            len = -1;
            serialBuffer = new byte[256];
            serialdata = new byte[256];
            expectedlength = 5 + quantityRead;
            currentLength = 0;
            ** GOTO lbl71
            {
                len = -1;
                while ((len = this.in.read(serialBuffer)) <= 0 & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) {
                }
                i = 0;
                while (i < len) {
                    serialdata[currentLength] = serialBuffer[i];
                    ++currentLength;
                    ++i;
                }
                do {
                    if (currentLength < expectedlength & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout)) continue block1;
                    receivedUnitIdentifier = serialdata[0];
lbl71:
                    // 2 sources

                } while (receivedUnitIdentifier != this.unitIdentifier & DateTime.getDateTimeTicks() - dateTimeSend <= (long)(10000 * this.connectTimeout));
            }
            if (receivedUnitIdentifier != this.unitIdentifier) {
                data = new byte[256];
            }
        }
        if (serialdata != null) {
            data = new byte[262];
            System.arraycopy(serialdata, 0, data, 6, serialdata.length);
        }
        if (this.tcpClientSocket.isConnected() | this.udpFlag) {
            if (this.udpFlag) {
                ipAddress = InetAddress.getByName(this.ipAddress);
                sendPacket = new DatagramPacket(data, data.length, ipAddress, this.port);
                clientSocket = new DatagramSocket();
                clientSocket.setSoTimeout(500);
                clientSocket.send(sendPacket);
                data = new byte[2100];
                receivePacket = new DatagramPacket(data, data.length);
                clientSocket.receive(receivePacket);
                clientSocket.close();
                data = receivePacket.getData();
            } else {
                this.outStream.write(data, 0, data.length - 2);
                if (this.sendDataChangedListener.size() > 0) {
                    this.sendData = new byte[data.length - 2];
                    System.arraycopy(data, 0, this.sendData, 0, data.length - 2);
                    for (SendDataChangedListener hl : this.sendDataChangedListener) {
                        hl.SendDataChanged();
                    }
                }
                data = new byte[2100];
                numberOfBytes = this.inStream.read(data, 0, data.length);
                if (this.receiveDataChangedListener.size() > 0) {
                    this.receiveData = new byte[numberOfBytes];
                    System.arraycopy(data, 0, this.receiveData, 0, numberOfBytes);
                    for (ReceiveDataChangedListener hl : this.receiveDataChangedListener) {
                        hl.ReceiveDataChanged();
                    }
                }
            }
        }
        if ((data[7] & 255) == 151 & data[8] == 1) {
            throw new FunctionCodeNotSupportedException("Function code not supported by master");
        }
        if ((data[7] & 255) == 151 & data[8] == 2) {
            throw new StartingAddressInvalidException("Starting address invalid or starting address + quantity invalid");
        }
        if ((data[7] & 255) == 151 & data[8] == 3) {
            throw new QuantityInvalidException("quantity invalid");
        }
        if ((data[7] & 255) == 151 & data[8] == 4) {
            throw new ModbusException("error reading");
        }
        response = new int[quantityRead];
        i = 0;
        while (i < quantityRead) {
            highByte = data[9 + i * 2];
            lowByte = data[9 + i * 2 + 1];
            bytes = new byte[]{highByte, lowByte};
            byteBuffer = ByteBuffer.wrap(bytes);
            response[i] = byteBuffer.getShort();
            ++i;
        }
        return response;
    }

    public void Disconnect() throws IOException {
        if (!this.serialflag) {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
            if (this.tcpClientSocket != null) {
                this.tcpClientSocket.close();
            }
            this.tcpClientSocket = null;
        } else if (this.serialPort != null) {
            this.serialPort.close();
        }
    }

    public static byte[] toByteArray(int value) {
        byte[] result = new byte[2];
        result[1] = (byte)(value >> 8);
        result[0] = (byte)value;
        return result;
    }

    public static byte[] toByteArrayDouble(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static byte[] toByteArray(float value) {
        return ByteBuffer.allocate(4).putFloat(value).array();
    }

    public boolean isConnected() {
        if (this.serialflag) {
            if (this.portIdentifier == null) {
                return false;
            }
            return this.portIdentifier.isCurrentlyOwned();
        }
        boolean returnValue = false;
        returnValue = this.tcpClientSocket == null ? false : this.tcpClientSocket.isConnected();
        return returnValue;
    }

    public String getipAddress() {
        return this.ipAddress;
    }

    public void setipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getUDPFlag() {
        return this.udpFlag;
    }

    public void setUDPFlag(boolean udpFlag) {
        this.udpFlag = udpFlag;
    }

    public int getConnectionTimeout() {
        return this.connectTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectTimeout = connectionTimeout;
    }

    public void setSerialFlag(boolean serialflag) {
        this.serialflag = serialflag;
    }

    public boolean getSerialFlag() {
        return this.serialflag;
    }

    public void setUnitIdentifier(byte unitIdentifier) {
        this.unitIdentifier = unitIdentifier;
    }

    public byte getUnitIdentifier() {
        return this.unitIdentifier;
    }

    public void addReveiveDataChangedListener(ReceiveDataChangedListener toAdd) {
        this.receiveDataChangedListener.add(toAdd);
    }

    public void addSendDataChangedListener(SendDataChangedListener toAdd) {
        this.sendDataChangedListener.add(toAdd);
    }

    public static enum RegisterOrder {
        LowHigh,
        HighLow;

    }
}

