/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class KnxSystemAirconAPI
extends WallPadDevAPI {
    private final String TAG = "SystemAirconAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"SystemAirconAPI", (String)s);
    }

    public KnxSystemAirconAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("SystemAirconAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "KNXAIRCON";
        this.data = new Data();
        int ret = this.Refresh((byte)100, false);
        if (ret == 0) {
            byte AirconCount = this.data.Device.info.InsideAirconCount;
            Log.i((String)"SystemAirconAPI", (String)("GetInfo() - OK!!! (RoomCount:" + AirconCount + ")"));
            this.data.Device.SetAirconCount(AirconCount);
        } else {
            Log.i((String)"SystemAirconAPI", (String)("GetInfo() - fail!!! " + ret));
        }
        int retSetting = this.Refresh((byte)110, false);
        if (retSetting == 0) {
            byte AirconCount = this.data.Device.info.InsideAirconCount;
            Log.i((String)"SystemAirconAPI", (String)("GetInfo() - OK!!! (RoomCount:" + AirconCount + ")"));
            this.data.Device.SetAirconCount(AirconCount);
        } else {
            Log.i((String)"SystemAirconAPI", (String)("GetInfoSetting() - fail!!! " + retSetting));
        }
    }

    public int Refresh(byte Index, boolean real) {
        if ((Index < 0 || Index > 8) && Index != -1 && Index != 100 && Index != 110) {
            Log.w((String)"SystemAirconAPI", (String)("[Refresh] Param (Index) Out Of Range !!! (" + Index + ")"));
            return -300;
        }
        if (Index == 100 && real) {
            Log.w((String)"SystemAirconAPI", (String)"[Refresh] If the Index is REFRESH_IDX.INFO does not support the real(true)");
            return -300;
        }
        if (Index == 110 && real) {
            Log.w((String)"SystemAirconAPI", (String)"[Refresh] If the Index is REFRESH_IDX.INFO does not support the real(true)");
            return -300;
        }
        if (Index != 100 && this.data.Device.info.InsideAirconCount <= 0) {
            Log.w((String)"SystemAirconAPI", (String)("[Refresh] DEVICE IS NOT READY (" + Index + ")"));
            return -110;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = null;
        if (Index >= 0 && Index <= 8) {
            if (this.CheckParamAircon(Index) != 0) {
                Log.w((String)"SystemAirconAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
                return -300;
            }
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingAircon(ret);
        }
        if (Index == -1) {
            int i;
            if (real) {
                int iret = this.SendNReadCMD_int(MainCMD, SubCMD, -1, 0, 0, 0, 0);
                if (iret != 0) {
                    return -111;
                }
                MainCMD = "NOSINKCTRL";
            }
            for (i = 0; i < this.data.Device.info.InsideAirconCount && this.ParsingAircon(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) == 0; ++i) {
            }
            if (i < this.data.Device.info.InsideAirconCount) {
                Log.w((String)"SystemAirconAPI", (String)("[Refresh] REFRESH_IDX.ALL fail (i:" + i + ")"));
                return -111;
            }
            return 0;
        }
        if (Index == 100) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingInfo(ret);
        }
        if (Index == 110) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return 0;
        }
        Log.w((String)"SystemAirconAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
        return -300;
    }

    private int ParsingAircon(String ret) {
        String FUNC_NAME = "[ParsingRoom]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.KnxSystemAircon.AirData airconData = new DataClasses.KnxSystemAircon.AirData();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            byte modeData = Byte.parseByte(retData[index++]);
            byte Volume = Byte.parseByte(retData[index++]);
            byte onoff = Byte.parseByte(retData[index++]);
            airconData.Mode = modeData;
            airconData.Volume = Volume;
            airconData.OnOff = onoff;
            airconData.SetTemp = Double.parseDouble(retData[index++]);
            airconData.NowTemp = Double.parseDouble(retData[index++]);
            this.data.Device.Aircon[Current] = airconData;
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int ParsingInfo(String ret) {
        String FUNC_NAME = "[ParsingInfo]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SystemAirconAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.KnxSystemAircon.Info info = new DataClasses.KnxSystemAircon.Info();
            int index = 1;
            info.InsideAirconCount = Byte.parseByte(retData[index++]);
            info.Vendor = Byte.parseByte(retData[index++]);
            info.AirconStatus = Byte.parseByte(retData[index++]);
            info.FwVer_Year = Byte.parseByte(retData[index++]);
            info.FwVer_Month = Byte.parseByte(retData[index++]);
            info.FwVer_Day = Byte.parseByte(retData[index++]);
            info.FwVer_Number = Byte.parseByte(retData[index++]);
            info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
            info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
            info.Support.MinSetTemp = Byte.parseByte(retData[index++]);
            info.Support.MaxSetTemp = Byte.parseByte(retData[index++]);
            info.OutsideAirconCount = Byte.parseByte(retData[index++]);
            info.FirtstOutAirconCount = Byte.parseByte(retData[index++]);
            this.data.Device.info = info;
        }
        catch (Exception e) {
            Log.e((String)"SystemAirconAPI", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    public int SetEachRoomStatus(byte AirIndex, int SetMode, double SetTemp) {
        int ret = this.CheckParamAircon(AirIndex);
        if (ret != 0) {
            Log.w((String)"SystemAirconAPI", (String)("[SetEachRoomStatus] RoomIndex Out Of Range !!! (" + AirIndex + ")"));
            return ret;
        }
        ret = this.CheckParamSetMode(SetMode);
        if (ret != 0) {
            Log.w((String)"SystemAirconAPI", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
            return -300;
        }
        byte ByteTemp = 0;
        if (SetTemp != 0.0 && ((ByteTemp = (byte)SetTemp) < this.data.Device.info.Support.MinSetTemp || ByteTemp > this.data.Device.info.Support.MaxSetTemp)) {
            Log.w((String)"SystemAirconAPI", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! - (" + ByteTemp + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetEachRoomStatus", AirIndex, SetMode, ByteTemp, 0, 0);
    }

    public int SetAllRoomStatus(byte SetMode) {
        int ret = this.CheckParamSetMode(SetMode);
        if (ret != 0) {
            Log.w((String)"SystemAirconAPI", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
            return -300;
        }
        this.DebugLogOutput("[AircornAPI----------------------------------------] SetAllRoomStatus - OK");
        return this.SendNReadCMD_int("SINKCTRL", "SetAllRoomStatus", SetMode, 0, 0, 0, 0);
    }

    public int SetPollingMode(byte ChangePollingMode, byte RoomIndex) {
        int ret;
        if (ChangePollingMode != 2 && ChangePollingMode != 3) {
            return -300;
        }
        if (ChangePollingMode == 3 && (ret = this.CheckParamAircon(RoomIndex)) != 0) {
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPollingMode", ChangePollingMode, RoomIndex, 0, 0, 0);
    }

    private int CheckParamAircon(byte AirIndex) {
        byte AirCount = this.data.Device.info.InsideAirconCount;
        if (AirCount <= 0) {
            return -110;
        }
        if (this.data.Device == null) {
            return -110;
        }
        if (this.data.Device.Aircon == null) {
            return -110;
        }
        if (this.data.Device.Aircon.length <= AirIndex) {
            return -110;
        }
        return 0;
    }

    private int CheckParamSetMode(int Mode) {
        return 0;
    }

    public static class Data {
        public DataClasses.KnxSystemAircon Device = new DataClasses.KnxSystemAircon();
    }

    public static final class POLLING_MODE {
        public static final byte Normal = 2;
        public static final byte FixRoom = 3;
    }

    public static final class REFRESH_IDX {
        public static final byte AIR1 = 0;
        public static final byte AIR2 = 1;
        public static final byte AIR3 = 2;
        public static final byte AIR4 = 3;
        public static final byte AIR5 = 4;
        public static final byte AIR6 = 5;
        public static final byte AIR7 = 6;
        public static final byte AIR8 = 7;
        public static final byte AIR9 = 8;
        public static final byte ALL = -1;
        public static final byte INFO = 100;
        public static final byte SETTING = 110;
    }
}

