/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.Sdb_DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class SdbAPI
extends WallPadDevAPI {
    private final String TAG = "SdbAPI";
    private final boolean DEBUG_LOG_ON = false;
    public static byte EM_INDEX_LIVING = (byte)14;
    public static byte MAX_LIGHT_COUNT = (byte)12;
    public static byte MAX_CONCENT_COUNT = (byte)4;
    public Data data;
    private EmCountDataClass EmCountData;
    private boolean Use_LedLightExpData;
    private Sdb_DataClasses.BathRoomSensorLightClass BathRoomSensorLight;

    private void DebugLogOutput(String s) {
    }

    public SdbAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("SdbAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "SMART_DISTRIBUTION_BD";
        this.data = new Data();
        int ret = this.EmCountData_Load();
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[create] EmCountData_Load Error (ret:" + ret + ")"));
        }
        this.Use_LedLightExpData = false;
        this.BathRoomSensorLight = null;
    }

    public void Set_Use_LedLightExpData(boolean set) {
        Log.i((String)"SdbAPI", (String)("[Set_Use_LedLightExpData] set : " + set));
        this.Use_LedLightExpData = set;
    }

    public boolean Get_Use_LedLightExpData() {
        return this.Use_LedLightExpData;
    }

    public int Refresh(byte DeviceIndex, byte EmIndex) {
        int iret;
        int ret;
        String FUNC_NAME = "[Refresh]";
        this.DebugLogOutput(FUNC_NAME + "(DeviceIndex:" + DeviceIndex + ", EmIndex:" + EmIndex + ")");
        if ((DeviceIndex == DEVICE_INDEX.ALL || DeviceIndex == DEVICE_INDEX.ENERGY_METER) && (ret = this.EmCountData_Load()) < 0) {
            Log.w((String)"SdbAPI", (String)("[Refresh] EmCountData_Load Error (ret:" + ret + ")"));
            return -101;
        }
        if (DeviceIndex == DEVICE_INDEX.ALL) {
            if (EmIndex != -1) {
                Log.w((String)"SdbAPI", (String)("[Refresh] Param : EmIndex - Out Of Range !!! For DeviceIndex:DEVICE_INDEX.ALL, EmIndex must be define.DEVICE_ALL_OR_NOTHING.  (EmIndex:" + EmIndex + ")"));
                return -300;
            }
        } else if (!DEVICE_INDEX.CheckRange(DeviceIndex)) {
            Log.w((String)"SdbAPI", (String)("[Refresh] Param : DeviceIndex - Out Of Range !!!  (DeviceIndex:" + DeviceIndex + ")"));
            return -300;
        }
        if (DeviceIndex == DEVICE_INDEX.ENERGY_METER && EmIndex != -1 && (iret = this.IndexRangeCheck(EmIndex, (byte)-1, (byte)-1)) < 0) {
            Log.w((String)"SdbAPI", (String)("[Refresh] IndexRangeCheck Error (ret:" + iret + ")"));
            return iret;
        }
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret2 = null;
        int iret2 = -1;
        if (DeviceIndex == DEVICE_INDEX.ALL) {
            byte i;
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.ENERGY_CONT, 0, 0, 0, 0);
            iret2 = this.Parsing_EnergyCont(ret2);
            if (iret2 < 0) {
                Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_EnergyCont Error !!! (iret:" + iret2 + ")"));
                return iret2;
            }
            for (i = 0; i < this.EmCountData.BadRoom_Em_Count && this.Parsing_EnergyMeter(ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, i, this.Use_LedLightExpData ? 1 : 0, 0, 0, 0), i) == 0; i = (byte)(i + 1)) {
            }
            if (i < this.EmCountData.BadRoom_Em_Count) {
                Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_EnergyMeter Error !!! (i:" + i + ")"));
                return -111;
            }
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, EM_INDEX_LIVING, this.Use_LedLightExpData ? 1 : 0, 0, 0, 0);
            iret2 = this.Parsing_EnergyMeter(ret2, EM_INDEX_LIVING);
            if (iret2 != 0) {
                Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_EnergyMeter Error !!! (EM_INDEX_LIVING) (iret:" + iret2 + ")"));
                return -111;
            }
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.INTPOWER_CONT, 0, 0, 0, 0);
            iret2 = this.Parsing_IntPowerController(ret2);
            if (iret2 < 0) {
                Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_IntPowerController Error !!! (iret:" + iret2 + ")"));
                return iret2;
            }
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.DC_APU, 0, 0, 0, 0);
            iret2 = this.Parsing_DcApu(ret2);
            if (iret2 < 0) {
                Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_DcApu Error !!! (iret:" + iret2 + ")"));
                return iret2;
            }
            return 0;
        }
        if (DeviceIndex == DEVICE_INDEX.ENERGY_CONT) {
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DeviceIndex, 0, 0, 0, 0);
            return this.Parsing_EnergyCont(ret2);
        }
        if (DeviceIndex == DEVICE_INDEX.ENERGY_METER) {
            if (EmIndex == -1) {
                byte i;
                for (i = 0; i < this.EmCountData.BadRoom_Em_Count && this.Parsing_EnergyMeter(ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, i, this.Use_LedLightExpData ? 1 : 0, 0, 0, 0), i) == 0; i = (byte)(i + 1)) {
                }
                if (i < this.EmCountData.BadRoom_Em_Count) {
                    Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ENERGY_METER - Parsing_EnergyMeter Error !!! (i:" + i + ")"));
                    return -111;
                }
                ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, EM_INDEX_LIVING, this.Use_LedLightExpData ? 1 : 0, 0, 0, 0);
                iret2 = this.Parsing_EnergyMeter(ret2, EM_INDEX_LIVING);
                if (iret2 != 0) {
                    Log.w((String)"SdbAPI", (String)("[Refresh] DEVICE_INDEX.ENERGY_METER - Parsing_EnergyMeter Error !!! (EM_INDEX_LIVING) (iret:" + iret2 + ")"));
                    return -111;
                }
                return 0;
            }
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, EmIndex, this.Use_LedLightExpData ? 1 : 0, 0, 0, 0);
            return this.Parsing_EnergyMeter(ret2, EmIndex);
        }
        if (DeviceIndex == DEVICE_INDEX.INTPOWER_CONT) {
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DeviceIndex, 0, 0, 0, 0);
            return this.Parsing_IntPowerController(ret2);
        }
        if (DeviceIndex == DEVICE_INDEX.DC_APU) {
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DeviceIndex, 0, 0, 0, 0);
            return this.Parsing_DcApu(ret2);
        }
        Log.w((String)"SdbAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + DeviceIndex + ")"));
        return -300;
    }

    private int Parsing_EnergyCont(String ret) {
        String FUNC_NAME = "[Parsing_EnergyCont]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            Sdb_DataClasses.EnergyControllerClass EnergyController = new Sdb_DataClasses.EnergyControllerClass();
            int index = 1;
            EnergyController.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!EnergyController.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 7;
            EnergyController.Info.EnergyMeterCount = Byte.parseByte(retData[index++]);
            EnergyController.Data.BatchOffStatus = Byte.parseByte(retData[index++]);
            EnergyController.Data.AllConcentStatus = Byte.parseByte(retData[index++]);
            EnergyController.Data.OutingStatus = Byte.parseByte(retData[index++]);
            EnergyController.Data.LightLimitControl = Boolean.parseBoolean(retData[index++]);
            EnergyController.Data.LighLimitLevel = Byte.parseByte(retData[index++]);
            EnergyController.Data.SmartPhoneLightControl = Byte.parseByte(retData[index++]);
            this.data.EnergyController = EnergyController;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "SdbAPI", re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"SdbAPI", (String)(FUNC_NAME + " Exception Error"));
            LogUtil.errorLogInfo("", "SdbAPI", e);
            return -100000;
        }
        return 0;
    }

    private int Parsing_EnergyMeter(String ret, byte EmIndex) {
        String FUNC_NAME = "[Parsing_EnergyMeter]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        int index = 0;
        try {
            byte i;
            if (ret == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            Sdb_DataClasses.EnergyMeterClass EnergyMeter2 = new Sdb_DataClasses.EnergyMeterClass();
            index = 1;
            EnergyMeter2.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!EnergyMeter2.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 7;
            EnergyMeter2.Info.LightCount = Byte.parseByte(retData[index++]);
            EnergyMeter2.Info.ConcentCount = Byte.parseByte(retData[index++]);
            if (!this.Use_LedLightExpData) {
                EnergyMeter2.Data.setLedLight(EnergyMeter2.Info.LightCount);
            } else {
                EnergyMeter2.Data.setLedLightExp(EnergyMeter2.Info.LightCount);
            }
            EnergyMeter2.Data.setConcent(EnergyMeter2.Info.ConcentCount);
            EnergyMeter2.Data.CommFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.AlmostSenFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.WifiModuleFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.TempSenFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.LightBD_Temp = Double.parseDouble(retData[index++]);
            EnergyMeter2.Data.LightBD_Volt = Double.parseDouble(retData[index++]);
            EnergyMeter2.Data.LightElecNow = Double.parseDouble(retData[index++]);
            EnergyMeter2.Data.LightElecAcc = Integer.parseInt(retData[index++]);
            if (!this.Use_LedLightExpData) {
                for (i = 0; i < EnergyMeter2.Info.LightCount; i = (byte)(i + 1)) {
                    EnergyMeter2.Data.LedLight[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Info.Support.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Info.Support.Dimming = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Info.Support.Color = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Info.Code.Usage = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Data.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Data.Dimming = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLight[i].Data.Color = Byte.parseByte(retData[index++]);
                }
            } else {
                for (i = 0; i < EnergyMeter2.Info.LightCount; i = (byte)(i + 1)) {
                    EnergyMeter2.Data.LedLightExp[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                    if (!EnergyMeter2.Data.LedLightExp[i].Info.Version.setData(retData, index)) {
                        return -2;
                    }
                    index += 7;
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.Dimming = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.Color = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.VoltCheck = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.Sensor = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.SensorSensitAdjust = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.FullControl_12ea = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Support.SensorDetectionCount = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Code.Usage = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Code.Controller = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Code.Volume = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Info.Code.LightVendor = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.Dimming = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.Color = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.Channel_Count = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.Channel1_InVolt = Double.parseDouble(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.Channel2_InVolt = Double.parseDouble(retData[index++]);
                    EnergyMeter2.Data.LedLightExp[i].Data.InTemp = Double.parseDouble(retData[index++]);
                }
            }
            for (i = 0; i < EnergyMeter2.Info.ConcentCount; i = (byte)(i + 1)) {
                EnergyMeter2.Data.Concent[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                if (!EnergyMeter2.Data.Concent[i].Info.Version.setData(retData, index)) {
                    return -2;
                }
                index += 7;
                EnergyMeter2.Data.Concent[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.Status = Byte.parseByte(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.Mode = Byte.parseByte(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.NowPw = Double.parseDouble(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.AccPw = Integer.parseInt(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.CutOffVal = Double.parseDouble(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.AlwaysConcent.NowPw = Double.parseDouble(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.AlwaysConcent.AccPw = Integer.parseInt(retData[index++]);
            }
            if (EmIndex == EM_INDEX_LIVING) {
                this.data.LivingRoom_EnergyMeter = EnergyMeter2;
            } else {
                this.data.BadRoom_EnergyMeter[EmIndex] = EnergyMeter2;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "SdbAPI", re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"SdbAPI", (String)(FUNC_NAME + " Exception Error (index:" + index + ")"));
            LogUtil.errorLogInfo("", "SdbAPI", e);
            return -100000;
        }
        return 0;
    }

    private int Parsing_IntPowerController(String ret) {
        String FUNC_NAME = "[Parsing_IntPowerController]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            Sdb_DataClasses.IntPowerControllerClass IntPowerController = new Sdb_DataClasses.IntPowerControllerClass();
            int index = 1;
            IntPowerController.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!IntPowerController.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 7;
            IntPowerController.Info.CircuitCount = Byte.parseByte(retData[index++]);
            IntPowerController.Data.CommFault = Boolean.parseBoolean(retData[index++]);
            IntPowerController.Data.AcApu = Boolean.parseBoolean(retData[index++]);
            IntPowerController.Data.setCircuit(IntPowerController.Info.CircuitCount);
            for (byte i = 0; i < IntPowerController.Info.CircuitCount; i = (byte)(i + 1)) {
                IntPowerController.Data.Circuit[i].Status = Byte.parseByte(retData[index++]);
                IntPowerController.Data.Circuit[i].NowPw = Integer.parseInt(retData[index++]);
                IntPowerController.Data.Circuit[i].AccPw = Integer.parseInt(retData[index++]);
            }
            this.data.IntPowerController = IntPowerController;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "SdbAPI", re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"SdbAPI", (String)(FUNC_NAME + " Exception Error"));
            LogUtil.errorLogInfo("", "SdbAPI", e);
            return -100000;
        }
        return 0;
    }

    private int Parsing_DcApu(String ret) {
        String FUNC_NAME = "[Parsing_DcApu]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"SdbAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            Sdb_DataClasses.DcApuClass DcApu = new Sdb_DataClasses.DcApuClass();
            int index = 1;
            DcApu.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!DcApu.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 7;
            DcApu.Info.SMPSCnt = Byte.parseByte(retData[index++]);
            DcApu.Data.CommFault = Boolean.parseBoolean(retData[index++]);
            DcApu.Data.SMPS_Shared = Boolean.parseBoolean(retData[index++]);
            DcApu.Data.BatchOffStatus = Byte.parseByte(retData[index++]);
            DcApu.Data.setSMPS(DcApu.Info.SMPSCnt);
            for (byte i = 0; i < DcApu.Info.SMPSCnt; i = (byte)(i + 1)) {
                DcApu.Data.SMPS[i].OnOff = Boolean.parseBoolean(retData[index++]);
                DcApu.Data.SMPS[i].Volt_Fault = Boolean.parseBoolean(retData[index++]);
                DcApu.Data.SMPS[i].Overload_Fault = Boolean.parseBoolean(retData[index++]);
                DcApu.Data.SMPS[i].Volt = Double.parseDouble(retData[index++]);
                DcApu.Data.SMPS[i].Current = Double.parseDouble(retData[index++]);
            }
            this.data.DcApu = DcApu;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "SdbAPI", re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"SdbAPI", (String)(FUNC_NAME + " Exception Error"));
            LogUtil.errorLogInfo("", "SdbAPI", e);
            return -100000;
        }
        return 0;
    }

    public int AllLightOnOff(boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "AllLightOnOff", OnOff ? 1 : 0, 0, 0, 0, 0);
    }

    public int SetLight(byte EmIndex, byte LightIndex, boolean OnOff, byte Dimming, byte Color) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetLight] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"SdbAPI", (String)("[SetLight] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"SdbAPI", (String)("[SetLight] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLight", EmIndex, LightIndex, OnOff ? 1 : 0, Dimming, Color);
    }

    public int SetLight2(byte EmIndex, byte LightIndex, byte OnOff, byte Dimming, byte Color) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetLight2] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        if (!this.LightPowerRangeCheck(OnOff)) {
            Log.w((String)"SdbAPI", (String)("[SetLight] Param : Power Out Of Range !!! (OnOff:" + OnOff + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"SdbAPI", (String)("[SetLight2] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"SdbAPI", (String)("[SetLight2] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLight2", EmIndex, LightIndex, OnOff, Dimming, Color);
    }

    public int SetLightOnOff(byte EmIndex, byte LightIndex, boolean OnOff) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetLightOnOff] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", EmIndex, LightIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetLightDimming(byte EmIndex, byte LightIndex, byte Dimming) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetLightDimming] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"SdbAPI", (String)("[SetLightDimming] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightDimming", EmIndex, LightIndex, Dimming, 0, 0);
    }

    public int SetLightColor(byte EmIndex, byte LightIndex, byte Color) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetLightColor] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"SdbAPI", (String)("[SetLightColor] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightColor", EmIndex, LightIndex, Color, 0, 0);
    }

    public int SetConcentOnOff(byte EmIndex, byte ConcentIndex, boolean OnOff) {
        int ret = this.IndexRangeCheck(EmIndex, (byte)-1, ConcentIndex);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetConcentOnOff] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentOnOff", EmIndex, ConcentIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetConcentMode(byte EmIndex, byte ConcentIndex, boolean OnOff) {
        int ret = this.IndexRangeCheck(EmIndex, (byte)-1, ConcentIndex);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetConcentMode] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentMode", EmIndex, ConcentIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetConcentCutOff(byte EmIndex, byte ConcentIndex) {
        int ret = this.IndexRangeCheck(EmIndex, (byte)-1, ConcentIndex);
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[SetConcentCutOff] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentCutOff", EmIndex, ConcentIndex, 0, 0, 0);
    }

    public int SetCircuitOnOff(byte kind, boolean OnOff) {
        if (!CIRCUIT_KIND.CheckRange(kind)) {
            Log.w((String)"SdbAPI", (String)("[SetCircuitOnOff] Param : Kind Out Of Range !!!(kind:" + kind + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetCircuitOnOff", kind, OnOff ? 1 : 0, 0, 0, 0);
    }

    public int SetChangePassword() {
        return this.SendNReadCMD_int("SINKCTRL", "SetChangePassword", 0, 0, 0, 0, 0);
    }

    public int SetInitPassword() {
        return this.SendNReadCMD_int("SINKCTRL", "SetInitPassword", 0, 0, 0, 0, 0);
    }

    public Sdb_DataClasses.BathRoomSensorLightClass Get_BathRoomSensorLight() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "Get_BathRoomSensorLight", 0, 0, 0, 0, 0);
        if (ret == null) {
            return null;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return null;
        }
        if (retlist.length < 2) {
            return null;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                byte Count;
                Sdb_DataClasses.BathRoomSensorLightClass retBathRoomSensorLight = new Sdb_DataClasses.BathRoomSensorLightClass();
                index = 1;
                retBathRoomSensorLight.Count = Count = Byte.parseByte(retlist[index++]);
                if (Count > 0) {
                    retBathRoomSensorLight.setStatus(Count);
                    for (byte i = 0; i < Count; i = (byte)(i + 1)) {
                        retBathRoomSensorLight.Status[i].EnergyIndex = Byte.parseByte(retlist[index++]);
                        retBathRoomSensorLight.Status[i].Usage = Byte.parseByte(retlist[index++]);
                        retBathRoomSensorLight.Status[i].UseOnOff = Boolean.parseBoolean(retlist[index++]);
                    }
                }
                this.BathRoomSensorLight = retBathRoomSensorLight;
                return this.BathRoomSensorLight;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "SdbAPI", re);
                return null;
            }
            catch (Exception e) {
                Log.e((String)"SdbAPI", (String)("[GetEnergyMeterCount] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "SdbAPI", e);
                return null;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return null;
    }

    public int Set_BathRoomSensorLight_OnOff(byte Index, boolean UseOnOff) {
        if (this.BathRoomSensorLight == null && this.Get_BathRoomSensorLight() == null) {
            Log.w((String)"SdbAPI", (String)"[Set_BathRoomSensorLight_OnOff] Get_BathRoomSensorLight() is null");
            return -110;
        }
        if (Index == -1) {
            Log.w((String)"SdbAPI", (String)("[SetCircuitOnOff] Param : Index  Out Of Range !!!(Index:" + Index + ")"));
            return -300;
        }
        if (Index >= this.BathRoomSensorLight.Count) {
            Log.w((String)"SdbAPI", (String)("[SetCircuitOnOff] Param : Index  Out Of Range !!!(Index:" + Index + ", Count:" + this.BathRoomSensorLight.Count + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "Set_BathRoomSensorLight_OnOff", Index, UseOnOff ? 1 : 0, 0, 0, 0);
    }

    public int Set_SmartPhoneLightControl(boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "Set_SmartPhoneLightControl", OnOff ? 1 : 0, 0, 0, 0, 0);
    }

    public int Set_AccPwReset() {
        return this.SendNReadCMD_int("SINKCTRL", "Set_AccPwReset", 0, 0, 0, 0, 0);
    }

    private int GetEnergyMeterCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetEnergyMeterCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length < 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                EmCountDataClass emCountData = new EmCountDataClass();
                index = 1;
                emCountData.LivingRoom_Em_LightCount = Byte.parseByte(retlist[index++]);
                emCountData.LivingRoom_Em_ConcentCount = Byte.parseByte(retlist[index++]);
                byte BadRoom_Em_Count = Byte.parseByte(retlist[index++]);
                if (BadRoom_Em_Count <= 0) {
                    Log.w((String)"SdbAPI", (String)("[GetEnergyMeterCount] BadRoom_Em_Count Error ...(Count:" + BadRoom_Em_Count + ")"));
                    return -1;
                }
                emCountData.BadRoom_Em_Count = BadRoom_Em_Count;
                emCountData.BadRoom_Em_LightCount = new byte[BadRoom_Em_Count];
                emCountData.BadRoom_Em_ConcentCount = new byte[BadRoom_Em_Count];
                for (byte i = 0; i < BadRoom_Em_Count; i = (byte)(i + 1)) {
                    emCountData.BadRoom_Em_LightCount[i] = Byte.parseByte(retlist[index++]);
                    emCountData.BadRoom_Em_ConcentCount[i] = Byte.parseByte(retlist[index++]);
                }
                this.EmCountData = emCountData;
                return 0;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "SdbAPI", re);
                this.EmCountData = null;
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"SdbAPI", (String)("[GetEnergyMeterCount] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "SdbAPI", e);
                this.EmCountData = null;
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        this.EmCountData = null;
        return -1;
    }

    private int EmCountData_Load() {
        if (this.EmCountData == null || this.EmCountData.BadRoom_Em_Count == 0) {
            int ret = this.GetEnergyMeterCount();
            if (ret < 0) {
                Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - GetEnergyMeterCount Error#1 !!!(ret:" + ret + ")"));
                return -101;
            }
            this.data.BadRoom_Em_Count = this.EmCountData.BadRoom_Em_Count;
        }
        if (this.data.BadRoom_EnergyMeter == null) {
            this.data.BadRoom_EnergyMeter = new Sdb_DataClasses.EnergyMeterClass[this.EmCountData.BadRoom_Em_Count];
        }
        return 0;
    }

    private boolean LightPowerRangeCheck(byte OnOff) {
        return OnOff >= LIGHT_ONOFF.ON && LIGHT_ONOFF.OFF >= OnOff || OnOff == -1;
    }

    private boolean DimmingNColorRangeCheck(byte DimmingNColor) {
        return DimmingNColor >= 1 && 10 >= DimmingNColor || DimmingNColor == -1;
    }

    private int IndexRangeCheck(byte EmIndex, byte LightIndex, byte ConcentIndex) {
        if (EmIndex < 0 || EmIndex > EM_INDEX_LIVING) {
            Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : EmIndex - Default Check Error !!!(EmIndex:" + EmIndex + ")"));
            return -300;
        }
        if (LightIndex != -1 && (LightIndex < 0 || LightIndex >= MAX_LIGHT_COUNT)) {
            Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : LightIndex - Default Check Error !!!(LightIndex:" + LightIndex + ")"));
            return -300;
        }
        if (ConcentIndex != -1 && (ConcentIndex < 0 || ConcentIndex >= MAX_CONCENT_COUNT)) {
            Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : ConcentIndex - Default Check Error !!!(ConcentIndex:" + ConcentIndex + ")"));
            return -300;
        }
        int ret = this.EmCountData_Load();
        if (ret < 0) {
            Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] EmCountData_Load Error (ret:" + ret + ")"));
            return -101;
        }
        if (EmIndex == EM_INDEX_LIVING) {
            byte ConcentCount;
            byte LightCount;
            if (LightIndex != -1 && LightIndex >= (LightCount = this.EmCountData.LivingRoom_Em_LightCount)) {
                Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : LivingRoom LightIndex - Out Of Range !!!(LightIndex:" + LightIndex + ", LightCount:" + LightCount + ")"));
                return -300;
            }
            if (ConcentIndex != -1 && ConcentIndex >= (ConcentCount = this.EmCountData.LivingRoom_Em_ConcentCount)) {
                Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : LivingRoom ConcentIndex - Out Of Range !!!(ConcentIndex:" + ConcentIndex + ", ConcentCount:" + ConcentCount + ")"));
                return -300;
            }
        } else {
            byte ConcentCount;
            byte LightCount;
            if (EmIndex >= this.EmCountData.BadRoom_Em_Count) {
                Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : EmIndex - Out Of Range !!!(EmIndex:" + EmIndex + ", BadRoom_Em_Count:" + this.EmCountData.BadRoom_Em_Count + ")"));
                return -300;
            }
            if (LightIndex != -1 && LightIndex >= (LightCount = this.EmCountData.BadRoom_Em_LightCount[EmIndex])) {
                Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : BadRoom LightIndex - Out Of Range !!!(LightIndex:" + LightIndex + ", LightCount:" + LightCount + ")"));
                return -300;
            }
            if (ConcentIndex != -1 && ConcentIndex >= (ConcentCount = this.EmCountData.BadRoom_Em_ConcentCount[EmIndex])) {
                Log.w((String)"SdbAPI", (String)("[IndexRangeCheck] - Param : BadRoom ConcentIndex - Out Of Range !!!(ConcentIndex:" + ConcentIndex + ", ConcentCount:" + ConcentCount + ")"));
                return -300;
            }
        }
        return 0;
    }

    public static class LIGHT_ONOFF {
        public static byte ON = 1;
        public static byte OFF = (byte)2;
        public static byte DONTCARE = (byte)-1;
    }

    private class EmCountDataClass {
        public byte LivingRoom_Em_LightCount = 0;
        public byte LivingRoom_Em_ConcentCount = 0;
        public byte BadRoom_Em_Count = 0;
        public byte[] BadRoom_Em_LightCount = null;
        public byte[] BadRoom_Em_ConcentCount = null;

        private EmCountDataClass() {
        }
    }

    public static class Data {
        public byte BadRoom_Em_Count = 0;
        public Sdb_DataClasses.EnergyControllerClass EnergyController = null;
        public Sdb_DataClasses.EnergyMeterClass LivingRoom_EnergyMeter = null;
        public Sdb_DataClasses.EnergyMeterClass[] BadRoom_EnergyMeter = null;
        public Sdb_DataClasses.IntPowerControllerClass IntPowerController = null;
        public Sdb_DataClasses.DcApuClass DcApu = null;
    }

    public static class CIRCUIT_KIND {
        public static byte ELEC_HEAT = 0;
        public static byte BATH_WASHER = 1;
        public static byte AIRCON_IN = (byte)2;
        public static byte AIRCON_OUT = (byte)3;
        public static byte LED_LIGHT = (byte)4;

        public static boolean CheckRange(byte nkind) {
            if (nkind == ELEC_HEAT) {
                return true;
            }
            if (nkind == BATH_WASHER) {
                return true;
            }
            if (nkind == AIRCON_IN) {
                return true;
            }
            if (nkind == AIRCON_OUT) {
                return true;
            }
            return nkind == LED_LIGHT;
        }

        public static String ToString(byte nDeviceIndex) {
            if (nDeviceIndex == ELEC_HEAT) {
                return "ELEC_HEAT";
            }
            if (nDeviceIndex == BATH_WASHER) {
                return "BATH_WASHER";
            }
            if (nDeviceIndex == AIRCON_IN) {
                return "AIRCON_IN";
            }
            if (nDeviceIndex == AIRCON_OUT) {
                return "AIRCON_OUT";
            }
            if (nDeviceIndex == LED_LIGHT) {
                return "LED_LIGHT";
            }
            return "UnDefined";
        }
    }

    public static class DEVICE_INDEX {
        public static byte ENERGY_METER = 0;
        public static byte ENERGY_CONT = (byte)16;
        public static byte INTPOWER_CONT = (byte)32;
        public static byte DC_APU = (byte)48;
        public static byte ALL = (byte)-1;

        public static boolean CheckRange(byte nDeviceIndex) {
            if (nDeviceIndex >= 0 && nDeviceIndex <= EM_INDEX_LIVING) {
                return true;
            }
            if (nDeviceIndex == ENERGY_CONT) {
                return true;
            }
            if (nDeviceIndex == INTPOWER_CONT) {
                return true;
            }
            return nDeviceIndex == DC_APU;
        }

        public static String ToString(byte nDeviceIndex) {
            if (nDeviceIndex >= 0 && nDeviceIndex <= EM_INDEX_LIVING) {
                return "ENERGY_METER #" + nDeviceIndex;
            }
            if (nDeviceIndex == ENERGY_CONT) {
                return "ENERGY_CONT";
            }
            if (nDeviceIndex == INTPOWER_CONT) {
                return "INTPOWER_CONT";
            }
            if (nDeviceIndex == DC_APU) {
                return "DC_APU";
            }
            return "UnDefined";
        }
    }
}

