/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.KNX_DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class Knx_LivingRoomLightAPI
extends WallPadDevAPI {
    private final String TAG = "Knx_LivingRoomLightAPI";
    private final boolean DEBUG_LOG_ON = true;
    public static byte MAX_LIGHT_COUNT = (byte)4;
    public KNX_DataClasses.LivingEnergyMeterClass data;

    private void DebugLogOutput(String s) {
        Log.d((String)"Knx_LivingRoomLightAPI", (String)s);
    }

    public Knx_LivingRoomLightAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("Knx_LivingRoomLightAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "KNX_LIVINGROOM_LIGHT";
        int ret = this.Refresh();
        if (ret < 0) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[create] Refresh Error (ret:" + ret + ")"));
            this.data = new KNX_DataClasses.LivingEnergyMeterClass();
        }
    }

    public int Refresh() {
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                KNX_DataClasses.LivingEnergyMeterClass LivingEnergyMeter = new KNX_DataClasses.LivingEnergyMeterClass();
                index = 1;
                LivingEnergyMeter.Info.Install = Boolean.parseBoolean(retlist[index++]);
                if (!LivingEnergyMeter.Info.Version.setData(retlist, index)) {
                    return -2;
                }
                index += 8;
                LivingEnergyMeter.Info.FactorySet_Info = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.ErrorDisplay_Status = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.Linkage_Info = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.DIMnCOLOR_Level = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.LightCount = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.LightType_1n2 = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.LightType_3n4 = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.LightType_Expand = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Group_Use[0] = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Group_Use[1] = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Group_Use[2] = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Info.LightGroup.Group_Use[3] = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Data.DeviceInfo = Byte.parseByte(retlist[index++]);
                LivingEnergyMeter.Data.Fault_Button = Boolean.parseBoolean(retlist[index++]);
                LivingEnergyMeter.Data.Fault_ErrorDisplay = Boolean.parseBoolean(retlist[index++]);
                if (LivingEnergyMeter.Info.LightCount > 0) {
                    LivingEnergyMeter.Data.setLivLight(LivingEnergyMeter.Info.LightCount);
                    for (byte i = 0; i < LivingEnergyMeter.Info.LightCount; i = (byte)(i + 1)) {
                        LivingEnergyMeter.Data.LIV_Lights[i].Info.Install = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LIV_Lights[i].Info.Type = Byte.parseByte(retlist[index++]);
                        LivingEnergyMeter.Data.LIV_Lights[i].Data.OnOff = Boolean.parseBoolean(retlist[index++]);
                        LivingEnergyMeter.Data.LIV_Lights[i].Data.Dimming = Byte.parseByte(retlist[index++]);
                        LivingEnergyMeter.Data.LIV_Lights[i].Data.Color = Byte.parseByte(retlist[index++]);
                    }
                }
                this.data = LivingEnergyMeter;
            }
            catch (RuntimeException e) {
                Log.e((String)"Knx_LivingRoomLightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "Knx_LivingRoomLightAPI", e);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"Knx_LivingRoomLightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "Knx_LivingRoomLightAPI", e);
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetLight(byte LightIndex, boolean OnOff, byte Dimming, byte Color) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)"[SetLight] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[SetLight] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[SetLight] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLight", LightIndex, OnOff ? 1 : 0, Dimming, Color, 0);
    }

    public int SetLightOnOff(byte LightIndex, boolean OnOff) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)"[SetLightOnOff] LightIndexRangeCheck Error");
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", LightIndex, OnOff ? 1 : 0, 0, 0, 0);
    }

    public int SetLightDimming(byte LightIndex, byte Dimming) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)"[SetLightDimming] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[SetLightDimming] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightDimming", LightIndex, Dimming, 0, 0, 0);
    }

    public int SetLightColor(byte LightIndex, byte Color) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)"[SetLightDimming] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[SetLightColor] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightColor", LightIndex, Color, 0, 0, 0);
    }

    public int SetLightGroup(byte[] lightGroupArr) {
        int ret;
        if (this.data == null && (ret = this.Refresh()) < 0) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[SetLightGroup] Refresh Error (ret:" + ret + ")"));
            return -111;
        }
        if (lightGroupArr.length != 4) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[SetLightGroup] lightGroupArr LEN Error (length:" + lightGroupArr.length + ")"));
            return -111;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightGroup", lightGroupArr[0], lightGroupArr[1], lightGroupArr[2], lightGroupArr[3], 0);
    }

    public int SetControlMode(boolean ControlType) {
        return this.SendNReadCMD_int("SINKCTRL", "SetControlMode", ControlType ? 1 : 0, 0, 0, 0, 0);
    }

    private boolean DimmingNColorRangeCheck(byte DimmingNColor) {
        return DimmingNColor >= 1 && DimmingNColor <= 10;
    }

    private boolean LightIndexRangeCheck(byte LightIndex) {
        int ret;
        if (this.data == null && (ret = this.Refresh()) < 0) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[LightIndexRangeCheck] Refresh Error (ret:" + ret + ")"));
            return false;
        }
        byte LightCount = this.data.Info.LightCount;
        if (LightIndex != -1 && (LightIndex < 0 || LightIndex >= LightCount)) {
            Log.w((String)"Knx_LivingRoomLightAPI", (String)("[LightIndexRangeCheck] - Param : LightIndex - Out Of Range !!!(LightIndex:" + LightIndex + ", LightCount:" + LightCount + ")"));
            return false;
        }
        return true;
    }

    public static class LIGHT_MODE {
        public static byte NONE = 0;
        public static byte READING = 1;
        public static byte REST = (byte)2;
        public static byte MOVIE = (byte)3;
        public static byte USER = (byte)4;

        public static boolean CheckRange(byte nMode) {
            if (nMode == READING) {
                return true;
            }
            if (nMode == REST) {
                return true;
            }
            if (nMode == MOVIE) {
                return true;
            }
            return nMode == USER;
        }

        public static String ToString(byte nMode) {
            if (nMode == READING) {
                return "READING";
            }
            if (nMode == REST) {
                return "REST";
            }
            if (nMode == MOVIE) {
                return "MOVIE";
            }
            if (nMode == USER) {
                return "USER";
            }
            return "UnDefined";
        }
    }
}

