package bssoft.stack.sip;

import java.util.Date;
import java.util.StringTokenizer;
import java.util.Timer;

public class CMCore {
	public String commandLine		= null;
	public String viaH				= null;
	public String maxforwardH		= null;
	public String contactH			= null;
	public String toH				= null;
	public String fromH				= null;
	public String callidH			= null;
	public String cseqH				= null;
	public String expiresH			= null;
	public String allowH			= null;
	public String useragentH		= null;
	public String contentlengthH	= null;
	public String authorizationH	= null;
	public String serverIp			= null;
	public int	serverPort			= 5060;
	public String serverDomain		= null;
	public String id				= null;
	public String cid				= null;
	public String authid			= null;
	public String authpassword		= null;
	public String localIp			= null;
	public String fromTag			= null;
	public String callId			= null;
	public int localPort			= 5060;
	public byte[] byteAddress		= null;
	public int CSEQ_NUMBER			= SIPStack.SIP_SEQUENCE_REGISTER;
	public  int regState			= SIPStack.SIP_REGSTATE_IDLE;
	public Date regTime				= new Date();
	
	public Date callTime			= new Date();

	public int expiresSeconds		= 60;
	public int repeatRegisterCount	= 0;
	public int registerNonceCount	= 0;
	public String ifIp				= null;
	public int ifPort				= 5060;
	public String previfIp				= null;
	public int previfPort				= 5060;
	public boolean bInterfaceChanged	= false;

	public String 				message				= null;
	public int serviceMode				= SIPStack.SIP_SERVICEMODE_BASIC;
	public boolean bRequestReadySet				= false;
	//
	public Timer	SIGNALCTRLTimer					= null;
	public Thread 	SIGNALCTRLThread				= null;
	public boolean SIGNALCTRLRunning 				= false;
	public int ctrlIndex							= 0;
	public Date ctrlIntervalTimer					= new Date();
	public Date netcheckIntervalTimer				= new Date();
	
	public Date registStatusTimer					= new Date();
	public static Date pauseTime					= new Date();//2015 07 09
	public static boolean bPausing 					= true;//2015 07 09
	public static final int BSSSIPStun_ICONTROLS_REGISTER 				= 1;
	public static final int BSSSIPStun_ICONTROLS_UNREGISTER 			= 2;
	public static final int BSSSIPStun_ICONTROLS_SET_INT_VALUE 			= 3;
	public static final int BSSSIPStun_ICONTROLS_SET_STRING_VALUE 		= 4;
	public static final int BSSSIPStun_ICONTROLS_CM_UPDATESTATUS_TRUE 	= 10;
	public static final int BSSSIPStun_ICONTROLS_CM_UPDATESTATUS_FALSE 	= 11;
	public static final int BSSSIPStun_ICONTROLS_CM_VIDEOSET_TRUE 		= 12;
	public static final int BSSSIPStun_ICONTROLS_CM_VIDEOSET_FALSE 		= 13;
	public static final int BSSSIPStun_ICONTROLS_CM_INCOMINGCALL		= 14;
	public static final int BSSSIPStun_ICONTROLS_CM_CALLCONNECTED		= 15;
	public static final int BSSSIPStun_ICONTROLS_CM_SHUTDOWNAPPLICATION	= 16;
	public static final int BSSSIPStun_ICONTROLS_CM_BACKGROUNDINCOMINGCALL	= 17;
	public static final int BSSSIPStun_ICONTROLS_CM_VIBRATOR_TRUE 		= 18;
	public static final int BSSSIPStun_ICONTROLS_CM_VIBRATOR_FALSE 		= 19;
	public static final int BSSSIPStun_ICONTROLS_CM_REGISTSTATUS_TRUE 	= 20;
	public static final int BSSSIPStun_ICONTROLS_CM_REGISTSTATUS_FALSE	= 21; 
	public static final int BSSSIPStun_ICONTROLS_CM_RINGBACKTONE_TRUE 	= 22;
	public static final int BSSSIPStun_ICONTROLS_CM_RINGBACKTONE_FALSE 	= 23;
	public static final int BSSSIPStun_ICONTROLS_CM_CALLEND_TRUE 		= 24;
	public static final int BSSSIPStun_ICONTROLS_CM_CALLEND_FALSE 		= 25;
	public static final int BSSSIPStun_ICONTROLS_CM_OUTBANDDTMF 		= 26;
	public static final int BSSSIPStun_ICONTROLS_CM_PADNUMBER 			= 27;
	public static final int BSSSIPStun_ICONTROLS_CM_PADTYPE 			= 28;
	public static final int BSSSIPStun_ICONTROLS_CM_CALLNEIGHBOR 		= 29;
	public static final int BSSSIPStun_ICONTROLS_CM_CALLGUARD 			= 30;
	public static final int BSSSIPStun_ICONTROLS_CM_CALLTIME 			= 31;
	public static final int BSSSIPStun_ICONTROLS_CM_INCOMINGMULTICALL	= 32;
	public static final int BSSSIPStun_ICONTROLS_CM_ENDMULTICALL		= 33;
	public static final int BSSSIPStun_ICONTROLS_CM_NORMALIZEMULTICALL	= 34;
	public static final int BSSSIPStun_ICONTROLS_CM_CANCELMULTICALL		= 35;
	public static final int BSSSIPStun_ICONTROLS_CM_OUTCALLFAIL			= 36;//2014 12 22
	public static final int BSSSIPStun_ICONTROLS_DIALER_ACCEPTMULTICALL	= 40;
	public static final int BSSSIPStun_ICONTROLS_DIALER_REJECTMULTICALL	= 41;
	public static final int BSSSIPStun_ICONTROLS_DIALER_CANCELMULTICALL	= 42;
	public static final int BSSSIPStun_ICONTROLS_DIALER_COMMAND 		= 43;
	public static final int BSSSIPStun_ICONTROLS_DIALER_FORWARD 		= 44;
	public static final int BSSSIPStun_ICONTROLS_CONTACT_CALLNEIGHBOR 	= 50;
	public static final int BSSSIPStun_ICONTROLS_CONTACT_CALLGUARD 		= 51;
	
	public static final int BSSSIPStun_ICONTROLS_BLOCK_INVITE_MSG         = 100;
	
	public static final int BSSSIPStun_ICONTROLS_PAUSING_DURATION		= 1000;//Milli seconds
	public static boolean bDialerActive=false;

	
	public CMCore()
	{
		if(SIPStack.bStackLicensed==false) {
			System.out.println("̽Ű ϼ.");
			System.exit(0);
		}

		commandLine			= null;
		viaH				= null;
		maxforwardH			= null;
		contactH			= null;
		toH					= null;
		fromH				= null;
		callidH				= null;
		cseqH				= null;
		expiresH			= null;
		allowH				= null;
		useragentH			= null;
		contentlengthH		= null;
		authorizationH		= null;
		serverIp			= null;
		serverPort			= 5060;
		serverDomain		= null;
		id					= null;
		cid					= null;
		authid				= null;
		authpassword		= null;
		localIp				= null;
		fromTag				= null;
		callId				= null;
		localPort			= 5060;
		byteAddress			= null;
		CSEQ_NUMBER			= SIPStack.SIP_SEQUENCE_REGISTER;
		regState			= SIPStack.SIP_REGSTATE_IDLE;
		regTime				= new Date();
		
		callTime			= new Date();

		expiresSeconds		= 60;
		repeatRegisterCount	= 0;
		registerNonceCount	= 0;
		ifIp				= null;
		ifPort				= 5060;
		previfIp			= null;
		previfPort			= 5060;
		bInterfaceChanged	= false;

		message				= null;
		serviceMode			= SIPStack.SIP_SERVICEMODE_BASIC;
		bRequestReadySet	= false;
		//
		SIGNALCTRLTimer		= null;
		SIGNALCTRLThread 	= null;
		SIGNALCTRLRunning	= false;
		ctrlIndex			= 0;
		ctrlIntervalTimer	= new Date();
		netcheckIntervalTimer	= new Date();
		registStatusTimer		= new Date();
	}
	public void action_0(byte[] byteLocalip
			,int localport
			,byte[] byteServerip
			,int serverport
			,byte[] byteServerdomain,
			byte[] byteId,
			byte[] byteCid,
			byte[] byteAuthid,
			byte[] byteAuthpassword
			)
	{
		byteAddress=byteAddress;
		localIp=new String(byteLocalip,0,0,byteLocalip.length);
		localPort=localport;

		SIPStack.localSdpIp=new String(byteLocalip,0,0,byteLocalip.length);
		if(
				SIPStack.usePrivateWiMax	== true &&
				(SIPStack.isInternetWiMax==true || SIPStack.isInternetMobile== true) &&
				SIPStack.isPrivateIp(SIPStack.localSdpIp)==false
		)
		{
			SIPStack.localSdpIp="192.168.10.2";
		}

		ifIp=new String(byteLocalip,0,0,byteLocalip.length);
		ifPort=localPort;
		//Set server information
		serverIp=new String(byteServerip,0,0,byteServerip.length);
		serverPort=serverport;
		serverDomain=new String(byteServerdomain,0,0,byteServerdomain.length);//2012 05 02
		if(serverDomain==null || serverDomain.length()==0)
		{
			serverDomain=new String(serverIp);
		}
		id=new String(byteId,0,0,byteId.length);
		cid=new String(byteCid,0,0,byteCid.length);
		if(cid.length()<7 || cid.length()==0) cid=new String(id);//2012 07 23
		authid=new String(byteAuthid,0,0,byteAuthid.length);
		authpassword=new String(byteAuthpassword,0,0,byteAuthpassword.length);
		//Initialize Headers
		//REQUEST LINE 
		commandLine="REGISTER sip:"+serverDomain+":"+serverPort+" SIP/2.0";
		//VIA HEADER
		Date today=new Date();
		viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
		//MAXFORWARDS HEADER
		maxforwardH="Max-Forwards: 70";
		//CONTACT HEADER
		contactH="Contact: <sip:"+id+"@"+localIp+":"+localPort+">";
		//TO HEADER
		toH="To: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">";
		//FROM HEADER
		fromTag=SIPStack.newTag();
		fromH="From: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">;tag="+fromTag;
		//CALLID HEADER
		callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
		callidH="Call-ID: "+callId;
		//CSEQ HEADER
		if(CSEQ_NUMBER>65556) CSEQ_NUMBER=0;
		SIPStack.SIP_SEQUENCE_REGISTER=CSEQ_NUMBER;
		cseqH="CSeq: "+CSEQ_NUMBER+" REGISTER";
		//EXPIRES HEADER
		expiresH="Expires: "+expiresSeconds;
		//ALLOW HEADER
		allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
		//USER-AGENT HEADER
		useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
		//CONTENT-LENGTH HEADER
		contentlengthH="Content-Length: 0";
		//AUTHORIZATION HEADER
		//
		message=commandLine+SIPStack.SIP_LINE_END+
				viaH+SIPStack.SIP_LINE_END+
				maxforwardH+SIPStack.SIP_LINE_END+
				contactH+SIPStack.SIP_LINE_END +
				fromH+SIPStack.SIP_LINE_END +
				toH+SIPStack.SIP_LINE_END+
				callidH+SIPStack.SIP_LINE_END+
				cseqH+SIPStack.SIP_LINE_END+
				expiresH+SIPStack.SIP_LINE_END+
				allowH+SIPStack.SIP_LINE_END+
				useragentH+SIPStack.SIP_LINE_END+
				contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;
		if(SIPStack.bUseCtrlTimer==true)
		{
			if(SIGNALCTRLTimer!=null) SIGNALCTRLTimer.cancel();
		}
		else {
			if(SIGNALCTRLThread!=null) SIGNALCTRLThread.interrupt();
			SIGNALCTRLRunning=false;
		}
		SIGNALCTRLTimer = new Timer(); 
	}
	public void action_1(
			byte[] byteAddress,
			byte[] byteLocalip,
			int localport,
			String strServerHost,
			int serverport,
			String strServerDomain,
			byte[] byteId,
			byte[] byteCid,
			byte[] byteAuthid,
			byte[] byteAuthpassword
		)
	{
		byteAddress=byteAddress;
		localIp=new String(byteLocalip,0,0,byteLocalip.length);
		localPort=localport;
		SIPStack.localSdpIp=localIp;
		//2012 07 26
		ifIp=new String(byteLocalip,0,0,byteLocalip.length);
		ifPort=localPort;
		serverPort=serverport;
		SIPStack.ipdns.bSipAddressResolved=false;
		SIPStack.ipdns.sipServerHost="";
		serverDomain="";
		serverIp="";
		SIPStack.ipdns.sipTry=0;
		if(strServerDomain!=null && strServerDomain.length()>0) serverDomain=new String(strServerDomain);
		if(strServerHost!=null && strServerHost.length()>0)
		{
			SIPStack.ipdns.sipServerHost=strServerHost;
		}
		else {
			SIPStack.ipdns.bSipAddressResolved=true;
		}
		

		//
		id=new String(byteId,0,0,byteId.length);
		cid=new String(byteCid,0,0,byteCid.length);
		if(cid.length()<7 || cid.length()==0) cid=new String(id);//2012 07 23
		authid=new String(byteAuthid,0,0,byteAuthid.length);
		authpassword=new String(byteAuthpassword,0,0,byteAuthpassword.length);
		//Initialize Headers
		//REQUEST LINE 
		commandLine="REGISTER sip:"+serverDomain+":"+serverPort+" SIP/2.0";
		//VIA HEADER
		Date today=new Date();
		viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
		//MAXFORWARDS HEADER
		maxforwardH="Max-Forwards: 70";
		//CONTACT HEADER
		if(ifIp!=null && ifIp.length()>0 && ifPort>0)
		{
			contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
		}
		else contactH="Contact: <sip:"+id+"@"+localIp+":"+localPort+">";
		//TO HEADER
		toH="To: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">";
		//FROM HEADER
		fromTag=SIPStack.newTag();
		fromH="From: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">;tag="+fromTag;
		//CALLID HEADER
		callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
		callidH="Call-ID: "+callId;
		//CSEQ HEADER
		if(CSEQ_NUMBER>65556) CSEQ_NUMBER=0;
		SIPStack.SIP_SEQUENCE_REGISTER=CSEQ_NUMBER;
		cseqH="CSeq: "+CSEQ_NUMBER+" REGISTER";
		//EXPIRES HEADER
		expiresH="Expires: "+expiresSeconds;
		//ALLOW HEADER
		allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
		//USER-AGENT HEADER
		useragentH="User-Agent: "+SIPStack.USER_AGENT;
		//CONTENT-LENGTH HEADER
		contentlengthH="Content-Length: 0";
		//AUTHORIZATION HEADER
		//
		message=commandLine+SIPStack.SIP_LINE_END+
				viaH+SIPStack.SIP_LINE_END+
				maxforwardH+SIPStack.SIP_LINE_END+
				contactH+SIPStack.SIP_LINE_END +
				fromH+SIPStack.SIP_LINE_END +
				toH+SIPStack.SIP_LINE_END+
				callidH+SIPStack.SIP_LINE_END+
				cseqH+SIPStack.SIP_LINE_END+
				expiresH+SIPStack.SIP_LINE_END+
				allowH+SIPStack.SIP_LINE_END+
				useragentH+SIPStack.SIP_LINE_END+
				contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;
		if(SIPStack.bUseCtrlTimer==true)
		{
			if(SIGNALCTRLTimer!=null) SIGNALCTRLTimer.cancel();
		}
		else {
			if(SIGNALCTRLThread!=null) SIGNALCTRLThread.interrupt();
			SIGNALCTRLRunning=false;
		}
		SIGNALCTRLTimer = new Timer(); 
	}
	public void action_2(
			String strId,
			String strCid,
			String strAuthid,
			String strAuthpassword,
			String strServerHost,
			String strServerDomain,
			int serverport
			)
	{
		//Set server information
		serverIp=SIPStack.getIPV4(strServerHost);
		if(serverIp==null) serverIp="";
		if(strServerDomain==null || strServerDomain.length()==0) {
			serverDomain=new String(serverIp);
		}
		else serverDomain=new String(strServerDomain);

		serverPort=serverport;
		id=new String(strId);
		cid=new String(strCid);
		authid=new String(strAuthid);
		authpassword=new String(strAuthpassword);
		
		regState		= SIPStack.SIP_REGSTATE_REGISTERING;

	}
	public boolean action_net_0()
	{
		try
		{
			if(
					SIPStack.ipdns.bSipAddressResolved==false && 
					SIPStack.ipdns.sipServerHost!=null &&
					SIPStack.ipdns.sipServerHost.length()>0
					)
			{
				serverIp=SIPStack.getIPV4(SIPStack.ipdns.sipServerHost); 
				SIPStack.ipdns.sipTry++;
				if(serverIp==null) {
					serverIp="";
				}
				else {
					SIPStack.ipdns.bSipAddressResolved=true;
				}
				if(serverDomain==null || serverDomain.length()==0) {
					serverDomain=new String(SIPStack.ipdns.sipServerHost);
				}
				if(serverIp!=null && serverIp.length()>0)
				{
					regState		= SIPStack.SIP_REGSTATE_REGISTERING;
					//sendRegister();
					return true;
				}
				//
			}
			return false;
		}catch(Exception e){}
		return false;

	}
	public void action_net_1(String host)
	{
		try
		{
			if(host!=null && host.length()>0) {
				String ip=SIPStack.getIPV4(host);
				if(ip!=null && ip.length()>0) SIPStack.networkStatus=SIPStack.SIP_NETIF_AVAILABLE;
				if(ip!=null && ip.length()>0 && ip.compareToIgnoreCase(localIp)!=0)
				{
					localIp=new String(ip);
					
					if(
							SIPStack.usePrivateWiMax	== true &&
							(SIPStack.isInternetWiMax==true || SIPStack.isInternetMobile== true) &&
							SIPStack.isPrivateIp(ip)==false
					)
					{
						SIPStack.localSdpIp="192.168.10.2";
					}
					else SIPStack.localSdpIp=new String(ip);
					//

					if(ifIp==null || ifIp.length()==0 || ifPort<=0)
					{
						ifIp=new String(localIp);
						ifPort=SIPStack.SIP_LOCAL_PORT;
					}
					//
				}
				else if(ip==null || ip.length()==0)
				{
					localIp="127.0.0.1";
					SIPStack.localSdpIp="127.0.0.1";
					SIPStack.networkStatus=SIPStack.SIP_NETIF_UNAVAILABLE;
					
				}
				//
			}
			else if(host==null || host.length()==0)
			{
				localIp="127.0.0.1";
				SIPStack.localSdpIp="127.0.0.1";
				SIPStack.networkStatus=SIPStack.SIP_NETIF_UNAVAILABLE;		
			}

		}catch(Exception e){}
		return;
	}
	public boolean action_net_2(String host)
	{
		try {
			if(host!=null && host.length()>0) {
				String ip=SIPStack.getIPV4(host);
				if(ip!=null && ip.length()>0) SIPStack.networkStatus=SIPStack.SIP_NETIF_AVAILABLE;
				if(ip!=null && ip.length()>0 && ip.compareToIgnoreCase(localIp)!=0)
				{
					localIp=new String(ip);
					if(
							SIPStack.usePrivateWiMax	== true &&
							(SIPStack.isInternetWiMax==true || SIPStack.isInternetMobile== true) &&
							SIPStack.isPrivateIp(ip)==false
					)
					{
						SIPStack.localSdpIp="192.168.10.2";
					}
					else SIPStack.localSdpIp=new String(ip);
					//
					ifIp=new String(localIp);
					ifPort=SIPStack.SIP_LOCAL_PORT;
					authorizationH="";
					return true;
					
				}
				else if(ip==null || ip.length()==0)
				{
					localIp="127.0.0.1";
					SIPStack.localSdpIp="127.0.0.1";
					SIPStack.networkStatus=SIPStack.SIP_NETIF_UNAVAILABLE;
					
				}
				//
			}
			else if(host==null || host.length()==0)
			{
				localIp="127.0.0.1";
				SIPStack.localSdpIp="127.0.0.1";
				SIPStack.networkStatus=SIPStack.SIP_NETIF_UNAVAILABLE;
				
			}
			return false;

		}catch(Exception e){}
		return false;
	}
	public boolean action_net_3(String host)
	{
		try {

			if(host!=null && host.length()>0) {
				String ip=SIPStack.getIPV4(host);
				//System.out.println("ip address:"+ip);
				if(ip!=null && ip.length()>0) SIPStack.networkStatus=SIPStack.SIP_NETIF_AVAILABLE;
				if(ip!=null && ip.length()>0 && ip.compareToIgnoreCase(localIp)!=0)
				{
					localIp=new String(ip);
					if(
							SIPStack.usePrivateWiMax	== true &&
							(SIPStack.isInternetWiMax==true || SIPStack.isInternetMobile== true) &&
							SIPStack.isPrivateIp(ip)==false
					)
					{
						SIPStack.localSdpIp="192.168.10.2";
					}
					else SIPStack.localSdpIp=new String(ip);
					//

					bInterfaceChanged=true;
					previfIp=ifIp;
					previfPort=ifPort;
					ifIp=new String(localIp);
					ifPort=SIPStack.SIP_LOCAL_PORT;
					return true;					
				}
				else if(ip==null || ip.length()==0)
				{
					localIp="127.0.0.1";
					SIPStack.localSdpIp="127.0.0.1";
					SIPStack.networkStatus=SIPStack.SIP_NETIF_UNAVAILABLE;
				}
			}
			else if(host==null || host.length()==0)
			{
				localIp="127.0.0.1";
				SIPStack.localSdpIp="127.0.0.1";
				SIPStack.networkStatus=SIPStack.SIP_NETIF_UNAVAILABLE;
				
			}
			return false;
			//
		}catch(Exception e){}
		return false;
	}
	
	public SIPCONTACTHeader action_reg_0(String message)
	{
		try
		{
			//GET EXPIRES TIME
			String requestUri="sip:"+id+"@"+localIp+":"+localPort;
			
			if(
					ifIp!=null && 
					ifIp.length()>0 &&
					ifPort>0
			)
			{
				if(bInterfaceChanged==true)
					requestUri="sip:"+id+"@"+previfIp+":"+previfPort;
				else requestUri="sip:"+id+"@"+ifIp+":"+ifPort;
			}

			//2012 01 13
			return new SIPCONTACTHeader(message,requestUri);
		}catch(Exception e){}
		return null;
	}
	public boolean action_reg_1(String message)
	{
		try
		{
			SIPVIAHeader viaHeader=new SIPVIAHeader(message);
			if(viaHeader.flag==true && viaHeader.rportService==true
					&& viaHeader.rport>0 && viaHeader.received.length()>0)
			{
				if(
						ifIp==null || 
						ifIp.length()==0 || 
						ifPort<=0 || 
						ifIp.compareToIgnoreCase(viaHeader.received) !=0 ||
						ifPort != viaHeader.rport
				)
				{
					bInterfaceChanged=true;
					previfIp=ifIp;
					previfPort=ifPort;
					ifIp=new String(viaHeader.received);
					ifPort=viaHeader.getRport();
					return true;
				}

			}
			return false;
		}catch(Exception e){}
		return false;
	}
	public boolean action_reg_2(String message)
	{
		try
		{

			authorizationH="";
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
			//2013 02 12
			if(sipHeader==null || sipHeader.flag==false)
				sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
			//
			if(sipHeader!=null && sipHeader.flag==true)//2012 03 22
			{
				SIPAUTHENTICATEHeader authHeader=
						new SIPAUTHENTICATEHeader(sipHeader.header,SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
				//2013 02 12
				if(authHeader==null || authHeader.flag==false)
					authHeader=new SIPAUTHENTICATEHeader(sipHeader.header,SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
				//
				if(authHeader!=null && authHeader.flag==true)//2012 03 22
				{
					if(authHeader.nonceValue.length()>0 && authHeader.realmValue.length()>0)
					{
						String qop=authHeader.qopValue;
						String uri="sip:"+serverDomain+":"+serverPort;
						authorizationH=getAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_REGISTER
								);
						return true;
					}
				}
			}
			return false;
			//
		}catch(Exception e){}
		return false;
	}
	public boolean action_reg_3(String message)
	{
		try
		{

			regState		= SIPStack.SIP_REGSTATE_UNAUTHORIZED;
			authorizationH="";
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
			if(sipHeader!=null && sipHeader.flag==true)
			{
				SIPAUTHENTICATEHeader authHeader=
						new SIPAUTHENTICATEHeader(sipHeader.header,SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
				if(authHeader!=null && authHeader.flag==true)
				{
					if(authHeader.nonceValue.length()>0 && authHeader.realmValue.length()>0)
					{
						String qop=authHeader.qopValue;
						String uri="sip:"+serverDomain+":"+serverPort;
						authorizationH=getProxyAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_REGISTER
								);
						return true;
					}
				}
			}
			return false;

			//
		}catch(Exception e){}
		return false;
	}
	public void action_reg_4(String message)
	{
		try
		{
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_MINEXPIRES);
			if(sipHeader!=null && sipHeader.flag==true)
			{
				expiresSeconds=Integer.parseInt(sipHeader.headerValue);
			}
			regState		= SIPStack.SIP_REGSTATE_IDLE;

			//
		}catch(Exception e){}
		return;
	}
	
	public boolean action_bye_0(SIPCall sipCall,String message)
	{
		try
		{
			SIPRequestLine requestLine=new SIPRequestLine(message);
			if(requestLine!=null) 
			{
				//validate call
				SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
				boolean bValidCall=false;
				if(sipHeader != null && sipHeader.flag==true)
				{
					if(
							sipHeader.headerValue!=null && //2012 03 23
							sipHeader.headerValue.length()>0 && //2012 03 23
							sipCall.callId!=null && //2012 03 23
							sipHeader.headerValue.compareTo(sipCall.callId)==0) 
					{
						bValidCall=true;
					}
	
				}
				//
				if(bValidCall==true) {
	
	
					sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
					
					if(sipHeader != null && sipHeader.flag==true) 
					{
						//2012 06 08
						int duration=0;
						Date currentTime=new Date();
						if(sipCall.callTime_T4!=null) duration=(int)(currentTime.getTime()-sipCall.callTime_T4.getTime())/1000;
						//
	
						sipCall.BYE_CSEQ=sipHeader.callSequenceNumber();
	
						//sipCall.resetCall();
						sipCall.callState=SIPStack.SIP_CALLSTATE_TERMINATING;
						sipCall.callTime_T6=new Date();
						return true;
					}
				}
			}
		}catch(Exception e){}
		return false;
	}
	public boolean action_bye_1(SIPCall sipCall,String message)
	{
		try
		{
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			boolean bValidCall=false;
			if(sipHeader != null && sipHeader.flag==true)
			{
				if(
						sipHeader.headerValue!=null && 
						sipHeader.headerValue.length()>0 && 
						sipCall.callId!=null && 
						sipHeader.headerValue.compareTo(sipCall.callId)==0) 
				{
					bValidCall=true;
				}
			}
			//
			if(bValidCall==true) {
				sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
				
				if(sipHeader != null && sipHeader.flag==true) 
				{
					sipCall.BYE_CSEQ=sipHeader.callSequenceNumber();
					sipCall.bByedisconnected=false;//2015 06 19
					sipCall.resetCall();
					return true;
				}
				
			}
		}catch(Exception e){}
		return false;
	}
	public boolean action_info_0(SIPCall sipCall,String message,int msgType)
	{
		try
		{
			if(
					msgType				== SIPStack.SIP_MSGTYPE_REQUEST 	&& 
					sipCall.flag		== true 							&& 
					sipCall.callState	== SIPStack.SIP_CALLSTATE_CONNECTED
				)
			{
				
				SIPRequestLine requestLine=new SIPRequestLine(message);
				if(requestLine!=null) 
				{
					//validate call
					SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
					if(sipHeader != null && sipHeader.flag==true)
					{
						if(
								sipHeader.headerValue!=null && //2012 03 23
								sipHeader.headerValue.length()>0 && //2012 03 23
								sipCall.callId!=null && //2012 03 23
								sipHeader.headerValue.compareTo(sipCall.callId)==0) 
						{
							return true;
						}
					}
					//
				}
			}
		}catch(Exception e){}
		return false;
		
	}
	public String getAuthorizationHeader(
			String qop,
			String authid,
			String realmValue,
			String authpassword,
			String uri,
			String nonceValue,
			int		methodType
			)
	{
		String strHeader=null;
		String finalDigest=null;
		String step1Digest=SIPStack.BSSMD5Get(authid+":"+realmValue+":"+authpassword);
		String step2Digest=null;
		if(methodType==SIPStack.SIP_METHODTYPE_REGISTER) step2Digest=SIPStack.BSSMD5Get("REGISTER:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_INVITE) step2Digest=SIPStack.BSSMD5Get("INVITE:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_CANCEL) step2Digest=SIPStack.BSSMD5Get("CANCEL:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_ACK) step2Digest=SIPStack.BSSMD5Get("ACK:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_BYE) step2Digest=SIPStack.BSSMD5Get("BYE:"+uri);
		registerNonceCount++;
		if(qop.length()>0)
		{
			int nonceCount=0;
			String cnonce=SIPStack.BSSMD5Get("60cf184b29500b20"+registerNonceCount);
			if(nonceValue.length()>0) nonceCount=1;
			finalDigest=SIPStack.BSSMD5Get(step1Digest+":"+nonceValue+":"+String.format("%08x",nonceCount)+":"+cnonce+":"+qop+":"+step2Digest);
			strHeader="Authorization: Digest"+
					" username=\""+authid+"\","+
					" realm=\""+realmValue+"\","+
					" nonce=\""+nonceValue+"\","+
					" uri=\""+uri+"\","+
					" response=\""+finalDigest+"\","+
					" cnonce=\""+cnonce+"\","+
					" nc="+String.format("%08x",nonceCount)+","+
					" qop="+qop+","+
					" algorithm=MD5";
			
		}
		else {
			finalDigest=SIPStack.BSSMD5Get(step1Digest+":"+nonceValue+":"+step2Digest);
			strHeader="Authorization: Digest"+
					" username=\""+authid+"\","+
					" realm=\""+realmValue+"\","+
					" nonce=\""+nonceValue+"\","+
					" uri=\""+uri+"\","+
					" response=\""+finalDigest+"\","+
					" algorithm=MD5";
		}
		
		
		return strHeader;
	}
	public String getProxyAuthorizationHeader(
			String qop,
			String authid,
			String realmValue,
			String authpassword,
			String uri,
			String nonceValue,
			int		methodType
			)
	{
		String strHeader=null;
		String finalDigest=null;
		String step1Digest=SIPStack.BSSMD5Get(authid+":"+realmValue+":"+authpassword);
		String step2Digest=null;
		if(methodType==SIPStack.SIP_METHODTYPE_REGISTER) step2Digest=SIPStack.BSSMD5Get("REGISTER:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_INVITE) step2Digest=SIPStack.BSSMD5Get("INVITE:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_CANCEL) step2Digest=SIPStack.BSSMD5Get("CANCEL:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_ACK) step2Digest=SIPStack.BSSMD5Get("ACK:"+uri);
		else if(methodType==SIPStack.SIP_METHODTYPE_BYE) step2Digest=SIPStack.BSSMD5Get("BYE:"+uri);
		registerNonceCount++;

		if(qop.length()>0)
		{
			int nonceCount=0;
			//String cnonce="60cf184b29500b20";
			String cnonce=SIPStack.BSSMD5Get("60cf184b29500b20"+registerNonceCount);
			if(nonceValue.length()>0) nonceCount=1;
			finalDigest=SIPStack.BSSMD5Get(step1Digest+":"+nonceValue+":"+String.format("%08x",nonceCount)+":"+cnonce+":"+qop+":"+step2Digest);
			strHeader="Proxy-Authorization: Digest"+
					" username=\""+authid+"\","+
					" realm=\""+realmValue+"\","+
					" nonce=\""+nonceValue+"\","+
					" uri=\""+uri+"\","+
					" response=\""+finalDigest+"\","+
					" cnonce=\""+cnonce+"\","+
					" nc="+String.format("%08x",nonceCount)+","+
					" qop="+qop+","+
					" algorithm=MD5";
					
		
		}
		else {
			finalDigest=SIPStack.BSSMD5Get(step1Digest+":"+nonceValue+":"+step2Digest);
			strHeader="Proxy-Authorization: Digest"+
					" username=\""+authid+"\","+
					" realm=\""+realmValue+"\","+
					" nonce=\""+nonceValue+"\","+
					" uri=\""+uri+"\","+
					" response=\""+finalDigest+"\","+
					" algorithm=MD5";
					
		}
		
		return strHeader;
	}
	
	public boolean makeRegister()
	{
		try
		{
			CSEQ_NUMBER++;
			//REQUEST LINE 
			commandLine="REGISTER sip:"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			Date today=new Date();
			viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
			//MAXFORWARDS HEADER
			maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			{
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			}
			else contactH="Contact: <sip:"+id+"@"+localIp+":"+localPort+">";
			//TO HEADER
			toH="To: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">";
			//FROM HEADER
			fromTag=SIPStack.newTag();
			fromH="From: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">;tag="+fromTag;
			//CALLID HEADER
			if(callId==null || callId.length()==0)
			{
				//System.out.println("...............  !!!!! !!! !! REGIST CALL ID generate newly.");
				callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
				callidH="Call-ID: "+callId;
			}
			//CSEQ HEADER
			if(CSEQ_NUMBER>65556) CSEQ_NUMBER=0;
			SIPStack.SIP_SEQUENCE_REGISTER=CSEQ_NUMBER;
			cseqH="CSeq: "+CSEQ_NUMBER+" REGISTER";
			//EXPIRES HEADER
			expiresH="Expires: "+expiresSeconds;
			//ALLOW HEADER
			allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0";
			//AUTHORIZATION HEADER
			//
			if(authorizationH != null && authorizationH.length()>0)
			{
				message=commandLine+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						maxforwardH+SIPStack.SIP_LINE_END+
						contactH+SIPStack.SIP_LINE_END +
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						expiresH+SIPStack.SIP_LINE_END+
						allowH+SIPStack.SIP_LINE_END+
						useragentH+SIPStack.SIP_LINE_END+
						authorizationH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
			}
			else
			{
				message=commandLine+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						maxforwardH+SIPStack.SIP_LINE_END+
						contactH+SIPStack.SIP_LINE_END +
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						expiresH+SIPStack.SIP_LINE_END+
						allowH+SIPStack.SIP_LINE_END+
						useragentH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;			

			}
			return true;
		}catch(Exception e){}
		return false;
	}
	public boolean makeUNRegister()
	{
		try
		{
			CSEQ_NUMBER++;
			//REQUEST LINE 
			commandLine="REGISTER sip:"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			Date today=new Date();
			viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
			//MAXFORWARDS HEADER
			maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			{
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">;expires=0";
			}
			else contactH="Contact: <sip:"+id+"@"+localIp+":"+localPort+">;expires=0";
			//TO HEADER
			toH="To: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">";
			//FROM HEADER
			fromTag=SIPStack.newTag();
			fromH="From: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">;tag="+fromTag;
			//CALLID HEADER
			if(callId==null || callId.length()==0)
			{
				callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
				callidH="Call-ID: "+callId;
			}
			//CSEQ HEADER
			if(CSEQ_NUMBER>65556) CSEQ_NUMBER=0;
			SIPStack.SIP_SEQUENCE_REGISTER=CSEQ_NUMBER;
			cseqH="CSeq: "+CSEQ_NUMBER+" REGISTER";
			//EXPIRES HEADER
			expiresH="Expires: 0";
			//ALLOW HEADER
			allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0";
			//AUTHORIZATION HEADER
			//
			if(authorizationH != null && authorizationH.length()>0)
			{
				message=commandLine+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						maxforwardH+SIPStack.SIP_LINE_END+
						contactH+SIPStack.SIP_LINE_END +
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						expiresH+SIPStack.SIP_LINE_END+
						allowH+SIPStack.SIP_LINE_END+
						useragentH+SIPStack.SIP_LINE_END+
						authorizationH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
		
			}
			else
			{
				
				message=commandLine+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						maxforwardH+SIPStack.SIP_LINE_END+
						contactH+SIPStack.SIP_LINE_END +
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						expiresH+SIPStack.SIP_LINE_END+
						allowH+SIPStack.SIP_LINE_END+
						useragentH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;

			}
			return true;
		
		}catch(Exception e){}
		return false;
	}
	public boolean makeUNRegister(String contactip,int contactport)
	{
		try
		{
			CSEQ_NUMBER++;
			//REQUEST LINE 
			commandLine="REGISTER sip:"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			Date today=new Date();
			viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
			//MAXFORWARDS HEADER
			maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(contactip!=null && contactip.length()>0 && contactport>0)
			{
				contactH="Contact: <sip:"+id+"@"+contactip+":"+contactport+">";
			}
			else return true;
			//TO HEADER
			toH="To: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">";
			//FROM HEADER
			fromTag=SIPStack.newTag();
			fromH="From: \""+id+"\"<sip:"+id+"@"+serverDomain+":"+serverPort+">;tag="+fromTag;
			//CALLID HEADER
			if(callId==null || callId.length()==0)
			{
				//System.out.println("...............  !!!!! !!! !! REGIST CALL ID generate newly.");
				callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
				callidH="Call-ID: "+callId;
			}
			//CSEQ HEADER
			if(CSEQ_NUMBER>65556) CSEQ_NUMBER=0;
			SIPStack.SIP_SEQUENCE_REGISTER=CSEQ_NUMBER;
			cseqH="CSeq: "+CSEQ_NUMBER+" REGISTER";
			//EXPIRES HEADER
			expiresH="Expires: 0";
			//ALLOW HEADER
			allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0";
			//AUTHORIZATION HEADER
			//
			if(authorizationH != null && authorizationH.length()>0)
			{
				message=commandLine+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						maxforwardH+SIPStack.SIP_LINE_END+
						contactH+SIPStack.SIP_LINE_END +
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						expiresH+SIPStack.SIP_LINE_END+
						allowH+SIPStack.SIP_LINE_END+
						useragentH+SIPStack.SIP_LINE_END+
						authorizationH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
	
			}
			else
			{
				
				message=commandLine+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						maxforwardH+SIPStack.SIP_LINE_END+
						contactH+SIPStack.SIP_LINE_END +
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						expiresH+SIPStack.SIP_LINE_END+
						allowH+SIPStack.SIP_LINE_END+
						useragentH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;

			}
			return true;
		
		}catch(Exception e){}
		return false;
	}
	public boolean makeCancel(SIPCall sipCall)
	{
		if(sipCall==null || sipCall.flag==false ) return false;
		
		sipCall.CANCEL_CSEQ=sipCall.CSEQ_NUMBER;
		if(
				sipCall.callState != SIPStack.SIP_CALLSTATE_INVITING &&
				sipCall.callState != SIPStack.SIP_CALLSTATE_PROCEEDING &&
				sipCall.callState != SIPStack.SIP_CALLSTATE_PROGRESSING
		)
		{
			return false;
		}

		//REQUEST LINE 
		String commandLine="CANCEL sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
		//TO HEADER
		String toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";;
		//VIA HEADER(call cycle    via header invite  ״ ؾ Ѵ)
		if(sipCall.viaH==null || sipCall.viaH.length()==0) //2013 02 13
		{
			if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) sipCall.viaBranch=SIPStack.getViaBranch();
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
		}
		//CSEQ HEADER
		sipCall.cseqH="CSeq: "+sipCall.CANCEL_CSEQ+" CANCEL";
		//CONTENT-LENGTH HEADER
		sipCall.contentlengthH="Content-Length: 0";
		//ROUTE HEADER
		String routeString="";
		if(sipCall.routeArray!=null &&
				sipCall.routeArray.length()>0) routeString=sipCall.routeArray.toString();
		//CONTACT HEADER
		if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
		else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";

		//AUTHORIZATION HEADER
		//
		if(sipCall.authorizationCANCELH != null && sipCall.authorizationCANCELH.length() > 0)
		{
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							routeString+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							sipCall.authorizationCANCELH+SIPStack.SIP_LINE_END+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;
		}
		else
		{
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							routeString+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;
		}	
		return true;
		
	}
	public boolean makeRecancel(SIPCall sipCall)
	{
		if(sipCall==null || sipCall.flag==false ) return false;
		
		sipCall.CANCEL_CSEQ=sipCall.CSEQ_NUMBER;
		if(
				sipCall.callState != SIPStack.SIP_CALLSTATE_CANCELLING
		)
		{
			return false;
		}

		//REQUEST LINE 
		String commandLine="CANCEL sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
		//TO HEADER
		String toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";;
		//VIA HEADER(call cycle    via header invite  ״ ؾ Ѵ)
		if(sipCall.viaH==null || sipCall.viaH.length()==0) //2013 02 13
		{
			if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) sipCall.viaBranch=SIPStack.getViaBranch();
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
		}
		//CSEQ HEADER
		sipCall.cseqH="CSeq: "+sipCall.CANCEL_CSEQ+" CANCEL";
		//CONTENT-LENGTH HEADER
		sipCall.contentlengthH="Content-Length: 0";
		//ROUTE HEADER
		String routeString="";
		if(sipCall.routeArray!=null &&
				sipCall.routeArray.length()>0) routeString=sipCall.routeArray.toString();
		//CONTACT HEADER
		if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
		else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";

		//AUTHORIZATION HEADER
		//
		if(sipCall.authorizationCANCELH != null && sipCall.authorizationCANCELH.length() > 0)
		{
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							routeString+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							sipCall.authorizationCANCELH+SIPStack.SIP_LINE_END+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;
		}
		else
		{
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							routeString+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;
		}	
		return true;
		
	}
	public boolean makeBye(SIPCall sipCall)
	{
		if(sipCall==null || sipCall.flag==false ) return false;
		
		if(
				sipCall.callState != SIPStack.SIP_CALLSTATE_CONNECTED &&
				sipCall.callState != SIPStack.SIP_CALLSTATE_ACCEPTED &&
				sipCall.callState != SIPStack.SIP_CALLSTATE_REMOTEACCEPTED
		)
		{
			return false;
		}
		
		//REQUEST LINE
		String commandLine=null;
		if(sipCall.remoteContactUri!= null && sipCall.remoteContactUri.length()>0)
		{
			commandLine="BYE "+sipCall.remoteContactUri+" SIP/2.0";
		}
		else commandLine="BYE sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
		//VIA HEADER 2013 02 13
		if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) 
		{
			sipCall.viaBranch=SIPStack.getViaBranch();
		}
		String viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch;
		//MAXFORWARDS HEADER
		String maxforwardH="Max-Forwards: 70";
		//CONTACT HEADER
		String contactH=null;
		if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
		else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
		//TO HEADER
		String toH=null;
		if(sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN)
		{
			if(sipCall.fromHeaderValue==null || sipCall.fromHeaderValue.length()==0)
			{
				toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			}
			else toH="To: "+sipCall.fromHeaderValue;
		}
		else {
			toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.toTag;
		}
		//FROM HEADER
		String fromH=null;
		if(sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN)
		{
			if(sipCall.toHeaderValue==null || sipCall.toHeaderValue.length()==0)
			{
				fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.toTag;
			}
			else fromH="From: "+sipCall.toHeaderValue;
		}
		else
		{
			fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
		}		
		//CSEQ HEADER
		
		sipCall.BYE_CSEQ=sipCall.CSEQ_NUMBER+1;
		String cseqH="CSeq: "+sipCall.BYE_CSEQ+" BYE";
		//CONTENT-LENGTH HEADER
		String contentlengthH="Content-Length: 0";
		//ROUTE HEADER
		String routeString="";
		if(sipCall.routeArray!=null &&
				sipCall.routeArray.length()>0) routeString=sipCall.routeArray.toString();

		//AUTHORIZATION HEADER
		//
		if(sipCall.authorizationBYEH != null && sipCall.authorizationBYEH.length() > 0)
		{
			//
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							viaH+SIPStack.SIP_LINE_END+
							routeString+
							maxforwardH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END +
							fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							sipCall.authorizationBYEH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;

		}
		else 
		{
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							viaH+SIPStack.SIP_LINE_END+
							routeString+
							maxforwardH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END +
							fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;

		}		
		return true;
	}
	//2015 06 19
	public boolean makeReBye(SIPCall sipCall)
	{
		if(sipCall==null || sipCall.flag==false ) return false;
		
		if(
				sipCall.callState != SIPStack.SIP_CALLSTATE_DISCONNECTING ||
				sipCall.bByedisconnected != true
		)
		{
			return false;
		}
		
		//REQUEST LINE
		String commandLine=null;
		if(sipCall.remoteContactUri!= null && sipCall.remoteContactUri.length()>0)
		{
			commandLine="BYE "+sipCall.remoteContactUri+" SIP/2.0";
		}
		else commandLine="BYE sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
		//VIA HEADER 2013 02 13
		if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) 
		{
			sipCall.viaBranch=SIPStack.getViaBranch();
		}
		String viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch;
		//MAXFORWARDS HEADER
		String maxforwardH="Max-Forwards: 70";
		//CONTACT HEADER
		String contactH=null;
		if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
		else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
		//TO HEADER
		String toH=null;
		if(sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN)
		{
			if(sipCall.fromHeaderValue==null || sipCall.fromHeaderValue.length()==0)
			{
				toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			}
			else toH="To: "+sipCall.fromHeaderValue;
		}
		else {
			toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.toTag;
		}
		//FROM HEADER
		String fromH=null;
		if(sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN)
		{
			if(sipCall.toHeaderValue==null || sipCall.toHeaderValue.length()==0)
			{
				fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.toTag;
			}
			else fromH="From: "+sipCall.toHeaderValue;
		}
		else
		{
			fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
		}		
		//CSEQ HEADER
		
		sipCall.BYE_CSEQ=sipCall.CSEQ_NUMBER+1;
		String cseqH="CSeq: "+sipCall.BYE_CSEQ+" BYE";
		//CONTENT-LENGTH HEADER
		String contentlengthH="Content-Length: 0";
		//ROUTE HEADER
		String routeString="";
		if(sipCall.routeArray!=null &&
				sipCall.routeArray.length()>0) routeString=sipCall.routeArray.toString();

		//AUTHORIZATION HEADER
		//
		if(sipCall.authorizationBYEH != null && sipCall.authorizationBYEH.length() > 0)
		{
			//
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							viaH+SIPStack.SIP_LINE_END+
							routeString+
							maxforwardH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END +
							fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							sipCall.authorizationBYEH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;

		}
		else 
		{
			sipCall.message=
					commandLine+SIPStack.SIP_LINE_END+
							viaH+SIPStack.SIP_LINE_END+
							routeString+
							maxforwardH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END +
							fromH+SIPStack.SIP_LINE_END +
							toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;

		}		
		return true;
	}
	//
	public String getVideomediadescription(int port)
	{
		String str="m=video "+port+" RTP/AVP "+SIPStack.SIP_CODEC_H264+SIPStack.SIP_LINE_END+
				"a=rtpmap:"+SIPStack.SIP_CODEC_H264+" H264/90000"+SIPStack.SIP_LINE_END+
				"a=fmtp:"+SIPStack.SIP_CODEC_H264+" packetization-mode=1;profile-level-id=2"+SIPStack.SIP_LINE_END+
				"a=cliprect:0,0,240,320"+SIPStack.SIP_LINE_END+
				"a=framesize:"+SIPStack.SIP_CODEC_H264+" 320-240"+SIPStack.SIP_LINE_END;
				
		return str;
	}

	public boolean makeDirectcallMake(SIPCall sipCall,String number)
	{
		///!!!!!!!!!!!!!!!!!!
		String header="";
		if(sipCall==null || sipCall.flag==true) return false;
		
		//sipCall.CSEQ_NUMBER=0; original
		sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 27
		SIPStack.SIP_SEQUENCE_INVITE++;
		if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
		
		if(
				false==sipCall.activeCallHandle(
						id,
						cid,
						authid,
						authpassword,
						number,
						sipCall.serverIp,
						sipCall.serverPort,
						sipCall.serverDomain,
						localIp,
						localPort
						)
		) return false;
		
		//System.out.println("callMake: "+number);

		if(number.length()<=0) return false;
		//REQUEST LINE 
		sipCall.commandLine="INVITE sip:"+number+"@"+sipCall.serverDomain+":"+sipCall.serverPort+" SIP/2.0";
		//VIA HEADER
		Date today=new Date();
		sipCall.viaBranch=SIPStack.getViaBranch();//2013 02 13
		sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
		//MAXFORWARDS HEADER
		sipCall.maxforwardH="Max-Forwards: 70";
		//CONTACT HEADER
		if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
		else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
		//TO HEADER
		sipCall.toH="To: \""+number+"\"<sip:"+number+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
		//FROM HEADER
		sipCall.fromTag=SIPStack.newTag();
		sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
		//CALLID HEADER
		if(BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED==BSSVideo.HNS_SERVICE_LOBBY)
		{
			String postFix="";
			if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
			{
				postFix=BSSVideo.HNS_POSTFIX_GUARD;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_GUARD;
			}
			else if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
			{
				postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
			}
			else {
				postFix=BSSVideo.HNS_POSTFIX_LOBBY;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
			}
				
			sipCall.callId=BSSVideo.HNS_PREFIX_LOBBY+SIPStack.BSSMD5Get(viaH)
					+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+"."+postFix;
			sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_LOBBY;
			BSSVideo.bProgressvideooffer=true;
			//
		}
		else if(BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
		{
			String postFix="";
			if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
			{
				postFix=BSSVideo.HNS_POSTFIX_GUARD;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_GUARD;
			}
			else if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
			{
				postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
			}
			else {
				postFix=BSSVideo.HNS_POSTFIX_GUARD;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
			}

			sipCall.callId=BSSVideo.HNS_PREFIX_GUARD+SIPStack.BSSMD5Get(viaH)
					+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+"."+postFix;
			sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_GUARD;
			BSSVideo.bProgressvideooffer=true;
			//
		}
		else if(BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
		{
			String postFix="";
			if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
			{
				postFix=BSSVideo.HNS_POSTFIX_GUARD;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_GUARD;
				BSSVideo.bProgressvideooffer=true;
			}
			else if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
			{
				postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
				BSSVideo.bProgressvideooffer=true;
			}
			else {
				postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;;
				BSSVideo.bProgressvideooffer=false;
			}

			sipCall.callId=BSSVideo.HNS_PREFIX_NEIGHBOR+SIPStack.BSSMD5Get(viaH)
					+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+"."+postFix;
			sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
			
			//
		}
		else {
			sipCall.callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
			sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_NONE;
			sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NONE;
			BSSVideo.bProgressvideooffer=false;
			//
		}
		sipCall.callidH="Call-ID: "+sipCall.callId;
		//CSEQ HEADER
		//if(sipCall.CSEQ_NUMBER>65556) sipCall.CSEQ_NUMBER=0;
		//SIPStack.SIP_SEQUENCE_INVITE=sipCall.CSEQ_NUMBER;
		sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
		//ALLOW HEADER
		sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
		//USER-AGENT HEADER
		sipCall.useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
		//2012 05 05 Virtual caller id
		if(sipCall.cid!=null && sipCall.cid.length()>0)
		{
			sipCall.passertedidentityH="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			header="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
		}
		else {
			sipCall.passertedidentityH=null;
			header="";
		}
		//make body	
		int audioport=SIPStack.getFreeAudioRtpPort();
		if(audioport>0) sipCall.constructSdp();
		if(sipCall.sdp != null && sipCall.sdp.flag==true) 
		{
			sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
			if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
			{
				sipCall.sdp.setCodec(
						SIPStack.SIP_MEDIATYPE_AUDIO,
						SIPStack.SIP_CODEC_G711U,
						"PCMU/8000");
				sipCall.sdp.setCodec(
						SIPStack.SIP_MEDIATYPE_AUDIO,
						SIPStack.SIP_CODEC_G711A,
						"PCMA/8000");
			}
			else
			{
				sipCall.sdp.setCodec(
						SIPStack.SIP_MEDIATYPE_AUDIO,
						SIPStack.SIP_CODEC_G711A,
						"PCMA/8000");
				sipCall.sdp.setCodec(
						SIPStack.SIP_MEDIATYPE_AUDIO,
						SIPStack.SIP_CODEC_G711U,
						"PCMU/8000");
				
			}
			sipCall.sdp.setCodec(
					SIPStack.SIP_MEDIATYPE_AUDIO,
					RFC2833.payloadType,
					"telephone-event/8000");
			sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
		}
		
		//CONTENT-LENGTH HEADER
		String body=null;
		sipCall.contenttypeH="";
		if(sipCall.sdp != null && sipCall.sdp.flag==true)
		{
			sipCall.contenttypeH="Content-Type: application/SDP\r\n";
			//2014 05 26
			if(SIPStack.bVideocommunication==true)
			{
				body=sipCall.sdp.getBodyString()+getVideomediadescription(audioport+2);
			}
			else body=sipCall.sdp.getBodyString();
			///////////////
			sipCall.contentlengthH="Content-Length: "+body.length();
		}
		else {
			body="";
			sipCall.contentlengthH="Content-Length: 0";
		}

		//
		sipCall.callState=SIPStack.SIP_CALLSTATE_INVITING;
		sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
		
		if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
		{
			sipCall.message=
					sipCall.commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							header+
							sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
							sipCall.contenttypeH+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
							body
					;
		}
		else
		{
			sipCall.message=
					sipCall.commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							header+
							sipCall.contenttypeH+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
							body
					;

		}
		return true;
	}
	public boolean INVITEParser_action_0(SIPCall sipCall,String message)
	{
		try
		{
			SIPRequestLine requestLine=new SIPRequestLine(message);
			if(
					requestLine!=null && 
					sipCall!=null && 
					sipCall.flag==true && 
					sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_OUT
			) 
			{
				//validate call
				SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
				boolean bValidCall=false;
				if(sipHeader != null && sipHeader.flag==true)
				{
					if(
							sipHeader.headerValue!=null && //2012 03 23
							sipHeader.headerValue.length()>0 && //2012 03 23
							sipCall.callId!=null && //2012 03 23
							sipHeader.headerValue.compareTo(sipCall.callId)==0) 
					{
						//2012 1 13
						SIPHeader seqHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
						if(seqHeader != null && seqHeader.callSequenceNumber()==sipCall.CSEQ_NUMBER)
						//
						{
							sipCall.responseCode=requestLine.code;
							return true;
						}
					}
				}
			}
		}catch(Exception e){}
		return false;
	}
	public boolean ACKParser_action_0(SIPCall sipCall,String message)
	{
		try
		{
			if(
					sipCall.callState==SIPStack.SIP_CALLSTATE_UPDATEOFFERRED ||
					sipCall.callState==SIPStack.SIP_CALLSTATE_UPDATEACCEPTED 
			)
			{
				SIPRequestLine requestLine=new SIPRequestLine(message);
				if(requestLine!=null) 
				{
					SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
					boolean bValidCall=false;
					if(sipHeader != null && sipHeader.flag==true)
					{
						if(
								sipHeader.headerValue!=null && //2012 03 23
								sipHeader.headerValue.length()>0 && //2012 03 23
								sipCall.callId!=null && //2012 03 23
								sipHeader.headerValue.compareTo(sipCall.callId)==0) 
						{
							bValidCall=true;
						}
					}
					//
					if(bValidCall==true) {
						sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
						
						if(sipHeader != null && sipHeader.flag==true) 
						{
							sipCall.ACK_CSEQ=sipHeader.callSequenceNumber();
							sipCall.callMode=SIPStack.SIP_CALLMODE_BASIC;
							sipCall.callState=SIPStack.SIP_CALLSTATE_CONNECTED;
							sipCall.resetUpdateheaders();
							return true;
						}
					}
				}
			}


		}catch(Exception e){}
		return false;
		
	}
	public boolean ACKParser_action_1(SIPCall sipCall,String message)
	{
		try
		{
			SIPRequestLine requestLine=new SIPRequestLine(message);
			if(requestLine!=null) 
			{
				boolean bValidCall=false;
				SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
				if(sipHeader != null && sipHeader.flag==true)
				{
					if(
							sipHeader.headerValue!=null && //2012 03 23
							sipHeader.headerValue.length()>0 && //2012 03 23
							sipCall.callId!=null && //2012 03 23
							sipHeader.headerValue.compareTo(sipCall.callId)==0) 
					{
						bValidCall=true;
					}
				}
				if(bValidCall==true) {
					sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
					
					if(sipHeader != null && sipHeader.flag==true) 
					{
						sipCall.ACK_CSEQ=sipHeader.callSequenceNumber();
						sipCall.callState=SIPStack.SIP_CALLSTATE_CONNECTED;
						return true;
					}
				}
			}
		}catch(Exception e){}
		return false;
		
	}
	public boolean ACKParser_action_2(SIPCall sipCall,String message)
	{
		try
		{
			boolean bValidCall=false;
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipHeader != null && sipHeader.flag==true)
			{
				if(
						sipHeader.headerValue!=null && 
						sipHeader.headerValue.length()>0 && 
						sipCall.callId!=null && 
						sipHeader.headerValue.compareTo(sipCall.callId)==0) 
				{
					return true;
				}
			}
		}catch(Exception e){}
		return false;
		
	}
	public boolean CANCELParser_action_0(SIPCall sipCall,String message)
	{
		try
		{
			SIPRequestLine requestLine=new SIPRequestLine(message);
			if(requestLine!=null) 
			{
				//validate call
				SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
				boolean bValidCall=false;
				if(sipHeader != null && sipHeader.flag==true)
				{
					if(
							sipHeader.headerValue!=null && //2012 03 23
							sipHeader.headerValue.length()>0 && //2012 03 23
							sipCall.callId!=null && //2012 03 23
							sipHeader.headerValue.compareTo(sipCall.callId)==0) 
					{
						bValidCall=true;
					}
				}
				//
				if(bValidCall==true) {

					sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
					
					if(sipHeader != null && sipHeader.flag==true) 
					{
						sipCall.CANCEL_CSEQ=sipHeader.callSequenceNumber();
						sipCall.callState=SIPStack.SIP_CALLSTATE_CANCELLED;
						return true;
					}

				}
			}
		}catch(Exception e){}
		return false;
	}
	public boolean CANCELParser_action_1(SIPCall sipCall,String message)
	{
		try
		{
			SIPRequestLine requestLine=new SIPRequestLine(message);
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			boolean bValidCall=false;
			if(sipHeader != null && sipHeader.flag==true)
			{
				if(
						sipHeader.headerValue!=null && 
						sipHeader.headerValue.length()>0 && 
						sipCall.callId!=null && 
						sipHeader.headerValue.compareTo(sipCall.callId)==0) 
				{
					bValidCall=true;
				}
			}
			//
			if(bValidCall==true) {
				if(requestLine.code==401 						
					)//WWW-Athenticate
				{
					//make Authorization
					//sendCancelWithAuthorization();
				}
				else if(requestLine.code==407 								
					)//Proxy-Athenticate
				{
					//make Proxy-Authorization
					//sendCancelWithAuthorization();
				}
				return true;
			}
		}catch(Exception e){}
		return false;
	}
	
	//CANCEL ACTIONS
	public String makeAcceptCancelRequest(SIPCall sipCall,String message)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			
			sipCall.BYE_CSEQ=sipCall.ACK_CSEQ;
			
			String commandLine		= null;
			String viaH				= null;
			String maxforwardH		= null;
			String contactH			= null;
			String toH				= null;
			String fromH			= null;
			String callidH			= null;
			String cseqH			= null;
			String expiresH			= null;
			String allowH			= null;
			String useragentH		= null;
			String contentlengthH	= null;

			//REQUEST LINE 
			commandLine="SIP/2.0 200 "+SIPStack.getResponseDescription(200)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_VIA);
			if(sipHeader != null && sipHeader.flag==true) viaH=sipHeader.header+SIPStack.SIP_LINE_END;
			else viaH="";
			//FROM HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_FROM);
			if(sipHeader != null && sipHeader.flag==true) fromH=sipHeader.header+SIPStack.SIP_LINE_END;
			else fromH="";
			//TO HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_TO);
			if(sipHeader != null && sipHeader.flag==true) {
				toH=sipHeader.header+SIPStack.SIP_LINE_END;
				if(toH.indexOf("tag=")<0) toH=sipHeader.header+";tag="+SIPStack.newTag()+SIPStack.SIP_LINE_END;
			}
			else toH="";
			//CALLID HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipHeader != null && sipHeader.flag==true) callidH=sipHeader.header+SIPStack.SIP_LINE_END;
			else callidH="";
			//CSEQ HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);		
			if(sipHeader != null && sipHeader.flag==true) 
			{
				sipCall.CANCEL_CSEQ=sipHeader.callSequenceNumber();
				cseqH=sipHeader.header+SIPStack.SIP_LINE_END;
			}
			else cseqH="";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0\r\n";
			//
			
			String sendmessage=
					commandLine+
							viaH+
							fromH+
							toH+
							callidH+
							cseqH+
							contentlengthH+SIPStack.SIP_LINE_END
					;
			//
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendProgressingwithbody(SIPCall sipCall)
	{
		try
		{
			String commandLine		= null;
			String contactH			= null;
			String contentlengthH	= null;

			//REQUEST LINE 
			commandLine="SIP/2.0 183 "+SIPStack.getResponseDescription(183)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			String viaString="";
			if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
			String routeString="";
			if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//CONTENT
			String contenttypeString="";
			String bodyString="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true )
			{
				//2014 05 26
				String body="";
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getFinalBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getFinalBodyString();
				///////////////////////////////////////////////////////
				if(body!=null && body.length()>0)
				{
					bodyString=body;
					contenttypeString="Content-Type: application/SDP\r\n";
				}
			}
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: "+bodyString.length()+SIPStack.SIP_LINE_END;
			//
			
			String sendmessage=
					commandLine+
							viaString+
							routeString+
							sipCall.fromH+SIPStack.SIP_LINE_END+
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END+
							contenttypeString+
							contentlengthH+SIPStack.SIP_LINE_END+
							bodyString
					;
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendProgressing(SIPCall sipCall)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			
			
			String commandLine		= null;
			String contactH			= null;
			String contentlengthH	= null;

			//REQUEST LINE 
			commandLine="SIP/2.0 180 "+SIPStack.getResponseDescription(180)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			String viaString="";
			if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
			String routeString="";
			if(sipCall.recordrouteArray!=null &&
					sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();

			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0\r\n";
			//
			String sendmessage=
					commandLine+
							viaString+
							routeString+
							sipCall.fromH+SIPStack.SIP_LINE_END+
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_END
					;
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendProceeding(SIPCall sipCall)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			
			
			String commandLine		= null;
			String contactH			= null;
			String contentlengthH	= null;

			//REQUEST LINE 
			commandLine="SIP/2.0 100 "+SIPStack.getResponseDescription(100)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			String viaString="";
			if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
			String routeString="";
			if(sipCall.recordrouteArray!=null &&
					sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0\r\n";
			//
			
			
			String sendmessage=
					commandLine+
							viaString+
							routeString+
							sipCall.fromH+SIPStack.SIP_LINE_END+
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_END
					;

			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendAccept(SIPCall sipCall)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if( 
				sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN &&
				sipCall.callState==SIPStack.SIP_CALLSTATE_OFFERRED
			)
			{
				String commandLine		= null;
				String contactH			= null;
				String contentlengthH	= null;

				//REQUEST LINE 
				commandLine="SIP/2.0 200 "+SIPStack.getResponseDescription(200)+SIPStack.SIP_LINE_END;
				//VIA HEADER GET
				String viaString="";
				if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
				String routeString="";
				if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
				//CONTACT HEADER
				if(ifIp!=null && ifIp.length()>0 && ifPort>0)
					contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
				else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				//CONTENT
				String contenttypeString="";
				String bodyString="";
				if(sipCall.sdp != null && sipCall.sdp.flag==true )
				{
					//2014 05 26
					String body="";
					if(SIPStack.bVideocommunication==true)
					{
						body=sipCall.sdp.getFinalBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
					}
					else body=sipCall.sdp.getFinalBodyString();
					///////////////////////////////////////////////////////
					if(body!=null && body.length()>0)
					{
						bodyString=body;
						contenttypeString="Content-Type: application/SDP\r\n";
					}
				}
				//CONTENT-LENGTH HEADER
				contentlengthH="Content-Length: "+bodyString.length()+SIPStack.SIP_LINE_END;
				//
				
				String sendmessage=
						commandLine+
								viaString+
								routeString+
								sipCall.fromH+SIPStack.SIP_LINE_END+
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								contactH+SIPStack.SIP_LINE_END+
								contenttypeString+
								contentlengthH+SIPStack.SIP_LINE_END+
								bodyString
						;
				return sendmessage;
			}
		}catch(Exception e){}
		return "";
		
	}
	
	public String makeDirectsendAccept(SIPCall sipCall)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if( 
				sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN &&
				sipCall.callState==SIPStack.SIP_CALLSTATE_OFFERRED
			)
			{
				String commandLine		= null;
				String contactH			= null;
				String contentlengthH	= null;

				//REQUEST LINE 
				commandLine="SIP/2.0 200 "+SIPStack.getResponseDescription(200)+SIPStack.SIP_LINE_END;
				//VIA HEADER GET
				String viaString="";
				if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
				String routeString="";
				if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
				//CONTACT HEADER
				if(ifIp!=null && ifIp.length()>0 && ifPort>0)
					contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
				else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				//CONTENT
				String contenttypeString="";
				String bodyString="";
				if(sipCall.sdp != null && sipCall.sdp.flag==true )
				{
					//2014 05 26
					String body="";
					if(SIPStack.bVideocommunication==true)
					{
						body=sipCall.sdp.getFinalBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
					}
					else body=sipCall.sdp.getFinalBodyString();
					///////////////////////////////////////////////////////
					if(body!=null && body.length()>0)
					{
						bodyString=body;
						contenttypeString="Content-Type: application/SDP\r\n";
					}
				}
				//CONTENT-LENGTH HEADER
				contentlengthH="Content-Length: "+bodyString.length()+SIPStack.SIP_LINE_END;
				//
				
				String sendmessage=
						commandLine+
								viaString+
								routeString+
								sipCall.fromH+SIPStack.SIP_LINE_END+
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								contactH+SIPStack.SIP_LINE_END+
								contenttypeString+
								contentlengthH+SIPStack.SIP_LINE_END+
								bodyString
						;
				return sendmessage;
			}
			
		}catch(Exception e){}
		return "";
		
	}
	public boolean makeCallMake(SIPCall sipCall,String number)
	{
		try
		{
			///!!!!!!!!!!!!!!!!!!
			String header="";
			if(sipCall==null || sipCall.flag==true) return false;
			
			//sipCall.CSEQ_NUMBER=0; original
			sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 27
			SIPStack.SIP_SEQUENCE_INVITE++;
			if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
			
			if(
					false==sipCall.activeCallHandle(
							id,
							cid,
							authid,
							authpassword,
							number,
							serverIp,
							serverPort,
							serverDomain,
							localIp,
							localPort
							)
			) return false;
			
			//System.out.println("callMake: "+number);
	
			if(number.length()<=0) return false;
			//REQUEST LINE 
			sipCall.commandLine="INVITE sip:"+number+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			Date today=new Date();
			sipCall.viaBranch=SIPStack.getViaBranch();//2013 02 13
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			//MAXFORWARDS HEADER
			sipCall.maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//TO HEADER
			sipCall.toH="To: \""+number+"\"<sip:"+number+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
			//FROM HEADER
			sipCall.fromTag=SIPStack.newTag();
			sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			//CALLID HEADER
			sipCall.callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
			sipCall.callidH="Call-ID: "+sipCall.callId;
			//CSEQ HEADER
			//if(sipCall.CSEQ_NUMBER>65556) sipCall.CSEQ_NUMBER=0;
			//SIPStack.SIP_SEQUENCE_INVITE=sipCall.CSEQ_NUMBER;
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			//ALLOW HEADER
			sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			sipCall.useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//2012 05 05 Virtual caller id
			if(sipCall.cid!=null && sipCall.cid.length()>0)
			{
				sipCall.passertedidentityH="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				header="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
			}
			else {
				sipCall.passertedidentityH=null;
				header="";
			}
			//make body	
			int audioport=SIPStack.getFreeAudioRtpPort();
			if(audioport>0) sipCall.constructSdp();
			if(sipCall.sdp != null && sipCall.sdp.flag==true) 
			{
				sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
				if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
				{
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711U,
							"PCMU/8000");
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711A,
							"PCMA/8000");
				}
				else
				{
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711A,
							"PCMA/8000");
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711U,
							"PCMU/8000");
					
				}
				sipCall.sdp.setCodec(
						SIPStack.SIP_MEDIATYPE_AUDIO,
						RFC2833.payloadType,
						"telephone-event/8000");
				sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
			}
			
			//CONTENT-LENGTH HEADER
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				//2014 05 26
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();
				///////////////
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
	
			//
			sipCall.callState=SIPStack.SIP_CALLSTATE_INVITING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			
			if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
				return true;
			}
			else
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;			
				return true;
			}
		}catch(Exception e){}
		return false;
	}
	public boolean makeSendReInvite(SIPCall sipCall)
	{
		try
		{
			String header=null;
			if(sipCall==null || sipCall.flag==false) return false;
		
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			sipCall.callState=SIPStack.SIP_CALLSTATE_INVITING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();	
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
			
			if(sipCall.cid!=null && sipCall.cid.length()>0)
			{
				sipCall.passertedidentityH="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				header="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
			}
			else {
				sipCall.passertedidentityH=null;
				header="";
			}
	
			
			if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
				
				return true;
			}
			else
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;

				
				return true;
			}
		}catch(Exception e){}
		return false;
	}
	public String makeRejectCall(SIPCall sipCall,int code)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if( 
				sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN &&
				(
					sipCall.callState==SIPStack.SIP_CALLSTATE_OFFERRED ||
					sipCall.callState==SIPStack.SIP_CALLSTATE_CANCELLED
				)
			)
			{
	
				String commandLine		= null;
				String contactH			= null;
				String contentlengthH	= null;
	
				//REQUEST LINE 
				commandLine="SIP/2.0 "+code+" "+SIPStack.getResponseDescription(code)+SIPStack.SIP_LINE_END;
				//VIA HEADER GET
				String viaString="";
				if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
				String routeString="";
				if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
				//CONTACT HEADER
				if(ifIp!=null && ifIp.length()>0 && ifPort>0)
					contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
				else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				//CONTENT-LENGTH HEADER
				contentlengthH="Content-Length: "+0+SIPStack.SIP_LINE_END;
				
				//
				String sendmessage=
						commandLine+
								viaString+
								routeString+
								sipCall.fromH+SIPStack.SIP_LINE_END+
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								contactH+SIPStack.SIP_LINE_END+
								contentlengthH+SIPStack.SIP_LINE_END
						;
				return sendmessage;
			}
		}catch(Exception e){}
		return "";
	}
	public String makeRejectCall(SIPCall sipCall,int code,String contact)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if( 
				sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN &&
				(
					sipCall.callState==SIPStack.SIP_CALLSTATE_OFFERRED ||
					sipCall.callState==SIPStack.SIP_CALLSTATE_CANCELLED
				)
			)
			{
	
				String commandLine		= null;
				String contactH			= null;
				String contentlengthH	= null;
	
				//REQUEST LINE 
				commandLine="SIP/2.0 "+code+" "+SIPStack.getResponseDescription(code)+SIPStack.SIP_LINE_END;
				//VIA HEADER GET
				String viaString="";
				if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
				String routeString="";
				if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
				//CONTACT HEADER
				contactH="Contact: <"+contact+">";
				//CONTENT-LENGTH HEADER
				contentlengthH="Content-Length: "+0+SIPStack.SIP_LINE_END;
				
				//
				String sendmessage=
						commandLine+
								viaString+
								routeString+
								sipCall.fromH+SIPStack.SIP_LINE_END+
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								contactH+SIPStack.SIP_LINE_END+
								contentlengthH+SIPStack.SIP_LINE_END
						;
				return sendmessage;
			}
		}catch(Exception e){}
		return "";
	}
	public String makeRejectCall(String message,int code,String localIp,int localPort,String remoteIp,int remotePort)
	{
		try
		{
			///!!!!!!!!!!!!!!!!!!
			if(message==null || message.length()==0 || remoteIp==null || remoteIp.length()==0
					|| remotePort<=0) return "";
			
			//CONSTRUCT RESPONSE HEADERS
			String viaH						= "";
			StringBuffer viaArray			= new StringBuffer();
			String routeH					= "";
			StringBuffer routeArray			= new StringBuffer();
			String recordrouteH				= "";
			StringBuffer recordrouteArray	= new StringBuffer();
			String contactH					= "";
			String fromH					= "";
			String callidH					= "";
			String cseqH					= "";
			String contentlengthH			= "";
			
			StringTokenizer tokenArray= new StringTokenizer(message,SIPStack.SIP_LINE_END,true);
			while(tokenArray.hasMoreTokens())
			{
				String token=tokenArray.nextToken().trim();
				if(token.length()<=0) continue;
				if(token.compareTo("\r")==0) continue;
				if(token.compareTo("\n")==0) continue;
				if(token.startsWith("From: ")==true) 
				{
					fromH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("f: ")==true) //2012 04 27
				{
					fromH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("To: ")==true) 
				{
					if(token.indexOf("tag=")<0) {
						toH=token+";tag="+new Date().getTime()+SIPStack.SIP_LINE_END;
					}
					else toH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("t: ")==true) //2012 04 27
				{
					if(token.indexOf("tag=")<0) {
						toH=token+";tag="+new Date().getTime()+SIPStack.SIP_LINE_END;
					}
					else toH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("Via: ")==true) 
				{
					if(viaH==null || viaH.length()==0) {//2013 02 13
						viaH=token;
						int iS=token.indexOf(";rport=");
						if(iS>0 && token.indexOf(";received=")<0)
						{
							String s1=token.substring(0,iS);
							int iS_=token.indexOf(";",iS+1);
							String s2=null;
							if(iS_>0) {
								s2=token.substring(iS_+1);
								if(s1!=null && s2!=null) viaH=s1+";"+s2;
								else if(s1!=null) viaH=s1;
							}
							else viaH=s1;
							
							if(viaH!=null && viaH.length()>0) viaH=viaH+";received="+remoteIp+";rport="+remotePort;
						}
						if(viaH!=null && viaH.length()>0) viaArray.append(viaH+SIPStack.SIP_LINE_END);
	
					}
					else viaArray.append(token+SIPStack.SIP_LINE_END);
				}
				else if(token.startsWith("v: ")==true) 
				{
					if(viaH==null || viaH.length()==0) {
						viaH=token;
						int iS=token.indexOf(";rport=");
						if(iS>0 && token.indexOf(";received=")<0)
						{
							String s1=token.substring(0,iS);
							int iS_=token.indexOf(";",iS+1);
							String s2=null;
							if(iS_>0) {
								s2=token.substring(iS_+1);
								if(s1!=null && s2!=null) viaH=s1+";"+s2;
								else if(s1!=null) viaH=s1;
							}
							else viaH=s1;
							
							if(viaH!=null && viaH.length()>0) viaH=viaH+";received="+remoteIp+";rport="+remotePort;
						}
						if(viaH!=null && viaH.length()>0) viaArray.append(viaH+SIPStack.SIP_LINE_END);
					}
					else viaArray.append(token+SIPStack.SIP_LINE_END);
				}
				else if(token.startsWith("Record-Route: ")==true) 
				{
					if(recordrouteH==null || recordrouteH.length()==0) {
						routeH=null;
						routeArray=new StringBuffer();
						recordrouteH=token;
						recordrouteArray.append(recordrouteH+SIPStack.SIP_LINE_END);
						routeArray.append(token.substring(7)+SIPStack.SIP_LINE_END);
					}
					else {
						recordrouteArray.append(token+SIPStack.SIP_LINE_END);
						routeArray.append(token.substring(7)+SIPStack.SIP_LINE_END);
					}
				}
				else if(token.startsWith("Call-ID: ")==true) 
				{
					callidH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("i: ")==true) 
				{
					callidH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("CSeq: ")==true) 
				{
					cseqH=token+SIPStack.SIP_LINE_END;
				}
				else if(token.startsWith("Content-Length: ")==true) 
				{
					contentlengthH="Content-Length: 0\r\n";
				}
				else if(token.startsWith("l: ")==true) 
				{
					contentlengthH="Content-Length: 0\r\n";
				}
			}
				
			//REQUEST LINE 
			String commandLine="SIP/2.0 "+code+" "+SIPStack.getResponseDescription(code)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			String viaString="";
			if(viaArray.length()>0) viaString=viaArray.toString();
			String routeString="";
			if(recordrouteArray.length()>0) routeString=recordrouteArray.toString();
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else contactH="Contact: <sip:"+id+"@"+localIp+":"+localPort+">";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: "+0+SIPStack.SIP_LINE_END;
			
			//
			String sendmessage=
					commandLine+
							viaString+
							routeString+
							fromH+
							toH+
							callidH+
							cseqH+
							contactH+SIPStack.SIP_LINE_END+
							contentlengthH+SIPStack.SIP_LINE_END
					;
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendUpdateAccept(SIPCall sipCall)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if( 
				sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN &&
				sipCall.callState==SIPStack.SIP_CALLSTATE_UPDATEOFFERRED
			)
			{
				String commandLine		= null;
				String contactH			= null;
				String contentlengthH	= null;
	
				//REQUEST LINE 
				commandLine="SIP/2.0 200 "+SIPStack.getResponseDescription(200)+SIPStack.SIP_LINE_END;
				//VIA HEADER GET
				String viaString="";
				if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
				String routeString="";
				if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
				//CONTACT HEADER
				if(ifIp!=null && ifIp.length()>0 && ifPort>0)
					sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
				else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				//CONTENT
				String contenttypeString="";
				String bodyString="";
				if(sipCall.sdp != null && sipCall.sdp.flag==true )
				{
					String body=sipCall.sdp.getFinalBodyString();
					if(body!=null && body.length()>0)
					{
						bodyString=body;
						contenttypeString="Content-Type: application/SDP\r\n";
					}
				}
	
				//CONTENT-LENGTH HEADER
				contentlengthH="Content-Length: "+bodyString.length()+SIPStack.SIP_LINE_END;
				
				//
				String sendmessage=
						commandLine+
								viaString+
								routeString+
								sipCall.fromH+SIPStack.SIP_LINE_END+
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								contactH+SIPStack.SIP_LINE_END+
								contenttypeString+
								contentlengthH+SIPStack.SIP_LINE_END+
								bodyString
						;
		
				return sendmessage;
			}
		}catch(Exception e){}
		return "";
	}
	public boolean makeSendRedirectCall(SIPCall sipCall,String message)
	{
		try
		{
			String header=null;
			if(message==null || message.length()==0) return false;
			if(sipCall==null || sipCall.flag==false) return false;
		
			//Get Redirect Contact
			SIPCONTACTHeader contactHeader=new SIPCONTACTHeader(message);	
			if(contactHeader==null || contactHeader.flag==false)
			{
				return false;
			}
			//
			sipCall.initializeRedirectCall();
			
			//sipCall.CSEQ_NUMBER++; original
			sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 27
			SIPStack.SIP_SEQUENCE_INVITE++;
			if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
			//
			//VIA HEADER
			//REQUEST LINE 
			if(contactHeader != null && contactHeader.sipuri!=null &&
					contactHeader.sipuri.length()>0)
			{
				sipCall.commandLine="INVITE "+contactHeader.sipuri+" SIP/2.0";
				sipCall.remoteIp=contactHeader.ip;
				sipCall.remotePort=contactHeader.port;
				sipCall.dnis=contactHeader.username;
				sipCall.serverDomain=contactHeader.ip;
				sipCall.serverPort=contactHeader.port;
				BSSVideo.HNS_SERVICE_RECEIVER_SELECTED=BSSVideo.HNS_SERVICE_NEIGHBOR;
				if(contactHeader.username.startsWith("lobby")==true)
					BSSVideo.HNS_SERVICE_RECEIVER_SELECTED=BSSVideo.HNS_SERVICE_LOBBY;
				else if(contactHeader.username.startsWith("office")==true)
					BSSVideo.HNS_SERVICE_RECEIVER_SELECTED=BSSVideo.HNS_SERVICE_GUARD;

				//!!!!
			}
			else {
				return false;
			}
			//VIA HEADER
			Date today=new Date();
			sipCall.viaBranch=SIPStack.getViaBranch();//2013 02 13
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			//MAXFORWARDS HEADER
			sipCall.maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//TO HEADER
			sipCall.toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
			//FROM HEADER
			sipCall.fromTag=SIPStack.newTag();
			sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			//CALLID HEADER
			if(BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED==BSSVideo.HNS_SERVICE_LOBBY)
			{
				String postFix="";
				if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
				{
					postFix=BSSVideo.HNS_POSTFIX_GUARD;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_GUARD;
				}
				else if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
				{
					postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
				}
				else {
					postFix=BSSVideo.HNS_POSTFIX_LOBBY;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
				}
					
				sipCall.callId=BSSVideo.HNS_PREFIX_LOBBY+SIPStack.BSSMD5Get(viaH)
						+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+"."+postFix;
				sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_LOBBY;
				BSSVideo.bProgressvideooffer=true;
				//
			}
			else if(BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
			{
				String postFix="";
				if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
				{
					postFix=BSSVideo.HNS_POSTFIX_GUARD;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_GUARD;
				}
				else if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
				{
					postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
				}
				else {
					postFix=BSSVideo.HNS_POSTFIX_GUARD;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;
				}

				sipCall.callId=BSSVideo.HNS_PREFIX_GUARD+SIPStack.BSSMD5Get(viaH)
						+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+"."+postFix;
				sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_GUARD;
				BSSVideo.bProgressvideooffer=true;
				//
			}
			else if(BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
			{
				String postFix="";
				if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_GUARD)
				{
					postFix=BSSVideo.HNS_POSTFIX_GUARD;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_GUARD;
					BSSVideo.bProgressvideooffer=true;
				}
				else if(BSSVideo.HNS_SERVICE_RECEIVER_SELECTED==BSSVideo.HNS_SERVICE_NEIGHBOR)
				{
					postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
					BSSVideo.bProgressvideooffer=true;
				}
				else {
					postFix=BSSVideo.HNS_POSTFIX_NEIGHBOR;
					sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_ORIGINATOR_SELECTED;;
					BSSVideo.bProgressvideooffer=false;
				}

				sipCall.callId=BSSVideo.HNS_PREFIX_NEIGHBOR+SIPStack.BSSMD5Get(viaH)
						+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+"."+postFix;
				sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_NEIGHBOR;
				
				//
			}
			else {
				sipCall.callId=SIPStack.BSSMD5Get(viaH)+SIPStack.BSSMD5Get("1198602188")+today.getSeconds()+".";
				sipCall.hnsOriginatorServiceType=BSSVideo.HNS_SERVICE_NONE;
				sipCall.hnsReceiverServiceType=BSSVideo.HNS_SERVICE_NONE;
				BSSVideo.bProgressvideooffer=false;
				//
			}			//
			sipCall.callidH="Call-ID: "+sipCall.callId;
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			//ALLOW HEADER
			sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			sipCall.useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//2012 05 05 Virtual caller id
			if(sipCall.cid!=null && sipCall.cid.length()>0)
			{
				sipCall.passertedidentityH="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				header="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
			}
			else {
				sipCall.passertedidentityH=null;
				header="";
			}
	
			//make body
			//for debug
			int audioport=SIPStack.getFreeAudioRtpPort();
			if(audioport>0) sipCall.constructSdp();
			if(sipCall.sdp != null && sipCall.sdp.flag==true) 
			{
				sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
				if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
				{
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711U,
							"PCMU/8000");
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711A,
							"PCMA/8000");
				}
				else
				{
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711A,
							"PCMA/8000");
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							SIPStack.SIP_CODEC_G711U,
							"PCMU/8000");
					
				}
				sipCall.sdp.setCodec(
						SIPStack.SIP_MEDIATYPE_AUDIO,
						RFC2833.payloadType,
						"telephone-event/8000");
				sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
			}
			
			//CONTENT-LENGTH HEADER
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();	
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
	
	
			//
			sipCall.callState=SIPStack.SIP_CALLSTATE_INVITING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			
			sipCall.message=
					sipCall.commandLine+SIPStack.SIP_LINE_END+
							sipCall.viaH+SIPStack.SIP_LINE_END+
							sipCall.maxforwardH+SIPStack.SIP_LINE_END+
							sipCall.contactH+SIPStack.SIP_LINE_END +
							sipCall.fromH+SIPStack.SIP_LINE_END +
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							sipCall.allowH+SIPStack.SIP_LINE_END+
							sipCall.useragentH+SIPStack.SIP_LINE_END+
							header+
							sipCall.contenttypeH+
							sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
							body
					;
			
			
			return true;
		}catch(Exception e){}
		return false;

	}
	public boolean makeReactionForWWWAUTHENTICATE(SIPCall sipCall,String message)
	{
		try
		{
			String header=null;
			if(sipCall==null || sipCall.flag==false) return false;
			
			SIPStack.SIP_SEQUENCE_INVITE++;
			sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 31
			if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
	
			
			//
			sipCall.authorizationINVITEH="";
			sipCall.authorizationCANCELH="";
			sipCall.authorizationBYEH="";
			sipCall.authorizationACKH="";
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
			//2013 02 12
			if(sipHeader==null || sipHeader.flag==false)
				sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
			//
			if(sipHeader!=null && sipHeader.flag==true)//2012 03 22
			{
				SIPAUTHENTICATEHeader authHeader=
						new SIPAUTHENTICATEHeader(sipHeader.header,SIPStack.SIP_HEADERTYPE_WWWAUTHENTICATE);
				//2013 02 12
				if(authHeader==null || authHeader.flag==false)
					authHeader=new SIPAUTHENTICATEHeader(sipHeader.header,SIPStack.SIP_HEADERTYPE_WwwAUTHENTICATE);
				//
				if(authHeader!=null && authHeader.flag==true)//2012 03 22
				{
					if(authHeader.nonceValue.length()>0 && authHeader.realmValue.length()>0)
					{
						String qop=authHeader.qopValue;
						String uri="sip:"+serverDomain+":"+serverPort;
						//INVITE AUTHORIZATION HEADER
						sipCall.authorizationINVITEH=getAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_INVITE
								);
						//CANCEL AUTHORIZATION HEADER
						sipCall.authorizationCANCELH=getAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_CANCEL
								);
						//BYE AUTHORIZATION HEADER
						sipCall.authorizationBYEH=getAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_BYE
								);
						//ACK AUTHORIZATION HEADER
						sipCall.authorizationACKH=getAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_ACK
								);
					}
				}
			}
	
			//REQUEST LINE 
			sipCall.commandLine="INVITE sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			sipCall.viaBranch=SIPStack.getViaBranch();//2013 02 13
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			//MAXFORWARDS HEADER
			sipCall.maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//TO HEADER
			sipCall.toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
			//FROM HEADER
			sipCall.fromTag=SIPStack.newTag();
			sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			//ALLOW HEADER
			sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			sipCall.useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//2012 05 05 Virtual caller id
			if(sipCall.cid!=null && sipCall.cid.length()>0)
			{
				sipCall.passertedidentityH="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				header="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
			}
			else {
				sipCall.passertedidentityH=null;
				header="";
			}
	
			//make body
			if(sipCall.sdp==null)
			{
				int audioport=SIPStack.getFreeAudioRtpPort();
				if(audioport>0) sipCall.constructSdp();
				if(sipCall.sdp != null && sipCall.sdp.flag==true) 
				{
					sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
					
					if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
					}
					else
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						
					}
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							RFC2833.payloadType,
							"telephone-event/8000");
					sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
				}
			}		
			//CONTENT-LENGTH HEADER
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				//2014 05 26
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();
				///////////////
	
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
	
	
			//
			sipCall.callState=SIPStack.SIP_CALLSTATE_INVITING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			sipCall.message="";
			
			if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
			}
			else
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
			}
			return true;
		}catch(Exception e){}
		return false;
	}
	public boolean makeReactionForPROXYAUTHENTICATE(SIPCall sipCall,String message)
	{
		try
		{
			String header=null;
			if(sipCall==null || sipCall.flag==false) return false;
			
			SIPStack.SIP_SEQUENCE_INVITE++;
			sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 31
			if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
			//
			
			//
			sipCall.authorizationINVITEH="";
			sipCall.authorizationCANCELH="";
			sipCall.authorizationBYEH="";
			sipCall.authorizationACKH="";
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
			if(sipHeader!=null && sipHeader.flag==true) //2012 03 22
			{
				SIPAUTHENTICATEHeader authHeader=
						new SIPAUTHENTICATEHeader(sipHeader.header,SIPStack.SIP_HEADERTYPE_PROXYAUTHENTICATE);
				if(authHeader.flag==true)
				{
					if(authHeader.nonceValue.length()>0 && authHeader.realmValue.length()>0)
					{
						String qop=authHeader.qopValue;
						String uri="sip:"+serverDomain+":"+serverPort;
						//INVITE AUTHORIZATION HEADER
						sipCall.authorizationINVITEH=getProxyAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_INVITE
								);
						//CANCEL AUTHORIZATION HEADER
						sipCall.authorizationCANCELH=getProxyAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_CANCEL
								);
						//BYE AUTHORIZATION HEADER
						sipCall.authorizationBYEH=getProxyAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_BYE
								);
						//ACK AUTHORIZATION HEADER
						sipCall.authorizationACKH=getProxyAuthorizationHeader(
								qop,
								authid,
								authHeader.realmValue,
								authpassword,uri,
								authHeader.nonceValue,
								SIPStack.SIP_METHODTYPE_ACK
								);
					}
	
				}
			}
	
			//REQUEST LINE 
			sipCall.commandLine="INVITE sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			//2013 02 13
			sipCall.viaBranch=SIPStack.getViaBranch();
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			//MAXFORWARDS HEADER
			sipCall.maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//TO HEADER
			sipCall.toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
			//FROM HEADER
			sipCall.fromTag=SIPStack.newTag();
			sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			//ALLOW HEADER
			sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			sipCall.useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o";
			//2012 05 05 Virtual caller id
			if(sipCall.cid!=null && sipCall.cid.length()>0)
			{
				sipCall.passertedidentityH="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">";
				header="P-Asserted-Identity: <sip:"+sipCall.cid+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
			}
			else {
				sipCall.passertedidentityH=null;
				header="";
			}
	
			//make body
			if(sipCall.sdp==null)
			{
				int audioport=SIPStack.getFreeAudioRtpPort();
				if(audioport>0) sipCall.constructSdp();
				if(sipCall.sdp != null && sipCall.sdp.flag==true) 
				{
					sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
					if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
					}
					else
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						
					}
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							RFC2833.payloadType,
							"telephone-event/8000");
					sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
				}
			}		
			//CONTENT-LENGTH HEADER
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				//2014 05 26
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();
				///////////////
	
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
	
	
			//
			sipCall.callState=SIPStack.SIP_CALLSTATE_INVITING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			
			if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
			}
			else
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								header+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
				
			}
			return true;
		}catch(Exception e){}
		return false;
	}
	public String makeRedirectIncomingCall(SIPCall sipCall,String redirectId)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if(redirectId==null || redirectId.length()==0) return "";
			if( 
				sipCall.callDirection==SIPStack.SIP_CALLDIRECTION_IN &&
				(
					sipCall.callState==SIPStack.SIP_CALLSTATE_OFFERRED ||
					sipCall.callState==SIPStack.SIP_CALLSTATE_CANCELLED
				)
			)
			{
	
				String commandLine		= null;
				String contactH			= null;
				String contentlengthH	= null;
	
				//REQUEST LINE 
				commandLine="SIP/2.0 "+302+" "+SIPStack.getResponseDescription(302)+SIPStack.SIP_LINE_END;
				//VIA HEADER GET
				String viaString="";
				if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
				String routeString="";
				if(sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
				//CONTACT HEADER
				// 2012 02 09 
				contactH="Contact: <sip:"+redirectId+"@"+serverIp+":"+serverPort+">";
				//CONTENT-LENGTH HEADER
				contentlengthH="Content-Length: "+0+SIPStack.SIP_LINE_END;
				
				//
				String sendmessage=
						commandLine+
								viaString+
								routeString+
								sipCall.fromH+SIPStack.SIP_LINE_END+
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								contactH+SIPStack.SIP_LINE_END+
								contentlengthH+SIPStack.SIP_LINE_END
						;
				return sendmessage;
			}
		}catch(Exception e){}
		return "";
	}
	public String makeSendProgressing(SIPCall sipCall,String body)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			if(body==null || body.length()<=0) return "";
					
			
			String commandLine		= null;
			String contactH			= null;
			String contentlengthH	= null;
	
			//REQUEST LINE 
			commandLine="SIP/2.0 183 "+SIPStack.getResponseDescription(183)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			String viaString="";
			if(sipCall.viaArray.length()>0) viaString=sipCall.viaArray.toString();
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_VIA);
			if(sipHeader != null && sipHeader.flag==true) viaH=sipHeader.header+SIPStack.SIP_LINE_END;
			else viaH="";
			String routeString="";
			if(sipCall.recordrouteArray!=null &&
					sipCall.recordrouteArray.length()>0) routeString=sipCall.recordrouteArray.toString();
	
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: "+body.length()+SIPStack.SIP_LINE_END;
			String contenttypeH="";
			if(body != null && body.length()>0)
			{
				contenttypeH="Content-Type: application/SDP"+SIPStack.SIP_LINE_END;
			}
	
			//
			
			String sendmessage=
					commandLine+
							viaString+
							routeString+
							sipCall.fromH+SIPStack.SIP_LINE_END+
							sipCall.toH+SIPStack.SIP_LINE_END+
							sipCall.callidH+SIPStack.SIP_LINE_END+
							sipCall.cseqH+SIPStack.SIP_LINE_END+
							contactH+SIPStack.SIP_LINE_END+
							contenttypeH+
							contentlengthH+
							SIPStack.SIP_LINE_END+
							body
					;
	
					
			return sendmessage;	
		}catch(Exception e){}
		return "";
	}
	public boolean makeSendAck(SIPCall sipCall,String message)
	{
		try
		{
			sipCall.routeIp="";
			sipCall.routePort=5060;
		
			if(sipCall==null || sipCall.flag==false ) return false;
			
			sipCall.ACK_CSEQ=sipCall.CSEQ_NUMBER;
			
			sipCall.reverseRecordRoute(message);
			//REQUEST LINE 
			if(sipCall.remoteContactUri!=null && sipCall.remoteContactUri.length()>0)
			{
				sipCall.commandLine="ACK "+sipCall.remoteContactUri+" SIP/2.0";
			}
			else sipCall.commandLine="ACK sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER(call cycle    via header invite  ״ ؾ Ѵ)
			if(sipCall.viaH==null || sipCall.viaH.length()==0) //2013 02 13
			{
				if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) sipCall.viaBranch=SIPStack.getViaBranch();
				sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			}
			//CSEQ HEADER
			sipCall.cseqH="CSeq: "+sipCall.ACK_CSEQ+" ACK"; 
			
			
			//CONTENT-LENGTH HEADER
			sipCall.contentlengthH="Content-Length: 0";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//
			String routeString="";
			
			if(sipCall.routeArray!=null &&
					sipCall.routeArray.length()>0) 
			{
				routeString=sipCall.routeArray.toString();
				if(sipCall.routeH!=null && sipCall.routeH.length()>0)
				{
					//SIPROUTEHeader(String header)
					SIPROUTEHeader header=new SIPROUTEHeader(sipCall.routeH);
					if(header!=null && header.flag==true)
					{
						sipCall.routeIp=header.getIp();
						sipCall.routePort=header.getPort();
					}
				}
			}
			//AUTHORIZATION HEADER
			//
			if(sipCall.authorizationACKH != null && sipCall.authorizationACKH.length() > 0)
			{
				
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								routeString+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.authorizationACKH+SIPStack.SIP_LINE_END+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
			}
			else 
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								routeString+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
			}
			return true;
		}catch(Exception e){}
		return false;
	}
	public boolean makeSendFinalAck(SIPCall sipCall,String message)
	{
		try
		{
			String fromH					= null;
			String toH						= null;
			String callidH					= null;
			//
			String viaH						= null;
			String commandLine				= null;
			String contentlengthH					= null;
			String cseqH					= null;
	
			SIPHeader  sipheader			= null;
			sipCall.routeIp="";
			sipCall.routePort=5060;
	
			if(sipCall==null || sipCall.flag==false ) return false;
			
			//2012 07 31
			//FROM HEADER GET
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_FROM);
			if(sipheader != null && sipheader.flag==true && sipheader.header!=null && sipheader.header.length()>0)
			{
				fromH=new String(sipheader.header);
			}
			else return false;
			//TO HEADER GET
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_TO);
			if(sipheader != null && sipheader.flag==true && sipheader.header!=null && sipheader.header.length()>0)
			{
				toH=new String(sipheader.header);
			}
			else return false;
			//CALLID HEADER GET
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipheader != null && sipheader.flag==true && sipheader.header!=null && sipheader.header.length()>0)
			{
				callidH=new String(sipheader.header);
			}
			else return false;
			//
			
			int ACK_CSEQ=sipCall.CSEQ_NUMBER; 
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
			if(sipheader != null && sipheader.flag==true && sipheader.callSequenceNumber()>=0)
			{
				ACK_CSEQ=sipheader.callSequenceNumber();
				
			}
			
			sipCall.reverseRecordRoute(message);
			//REQUEST LINE 
			if(sipCall.remoteContactUri!=null && sipCall.remoteContactUri.length()>0)
			{
				commandLine="ACK "+sipCall.remoteContactUri+" SIP/2.0";
			}
			else commandLine="ACK sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER(call cycle    via header invite  ״ ؾ Ѵ)
			//2013 02 13
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_VIA);
			if(sipheader != null && sipheader.flag==true)
			{
				viaH=new String(sipheader.header);
				if(viaH!=null && viaH.length()>0)
				{
					String branch="";
					int index=viaH.indexOf(";branch=");
					if(index>0) branch=viaH.substring(index+1);
					index=branch.indexOf(";");
					if(index>0) branch=branch.substring(0,index);
					index=viaH.indexOf(";received=");
					if(index>0) viaH=viaH.substring(0,index);
					index=viaH.indexOf(";rport=");
					if(index>0) viaH=viaH.substring(0,index);
					viaH=viaH+";"+branch;
				}
			}
			if(viaH==null || viaH.length()==0)
			{
				viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
			}
			//CSEQ HEADER
			cseqH="CSeq: "+ACK_CSEQ+" ACK"; 
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0";
			String routeString="";
			if(sipCall.routeArray!=null &&
					sipCall.routeArray.length()>0) 
			{
				routeString=sipCall.routeArray.toString();
				if(sipCall.routeH!=null && sipCall.routeH.length()>0)
				{
					//SIPROUTEHeader(String header)
					SIPROUTEHeader header=new SIPROUTEHeader(sipCall.routeH);
					if(header!=null && header.flag==true)
					{
						sipCall.routeIp=header.getIp();
						sipCall.routePort=header.getPort();
					}
				}
			}
	
			//AUTHORIZATION HEADER
			//
			if(sipCall.authorizationACKH != null && sipCall.authorizationACKH.length() > 0)
			{
				sipCall.message=
						commandLine+SIPStack.SIP_LINE_END+
								fromH+SIPStack.SIP_LINE_END +
								toH+SIPStack.SIP_LINE_END+
								viaH+SIPStack.SIP_LINE_END+
								routeString+
								callidH+SIPStack.SIP_LINE_END+
								cseqH+SIPStack.SIP_LINE_END+
								sipCall.authorizationACKH+SIPStack.SIP_LINE_END+
								contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
			
			}
			else 
			{
				sipCall.message=
						commandLine+SIPStack.SIP_LINE_END+
						fromH+SIPStack.SIP_LINE_END +
						toH+SIPStack.SIP_LINE_END+
						viaH+SIPStack.SIP_LINE_END+
						routeString+
						callidH+SIPStack.SIP_LINE_END+
						cseqH+SIPStack.SIP_LINE_END+
						contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
	
			}
			
				
				
			return true;
		}catch(Exception e){}
		return false;
		
	}
	public String makeSendFinalAck(SIPCall sipCall,String message,String remoteIp,int remotePort)
	{
		try
		{
			String fromH					= null;
			String toH						= null;
			String callidH					= null;
			//
			String viaH						= null;
			String commandLine				= null;
			String contentlengthH					= null;
			String cseqH					= null;
	
			SIPHeader  sipheader			= null;
	
			
			//2012 07 31
			//FROM HEADER GET
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_FROM);
			if(sipheader != null && sipheader.flag==true && sipheader.header!=null && sipheader.header.length()>0)
			{
				fromH=new String(sipheader.header);
			}
			else return "";
			//TO HEADER GET
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_TO);
			if(sipheader != null && sipheader.flag==true && sipheader.header!=null && sipheader.header.length()>0)
			{
				toH=new String(sipheader.header);
			}
			else return "";
			//CALLID HEADER GET
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipheader != null && sipheader.flag==true && sipheader.header!=null && sipheader.header.length()>0)
			{
				callidH=new String(sipheader.header);
			}
			else return "";
			//
			
			int ACK_CSEQ=0; 
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);
			if(sipheader != null && sipheader.flag==true && sipheader.callSequenceNumber()>=0)
			{
				ACK_CSEQ=sipheader.callSequenceNumber();
				
			}
			
			//REQUEST LINE 
			commandLine="ACK sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER(call cycle    via header invite  ״ ؾ Ѵ)
			//2013 02 13
			sipheader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_VIA);
			if(sipheader != null && sipheader.flag==true)
			{
				viaH=new String(sipheader.header);
				if(viaH!=null && viaH.length()>0)
				{
					String branch="";
					int index=viaH.indexOf(";branch=");
					if(index>0) branch=viaH.substring(index+1);
					index=branch.indexOf(";");
					if(index>0) branch=branch.substring(0,index);
					index=viaH.indexOf(";received=");
					if(index>0) viaH=viaH.substring(0,index);
					index=viaH.indexOf(";rport=");
					if(index>0) viaH=viaH.substring(0,index);
					viaH=viaH+";"+branch;
				}
			}
			if(viaH==null || viaH.length()==0)
			{
				viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+SIPStack.getViaBranch()+";rport";
			}
			//CSEQ HEADER
			cseqH="CSeq: "+ACK_CSEQ+" ACK"; 
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0";
	
			//AUTHORIZATION HEADER
			//
			String sendmessage=
					commandLine+SIPStack.SIP_LINE_END+
					fromH+SIPStack.SIP_LINE_END +
					toH+SIPStack.SIP_LINE_END+
					viaH+SIPStack.SIP_LINE_END+
					callidH+SIPStack.SIP_LINE_END+
					cseqH+SIPStack.SIP_LINE_END+
					contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
					;

			
				
				
			return sendmessage;
		}catch(Exception e){}
		return "";
		
	}
	//
	public boolean makeSendRedirectFinalAck(SIPCall sipCall,String message)
	{
		try
		{
			sipCall.routeIp="";
			sipCall.routePort=5060;
	
			if(sipCall==null || sipCall.flag==false ) return false;
			
			sipCall.ACK_CSEQ=sipCall.CSEQ_NUMBER;
			
			sipCall.reverseRecordRoute(message);
			//REQUEST LINE 
			sipCall.commandLine="ACK sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER(call cycle    via header invite  ״ ؾ Ѵ)
			if(sipCall.viaH==null || sipCall.viaH.length()==0)//2013 02 13
			{
				if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) sipCall.viaBranch=SIPStack.getViaBranch();
				sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			}
			//CSEQ HEADER
			sipCall.cseqH="CSeq: "+sipCall.ACK_CSEQ+" ACK";
			//CONTENT-LENGTH HEADER
			sipCall.contentlengthH="Content-Length: 0";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			String routeString="";
			if(sipCall.routeArray!=null &&
					sipCall.routeArray.length()>0) 
			{
				routeString=sipCall.routeArray.toString();
				if(sipCall.routeH!=null && sipCall.routeH.length()>0)
				{
					//SIPROUTEHeader(String header)
					SIPROUTEHeader header=new SIPROUTEHeader(sipCall.routeH);
					if(header!=null && header.flag==true)
					{
						sipCall.routeIp=header.getIp();
						sipCall.routePort=header.getPort();
					}
				}
			}
	
			//AUTHORIZATION HEADER
			//
			if(sipCall.authorizationACKH != null && sipCall.authorizationACKH.length() > 0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								routeString+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.authorizationACKH+SIPStack.SIP_LINE_END+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
		
			}
			else 
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								routeString+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND
						;
			}
			return true;
		}catch(Exception e){}
		return false;
	
		
	}
	public String makeSendByeResponse(SIPCall sipCall,String message)
	{
		try 
		{
			if(sipCall==null || sipCall.flag==false ) return "";
			
			sipCall.BYE_CSEQ=sipCall.ACK_CSEQ;
			
			String commandLine		= null;
			String viaH				= null;
			String toH				= null;
			String fromH			= null;
			String callidH			= null;
			String cseqH			= null;
			String contentlengthH	= null;
	
			//REQUEST LINE 
			commandLine="SIP/2.0 200 "+SIPStack.getResponseDescription(200)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			viaH=sipCall.getViaArray(message);
			if(viaH == null || viaH.length()==0) viaH="";
			//FROM HEADER GET
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_FROM);
			if(sipHeader != null && sipHeader.flag==true) fromH=sipHeader.header+SIPStack.SIP_LINE_END;
			else fromH="";
			//TO HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_TO);
			if(sipHeader != null && sipHeader.flag==true) {
				toH=sipHeader.header+SIPStack.SIP_LINE_END;
				if(toH.indexOf("tag=")<0) toH=sipHeader.header+";tag="+SIPStack.newTag()+SIPStack.SIP_LINE_END;
			}
			else toH="";
			//CALLID HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipHeader != null && sipHeader.flag==true) callidH=sipHeader.header+SIPStack.SIP_LINE_END;
			else callidH="";
			//CSEQ HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);		
			if(sipHeader != null && sipHeader.flag==true) 
			{
				sipCall.BYE_CSEQ=sipHeader.callSequenceNumber();
				cseqH=sipHeader.header+SIPStack.SIP_LINE_END;
			}
			else cseqH="";
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0\r\n";
			//
			
			String sendmessage=
					commandLine+
							viaH+
							fromH+
							toH+
							callidH+
							cseqH+
							contentlengthH+SIPStack.SIP_LINE_END
					;
	
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendOptionsResponse(SIPCall sipCall,String message,int code)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false) return "";
			
			String commandLine		= null;
			String viaH				= null;
			String toH				= null;
			String fromH			= null;
			String callidH			= null;
			String cseqH			= null;
			String allowH			= null;
			String useragentH		= null;
			String contentlengthH	= null;
	
			//REQUEST LINE 
			commandLine="SIP/2.0 "+code+" "+SIPStack.getResponseDescription(code)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			viaH=sipCall.getViaArray(message);
			if(viaH == null || viaH.length()==0) viaH="";
			//FROM HEADER GET
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_FROM);
			if(sipHeader != null && sipHeader.flag==true) fromH=sipHeader.header+SIPStack.SIP_LINE_END;
			else fromH="";
			//TO HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_TO);
			if(sipHeader != null && sipHeader.flag==true) {
				toH=sipHeader.header+SIPStack.SIP_LINE_END;
				if(toH.indexOf("tag=")<0) toH=sipHeader.header+";tag="+SIPStack.newTag()+SIPStack.SIP_LINE_END;
			}
			else toH="";
			//CALLID HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipHeader != null && sipHeader.flag==true) callidH=sipHeader.header+SIPStack.SIP_LINE_END;
			else callidH="";
			//CSEQ HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);		
			if(sipHeader != null && sipHeader.flag==true) 
			{
				cseqH=sipHeader.header+SIPStack.SIP_LINE_END;
			}
			else cseqH="";
			//ALLOW HEADER
			allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO"+SIPStack.SIP_LINE_END;
			//USER-AGENT HEADER
			useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o"+SIPStack.SIP_LINE_END;
	
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0\r\n";
			//
			
			String sendmessage=
					commandLine+
							viaH+
							fromH+
							toH+
							callidH+
							cseqH+
							allowH+
							useragentH+
							contentlengthH+SIPStack.SIP_LINE_END
					;
				
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public String makeSendInfoResponse(SIPCall sipCall,String message,int code)
	{	
		if(sipCall==null || sipCall.flag==false) return "";
		try
		{
			String commandLine		= null;
			String viaH				= null;
			String toH				= null;
			String fromH			= null;
			String callidH			= null;
			String cseqH			= null;
			String allowH			= null;
			String useragentH		= null;
			String contentlengthH	= null;
	
			//REQUEST LINE 
			commandLine="SIP/2.0 "+code+" "+SIPStack.getResponseDescription(code)+SIPStack.SIP_LINE_END;
			//VIA HEADER GET
			viaH=sipCall.getViaArray(message);
			if(viaH == null || viaH.length()==0) viaH="";
			//FROM HEADER GET
			SIPHeader sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_FROM);
			if(sipHeader != null && sipHeader.flag==true) fromH=sipHeader.header+SIPStack.SIP_LINE_END;
			else fromH="";
			//TO HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_TO);
			if(sipHeader != null && sipHeader.flag==true) {
				toH=sipHeader.header+SIPStack.SIP_LINE_END;
				if(toH.indexOf("tag=")<0) toH=sipHeader.header+";tag="+SIPStack.newTag()+SIPStack.SIP_LINE_END;
			}
			else toH="";
			//CALLID HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CALLID);
			if(sipHeader != null && sipHeader.flag==true) callidH=sipHeader.header+SIPStack.SIP_LINE_END;
			else callidH="";
			//CSEQ HEADER GET
			sipHeader=new SIPHeader(message,SIPStack.SIP_HEADERTYPE_CSEQ);		
			if(sipHeader != null && sipHeader.flag==true) 
			{
				cseqH=sipHeader.header+SIPStack.SIP_LINE_END;
			}
			else cseqH="";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
			{
				contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">"+SIPStack.SIP_LINE_END;
			}
			else contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">"+SIPStack.SIP_LINE_END;
			//ALLOW HEADER
			allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO"+SIPStack.SIP_LINE_END;
			//USER-AGENT HEADER
			useragentH="User-Agent: KwangHaeSoft SmartSip release 0100o"+SIPStack.SIP_LINE_END;
	
			//CONTENT-LENGTH HEADER
			contentlengthH="Content-Length: 0\r\n";
			//
			
			String sendmessage=
					commandLine+
							viaH+
							fromH+
							toH+
							callidH+
							cseqH+
							contactH+
							allowH+
							useragentH+
							contentlengthH+SIPStack.SIP_LINE_END
					;
			return sendmessage;
		}catch(Exception e){}
		return "";
	}
	public boolean makeSendUpdate(SIPCall sipCall) 
	{
		try
		{
			if(sipCall==null || sipCall.flag==false) return false;
			String viaBranch=sipCall.viaBranch;//2013 02 13
			
			sipCall.setUpdateheaders("sendonly");
		
			//sipCall.CSEQ_NUMBER++; original
			sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 27
			SIPStack.SIP_SEQUENCE_INVITE++;
			if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
	
			//REQUEST LINE 
			sipCall.commandLine="INVITE sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			//2013 02 13
			sipCall.viaBranch=viaBranch;
			if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) sipCall.viaBranch=SIPStack.getViaBranch();
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			//MAXFORWARDS HEADER
			sipCall.maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//TO HEADER
			if(sipCall.toH==null || sipCall.toH.length()==0)
				sipCall.toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
			//FROM HEADER
			if(sipCall.fromH==null || sipCall.fromH.length()==0)
			{
				sipCall.fromTag=SIPStack.newTag();
				sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			}
			//CALLID HEADER
			// previous header use
			//CSEQ HEADER
			//2012 07 27 marked
			//if(sipCall.CSEQ_NUMBER>65556) sipCall.CSEQ_NUMBER=0;
			//SIPStack.SIP_SEQUENCE_INVITE=sipCall.CSEQ_NUMBER;
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			//ALLOW HEADER
			sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			sipCall.useragentH="User-Agent: "+SIPStack.USER_AGENT;
			//make body
			if(sipCall.sdp==null)
			{
				int audioport=SIPStack.getFreeAudioRtpPort();
				if(audioport>0) sipCall.constructSdp();
				if(sipCall.sdp != null && sipCall.sdp.flag==true) 
				{
					sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
					if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
					}
					else
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						
					}
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							RFC2833.payloadType,
							"telephone-event/8000");
					sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
				}
			}		
			//CONTENT-LENGTH HEADER
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				//2014 05 26
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();
				///////////////
	
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
			//
			sipCall.callState=SIPStack.SIP_CALLSTATE_UPDATING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			
			if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
	
			}
			else
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
	
			}
			return true;
		}catch(Exception e){}
		return false;
		
	}
	public boolean makeSendUpdate(SIPCall sipCall,String flow)
	{
		try
		{
			if(sipCall==null || sipCall.flag==false) return false;
			String viaBranch=sipCall.viaBranch;//2013 02 13
			
			sipCall.setUpdateheaders(flow);
		
			//sipCall.CSEQ_NUMBER++; original
			sipCall.CSEQ_NUMBER=SIPStack.SIP_SEQUENCE_INVITE;//2012 07 27
			SIPStack.SIP_SEQUENCE_INVITE++;
			if(SIPStack.SIP_SEQUENCE_INVITE>65556) SIPStack.SIP_SEQUENCE_INVITE=1;
			//
			
			//REQUEST LINE 
			sipCall.commandLine="INVITE sip:"+sipCall.dnis+"@"+serverDomain+":"+serverPort+" SIP/2.0";
			//VIA HEADER
			//2013 02 13
			sipCall.viaBranch=viaBranch;
			if(sipCall.viaBranch==null || sipCall.viaBranch.length()==0) sipCall.viaBranch=SIPStack.getViaBranch();
			sipCall.viaH="Via: SIP/2.0/UDP "+localIp+":"+localPort+";branch="+sipCall.viaBranch+";rport";
			//MAXFORWARDS HEADER
			sipCall.maxforwardH="Max-Forwards: 70";
			//CONTACT HEADER
			if(ifIp!=null && ifIp.length()>0 && ifPort>0)
				sipCall.contactH="Contact: <sip:"+id+"@"+ifIp+":"+ifPort+">";
			else sipCall.contactH="Contact: <sip:"+id+"@"+sipCall.localIp+":"+sipCall.localPort+">";
			//TO HEADER
			if(sipCall.toH==null || sipCall.toH.length()==0)
				sipCall.toH="To: \""+sipCall.dnis+"\"<sip:"+sipCall.dnis+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">";
			//FROM HEADER
			if(sipCall.fromH==null || sipCall.fromH.length()==0)
			{
				sipCall.fromTag=SIPStack.newTag();
				sipCall.fromH="From: \""+sipCall.id+"\"<sip:"+sipCall.id+"@"+sipCall.serverDomain+":"+sipCall.serverPort+">;tag="+sipCall.fromTag;
			}
			sipCall.cseqH="CSeq: "+sipCall.CSEQ_NUMBER+" INVITE";
			//ALLOW HEADER
			sipCall.allowH="Allow: INVITE, ACK, CANCEL, OPTIONS, BYE, REFER, NOTIFY, MESSAGE, SUBSCRIBE, INFO";
			//USER-AGENT HEADER
			sipCall.useragentH="User-Agent: "+SIPStack.USER_AGENT;
			//make body
			if(sipCall.sdp==null)
			{
				int audioport=SIPStack.getFreeAudioRtpPort();
				if(audioport>0) sipCall.constructSdp();
				if(sipCall.sdp != null && sipCall.sdp.flag==true) 
				{
					sipCall.sdp.setMediaPort(SIPStack.SIP_MEDIATYPE_AUDIO,audioport);
					if(SIPStack.PRIMARY_CODEC_AUDIO==SIPStack.SIP_CODEC_G711U)
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
					}
					else
					{
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711A,
								"PCMA/8000");
						sipCall.sdp.setCodec(
								SIPStack.SIP_MEDIATYPE_AUDIO,
								SIPStack.SIP_CODEC_G711U,
								"PCMU/8000");
						
					}
					sipCall.sdp.setCodec(
							SIPStack.SIP_MEDIATYPE_AUDIO,
							RFC2833.payloadType,
							"telephone-event/8000");
					sipCall.sdp.setFmtpDescribe(SIPStack.SIP_MEDIATYPE_AUDIO, RFC2833.payloadType, "0-15");
				}
			}		
			//CONTENT-LENGTH HEADER
			String body=null;
			sipCall.contenttypeH="";
			if(sipCall.sdp != null && sipCall.sdp.flag==true)
			{
				sipCall.contenttypeH="Content-Type: application/SDP\r\n";
				//2014 05 26
				if(SIPStack.bVideocommunication==true)
				{
					body=sipCall.sdp.getBodyString()+getVideomediadescription(sipCall.sdp.audioM.mediaPort+2);
				}
				else body=sipCall.sdp.getBodyString();
				///////////////
	
				sipCall.contentlengthH="Content-Length: "+body.length();
			}
			else {
				body="";
				sipCall.contentlengthH="Content-Length: 0";
			}
	
			//
			sipCall.callState=SIPStack.SIP_CALLSTATE_UPDATING;
			sipCall.callDirection=SIPStack.SIP_CALLDIRECTION_OUT;
			
			if(sipCall.authorizationINVITEH != null && sipCall.authorizationINVITEH.length()>0)
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.authorizationINVITEH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
			}
			else
			{
				sipCall.message=
						sipCall.commandLine+SIPStack.SIP_LINE_END+
								sipCall.viaH+SIPStack.SIP_LINE_END+
								sipCall.maxforwardH+SIPStack.SIP_LINE_END+
								sipCall.contactH+SIPStack.SIP_LINE_END +
								sipCall.fromH+SIPStack.SIP_LINE_END +
								sipCall.toH+SIPStack.SIP_LINE_END+
								sipCall.callidH+SIPStack.SIP_LINE_END+
								sipCall.cseqH+SIPStack.SIP_LINE_END+
								sipCall.allowH+SIPStack.SIP_LINE_END+
								sipCall.useragentH+SIPStack.SIP_LINE_END+
								sipCall.contenttypeH+
								sipCall.contentlengthH+SIPStack.SIP_LINE_DOUBLEEND+
								body
						;
			}
			return true;
		}catch(Exception e){}
		return false;
	}
	//2014 12 22
	/*
	 * ȭ Ǵ Ȳ

		1.     ȭ (User)
		
		2.     ȭ (Busy)
		
		3.      ( ȣ )
		
		4.      (߽ ȣ )

	 */
	public static String getCallfailReason(int finalCode)
	{
		String desc="";
		switch(finalCode)
		{
		case 200:
			desc="";//"ok"
			break;
		case 300:
			desc="";//"multiple choice"
			break;
		case 301:
			desc="";//Moved Permanently
			break;
		case 302:
			desc="";//Moved Temporarily
			break;
		case 305:
			desc="";//"Use Proxy";
			break;
		case 380:
			desc="";//"Alternative Service";
			break;
		case 400:
			desc="";//"Bad Request";
			break;
		case 401:
			desc="";//"Unauthorized";
			break;
		case 402:
			desc="";//"Payment Required";
			break;
		case 403:
			desc="";//"Forbidden";
			break;
		case 404:
			desc="";//"Not Found";
			break;
		case 405:
			desc="";//"Method Not Allowed";
			break;
		case 406:
			desc="";//"Not Acceptable";
			break;
		case 407:
			desc="";//"Proxy Authentication Required";
			break;
		case 408:
			desc="";//"Request Timeout";
			break;
		case 409:
			desc="";//"Conflict";
			break;
		case 410:
			desc="";//"Gone";
			break;
		case 411:
			desc="";//"Length Required";
			break;
		case 413:
			desc="";//"Request Entity Too Large";
			break;
		case 414:
			desc="";//"Request-URI Too Long";
			break;
		case 415:
			desc="";//"Unsupported Media Type";
			break;
		case 420:
			desc="";//"Bad Extension";
			break;
		case 421:
			desc="";//"Extension Required";
			break;
		case 423:
			desc="";//"Interval Too Brief";
			break;
		case 480:
			desc="";//"Temporarily Unavailable";
			break;
		case 481:
			desc="";//"Call Leg Does Not Exist";
			break;
		case 482:
			desc="";//"Loop Detected";
			break;
		case 483:
			desc="";//"Two Many Hops";
			break;
		case 484:
			desc="";//"Address Incomplete";
			break;
		case 485:
			desc="";//"Ambiguous";
			break;
		case 486:
			desc="ȭ";
			break;
		case 487:
			desc="";
			break;
		case 488:
			desc="";//"Not Acceptable Here";
			break;
		case 500:
			desc="";//"Server Internal Error";
			break;
		case 501:
			desc="";//"Not Implemented";
			break;
		case 502:
			desc="";//"Bad Gateway";
			break;
		case 503:
			desc="";//"Service Unavailable";
			break;
		case 504:
			desc="";//"Gateway Timeout";
			break;
		case 505:
			desc="";//"Version Not Supported";
			break;
		case 600:
			desc="ȭ";//"Busy Everywhere";
			break;
		case 603:
			desc="";//"Decline";
			break;
		case 604:
			desc="";//"Does Not Exist Anywhere";
			break;
		case 606:
			desc="";//"Not Acceptable";
			break;
		case 700:
			desc="ȭ";//"ȭ ڿ  ";
			break;
		default:
			break;
		}
		return desc;
	}
	//
}
