/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class HeatingV1API
extends WallPadDevAPI {
    private final String TAG = "HeatingV1API";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"HeatingV1API", (String)s);
    }

    public HeatingV1API(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("HeatingV1API create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "HEATINGV1";
        this.data = new Data();
        int ret = this.Refresh((byte)100, false);
        if (ret == 0) {
            byte RoomCount = this.data.Device.RoomCount;
            Log.i((String)"HeatingV1API", (String)("GetInfo() - OK!!! (RoomCount:" + RoomCount + ")"));
            this.data.Device.SetRoomCount(RoomCount);
        } else {
            Log.i((String)"HeatingV1API", (String)("GetInfo() - fail!!! " + ret));
        }
        ret = this.Refresh((byte)-1, false);
        Log.i((String)"HeatingV1API", (String)("Refresh() - ret:" + ret));
    }

    public int Refresh(byte Index, boolean real) {
        if ((Index < 0 || Index > 7) && Index != -1 && Index != 100) {
            Log.w((String)"HeatingV1API", (String)("[Refresh] Param (Index) Out Of Range !!! (" + Index + ")"));
            return -300;
        }
        if (Index == 100 && real) {
            Log.w((String)"HeatingV1API", (String)"[Refresh] If the Index is REFRESH_IDX.INFO_N_PAUSE does not support the real(true)");
            return -300;
        }
        if (Index != 100 && this.data.Device.RoomCount <= 0) {
            Log.w((String)"HeatingV1API", (String)("[Refresh] DEVICE IS NOT READY (" + Index + ")"));
            return -110;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = null;
        if (Index >= 0 && Index <= 7) {
            if (this.CheckParamRoom(Index) != 0) {
                Log.w((String)"HeatingV1API", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
                return -300;
            }
            ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingRoom(ret);
        }
        if (Index == -1) {
            int i;
            if (real) {
                int iret = this.SendNReadCMD_int(MainCMD, SubCMD, -1, 0, 0, 0, 0);
                if (iret != 0) {
                    return -111;
                }
                MainCMD = "NOSINKCTRL";
            }
            for (i = 0; i < this.data.Device.RoomCount && this.ParsingRoom(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) == 0; ++i) {
            }
            if (i < this.data.Device.RoomCount) {
                Log.w((String)"HeatingV1API", (String)("[Refresh] REFRESH_IDX.ALL fail (i:" + i + ")"));
                return -111;
            }
            return 0;
        }
        if (Index == 100) {
            ret = this.SendNReadCMD_str("NOSINKCTRL", SubCMD, Index, 0, 0, 0, 0);
            return this.ParsingInfoNPause(ret);
        }
        Log.w((String)"HeatingV1API", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + Index + ")"));
        return -300;
    }

    private int ParsingRoom(String ret) {
        String FUNC_NAME = "[ParsingRoom]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            DataClasses.HeatingV1.RoomData roomData = new DataClasses.HeatingV1.RoomData();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            roomData.bOnOff = Boolean.parseBoolean(retData[index++]);
            roomData.bValveStatus = Boolean.parseBoolean(retData[index++]);
            roomData.SetTemp = Double.parseDouble(retData[index++]);
            roomData.NowTemp = Double.parseDouble(retData[index++]);
            this.data.Device.Room[Current] = roomData;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "HeatingV1API", re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"HeatingV1API", (String)(FUNC_NAME + " Exception Error"));
            LogUtil.errorLogInfo("", "HeatingV1API", e);
            return -100000;
        }
        return 0;
    }

    private int ParsingInfoNPause(String ret) {
        String FUNC_NAME = "[ParsingInfoNPause]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"HeatingV1API", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            int index = 1;
            byte RoomCount = Byte.parseByte(retData[index++]);
            boolean SetTempPoint05 = Boolean.parseBoolean(retData[index++]);
            boolean Pause = Boolean.parseBoolean(retData[index++]);
            byte Error = Byte.parseByte(retData[index++]);
            this.data.Device.RoomCount = RoomCount;
            this.data.Device.SetTempPoint05 = SetTempPoint05;
            this.data.Device.Pause = Pause;
            this.data.Device.Error = Error;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "HeatingV1API", re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"HeatingV1API", (String)(FUNC_NAME + " Exception Error"));
            LogUtil.errorLogInfo("", "HeatingV1API", e);
            return -100000;
        }
        return 0;
    }

    public int SetPollingMode(byte ChangePollingMode, byte RoomIndex) {
        int ret;
        if (ChangePollingMode != 2 && ChangePollingMode != 3) {
            return -300;
        }
        if (ChangePollingMode == 3 && (ret = this.CheckParamRoom(RoomIndex)) != 0) {
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPollingMode", ChangePollingMode, RoomIndex, 0, 0, 0);
    }

    public int SetEachRoomTemp(byte RoomIndex, double SetTemp) {
        return this.SetEachRoomStatus(RoomIndex, (byte)0, SetTemp);
    }

    public int SetEachRoomMode(byte RoomIndex, boolean OnOff) {
        return this.SetEachRoomStatus(RoomIndex, OnOff ? (byte)1 : 2, 0.0);
    }

    public int SetEachRoomStatus(byte RoomIndex, byte SetMode, double SetTemp) {
        int ret = this.CheckParamRoom(RoomIndex);
        if (ret != 0) {
            Log.w((String)"HeatingV1API", (String)("[SetEachRoomStatus] RoomIndex Out Of Range !!! (" + RoomIndex + ")"));
            return ret;
        }
        switch (SetMode) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                Log.w((String)"HeatingV1API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
                return -300;
            }
        }
        byte ByteTemp = 0;
        int Point = 0;
        if (SetTemp != 0.0) {
            ByteTemp = (byte)SetTemp;
            if (ByteTemp < 5 || ByteTemp > 40) {
                Log.w((String)"HeatingV1API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! - (" + ByteTemp + ")"));
                return -300;
            }
            int n = Point = this.PointExist(SetTemp) ? 1 : 0;
            if (Point != 0 && !this.data.Device.SetTempPoint05) {
                Log.w((String)"HeatingV1API", (String)("[SetEachRoomStatus] SetMode Out Of Range !!! (" + String.format("%02X", SetMode) + ")"));
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetEachRoomStatus", RoomIndex, SetMode, ByteTemp, Point, 0);
    }

    public int SetAllRoomStatus(boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetAllRoomStatus", OnOff ? 1 : 2, 0, 0, 0, 0);
    }

    public int SetPause(boolean Pause) {
        int ParamPause = 0;
        if (Pause) {
            ParamPause = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetPause", ParamPause, 0, 0, 0, 0);
    }

    private int CheckParamRoom(byte RoomIndex) {
        byte RoomCount = this.data.Device.RoomCount;
        if (RoomCount <= 0) {
            return -110;
        }
        if (this.data.Device == null) {
            return -110;
        }
        if (this.data.Device.Room == null) {
            return -110;
        }
        if (this.data.Device.Room.length <= RoomIndex) {
            return -110;
        }
        return 0;
    }

    private boolean PointExist(double n) {
        int IntValue;
        double FilterData = Double.parseDouble(String.format("%.1f", n));
        double Point = FilterData - (double)(IntValue = (int)FilterData);
        return Point >= 0.5;
    }

    public static class Data {
        public DataClasses.HeatingV1 Device = new DataClasses.HeatingV1();
    }

    public static final class POLLING_MODE {
        public static final byte Normal = 2;
        public static final byte FixRoom = 3;
    }

    public static final class REFRESH_IDX {
        public static final byte ROOM1 = 0;
        public static final byte ROOM2 = 1;
        public static final byte ROOM3 = 2;
        public static final byte ROOM4 = 3;
        public static final byte ROOM5 = 4;
        public static final byte ROOM6 = 5;
        public static final byte ROOM7 = 6;
        public static final byte ROOM8 = 7;
        public static final byte ALL = -1;
        public static final byte INFO_N_PAUSE = 100;
    }
}

