/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class CooktopAPI
extends WallPadDevAPI {
    private final String TAG = "CooktopAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;
    int MAX_DEVICE_CNT = 8;
    int MAX_CIRCUIT_CNT = 15;

    private void DebugLogOutput(String s) {
        Log.d((String)"CooktopAPI", (String)s);
    }

    public CooktopAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("CooktopAPI create " + devctrcmd);
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "COOKTOPCTRL";
        this.data = new Data();
        this.getDeviceCnt();
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.getDeviceCnt() < 0) {
            Log.w((String)"CooktopAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"CooktopAPI", (String)("[Refresh] Param - Index Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            for (int i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            int index = 1;
            byte hRequestIndex = Byte.parseByte(retData[index++]);
            boolean bInstall = Boolean.parseBoolean(retData[index++]);
            byte hVendor = Byte.parseByte(retData[index++]);
            byte hCircuitCnt = Byte.parseByte(retData[index++]);
            DataClasses.CooktopCtrl Device2 = new DataClasses.CooktopCtrl(hCircuitCnt);
            if (bInstall) {
                Device2.info.bInstall = bInstall;
                Device2.info.hVendor = hVendor;
                Device2.info.hCircuitCnt = hCircuitCnt;
                Device2.info.hFWVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.hFWVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.hFWVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.hFWVer_No = Byte.parseByte(retData[index++]);
                Device2.info.hProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.hProtocolVer_Sub = Byte.parseByte(retData[index++]);
                index += hCircuitCnt;
                if (Device2.info.hCircuitCnt > 0) {
                    for (int i = 0; i < Device2.info.hCircuitCnt; ++i) {
                        Device2.circuit[i].hID = Byte.parseByte(retData[index++]);
                        Device2.circuit[i].hType = Byte.parseByte(retData[index++]);
                        Device2.circuit[i].hStatus = Byte.parseByte(retData[index++]);
                        Device2.circuit[i].hErrorStatus = Byte.parseByte(retData[index++]);
                    }
                }
            } else {
                Device2.info.bInstall = false;
            }
            this.data.Device[hRequestIndex] = Device2;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CooktopAPI", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"CooktopAPI", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "CooktopAPI", e);
            return -1;
        }
        return 0;
    }

    private int getDeviceCnt() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "getDeviceCnt", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                int i;
                index = 1;
                int hDeviceCnt = Byte.parseByte(retlist[index++]);
                byte hTotalCircuitCnt = Byte.parseByte(retlist[index++]);
                byte[] ahDeviceIndex = new byte[hDeviceCnt];
                byte[] ahDeviceCircuitCnt = new byte[hDeviceCnt];
                if (0 < hDeviceCnt) {
                    for (i = 0; i < hDeviceCnt; ++i) {
                        ahDeviceIndex[i] = Byte.parseByte(retlist[index++]);
                        ahDeviceCircuitCnt[i] = Byte.parseByte(retlist[index++]);
                    }
                }
                if (hDeviceCnt > 0) {
                    this.data.DeviceCnt = hDeviceCnt;
                    this.data.Device = new DataClasses.CooktopCtrl[hDeviceCnt];
                    if (0 < hDeviceCnt) {
                        if (this.data.Device != null) {
                            for (i = 0; i < hDeviceCnt; ++i) {
                                if (this.data.Device[i] == null) {
                                    this.data.Device[i] = new DataClasses.CooktopCtrl();
                                }
                                this.data.Device[i].setCircuitCnt(ahDeviceCircuitCnt[i]);
                                this.data.Device[i].circuit[i].setCircuitID(ahDeviceIndex[i]);
                            }
                        } else {
                            Log.w((String)"CooktopAPI", (String)"[getDeviceCnt] data.Device is null!!");
                        }
                    }
                    return 0;
                }
                return -1;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "CooktopAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"CooktopAPI", (String)("[getDeviceCnt] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "CooktopAPI", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int setUnitCircuitClose(byte Index, byte circuitIndex) {
        Log.w((String)"CooktopAPI", (String)("[setUnitCircuitClose] DeviceID is " + Index + ", cir ID" + circuitIndex));
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"CooktopAPI", (String)"[setUnitCircuitClose] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.checkDeviceIndexRange(Index)) {
            Log.w((String)"CooktopAPI", (String)("[setUnitCircuitClose] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (!this.checkCircuitIndexRange(Index, circuitIndex)) {
            Log.w((String)"CooktopAPI", (String)("[setUnitCircuitClose] Param - circuitIndex  : Out Of Range (circuitIndex:" + circuitIndex + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "setUnitCircuitClose", Index, circuitIndex, 0, 0, 0);
    }

    public int setEntireCircuitClose(byte Index) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"CooktopAPI", (String)"[setEntireCircuitClose] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.checkDeviceIndexRange(Index)) {
            Log.w((String)"CooktopAPI", (String)("[setEntireCircuitClose] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        return this.SendNReadCMD_int("SINKCTRL", "setEntireCircuitClose", Index, 0, 0, 0, 0);
    }

    private boolean checkDeviceIndexRange(byte Index) {
        try {
            return Index >= 0 && Index < this.data.DeviceCnt;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CooktopAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"CooktopAPI", (String)"[Exception Error] checkDeviceIndexRange");
            LogUtil.errorLogInfo("", "CooktopAPI", e);
            return false;
        }
    }

    private boolean checkCircuitIndexRange(byte Index, byte circuitIndex) {
        try {
            return !(this.data.Device[Index] == null ? circuitIndex != -1 && circuitIndex < 0 : circuitIndex != -1 && circuitIndex < 0);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CooktopAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"CooktopAPI", (String)"[Exception Error] checkSubDeviceIndexRange");
            LogUtil.errorLogInfo("", "CooktopAPI", e);
            return false;
        }
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.CooktopCtrl[] Device = null;
    }
}

