/*
 * Decompiled with CFR 0.152.
 */
package com.icontrols.service.control;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.icontrols.service.control.ILightControlServiceCallback;

public interface ILightControlService
extends IInterface {
    public void registerLightControlServiceCallback(ILightControlServiceCallback var1) throws RemoteException;

    public void unregisterLightControlServiceCallback(ILightControlServiceCallback var1) throws RemoteException;

    public String retrieveAllDevices() throws RemoteException;

    public String retrieveAllResources(String var1) throws RemoteException;

    public String doGetResourceProperties(String var1, String var2) throws RemoteException;

    public boolean doPostResourceProperties(String var1, String var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILightControlService {
        private static final String DESCRIPTOR = "com.icontrols.service.control.ILightControlService";
        static final int TRANSACTION_registerLightControlServiceCallback = 1;
        static final int TRANSACTION_unregisterLightControlServiceCallback = 2;
        static final int TRANSACTION_retrieveAllDevices = 3;
        static final int TRANSACTION_retrieveAllResources = 4;
        static final int TRANSACTION_doGetResourceProperties = 5;
        static final int TRANSACTION_doPostResourceProperties = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILightControlService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILightControlService) {
                return (ILightControlService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ILightControlServiceCallback _arg0 = ILightControlServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerLightControlServiceCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ILightControlServiceCallback _arg0 = ILightControlServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterLightControlServiceCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _result = this.retrieveAllDevices();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.retrieveAllResources(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.doGetResourceProperties(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    boolean _result = this.doPostResourceProperties(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ILightControlService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ILightControlService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ILightControlService {
            private IBinder mRemote;
            public static ILightControlService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerLightControlServiceCallback(ILightControlServiceCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerLightControlServiceCallback(cb);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterLightControlServiceCallback(ILightControlServiceCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterLightControlServiceCallback(cb);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String retrieveAllDevices() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().retrieveAllDevices();
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String retrieveAllResources(String device_uuid) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(device_uuid);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().retrieveAllResources(device_uuid);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String doGetResourceProperties(String device_uuid, String resource_uri) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(device_uuid);
                    _data.writeString(resource_uri);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().doGetResourceProperties(device_uuid, resource_uri);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean doPostResourceProperties(String device_uuid, String resource_uri, String prop_data) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(device_uuid);
                    _data.writeString(resource_uri);
                    _data.writeString(prop_data);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().doPostResourceProperties(device_uuid, resource_uri, prop_data);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ILightControlService {
        @Override
        public void registerLightControlServiceCallback(ILightControlServiceCallback cb) throws RemoteException {
        }

        @Override
        public void unregisterLightControlServiceCallback(ILightControlServiceCallback cb) throws RemoteException {
        }

        @Override
        public String retrieveAllDevices() throws RemoteException {
            return null;
        }

        @Override
        public String retrieveAllResources(String device_uuid) throws RemoteException {
            return null;
        }

        @Override
        public String doGetResourceProperties(String device_uuid, String resource_uri) throws RemoteException {
            return null;
        }

        @Override
        public boolean doPostResourceProperties(String device_uuid, String resource_uri, String prop_data) throws RemoteException {
            return false;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

