/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadAPI;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class IntLightAPI
extends WallPadDevAPI {
    private final String TAG = "IntLightAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"IntLightAPI", (String)s);
    }

    public IntLightAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("IntLightAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "INTLIGHT";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String MainCMD = null;
        MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 10) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.LightCount = Byte.parseByte(retlist[index++]);
                this.data.LightStatus[0] = Boolean.parseBoolean(retlist[index++]);
                this.data.LightStatus[1] = Boolean.parseBoolean(retlist[index++]);
                this.data.LightStatus[2] = Boolean.parseBoolean(retlist[index++]);
                this.data.LightStatus[3] = Boolean.parseBoolean(retlist[index++]);
                this.data.LightStatus[4] = Boolean.parseBoolean(retlist[index++]);
                if (!WallPadAPI.Get_HDCIntLightType()) {
                    this.data.LightStatus[5] = Boolean.parseBoolean(retlist[index++]);
                } else {
                    this.data.AllLightStatus = Boolean.parseBoolean(retlist[index++]);
                }
                this.data.ProgramStatus[0] = Boolean.parseBoolean(retlist[index++]);
                this.data.ProgramStatus[1] = Boolean.parseBoolean(retlist[index++]);
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "IntLightAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"IntLightAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "IntLightAPI", e);
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int LightControl(byte LightIdx, boolean OnOff) {
        switch (LightIdx) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                if (!WallPadAPI.Get_HDCIntLightType()) break;
                Log.w((String)"IntLightAPI", (String)"[LightControl] WallPadAPI.Get_HDCIntLightType is true !!!");
                return -300;
            }
            case -1: {
                break;
            }
            default: {
                Log.w((String)"IntLightAPI", (String)("[LightControl] Param : Out Of Range (LightIdx:" + LightIdx + ")"));
                return -300;
            }
        }
        int onoff = 0;
        if (OnOff) {
            onoff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "LightControl", LightIdx, onoff, 0, 0, 0);
    }

    public int AllLightControl(boolean OnOff) {
        if (!WallPadAPI.Get_HDCIntLightType()) {
            Log.w((String)"IntLightAPI", (String)"[AllLightControl] WallPadAPI.Get_HDCIntLightType is false !!!");
            return -11;
        }
        int onoff = 0;
        if (OnOff) {
            onoff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "LightControl", 6, onoff, 0, 0, 0);
    }

    public int LightProgramControl(byte ProgramIdx, byte OnOff) {
        switch (ProgramIdx) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                Log.w((String)"IntLightAPI", (String)("[LightProgramControl] Param : Out Of Range (ProgramIdx:" + ProgramIdx + ")"));
                return -300;
            }
        }
        switch (OnOff) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                Log.w((String)"IntLightAPI", (String)("[LightProgramControl] Param : Out Of Range (OnOff:" + OnOff + ")"));
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "LightProgramControl", ProgramIdx, OnOff, 0, 0, 0);
    }

    public int LightProgramSave(byte ProgramIdx) {
        switch (ProgramIdx) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                Log.w((String)"IntLightAPI", (String)("[LightProgramSave] Param : Out Of Range (ProgramIdx:" + ProgramIdx + ")"));
                return -300;
            }
        }
        return this.SendNReadCMD_int("SINKCTRL", "LightProgramSave", ProgramIdx, 0, 0, 0, 0);
    }

    public int LedBrightCtrl(byte BrightIdx) {
        if (BrightIdx != 0 && BrightIdx != 1 && BrightIdx != 2) {
            Log.w((String)"IntLightAPI", (String)("[LedBrightCtrl] Param : Out Of Range (BrightIdx:" + BrightIdx + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "LedBrightCtrl", BrightIdx, 0, 0, 0, 0);
    }

    public static class Data {
        public byte LightCount = 0;
        public boolean[] LightStatus = null;
        public boolean AllLightStatus = false;
        public boolean[] ProgramStatus = null;

        public Data() {
            if (!WallPadAPI.Get_HDCIntLightType()) {
                this.LightCount = (byte)6;
                this.LightStatus = new boolean[]{false, false, false, false, false, false};
            } else {
                this.LightCount = (byte)5;
                this.LightStatus = new boolean[]{false, false, false, false, false};
            }
            this.AllLightStatus = false;
            this.ProgramStatus = new boolean[]{false, false};
        }
    }
}

