/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class CutOffConcentAPI
extends WallPadDevAPI {
    private final String TAG = "CutOffConcentAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"CutOffConcentAPI", (String)s);
    }

    public CutOffConcentAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("CutOffConcentAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "CUTOFFCONCENT";
        this.data = new Data();
        this.GetDeviceCount();
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"CutOffConcentAPI", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"CutOffConcentAPI", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            boolean Install;
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.CutOffConcent Device2 = new DataClasses.CutOffConcent();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            if (Install = Boolean.parseBoolean(retData[index++])) {
                byte CircuitCount = Byte.parseByte(retData[index++]);
                Device2.setCircuitCount(CircuitCount);
                Device2.info.Install = Install;
                Device2.info.CircuitCount = CircuitCount;
                Device2.info.Vender = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Number = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
                Device2.circuit.CircuitCount = Byte.parseByte(retData[index++]);
                for (byte i = 0; i < CircuitCount; i = (byte)(i + 1)) {
                    Device2.circuit.Mode[i] = Boolean.parseBoolean(retData[index++]);
                    Device2.circuit.CutoffStatus[i] = Boolean.parseBoolean(retData[index++]);
                    Device2.circuit.CutoffValStatus[i] = Boolean.parseBoolean(retData[index++]);
                    Device2.circuit.OverloadError[i] = Boolean.parseBoolean(retData[index++]);
                }
                this.data.Device[Current] = Device2;
            } else {
                Device2.info.Install = false;
                this.data.Device[Current] = Device2;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CutOffConcentAPI", re);
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new DataClasses.CutOffConcent[DeviceCount];
                    return 0;
                }
                return -1;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "CutOffConcentAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"CutOffConcentAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "CutOffConcentAPI", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetModeChange(byte DeviceIdx, byte ConcentIdx, boolean ChangeMode) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"CutOffConcentAPI", (String)"[SetModeChange] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (DeviceIdx != -1) {
            if (!this.DeviceIndexRangeCheck(DeviceIdx)) {
                Log.w((String)"CutOffConcentAPI", (String)("[SetModeChange] Param - Index  : Out Of Range (DeviceIdx:" + DeviceIdx + ")"));
                return -2;
            }
            if (!this.ConcentIndexRangeCheck(DeviceIdx, ConcentIdx)) {
                Log.w((String)"CutOffConcentAPI", (String)("[SetModeChange] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
                return -3;
            }
        }
        int ByteOnOff = 0;
        if (ChangeMode) {
            ByteOnOff = 1;
        }
        if (DeviceIdx != -1) {
            return this.SendNReadCMD_int("SINKCTRL", "SetModeChange", DeviceIdx, ConcentIdx, ByteOnOff, 0, 0);
        }
        for (int i = 0; i < this.data.DeviceCnt; ++i) {
            int ret = this.SendNReadCMD_int("SINKCTRL", "SetModeChange", i, ConcentIdx, ByteOnOff, 0, 0);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    public int SetRestore(byte DeviceIdx, byte ConcentIdx) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"CutOffConcentAPI", (String)"[SetRestore] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(DeviceIdx)) {
            Log.w((String)"CutOffConcentAPI", (String)("[SetRestore] Param - Index  : Out Of Range (DeviceIdx:" + DeviceIdx + ")"));
            return -2;
        }
        if (!this.ConcentIndexRangeCheck(DeviceIdx, ConcentIdx)) {
            Log.w((String)"CutOffConcentAPI", (String)("[SetRestore] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetRestore", DeviceIdx, ConcentIdx, 0, 0, 0);
    }

    public int SetCutoffVal(byte DeviceIdx, byte ConcentIdx) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"CutOffConcentAPI", (String)"[SetCutoffVal] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(DeviceIdx)) {
            Log.w((String)"CutOffConcentAPI", (String)("[SetCutoffVal] Param - Index  : Out Of Range (DeviceIdx:" + DeviceIdx + ")"));
            return -2;
        }
        if (!this.ConcentIndexRangeCheck(DeviceIdx, ConcentIdx)) {
            Log.w((String)"CutOffConcentAPI", (String)("[SetCutoffVal] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetCutoffVal", DeviceIdx, ConcentIdx, 0, 0, 0);
    }

    public int SetReleaseOverlad(byte DeviceIdx, byte ConcentIdx) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"CutOffConcentAPI", (String)"[SetReleaseOverlad] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(DeviceIdx)) {
            Log.w((String)"CutOffConcentAPI", (String)("[SetReleaseOverlad] Param - Index  : Out Of Range (DeviceIdx:" + DeviceIdx + ")"));
            return -2;
        }
        if (!this.ConcentIndexRangeCheck(DeviceIdx, ConcentIdx)) {
            Log.w((String)"CutOffConcentAPI", (String)("[SetReleaseOverlad] Param - ConcentIdx  : Out Of Range (ConcentIdx:" + ConcentIdx + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetReleaseOverlad", DeviceIdx, ConcentIdx, 0, 0, 0);
    }

    private boolean DeviceIndexRangeCheck(byte Index) {
        try {
            return Index >= 0 && Index < this.data.DeviceCnt;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CutOffConcentAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"CutOffConcentAPI", (String)"[Exception Error] DeviceIndexRangeCheck");
            LogUtil.errorLogInfo("", "CutOffConcentAPI", e);
            return false;
        }
    }

    private boolean ConcentIndexRangeCheck(byte Index, byte ConcentIdx) {
        try {
            return !(this.data.Device[Index] == null ? ConcentIdx != -1 && (ConcentIdx >= 8 || ConcentIdx < 0) : ConcentIdx != -1 && (ConcentIdx >= this.data.Device[Index].circuit.CircuitCount || ConcentIdx < 0));
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "CutOffConcentAPI", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"CutOffConcentAPI", (String)"[Exception Error] ConcentIndexRangeCheck");
            LogUtil.errorLogInfo("", "CutOffConcentAPI", e);
            return false;
        }
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.CutOffConcent[] Device = null;
    }
}

