/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class WallpadSmartKeyRegData
extends wallpaddbmgr {
    private static final String TAG = "WallpadSmartKeyRegData";
    public List<SmartKeyDataClass> SyncData = new ArrayList<SmartKeyDataClass>();
    private final String INIT_HEX = "00000000";
    private final String INIT_DATE = "0000:00:00:00:00:00";
    private final int USED_FALSE = 0;
    private final int USED_TRUE = 1;

    public WallpadSmartKeyRegData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("SmartKeyRegDB")) {
            try {
                Log.i((String)TAG, (String)"[Create] CreateSmartKeyRegDB");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table SmartKeyRegDB (id INTEGER unique, Used INTEGER, Uid text, SiteCode text, DongHo text, RegDate text, LastUseDate text, SerialNumber text);");
                }
                boolean bRet = this.InitInsert();
                Log.i((String)TAG, (String)("[Create] InitInsert = " + bRet));
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Create] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    private boolean InitInsert() {
        for (int i = 0; i < 10; ++i) {
            long ret;
            ContentValues values = this.GetInitValues(i + 1);
            if (this.wdb == null || (ret = this.wdb.insert("SmartKeyRegDB", null, values)) >= 0L) continue;
            return false;
        }
        return true;
    }

    private ContentValues GetInitValues(int id) {
        ContentValues values = new ContentValues();
        values.put("id", Integer.valueOf(id));
        values.put("Used", Integer.valueOf(0));
        values.put("Uid", "00000000");
        values.put("SiteCode", "00000000");
        values.put("DongHo", "00000000");
        values.put("RegDate", "0000:00:00:00:00:00");
        values.put("LastUseDate", "0000:00:00:00:00:00");
        values.put("SerialNumber", "00000000000");
        return values;
    }

    public int GetEmptyId() {
        Cursor cursor = this.wdb.rawQuery("select id, Used from SmartKeyRegDB;", null);
        try {
            int Used = 0;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 0) continue;
                int id = cursor.getInt(0);
                cursor.close();
                return id;
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            return -100;
        }
        catch (Exception e) {
            cursor.close();
            Log.e((String)TAG, (String)"[GetEmptyId] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
        return -1;
    }

    public int Register(byte id, byte[] Uid, byte[] SiteCode, byte[] DongHo) {
        if (id <= 0 || id > 10) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        if (Uid == null) {
            Log.w((String)TAG, (String)"[Update] Param - Uid  is null !!!");
            return -2;
        }
        if (Uid.length != 4) {
            Log.w((String)TAG, (String)("[Update] Param - Uid.length  Not Match !!! (len:" + Uid.length + ")"));
            return -3;
        }
        if (SiteCode == null) {
            Log.w((String)TAG, (String)"[Update] Param - SiteCode  is null !!!");
            return -4;
        }
        if (SiteCode.length != 4) {
            Log.w((String)TAG, (String)("[Update] Param - SiteCode.length  Not Match !!! (len:" + SiteCode.length + ")"));
            return -5;
        }
        if (DongHo == null) {
            Log.w((String)TAG, (String)"[Update] Param - DongHo  is null !!!");
            return -6;
        }
        if (DongHo.length != 4) {
            Log.w((String)TAG, (String)("[Update] Param - DongHo.length  Not Match !!! (len:" + DongHo.length + ")"));
            return -7;
        }
        int ret = 0;
        int ExistId = this.isExistUid(Uid);
        if (ExistId > 0) {
            Log.w((String)TAG, (String)("[Update] isExistUid - Find !!! (ExistId:" + ExistId + ", Uid:" + WallpadSmartKeyRegData.GetByteStringFormat(Uid) + ")"));
            ret = this.UnRegister((byte)ExistId);
            Log.w((String)TAG, (String)("[Update] isExistUid - Find !!! UnRegister - ret:" + ret));
        }
        String whereClause = "id = " + id;
        ContentValues values = new ContentValues();
        values.put("Used", Integer.valueOf(1));
        values.put("Uid", WallpadSmartKeyRegData.GetByteStringFormat(Uid));
        values.put("SiteCode", WallpadSmartKeyRegData.GetByteStringFormat(SiteCode));
        values.put("DongHo", WallpadSmartKeyRegData.GetByteStringFormat(DongHo));
        GregorianCalendar cal = new GregorianCalendar();
        String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        values.put("RegDate", DateStr);
        values.put("LastUseDate", DateStr);
        String SerialNumber = String.format("%02X%02X%02X%02X%03d", DongHo[0], DongHo[1], DongHo[2], DongHo[3], id);
        values.put("SerialNumber", SerialNumber);
        ret = this.wdb.update("SmartKeyRegDB", values, whereClause, null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public int UnRegister(byte id) {
        String whereClause;
        if (id <= 0 || id > 10) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        ContentValues values = this.GetInitValues(id);
        int ret = this.wdb.update("SmartKeyRegDB", values, whereClause = "id = " + id, null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public int UnRegisterAll() {
        int ret = -1;
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            ret = this.UnRegister((byte)(i + 1));
            if (ret >= 0) continue;
            return -100 + -i;
        }
        return 0;
    }

    public int FindId(byte[] Uid) {
        Cursor cursor = this.wdb.rawQuery("select id, Used, Uid from SmartKeyRegDB;", null);
        try {
            int Used = 0;
            String UidStr = WallpadSmartKeyRegData.GetByteStringFormat(Uid);
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1 || UidStr == null || !UidStr.equals(cursor.getString(2))) continue;
                int id = cursor.getInt(0);
                cursor.close();
                return id;
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            return -100;
        }
        catch (Exception e) {
            cursor.close();
            Log.e((String)TAG, (String)"[FindId] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
        return -1;
    }

    public int UpdateLastUseDate(byte id) {
        if (id <= 0 || id > 10) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        String whereClause = "id = " + id;
        ContentValues values = new ContentValues();
        GregorianCalendar cal = new GregorianCalendar();
        String DateStr = cal.get(1) + ":" + (cal.get(2) + 1) + ":" + cal.get(5) + ":" + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        values.put("LastUseDate", DateStr);
        int ret = this.wdb.update("SmartKeyRegDB", values, whereClause, null);
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public String isExist(byte id, byte[] Uid, byte[] SiteCode, byte[] DongHo) {
        if (id <= 0 || id > 10) {
            Log.w((String)TAG, (String)("[isExist] Param - id  Out Of Range !!! (id:" + id + ")"));
            return null;
        }
        if (Uid == null) {
            Log.w((String)TAG, (String)"[isExist] Param - Uid  is null !!!");
            return null;
        }
        if (Uid.length != 4) {
            Log.w((String)TAG, (String)("[isExist] Param - Uid length Not Match !!!(len:" + Uid.length + ")"));
            return null;
        }
        if (SiteCode == null) {
            Log.w((String)TAG, (String)"[isExist] Param - SiteCode  is null !!!");
            return null;
        }
        if (SiteCode.length != 4) {
            Log.w((String)TAG, (String)("[isExist] Param - SiteCode length Not Match !!!(len:" + SiteCode.length + ")"));
            return null;
        }
        if (DongHo == null) {
            Log.w((String)TAG, (String)"[isExist] Param - DongHo  is null !!!");
            return null;
        }
        if (DongHo.length != 4) {
            Log.w((String)TAG, (String)("[isExist] Param - DongHo length Not Match !!!(len:" + DongHo.length + ")"));
            return null;
        }
        Cursor cursor = this.wdb.rawQuery("select id, Used, Uid, SiteCode, DongHo, SerialNumber from SmartKeyRegDB where id=\"" + id + "\";", null);
        try {
            int Used = 0;
            String nUidStr = WallpadSmartKeyRegData.GetByteStringFormat(Uid);
            String nSiteCodeStr = WallpadSmartKeyRegData.GetByteStringFormat(SiteCode);
            String nDongHoStr = WallpadSmartKeyRegData.GetByteStringFormat(DongHo);
            while (cursor.moveToNext()) {
                if (cursor.getInt(0) != id || (Used = cursor.getInt(1)) != 1) continue;
                String UidStr = cursor.getString(2);
                if (nUidStr == null || !nUidStr.equals(UidStr)) continue;
                String SiteCodeStr = cursor.getString(3);
                if (nSiteCodeStr == null || !nSiteCodeStr.equals(SiteCodeStr)) continue;
                String DongHoStr = cursor.getString(4);
                if (nDongHoStr == null || !nDongHoStr.equals(DongHoStr)) continue;
                String SerialNumber = cursor.getString(5);
                return SerialNumber;
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            return null;
        }
        catch (Exception e) {
            cursor.close();
            Log.e((String)TAG, (String)"[GetEmptyId] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
        return null;
    }

    public int isExistUid(byte[] Uid) {
        if (Uid == null) {
            Log.w((String)TAG, (String)"[isExistUid] Param - Uid  is null !!!");
            return -10;
        }
        if (Uid.length != 4) {
            Log.w((String)TAG, (String)("[isExistUid] Param - Uid length Not Match !!!(len:" + Uid.length + ")"));
            return -11;
        }
        Cursor cursor = this.wdb.rawQuery("select id, Used, Uid from SmartKeyRegDB;", null);
        try {
            int Used = 0;
            String nUidStr = WallpadSmartKeyRegData.GetByteStringFormat(Uid);
            String UidStr = null;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1) continue;
                UidStr = cursor.getString(2);
                if (nUidStr == null || UidStr == null || !nUidStr.equals(UidStr)) continue;
                int id = cursor.getInt(0);
                return id;
            }
            cursor.close();
            return -1;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            this.SyncData.clear();
            return -100;
        }
        catch (Exception e) {
            cursor.close();
            this.SyncData.clear();
            Log.e((String)TAG, (String)"[GetSmartKeyRegData] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
    }

    public List<SmartKeyDataClass> GetSmartKeyRegData() {
        Cursor cursor = this.wdb.rawQuery("select id, Used, Uid, SiteCode, DongHo, RegDate, LastUseDate, SerialNumber from SmartKeyRegDB;", null);
        try {
            this.SyncData.clear();
            int Used = 0;
            String RegDateStr = null;
            String LastUseDateStr = null;
            while (cursor.moveToNext()) {
                Used = cursor.getInt(1);
                if (Used != 1) continue;
                SmartKeyDataClass getdata = new SmartKeyDataClass();
                getdata.id = cursor.getInt(0);
                getdata.Uid = cursor.getString(2);
                getdata.SiteCode = cursor.getString(3);
                getdata.DongHo = cursor.getString(4);
                RegDateStr = cursor.getString(5);
                LastUseDateStr = cursor.getString(6);
                getdata.SerialNumber = cursor.getString(7);
                String[] retData = null;
                retData = RegDateStr.split(":");
                if (retData != null && retData.length >= 6) {
                    getdata.RegDateCal = new GregorianCalendar();
                    getdata.RegDateCal.set(1, Integer.parseInt(retData[0]));
                    getdata.RegDateCal.set(2, Integer.parseInt(retData[1]) - 1);
                    getdata.RegDateCal.set(5, Integer.parseInt(retData[2]));
                    getdata.RegDateCal.set(11, Integer.parseInt(retData[3]));
                    getdata.RegDateCal.set(12, Integer.parseInt(retData[4]));
                    getdata.RegDateCal.set(13, Integer.parseInt(retData[5]));
                }
                if ((retData = LastUseDateStr.split(":")) != null && retData.length >= 6) {
                    getdata.LastUseDateCal = new GregorianCalendar();
                    getdata.LastUseDateCal.set(1, Integer.parseInt(retData[0]));
                    getdata.LastUseDateCal.set(2, Integer.parseInt(retData[1]) - 1);
                    getdata.LastUseDateCal.set(5, Integer.parseInt(retData[2]));
                    getdata.LastUseDateCal.set(11, Integer.parseInt(retData[3]));
                    getdata.LastUseDateCal.set(12, Integer.parseInt(retData[4]));
                    getdata.LastUseDateCal.set(13, Integer.parseInt(retData[5]));
                }
                this.SyncData.add(getdata);
            }
            cursor.close();
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            cursor.close();
            this.SyncData.clear();
            return null;
        }
        catch (Exception e) {
            cursor.close();
            this.SyncData.clear();
            Log.e((String)TAG, (String)"[GetSmartKeyRegData] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
        return this.SyncData;
    }

    private static String GetByteStringFormat(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length != 4) {
            return null;
        }
        return String.format("%02X%02X%02X%02X", in[0], in[1], in[2], in[3]);
    }

    public String ToDebugSmartKeyData(List<SmartKeyDataClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "SmartKeyData\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            SmartKeyDataClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString();
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public static class SmartKeyDataClass {
        public int id = -1;
        public String Uid = null;
        public String SiteCode = null;
        public String DongHo = null;
        public Calendar RegDateCal = null;
        public Calendar LastUseDateCal = null;
        public String SerialNumber = null;

        public String ToDebugString() {
            String retStr = "==========================\r\nid  -  " + this.id + "\r\n==========================\r\nUid            : " + this.Uid + "\r\nSiteCode       : " + this.SiteCode + "\r\nDongHo         : " + this.DongHo + "\r\nRegDateCal     : " + this.RegDateCal.get(1) + "-" + (this.RegDateCal.get(2) + 1) + "-" + this.RegDateCal.get(5) + "  " + this.RegDateCal.get(11) + ":" + this.RegDateCal.get(12) + ":" + this.RegDateCal.get(13) + "\r\nLastUseDateCal : " + this.LastUseDateCal.get(1) + "-" + (this.LastUseDateCal.get(2) + 1) + "-" + this.LastUseDateCal.get(5) + "  " + this.LastUseDateCal.get(11) + ":" + this.LastUseDateCal.get(12) + ":" + this.LastUseDateCal.get(13) + "\r\nSerialNumber   : " + this.SerialNumber + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }
}

