package bssoft.stack.sip;
import java.net.DatagramPacket;
import java.util.*;

public class RTPCore {
	public int 						RTP_PORT		= 0;
	public int 						mediaType		= SIPStack.SIP_MEDIATYPE_NONE;
	public byte[] 					buffer			= null;
	public byte[]					pcmLinearBuffer = null;
	public boolean 					bRTPlooping		= false;
	public boolean 					bRTPparsing		= false;
	public boolean					bActive			= false;
	//RTP ENCODING FACTOR
	public int 						RTPversion		= 0;
	public int 						RTPpadding		= 0;
	public int 						RTPextension	= 0;
	public int 						RTPcsrc			= 0;
	public int 						RTPmark			= 0;
	public int 						RTPpayload		= 0;
	public int 						RTPsequence		= 0;
	public int 						RTPtimestamp	= 0;
	public int 						RTPssrc			= 0;
	public byte[] 					rtpPacketBuffer	= null;
	public byte[] 					rtpBulkBuffer	= null;
	public byte[] 					fieldBytes		= null;
	public byte[] 					rtpfieldBytes	= null;

	public boolean 					running				= false;
	public int 						remotePayloadType	= SIPStack.SIP_CODEC_NONE;
	public String 					remoteMediaIp		= null;
	public int 						remoteMediaPort		= 0;
	public boolean					bDtmfDetected		= false;
	public int						detectedDtmf		= 0;

	public Date 					rtpArrivalTime		= null;
	
	public int 						packetSize			= 0;
    ////////////////////////////////////////////////
    public int 				PARSEversion	= 0;
    public int 				PARSEpadding	= 0;
    public int 				PARSEextension	= 0;
    public int 				PARSEcsrc		= 0;
    public int 				PARSEmark		= 0;
    public int 				PARSEpayload	= 0;
    public int 				PARSEsequence	= 0;
    public int 				PARSEtimestamp	= 0;
    public int 				PARSEssrc		= 0;
    ////////////////////////////////////////////////
	public int 				PARSERFCdtmf	= 0;
	public int 				PARSERFCedge	= 0;
	public int 				PARSERFCvolume	= 0;
	public int 				PARSERFCduration= 0;


    ////////////////////////////////////////////////

	public RTPCore(int port,int mediaType)
	{
		if(SIPStack.bStackLicensed==false) {
			System.out.println("̽Ű ϼ.");
			System.exit(0);
		}
		
		RTP_PORT		= port;
		
		pcmLinearBuffer = new byte[1024];//320
		rtpPacketBuffer	= new byte[512];//172
		rtpBulkBuffer	= new byte[512];
		fieldBytes		= new byte[4];
		rtpfieldBytes	= new byte[4];
		
		RTPversion	= 2;
		RTPpadding	= 0;
		RTPextension= 0;
		RTPcsrc		= 0;
		RTPmark		= 0;
		RTPpayload	= 0;
		RTPsequence	= 0;
		Date date=new Date();
		RTPtimestamp= (int)date.getTime();
		RTPssrc		= (int)date.getTime();

		
		this.mediaType=mediaType;
		if(mediaType==SIPStack.SIP_MEDIATYPE_AUDIO) buffer = new byte[SIPStack.RTP_AUDIO_SIZE];
		else if(mediaType==SIPStack.SIP_MEDIATYPE_VIDEO) buffer = new byte[65507];
		else buffer = new byte[65507];

				
		bActive				= false;
		bDtmfDetected		= false;
		detectedDtmf		= 0;
		rtpArrivalTime=new Date();

	}
	public boolean encodeRtpHeader(
			byte[] header,
			int version,
			int padding,
			int extension,
			int csrc,
			int mark,
			int payload,
			int sequence,
			int timestamp,
			int ssrc
			)
	{
		if(header==null || header.length<12) return false;
		// V|P|X|CC|M|PT|SEQUENCE NUMBER|TIMESTAMP|SSRCI|
		// 2 1 1 4  1 7  16              32        32
		int iField=0;
		int iAppend=0;
		//VERSION
		iField=(version << 6) & 0x000000C0; //version
		//PADDING
		iAppend=(padding << 5) & 0x00000020; //padding
		iField |= iAppend;
		//EXTENSION
		iAppend=(extension << 4) & 0x00000010; //extension
		iField |= iAppend;
		//CSRC COUN
		iAppend=csrc & 0x0000000F; //csrc count
		iField |= iAppend;
		
		header[0]=(byte)iField;
		iField=0;
		//MARK
		iField=(mark << 7) & 0x00000080; //mark
		//PAYLOAD TYPE
		iAppend=payload & 0x0000007F; //payload
		iField |= iAppend;
		
		header[1]=(byte)iField;
		iField=0;
		//SEQUENC NUMBER
		header[2]=(byte)( (sequence << 16) >> 24 );
		header[3]=(byte)( (sequence << 24) >> 24 );
		//TIME STAMP PARSING
		header[4] =(byte)( timestamp >> 24 );
		header[5] =(byte)( (timestamp << 8) >> 24 );
		header[6] =(byte)( (timestamp << 16) >> 24 );
		header[7] =(byte)( (timestamp << 24) >> 24 );
		//SSRC PARSING
		header[8] =(byte)( ssrc >> 24 );
		header[9] =(byte)( (ssrc << 8) >> 24 );
		header[10] =(byte)( (ssrc << 16) >> 24 );
		header[11] =(byte)( (ssrc << 24) >> 24 );
		//
		return true;

	}
	public boolean encodeRtpHeader(
			int payload
			)
	{
		if(rtpPacketBuffer==null || rtpPacketBuffer.length<12) return false;
		// V|P|X|CC|M|PT|SEQUENCE NUMBER|TIMESTAMP|SSRCI|
		// 2 1 1 4  1 7  16              32        32
		int iField=0;
		int iAppend=0;
		//VERSION
		iField=(RTPversion << 6) & 0x000000C0; //version
		//PADDING
		iAppend=(RTPpadding << 5) & 0x00000020; //padding
		iField |= iAppend;
		//EXTENSION
		iAppend=(RTPextension << 4) & 0x00000010; //extension
		iField |= iAppend;
		//CSRC COUN
		iAppend=RTPcsrc & 0x0000000F; //csrc count
		iField |= iAppend;
		
		rtpPacketBuffer[0]=(byte)iField;
		iField=0;
		//MARK
		iField=(RTPmark << 7) & 0x00000080; //mark
		//PAYLOAD TYPE
		iAppend=payload & 0x0000007F; //payload
		iField |= iAppend;
		
		rtpPacketBuffer[1]=(byte)iField;
		iField=0;
		//SEQUENC NUMBER
		rtpPacketBuffer[2]=(byte)( (RTPsequence << 16) >> 24 );
		rtpPacketBuffer[3]=(byte)( (RTPsequence << 24) >> 24 );
		//TIME STAMP PARSING
		rtpPacketBuffer[4] =(byte)( RTPtimestamp >> 24 );
		rtpPacketBuffer[5] =(byte)( (RTPtimestamp << 8) >> 24 );
		rtpPacketBuffer[6] =(byte)( (RTPtimestamp << 16) >> 24 );
		rtpPacketBuffer[7] =(byte)( (RTPtimestamp << 24) >> 24 );
		//SSRC PARSING
		rtpPacketBuffer[8] =(byte)( RTPssrc >> 24 );
		rtpPacketBuffer[9] =(byte)( (RTPssrc << 8) >> 24 );
		rtpPacketBuffer[10] =(byte)( (RTPssrc << 16) >> 24 );
		rtpPacketBuffer[11] =(byte)( (RTPssrc << 24) >> 24 );
		//
		return true;

	}
	public int getBytesToInt(byte[] bytes) {
		 int newValue=0;
		 newValue |= (((int)bytes[0]) << 24) & 0xFF000000;
		 newValue |= (((int)bytes[1]) << 16) & 0xFF0000;
		 newValue |= (((int)bytes[2]) << 8) & 0xFF00;
		 newValue |= (((int)bytes[3])) & 0xFF;
		 return newValue;
	}
	public byte[] getIntToBytes(int iValue) {
		byte[] newbytes=new byte[4];
				
		newbytes[0] =(byte)( iValue >> 24 );
		newbytes[1] =(byte)( (iValue << 8) >> 24 );
		newbytes[2] =(byte)( (iValue << 16) >> 24 );
		newbytes[3] =(byte)( (iValue << 24) >> 24 );
		return newbytes;
	}
	public boolean setRTPPort(int port)
	{
		if(port<=0) return false;
		RTP_PORT=port;
		return true;
	}
	public void setRemoteMediaInfo(int payloadtype,String mediaIp,int mediaPort)
	{
		remotePayloadType=payloadtype;
		remoteMediaIp=mediaIp;
		remoteMediaPort=mediaPort;
		return;
	}
	public void parseRtpHeader(byte[] buffer)
	{
		if(buffer==null || buffer.length<12) return;
		// V|P|X|CC|M|PT|SEQUENCE NUMBER|TIMESTAMP|SSRCI|
		// 2 1 1 4  1 7  16              32        32
		//VERSION
		fieldBytes[0]=buffer[0];
		int version = (((int)fieldBytes[0]) >> 6) & 0x03;
		System.out.println("VERSION:"+version);
		//PAYLOAD TYPE
		fieldBytes[0]=buffer[1];
		int payloadType = ((int)fieldBytes[0]) & 0x7F;
		System.out.println("Payload:"+payloadType);
		//SEQUENC NUMBER
		fieldBytes[0]=0;
		fieldBytes[1]=0;
		fieldBytes[2]=buffer[2];
		fieldBytes[3]=buffer[3];
		int sequencNumber=getBytesToInt(fieldBytes);
		System.out.println("SEQUENCE NUMBER:"+sequencNumber);
		//TIME STAMP PARSING
		fieldBytes[0]=buffer[4];
		fieldBytes[1]=buffer[5];
		fieldBytes[2]=buffer[6];
		fieldBytes[3]=buffer[7];
		int timeStamp=getBytesToInt(fieldBytes);
		System.out.println("TIMESTAMP:"+timeStamp);
		//SSRC PARSING
		fieldBytes[0]=buffer[8];
		fieldBytes[1]=buffer[9];
		fieldBytes[2]=buffer[10];
		fieldBytes[3]=buffer[11];
		int ssrc=getBytesToInt(fieldBytes);
		System.out.println("SSRC:"+ssrc);
		//
		

		return;

	}
	public void init()
	{
		RTPversion	= 2;
		RTPpadding	= 0;
		RTPextension= 0;
		RTPcsrc		= 0;
		RTPmark		= 0;
		RTPpayload	= 0;
		RTPsequence	= 0;
		Date date=new Date();
		
		RTPtimestamp= (int)date.getTime();
		RTPssrc		= (int)date.getTime();
		
		
		bDtmfDetected		= false;
		detectedDtmf		= 0;
		bActive=false;
		//2015 06 19
		rtpArrivalTime=new Date();
		//

	}
	public boolean parseRTPHeader()
	{
		try
		{
		    PARSEversion	= 0;
		    PARSEpadding	= 0;
		    PARSEextension	= 0;
		    PARSEcsrc		= 0;
		    PARSEmark		= 0;
		    PARSEpayload	= 0;
		    PARSEsequence	= 0;
		    PARSEtimestamp	= 0;
		    PARSEssrc		= 0;
		    
			//System.out.println("<<< receive:"+dp.getLength());
			// V|P|X|CC|M|PT|SEQUENCE NUMBER|TIMESTAMP|SSRCI|
			// 2 1 1 4  1 7  16              32        32

			/*
			//VERSION
			rtpfieldBytes[0]=buffer[0];
			int version = (((int)rtpfieldBytes[0]) >> 6) & 0x03;
			System.out.println("VERSION:"+version);
			*/
			//PAYLOAD TYPE
			rtpfieldBytes[0]=buffer[1];
			PARSEmark = (((int)rtpfieldBytes[0]) >> 7) & 0x01;	
			PARSEpayload = ((int)rtpfieldBytes[0]) & 0x7F;			


		}catch(Exception e){return false;}
		return true;
	}
	public String getRemotAddress(DatagramPacket dp)
	{
		String strIp="0.0.0.0:0";
		try
		{
			byte[] address = dp.getAddress().getAddress();
			if(address.length==4)
			{
				int unsignedByte1 = address[0]<0 ? address[0]+256 : address[0];
				int unsignedByte2 = address[1]<0 ? address[1]+256 : address[1];
				int unsignedByte3 = address[2]<0 ? address[2]+256 : address[2];
				int unsignedByte4 = address[3]<0 ? address[3]+256 : address[3];
				strIp=unsignedByte1+"."+unsignedByte2+"."+unsignedByte3+"."+unsignedByte4+":"+dp.getPort();
			}
		}catch(Exception e){}
		return strIp;
	}
	public boolean parseRFC2833()
	{
		PARSERFCdtmf=0;
		PARSERFCedge=0;
		PARSERFCvolume=0;
		PARSERFCduration=0;
		try
		{
			/*	
			0                   1                   2                   3
		    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		   |     event     |E|R| volume    |          duration             |
		   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
			 */
			int field=0;
			//byte[] rfcdata=new byte[4];
			//0..7 EVENT
			PARSERFCdtmf=(int)buffer[12];
			//8..15 EDGE|RESERVED|VOLUME
			field=(int)buffer[13];
			PARSERFCedge=(field & 0x00000080) >> 7;
			PARSERFCvolume=field & 0x0000003F;
			//16..32 DURATION
			PARSERFCduration=((int)buffer[14] << 24)>>16 & 0x0000FF00;
			PARSERFCduration |= ((int)buffer[15] << 24)>>24 & 0x000000FF;
			//
			return true;

		}catch(Exception e){}
		return false;
	}
	public String getVideomediadescription()
	{
		int port=RTP_PORT+2;
		String str="m=video "+port+" RTP/AVP "+SIPStack.SIP_CODEC_H264+SIPStack.SIP_LINE_END+
				"a=rtpmap:"+SIPStack.SIP_CODEC_H264+" H264/90000"+SIPStack.SIP_LINE_END+
				"a=fmtp:"+SIPStack.SIP_CODEC_H264+" packetization-mode=1;profile-level-id=2"+SIPStack.SIP_LINE_END+
				"a=cliprect:0,0,240,320"+SIPStack.SIP_LINE_END+
				"a=framesize:"+SIPStack.SIP_CODEC_H264+" 320-240"+SIPStack.SIP_LINE_END;
				
		return str;
	}


}
