/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class LouverAPI
extends WallPadDevAPI {
    private final String TAG = "LouverAPI";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"LouverAPI", (String)s);
    }

    public LouverAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("LouverAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "LOUVER";
        this.data = new Data();
    }

    public int Refresh(boolean real) {
        String SubCMD;
        String MainCMD = null;
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD = "Refresh", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        this.DebugLogOutput("LouverAPI getstate cmd ret : " + ret);
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 3) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.data.LouverStatus = Byte.parseByte(retlist[index++]);
                this.data.Error = Byte.parseByte(retlist[index++]);
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "LouverAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"LouverAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "LouverAPI", e);
                return -100;
            }
            return 0;
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public static class Data {
        public byte LouverStatus = LOUVERSTATUS.Close;
        public byte Error = 0;

        public String ToDebugString() {
            String retStr = "==========================\r\nLouverData\r\n==========================\r\nLouverStatus : " + LOUVERSTATUS.ToDebugString(this.LouverStatus) + "\r\nError      : " + String.format("0x%02X", this.Error) + "\r\n==========================\r\n";
            return retStr;
        }
    }

    public static class LOUVERSTATUS {
        public static byte Close = 0;
        public static byte Venti = 1;
        public static byte Open = (byte)2;

        public static boolean CheckRange(byte nStatus) {
            if (nStatus == Close) {
                return true;
            }
            if (nStatus == Venti) {
                return true;
            }
            return nStatus == Open;
        }

        public static String ToDebugString(byte nStatus) {
            String retStr = nStatus == Close ? "Close" : (nStatus == Venti ? "Venti" : (nStatus == Open ? "Open" : "UnDefined"));
            return retStr;
        }
    }
}

