/*
 * Decompiled with CFR 0.152.
 */
package kr.co.icontrols.wallpadsupport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import kr.co.icontrols.wallpadsupport.WpadScale;
import kr.co.icontrols.wallpadsupport.WpadTextView;
import kr.co.icontrols.wallpadsupport.WpadUtil;

@SuppressLint(value={"ViewConstructor", "Recycle", "HandlerLeak"})
public class WpadImageView
extends ImageView {
    private static String TAG = "WpadImageView";
    private int mTouchKind = 0;
    private int mDefaultImageID = -1;
    private int mPressedImageID = -1;
    private int[] mFrontImageID = null;
    private int[] mRearImageID = null;
    private boolean mCreate = false;
    private boolean mButtonEventEnable = false;
    private boolean mButtonEventOff = false;
    private int mButtonEventOffResourceId = -1;
    private int mCurrentImageResourceId = -1;
    private boolean mTabSelect = false;
    private int mButtonEvent = 1;
    private int mTouchDelayMs = 0;
    private boolean mTouchDelayEnabled = false;
    private Handler TouchDelayHandler = null;
    private WpadImageView mButtonEventLinkImageView = null;
    private WpadTextView mButtonEventLinkTextView = null;

    public int getTouchKind() {
        return this.mTouchKind;
    }

    public int getDefaultImageID() {
        return this.mDefaultImageID;
    }

    public int getPressedImageID() {
        return this.mPressedImageID;
    }

    public boolean getButtonEventOff() {
        return this.mButtonEventOff;
    }

    public WpadImageView(Context context, int touchKind, int w, int h, int nDefaultImageID, int nPressedImageID, int nID) {
        super(context);
        if (touchKind == 1 && nPressedImageID <= 0) {
            Log.w((String)TAG, (String)"[WpadImageView] - Parameter(nPressedImageID) Please check the value !!!");
        }
        switch (touchKind) {
            case 0: {
                this.mButtonEventEnable = false;
                break;
            }
            case 1: {
                this.mButtonEventEnable = true;
                break;
            }
            case 2: {
                this.mButtonEventEnable = true;
                break;
            }
            case 3: {
                this.mButtonEventEnable = true;
                break;
            }
            case 4: {
                this.mButtonEventEnable = true;
                break;
            }
            case 6: {
                this.mButtonEventEnable = false;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("[WpadImageView] - Parameter(touchKind) Out of range !!! (" + touchKind + ")"));
                return;
            }
        }
        if (WpadScale.getAutoScale() && (WpadScale.getWidthPixels() != 1280 || WpadScale.getHeightPixels() != 800)) {
            super.setScaleType(ImageView.ScaleType.FIT_XY);
        }
        int setW = w;
        int setH = h;
        if (w != WpadScale.getWidthPixels() || h != WpadScale.getHeightPixels()) {
            setW = WpadScale.getWidth(w);
            setH = WpadScale.getHeight(h);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(setW, setH);
        super.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTouchKind = touchKind;
        this.mDefaultImageID = nDefaultImageID;
        this.mPressedImageID = nPressedImageID;
        this.setId(nID);
        if (nDefaultImageID > 0) {
            this.setImageResource(nDefaultImageID);
        }
        this.mCreate = true;
    }

    public WpadImageView(Context context, int touchKind, int w, int h, int[] nFrontImageID, int[] nRearImageID, int nID) {
        super(context);
        if (touchKind != 5 && touchKind != 1 && touchKind != 2) {
            Log.e((String)TAG, (String)("[Error] Param - touchKind  Out of range !!! (" + touchKind + ")"));
            return;
        }
        if (nFrontImageID == null) {
            Log.e((String)TAG, (String)"[Error] Param - nFrontImageID is null");
            return;
        }
        if (nFrontImageID.length != 2) {
            Log.e((String)TAG, (String)("[Error] Param - nFrontImageID length  Out of range !!! (" + nFrontImageID.length + ")"));
            return;
        }
        if (nRearImageID == null) {
            Log.e((String)TAG, (String)"[Error] Param - nRearImageID is null");
            return;
        }
        if (nRearImageID.length != 2) {
            Log.e((String)TAG, (String)("[Error] Param - nRearImageID  length  Out of range !!! (" + nRearImageID.length + ")"));
            return;
        }
        if (nFrontImageID[0] <= 0 || nFrontImageID[1] <= 0) {
            Log.e((String)TAG, (String)"[Error] Param - nFrontImageID  Please check the value !!!");
            return;
        }
        if (nRearImageID[0] <= 0 || nRearImageID[1] <= 0) {
            Log.e((String)TAG, (String)"[Error] Param - nRearImageID  Please check the value !!!");
            return;
        }
        this.mButtonEventEnable = true;
        if (WpadScale.getAutoScale() && (WpadScale.getWidthPixels() != 1280 || WpadScale.getHeightPixels() != 800)) {
            super.setScaleType(ImageView.ScaleType.FIT_XY);
        }
        int setW = w;
        int setH = h;
        if (w != WpadScale.getWidthPixels() || h != WpadScale.getHeightPixels()) {
            setW = WpadScale.getWidth(w);
            setH = WpadScale.getHeight(h);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(setW, setH);
        super.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTouchKind = touchKind;
        this.mFrontImageID = new int[2];
        this.mRearImageID = new int[2];
        this.mFrontImageID[0] = nFrontImageID[0];
        this.mFrontImageID[1] = nFrontImageID[1];
        this.mRearImageID[0] = nRearImageID[0];
        this.mRearImageID[1] = nRearImageID[1];
        this.setId(nID);
        if (touchKind == 5) {
            this.setBackgroundResource(this.mRearImageID[0]);
            this.setImageResource(this.mFrontImageID[0]);
        } else if (touchKind == 1) {
            this.setImageResource(this.mFrontImageID[0]);
        } else if (touchKind == 2) {
            this.setImageResource(this.mFrontImageID[0]);
            this.setBackgroundResource(this.mRearImageID[0]);
        }
        this.mCreate = true;
    }

    protected MotionEvent setTouchFilterNChangeImage(MotionEvent event) {
        if (!this.mCreate) {
            event.setAction(-1);
            return event;
        }
        if (this.mTouchKind == 0) {
            event.setAction(-2);
            return event;
        }
        if (this.mTouchKind == 6) {
            return event;
        }
        if (this.mTouchDelayEnabled) {
            event.setAction(-3);
            return event;
        }
        if (this.mButtonEventOff) {
            event.setAction(-4);
            return event;
        }
        int MoveEvent = event.getAction();
        if (this.mButtonEventEnable) {
            if (this.mButtonEvent == 3) {
                if (MoveEvent == 1) {
                    this.mButtonEvent = 1;
                    event.setAction(-10);
                } else {
                    event.setAction(-11);
                }
                this.sendButtonEventPass(1, true);
                return event;
            }
            if (this.mButtonEvent == 0 && MoveEvent == 2) {
                if (WpadUtil.PointerCancelCheck((View)this, event)) {
                    event.setAction(3);
                } else {
                    event.setAction(-12);
                    return event;
                }
            }
            return this.setTouchFilter_Process(event);
        }
        event.setAction(-13);
        return event;
    }

    private MotionEvent setTouchFilter_Process(MotionEvent event) {
        int MoveEvent = event.getAction();
        boolean RetToucheventOn = false;
        switch (this.mTouchKind) {
            case 1: {
                if (MoveEvent == 3) {
                    if (this.mDefaultImageID > 0) {
                        this.setImageResource(this.mDefaultImageID);
                    } else if (this.mFrontImageID != null && this.mFrontImageID != null) {
                        if (this.mFrontImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mFrontImageID[0]);
                        } else if (this.mRearImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mRearImageID[0]);
                        }
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                } else if (MoveEvent == 0) {
                    if (this.mButtonEvent == 1) {
                        if (this.mPressedImageID > 0) {
                            this.setImageResource(this.mPressedImageID);
                        } else if (this.mFrontImageID != null && this.mRearImageID != null) {
                            if (this.mFrontImageID[0] == this.getImageResource()) {
                                this.setImageResource(this.mFrontImageID[1]);
                            } else if (this.mRearImageID[0] == this.getImageResource()) {
                                this.setImageResource(this.mRearImageID[1]);
                            }
                        }
                        this.mButtonEvent = MoveEvent;
                        RetToucheventOn = true;
                    }
                } else if (MoveEvent == 1 && this.mButtonEvent == 0) {
                    if (this.mDefaultImageID > 0) {
                        this.setImageResource(this.mDefaultImageID);
                    } else if (this.mFrontImageID != null && this.mRearImageID != null) {
                        if (this.mFrontImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mFrontImageID[0]);
                        } else if (this.mRearImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mRearImageID[0]);
                        }
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                    this.setTouchDelayEnable();
                }
                if (RetToucheventOn) break;
                event.setAction(-100);
                break;
            }
            case 2: {
                if (MoveEvent == 3) {
                    if (this.mDefaultImageID > 0) {
                        this.setImageResource(this.mDefaultImageID);
                    } else if (this.mFrontImageID != null && this.mRearImageID != null) {
                        if (this.mFrontImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mFrontImageID[0]);
                        } else if (this.mRearImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mRearImageID[0]);
                        }
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                } else if (MoveEvent == 0) {
                    if (this.mButtonEvent == 1) {
                        if (this.mPressedImageID > 0) {
                            this.setImageResource(this.mPressedImageID);
                        } else if (this.mFrontImageID != null && this.mRearImageID != null) {
                            if (this.mFrontImageID[0] == this.getImageResource()) {
                                this.setImageResource(this.mFrontImageID[1]);
                            } else if (this.mRearImageID[0] == this.getImageResource()) {
                                this.setImageResource(this.mRearImageID[1]);
                            }
                        }
                        this.mButtonEvent = MoveEvent;
                        RetToucheventOn = true;
                    }
                } else if (MoveEvent == 1 && this.mButtonEvent == 0) {
                    if (this.mDefaultImageID > 0) {
                        this.setImageResource(this.mDefaultImageID);
                    } else if (this.mFrontImageID != null && this.mRearImageID != null) {
                        if (this.mFrontImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mFrontImageID[0]);
                        } else if (this.mRearImageID[1] == this.getImageResource()) {
                            this.setImageResource(this.mRearImageID[0]);
                        }
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                    this.setTouchDelayEnable();
                }
                if (RetToucheventOn) break;
                event.setAction(-100);
                break;
            }
            case 3: {
                if (MoveEvent == 3) {
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                } else if (MoveEvent == 0) {
                    if (this.mButtonEvent == 1) {
                        this.mButtonEvent = MoveEvent;
                        RetToucheventOn = true;
                    }
                } else if (MoveEvent == 1 && this.mButtonEvent == 0) {
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                    this.setTouchDelayEnable();
                }
                if (RetToucheventOn) break;
                event.setAction(-101);
                break;
            }
            case 4: {
                if (this.mTabSelect) {
                    event.setAction(-102);
                    return event;
                }
                if (MoveEvent == 3) {
                    if (this.mDefaultImageID > 0) {
                        this.setImageResource(this.mDefaultImageID);
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                } else if (MoveEvent == 0) {
                    if (this.mButtonEvent == 1) {
                        if (this.mPressedImageID > 0) {
                            this.setImageResource(this.mPressedImageID);
                        }
                        this.mButtonEvent = MoveEvent;
                        RetToucheventOn = true;
                    }
                } else if (MoveEvent == 1 && this.mButtonEvent == 0) {
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                    this.mTabSelect = true;
                    this.setTouchDelayEnable();
                }
                if (RetToucheventOn) break;
                event.setAction(-103);
                break;
            }
            case 5: {
                if (this.mTabSelect) {
                    event.setAction(-104);
                    return event;
                }
                if (MoveEvent == 3) {
                    if (this.mFrontImageID != null && this.mRearImageID != null && this.mFrontImageID[0] > 0) {
                        this.setImageResource(this.mFrontImageID[0]);
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                } else if (MoveEvent == 0) {
                    if (this.mButtonEvent == 1) {
                        if (this.mFrontImageID != null && this.mRearImageID != null && this.mFrontImageID[1] > 0) {
                            this.setImageResource(this.mFrontImageID[1]);
                        }
                        this.mButtonEvent = MoveEvent;
                        RetToucheventOn = true;
                    }
                } else if (MoveEvent == 1 && this.mButtonEvent == 0) {
                    if (this.mFrontImageID != null && this.mRearImageID != null && this.mRearImageID[1] > 0) {
                        this.setBackgroundResource(this.mRearImageID[1]);
                    }
                    this.mButtonEvent = MoveEvent;
                    RetToucheventOn = true;
                    this.mTabSelect = true;
                    this.setTouchDelayEnable();
                }
                if (RetToucheventOn) break;
                event.setAction(-105);
                break;
            }
            default: {
                event.setAction(-106);
            }
        }
        if (MoveEvent == 0 || MoveEvent == 1) {
            this.sendButtonEventPass(MoveEvent, false);
        } else if (MoveEvent == 3) {
            this.sendButtonEventPass(2, true);
        }
        return event;
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.mCurrentImageResourceId = resId;
    }

    public int getImageResource() {
        return this.mCurrentImageResourceId;
    }

    public boolean setButtonDefaultImageID() {
        if (!this.mCreate) {
            Log.w((String)TAG, (String)"[setButtonDefaultImageID] - This class is not created");
            return false;
        }
        if (this.mDefaultImageID <= 0) {
            Log.w((String)TAG, (String)"[setButtonDefaultImageID] - DefaultImageID is <= 0");
            return false;
        }
        this.setImageResource(this.mDefaultImageID);
        return true;
    }

    public boolean setButtonPressedImageID() {
        if (!this.mCreate) {
            Log.w((String)TAG, (String)"[setButtonPressedImageID] - This class is not created");
            return false;
        }
        if (this.mButtonEvent != 1) {
            Log.w((String)TAG, (String)"[setButtonPressedImageID] - Current state is operation in the event of the Button");
            return false;
        }
        if (this.mPressedImageID <= 0) {
            Log.w((String)TAG, (String)"[setButtonPressedImageID] - PressedImageID is <= 0");
            return false;
        }
        this.setImageResource(this.mPressedImageID);
        return true;
    }

    public boolean setButtonFrontImage() {
        if (!this.mCreate) {
            Log.w((String)TAG, (String)"[setButtonFrontImage] - This class is not created");
            return false;
        }
        if (this.mTouchKind != 1 && this.mTouchKind != 2) {
            Log.w((String)TAG, (String)"[setButtonFrontImage] - TOUCH_KIND is not BUTTON");
            return false;
        }
        if (this.mFrontImageID == null) {
            Log.w((String)TAG, (String)"[setButtonFrontImage] - FrontImageID is null");
            return false;
        }
        if (this.mFrontImageID[0] <= 0) {
            Log.w((String)TAG, (String)"[setButtonFrontImage] - FrontImageID not registered.");
            return false;
        }
        this.setImageResource(this.mFrontImageID[0]);
        return true;
    }

    public boolean setButtonRearImage() {
        if (!this.mCreate) {
            Log.w((String)TAG, (String)"[setButtonRearImage] - This class is not created");
            return false;
        }
        if (this.mTouchKind != 1 && this.mTouchKind != 2) {
            Log.w((String)TAG, (String)("[setButtonRearImage] - TouchKind is not supported (touchKind : " + this.mTouchKind + ")"));
            return false;
        }
        if (this.mButtonEvent != 1) {
            Log.w((String)TAG, (String)"[setButtonRearImage] - Current state is operation in the event of the Button");
            return false;
        }
        if (this.mRearImageID == null) {
            Log.w((String)TAG, (String)"[setButtonRearImage] - RearImageID is null");
            return false;
        }
        if (this.mRearImageID[0] <= 0) {
            Log.w((String)TAG, (String)"[setButtonRearImage] - RearImageID not registered.");
            return false;
        }
        this.setImageResource(this.mRearImageID[0]);
        return true;
    }

    public boolean setTabEnable() {
        if (!this.mCreate) {
            Log.w((String)TAG, (String)"[setTabEnable] - This class is not created");
            return false;
        }
        if (this.mTouchKind != 5 && this.mTouchKind != 4) {
            Log.w((String)TAG, (String)("[setTabEnable] - TouchKind is not supported (touchKind : " + this.mTouchKind + ")"));
            return false;
        }
        if (this.mTouchKind == 5) {
            this.setBackgroundResource(this.mRearImageID[1]);
            this.setImageResource(this.mFrontImageID[1]);
            this.mTabSelect = true;
        } else if (this.mTouchKind == 4) {
            this.setImageResource(this.mPressedImageID);
            this.mTabSelect = true;
        } else {
            return false;
        }
        return true;
    }

    public boolean setTabDisable() {
        if (!this.mCreate) {
            Log.w((String)TAG, (String)"[setTabDisable] - This class is not created");
            return false;
        }
        if (this.mTouchKind == 5) {
            this.setImageResource(this.mFrontImageID[0]);
            this.setBackgroundResource(this.mRearImageID[0]);
            this.mTabSelect = false;
        } else if (this.mTouchKind == 4) {
            this.setImageResource(this.mDefaultImageID);
            this.mTabSelect = false;
        } else {
            return false;
        }
        return true;
    }

    public boolean setTouchDelayMs(int ms) {
        if (!this.mButtonEventEnable) {
            Log.w((String)TAG, (String)"[setTouchDelayMs] - If you are not a button type is not supported.");
            return false;
        }
        if (ms < 0 || ms > 10000) {
            Log.e((String)TAG, (String)("[setTouchDelayMs] - param Out of range (ms:" + ms + ")"));
            return false;
        }
        this.mTouchDelayMs = ms;
        return true;
    }

    public int getTouchDelayMs() {
        if (!this.mButtonEventEnable) {
            Log.w((String)TAG, (String)"[getTouchDelayMs] - If you are not a button type is not supported.");
            return -1;
        }
        return this.mTouchDelayMs;
    }

    private boolean setTouchDelayEnable() {
        if (this.mTouchDelayMs <= 0) {
            return false;
        }
        if (this.mTouchDelayEnabled) {
            return false;
        }
        this.mTouchDelayEnabled = true;
        this.TouchDelayHandler = new Handler(){

            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    WpadImageView.this.mTouchDelayEnabled = false;
                }
            }
        };
        this.TouchDelayHandler.sendEmptyMessageDelayed(1, (long)this.mTouchDelayMs);
        return true;
    }

    @SuppressLint(value={"HandlerLeak"})
    public boolean setButtonEventOffEnable() {
        if (!this.mButtonEventEnable) {
            return false;
        }
        this.mButtonEventOff = true;
        this.mButtonEventOffResourceId = -1;
        return true;
    }

    public boolean setButtonEventOffEnable(int resId) {
        if (!this.mButtonEventEnable) {
            return false;
        }
        this.mButtonEventOff = true;
        this.setImageResource(resId);
        this.mButtonEventOffResourceId = resId;
        return true;
    }

    public boolean setButtonEventOffDisable() {
        if (!this.mButtonEventEnable) {
            return false;
        }
        if (!this.mButtonEventOff) {
            return false;
        }
        this.mButtonEventOff = false;
        if (this.mButtonEventOffResourceId > 0) {
            if (this.getDefaultImageID() > 0) {
                this.setButtonDefaultImageID();
            } else {
                this.setButtonFrontImage();
            }
        }
        return true;
    }

    public boolean setButtonEvent(int MoveEvent, boolean PointerCancel) {
        if (!this.mButtonEventEnable) {
            return false;
        }
        long Time = SystemClock.uptimeMillis();
        float x = 0.0f;
        float y = 0.0f;
        if (PointerCancel) {
            x = -1.0f;
            y = -1.0f;
        }
        MotionEvent sendevent = MotionEvent.obtain((long)Time, (long)Time, (int)MoveEvent, (float)x, (float)y, (int)0);
        this.dispatchTouchEvent(sendevent);
        return true;
    }

    public boolean setButtonEventLink(WpadImageView TargetImageView) {
        if (!this.mButtonEventEnable) {
            return false;
        }
        if (this.mButtonEventLinkImageView != null && TargetImageView == null && this.mButtonEvent == 1) {
            this.mButtonEventLinkImageView.setButtonEvent(1, true);
        }
        this.mButtonEventLinkImageView = TargetImageView;
        return true;
    }

    public boolean setButtonEventLink(WpadTextView TargetTextView) {
        if (!this.mButtonEventEnable) {
            return false;
        }
        if (this.mButtonEventLinkTextView != null && TargetTextView == null && this.mButtonEvent == 1) {
            this.mButtonEventLinkTextView.setButtonEvent(1, true);
        }
        this.mButtonEventLinkTextView = TargetTextView;
        return true;
    }

    private void sendButtonEventPass(int MoveEvent, boolean PointerCancel) {
        if (this.mButtonEventLinkImageView != null) {
            this.mButtonEventLinkImageView.setButtonEvent(MoveEvent, PointerCancel);
        }
        if (this.mButtonEventLinkTextView != null) {
            this.mButtonEventLinkTextView.setButtonEvent(MoveEvent, PointerCancel);
        }
    }

    public void setImageChange(int nDefaultImageID, int nPressedImageID) {
        this.mDefaultImageID = nDefaultImageID;
        this.mPressedImageID = nPressedImageID;
        this.setImageResource(this.mDefaultImageID);
    }

    public static final class TOUCH_KIND {
        public static final int NONE = 0;
        public static final int BUTTON = 1;
        public static final int BUTTON_LC = 2;
        public static final int BUTTON_M = 3;
        public static final int TAB = 4;
        public static final int TAB_MENU = 5;
        public static final int MOVE = 6;
    }
}

