/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class LedDimmingKCC_API
extends WallPadDevAPI {
    private final String TAG = "LedDimmingKCC_API";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"LedDimmingKCC_API", (String)s);
    }

    public LedDimmingKCC_API(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("LedDimmingKCC_API create " + devctrcmd);
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "LED_DIMMING";
        this.data = new Data();
    }

    public int Refresh(byte Index, boolean real) {
        if (Index < 0 || Index >= this.data.DeviceCnt) {
            Log.w((String)"LedDimmingKCC_API", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            boolean Install;
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.LedDimming Device2 = new DataClasses.LedDimming();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            if (Install = Boolean.parseBoolean(retData[index++])) {
                Device2.info.Install = true;
                Device2.info.Support.Color = Boolean.parseBoolean(retData[index++]);
                Device2.info.Support.Level = Boolean.parseBoolean(retData[index++]);
                Device2.info.Vender = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Number = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
                Device2.device.OnOff = Boolean.parseBoolean(retData[index++]);
                Device2.device.Color = Byte.parseByte(retData[index++]);
                Device2.device.Level = Byte.parseByte(retData[index++]);
            } else {
                Device2.info.Install = false;
            }
            this.data.Device[Current] = Device2;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "LedDimmingKCC_API", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"LedDimmingKCC_API", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "LedDimmingKCC_API", e);
            return -1;
        }
        return 0;
    }

    public int SetDimmingLevel(int Index, byte Level2) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"LedDimmingKCC_API", (String)"[SetDimmingLevel] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"LedDimmingKCC_API", (String)("[SetDimmingLevel] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        if (!DataClasses.LedDimming.Level.CheckRange(Level2)) {
            Log.w((String)"LedDimmingKCC_API", (String)("[SetDimmingLevel] Param - Level  : Out Of Range (Level:" + Level2 + ")"));
            return -3;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetDimmingLevel", Index, Level2, 0, 0, 0);
    }

    private boolean DeviceIndexRangeCheck(int Index) {
        try {
            return Index >= 0 && Index < this.data.DeviceCnt;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "LedDimmingKCC_API", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"LedDimmingKCC_API", (String)"[Exception Error] DeviceIndexRangeCheck");
            LogUtil.errorLogInfo("", "LedDimmingKCC_API", e);
            return false;
        }
    }

    public static class Data {
        public byte DeviceCnt = 1;
        public DataClasses.LedDimming[] Device = new DataClasses.LedDimming[this.DeviceCnt];
    }
}

