/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.artncore.commons.Sdb_DataClasses;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class WallpadConcentAccSaveData
extends wallpaddbmgr {
    private static final String TAG = "WallpadConcentAccSaveData";
    public static byte EM_INDEX_LIVING = (byte)14;
    public List<ConcentAccDataClass> SyncData = new ArrayList<ConcentAccDataClass>();

    @SuppressLint(value={"LongLogTag"})
    public WallpadConcentAccSaveData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("SmartConcentAccSaveTBL")) {
            try {
                if (this.wdb != null) {
                    this.wdb.execSQL("create table SmartConcentAccSaveTBL (num INTEGER unique, concentcount INTEGER, value text);");
                }
                boolean bRet = this.InitInsert();
                Log.i((String)TAG, (String)("[Create] InitInsert = " + bRet));
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    public boolean InitInsert() {
        for (int i = 0; i < 15; ++i) {
            long ret;
            ContentValues values = this.GetInitValues(i + 1);
            if (this.wdb == null || (ret = this.wdb.insert("SmartConcentAccSaveTBL", null, values)) >= 0L) continue;
            return false;
        }
        return true;
    }

    public ContentValues GetInitValues(int id) {
        ContentValues values = new ContentValues();
        values.put("num", Integer.valueOf(id));
        values.put("concentcount", Integer.valueOf(0));
        values.put("value", "0;0;0;0;0;0;0");
        return values;
    }

    public int UnRegister(byte id) {
        int ret;
        if (id <= 0 || id > 15) {
            Log.w((String)TAG, (String)("[Update] Param - id  Out Of Range !!! (id:" + id + ")"));
            return -1;
        }
        ContentValues values = this.GetInitValues(id);
        String whereClause = "num = " + id;
        if (this.wdb != null && (ret = this.wdb.update("SmartConcentAccSaveTBL", values, whereClause, null)) < 0) {
            return -10;
        }
        return 0;
    }

    public int UnRegisterAll() {
        int ret = -1;
        for (int i = 0; i < 15; i = (int)((byte)(i + 1))) {
            ret = this.UnRegister((byte)(i + 1));
            if (ret >= 0) continue;
            return -100 + -i;
        }
        return 0;
    }

    @SuppressLint(value={"LongLogTag"})
    public List<ConcentAccDataClass> Get_ConAccDataList() {
        try {
            String query = "select num, concentcount, value from SmartConcentAccSaveTBL order by num asc;";
            if (this.wdb != null) {
                Cursor cursor = this.wdb.rawQuery(query, null);
                this.SyncData.clear();
                while (cursor.moveToNext()) {
                    ConcentAccDataClass getdata = new ConcentAccDataClass();
                    getdata.Num = cursor.getInt(0);
                    getdata.ConcentCount = cursor.getInt(1);
                    getdata.Value = cursor.getString(2);
                    String[] AccData = getdata.Value.split(";");
                    if (Integer.parseInt(AccData[0]) != getdata.ConcentCount) {
                        Log.w((String)TAG, (String)("[Get_ConAccDbData] Concent Count MisMatch !!! --> Init [" + getdata.Num + "]"));
                        getdata = new ConcentAccDataClass(cursor.getInt(0), 0, "0");
                        this.SyncData.add(getdata);
                        continue;
                    }
                    getdata.CutoffAcc = new int[getdata.ConcentCount];
                    getdata.AlwaysAcc = new int[getdata.ConcentCount];
                    for (int i = 0; i < getdata.ConcentCount; ++i) {
                        getdata.CutoffAcc[i] = Integer.parseInt(AccData[1 + i * 2]);
                        getdata.AlwaysAcc[i] = Integer.parseInt(AccData[2 + i * 2]);
                    }
                    this.SyncData.add(getdata);
                }
                cursor.close();
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Get_ConAccDbData] Exception !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
        return this.SyncData;
    }

    public int Set_ConAccDbData(byte Emindex, Sdb_DataClasses.EnergyMeterClass.DataClass Data2) {
        int ret = -1;
        try {
            if (Data2 == null) {
                Log.w((String)TAG, (String)"[Set_ConAccDbData] Concent.Data NULL !!!");
                return -300;
            }
            int seqnum = 0;
            seqnum = Emindex == EM_INDEX_LIVING ? 1 : Emindex + 2;
            int ConcentCount = Data2.Concent.length;
            String AccStr = ConcentCount + ";";
            for (int i = 0; i < Data2.Concent.length; ++i) {
                AccStr = AccStr + Data2.Concent[i].Data.CutOffConcent.AccPw + ";";
                AccStr = AccStr + Data2.Concent[i].Data.AlwaysConcent.AccPw + ";";
            }
            String whereClause = "num = " + seqnum;
            ContentValues values = new ContentValues();
            values.put("concentcount", Integer.valueOf(ConcentCount));
            values.put("value", AccStr);
            Log.w((String)TAG, (String)("[Set_ConAccDbData] Update - num : " + seqnum));
            Log.w((String)TAG, (String)("[Set_ConAccDbData] Update - ConcentCount : " + ConcentCount));
            Log.w((String)TAG, (String)("[Set_ConAccDbData] Update - value : " + AccStr));
            if (this.wdb != null) {
                int updating = this.wdb.update("SmartConcentAccSaveTBL", values, whereClause, null);
                return updating;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"[Set_ConAccDbData] Exception !!!");
            LogUtil.errorLogInfo("", TAG, ex);
        }
        return ret;
    }

    public int isExistData(int RoomIdx) {
        int ret = -1;
        if (RoomIdx < 1 && RoomIdx > 15) {
            Log.w((String)TAG, (String)"[isExistData] RoomIdx Out of Range !!!");
            return -300;
        }
        if (this.SyncData == null) {
            Log.w((String)TAG, (String)"[isExistData] SyncData NULL !!!");
            return -2;
        }
        try {
            for (int i = 0; i < this.SyncData.size(); ++i) {
                if (this.SyncData.get((int)i).Num != RoomIdx) continue;
                ret = i;
                break;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100000;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"[isExistData] Exception !!!");
            LogUtil.errorLogInfo("", TAG, ex);
            return -100000;
        }
        return ret;
    }

    public void DeleteAllDB() {
        String sqlStr = "DELETE FROM SmartConcentAccSaveTBL;";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void DropTable() {
        String sqlst = "drop table SmartConcentAccSaveTBL;";
        try {
            if (this.wdb != null) {
                this.wdb.execSQL(sqlst);
            }
        }
        catch (SQLException e) {
            LogUtil.errorLogInfo("", TAG, e);
        }
    }

    public int getCount() {
        String query = "select count(*) from SmartConcentAccSaveTBL;";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                String getdata = cursor.getString(0).trim();
                try {
                    cursor.close();
                    return Integer.parseInt(getdata);
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    cursor.close();
                    return -999;
                }
                catch (Exception e) {
                    cursor.close();
                    return -999;
                }
            }
            cursor.close();
        }
        return -1000;
    }

    public static class ConcentAccDataClass {
        public int Num;
        public int ConcentCount;
        public String Value;
        public int[] CutoffAcc;
        public int[] AlwaysAcc;

        public ConcentAccDataClass() {
        }

        public ConcentAccDataClass(int num, int concount, String val) {
            this.Num = num;
            this.ConcentCount = concount;
            this.Value = val;
            this.CutoffAcc = new int[this.ConcentCount];
            this.AlwaysAcc = new int[this.ConcentCount];
            for (int i = 0; i < this.ConcentCount; ++i) {
                this.CutoffAcc[i] = 0;
                this.AlwaysAcc[i] = 0;
            }
            String[] AllData = val.split(";");
            int valConCount = Integer.parseInt(AllData[0]);
            if (valConCount != concount) {
                Log.w((String)WallpadConcentAccSaveData.TAG, (String)"[ConcentAccDataClass] Concent Count Not Match !!!");
                return;
            }
            if (AllData.length - 1 != valConCount * 2) {
                Log.w((String)WallpadConcentAccSaveData.TAG, (String)"[ConcentAccDataClass] Concent Data LEN Not Match !!!");
                return;
            }
            for (int i = 0; i < this.ConcentCount; ++i) {
                this.CutoffAcc[i] = Integer.parseInt(AllData[1 + i * 2]);
                this.AlwaysAcc[i] = Integer.parseInt(AllData[2 + i * 2]);
            }
        }

        public String ToDebugString() {
            String retStr = "==========================\r\nNum  -  " + this.Num + "\r\n==========================\r\nConcentCount \t: " + this.ConcentCount + "\r\nValue \t\t\t: " + this.Value + "\r\n";
            for (int i = 0; i < this.ConcentCount; ++i) {
                retStr = retStr + "CutoffAcc[" + i + "] \t:" + this.CutoffAcc[i] + "\r\nAlwaysAcc[" + i + "] \t:" + this.AlwaysAcc[i] + "\r\n==========================\r\n\r\n";
            }
            return retStr;
        }
    }
}

