/*
 * Decompiled with CFR 0.152.
 */
package ceres.service;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import ceres.cminterface.CMCallInfo;
import ceres.utils.printlog;

public class SipNotifications {
    private NotificationManager notificationManager;
    private Notification inCallNotification;
    private Context context;
    private Notification missedCallNotification;
    private Notification messageVoicemail;
    private static final String THIS_FILE = "SipNotifications";
    public static final int REGISTER_NOTIF_ID = 1;
    public static final int CALL_NOTIF_ID = 2;
    public static final int CALLLOG_NOTIF_ID = 3;
    public static final int MESSAGE_NOTIF_ID = 4;
    public static final int VOICEMAIL_NOTIF_ID = 5;

    public SipNotifications(Context aContext) {
        this.context = aContext;
        this.notificationManager = (NotificationManager)this.context.getSystemService("notification");
    }

    public void notifyRegisteredAccounts(int registered, String phonenum) {
        String tickerText = "C&S: Registration";
        String test = "C&S: Registration";
        printlog.d(THIS_FILE, " notifyRegisteredAccounts....");
        Intent notificationIntent = new Intent("com.cnstec.phone.action.DIALER");
        notificationIntent.setFlags(0x4000000);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)notificationIntent, (int)0x8000000);
        Notification.Builder mBuilder = new Notification.Builder(this.context).setContentTitle((CharSequence)test).setContentText((CharSequence)phonenum).setTicker((CharSequence)tickerText).setContentIntent(contentIntent);
        this.notificationManager.notify(1, mBuilder.build());
    }

    public void showNotificationForCall(CMCallInfo currentCallInfo) {
        int icon = 17301636;
        String remoteUri = currentCallInfo.remoteNumber;
        if (this.inCallNotification == null) {
            Intent notificationIntent = new Intent("com.cnstec.phone.action.ONCALL");
            notificationIntent.setFlags(0x30000000);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)notificationIntent, (int)0x10000000);
            this.inCallNotification = new Notification.Builder(this.context).setSmallIcon(icon).setContentText((CharSequence)remoteUri).setContentIntent(contentIntent).setOngoing(true).setDefaults(32).build();
        }
        this.notificationManager.notify(2, this.inCallNotification);
    }

    public void showNotificationForMissedCall(ContentValues callLog) {
        int icon = 17301631;
        if (this.missedCallNotification == null) {
            this.missedCallNotification = new Notification.Builder(this.context).setSmallIcon(icon).setDefaults(5).setOnlyAlertOnce(true).setAutoCancel(true).build();
        }
    }

    public void showNotificationForVoiceMail(CMCallInfo acc, int numberOfMessages, String voiceMailNumber) {
        if (this.messageVoicemail == null) {
            Intent notificationIntent = new Intent("android.intent.action.CALL");
            notificationIntent.setData(Uri.parse((String)voiceMailNumber));
            notificationIntent.putExtra("acc_id", acc.remoteNumber);
            notificationIntent.setFlags(0x10000000);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)notificationIntent, (int)0x10000000);
            this.messageVoicemail = new Notification.Builder(this.context).setSmallIcon(17301630).setContentText((CharSequence)(acc.remoteNumber + " : " + Integer.toString(numberOfMessages))).setContentIntent(contentIntent).setDefaults(5).setOnlyAlertOnce(true).setAutoCancel(true).build();
        }
        this.notificationManager.notify(5, this.messageVoicemail);
    }

    public void setViewingMessageFrom(String remoteFrom) {
    }

    protected static CharSequence buildTickerMessage(Context context, String address, String body) {
        String displayAddress = address;
        StringBuilder buf = new StringBuilder(displayAddress == null ? "" : displayAddress.replace('\n', ' ').replace('\r', ' '));
        buf.append(':').append(' ');
        int offset = buf.length();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            body = body.replace('\n', ' ').replace('\r', ' ');
            buf.append(body);
        }
        SpannableString spanText = new SpannableString((CharSequence)buf.toString());
        spanText.setSpan((Object)new StyleSpan(1), 0, offset, 33);
        return spanText;
    }

    public void cancelRegisters() {
        this.notificationManager.cancel(1);
    }

    public void cancelCalls() {
        this.notificationManager.cancel(2);
    }

    public void cancelMissedCalls() {
        this.notificationManager.cancel(3);
    }

    public void cancelMessages() {
        this.notificationManager.cancel(4);
    }

    public void cancelVoicemails() {
        this.notificationManager.cancel(5);
    }

    public void cancelAll() {
        this.cancelMessages();
        this.cancelMissedCalls();
        this.cancelRegisters();
        this.cancelVoicemails();
    }
}

