/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.media.ToneGenerator;
import android.os.Vibrator;
import ceres.utils.PreferencesWrapper;
import ceres.utils.printlog;
import java.util.Timer;
import java.util.TimerTask;

public class DialingFeedback {
    private static final String THIS_FILE = "DialingFeedback";
    private static final int HAPTIC_LENGTH_MS = 50;
    private static final int TONE_LENGTH_MS = 150;
    private static final int TONE_RELATIVE_VOLUME = 80;
    private boolean inCall;
    private int toneStream;
    private Activity context;
    private ToneGenerator toneGenerator = null;
    private Object toneGeneratorLock = new Object();
    private Vibrator vibrator = null;
    private Timer toneTimer = null;
    private PreferencesWrapper prefsWrapper;
    private boolean dialPressTone = false;
    private boolean dialPressVibrate = false;
    private int ringerMode;

    public DialingFeedback(Activity context, boolean inCall) {
        this.context = context;
        this.inCall = inCall;
        this.toneStream = inCall ? 0 : 0;
        printlog.d(THIS_FILE, "toneStream : " + this.toneStream);
        this.prefsWrapper = new PreferencesWrapper((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.dialPressTone = this.prefsWrapper.getDialPressTone();
        this.dialPressVibrate = this.prefsWrapper.getDialPressVibrate();
        printlog.d(THIS_FILE, "toneStream : dialPressTone : " + this.dialPressTone);
        this.dialPressTone = true;
        if (this.dialPressTone) {
            printlog.d(THIS_FILE, "toneStream : dialPressTone : 2222" + this.dialPressTone);
            Object object = this.toneGeneratorLock;
            synchronized (object) {
                printlog.d(THIS_FILE, "toneStream : dialPressTone 3333: " + this.dialPressTone);
                if (this.toneTimer == null) {
                    printlog.d(THIS_FILE, "toneStream : dialPressTone 4444: " + this.dialPressTone);
                    this.toneTimer = new Timer();
                }
                if (this.toneGenerator == null) {
                    printlog.d(THIS_FILE, "toneStream : dialPressTone 5555: " + this.dialPressTone);
                    try {
                        this.toneGenerator = new ToneGenerator(this.toneStream, 80);
                        if (!this.inCall) {
                            printlog.d(THIS_FILE, "toneStream : 6666" + this.toneStream);
                            this.context.setVolumeControlStream(0);
                        }
                    }
                    catch (RuntimeException e) {
                        this.toneGenerator = null;
                    }
                }
            }
        }
        this.toneTimer = null;
        this.toneGenerator = null;
        if (this.dialPressVibrate) {
            if (this.vibrator == null) {
                this.vibrator = (Vibrator)this.context.getSystemService("vibrator");
            }
        } else {
            this.vibrator = null;
        }
        AudioManager am = (AudioManager)this.context.getSystemService("audio");
        this.ringerMode = am.getRingerMode();
        printlog.d(THIS_FILE, "toneStream : end : " + this.dialPressTone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.toneGeneratorLock;
        synchronized (object) {
            if (this.toneGenerator != null) {
                this.toneGenerator.release();
                this.toneGenerator = null;
            }
            if (this.toneTimer != null) {
                this.toneTimer.cancel();
                this.toneTimer.purge();
                this.toneTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveFeedback(int tone) {
        switch (this.ringerMode) {
            case 2: {
                if (this.dialPressVibrate) {
                    this.vibrator.vibrate(50L);
                }
                if (!this.dialPressTone) break;
                Object object = this.toneGeneratorLock;
                synchronized (object) {
                    if (this.toneGenerator == null) {
                        return;
                    }
                    this.toneGenerator.startTone(tone);
                    this.toneTimer.schedule((TimerTask)new StopTimerTask(), 150L);
                    break;
                }
            }
            case 1: {
                if (!this.dialPressVibrate) break;
                this.vibrator.vibrate(50L);
                break;
            }
        }
    }

    public void hapticFeedback() {
        if (this.dialPressVibrate && this.ringerMode != 0) {
            this.vibrator.vibrate(50L);
        }
    }

    class StopTimerTask
    extends TimerTask {
        StopTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DialingFeedback.this.toneGeneratorLock;
            synchronized (object) {
                if (DialingFeedback.this.toneGenerator == null) {
                    return;
                }
                DialingFeedback.this.toneGenerator.stopTone();
            }
        }
    }
}

