/*
 * Decompiled with CFR 0.152.
 */
package ceres.srinterface;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowManager;
import ceres.api.SipManager;
import ceres.cminterface.CMInterface;
import ceres.srinterface.MediaDecoder;
import ceres.utils.printlog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class SRInterface {
    private static final String THIS_FILE = "SRInterface";
    private Camera m_Camera;
    private static Bitmap m_Bitmap = null;
    private static int[] m_BMPBUF = null;
    private static int CameraID = 1;
    private CMInterface mCMIF = null;
    private static VideoSize DefaultDisplay = new VideoSize(0, 0);
    private static VideoSize scaleSize = new VideoSize(0, 0);
    private static float scale;
    private static int scaleDpi;
    private static String m_strFilePath;
    private static boolean m_bCameraPic;
    private static boolean m_bCameraEnc;
    private static int m_iCameraEnc;
    static MediaDecoder m_MediaDecoder;
    public static SurfaceView m_DecodingView;
    public static VideoSize vsize;
    private static long st2;
    private static long et2;
    private static long fc;
    public static Handler handler;
    private Handler mHandler = new Handler();
    private myThread mThread;
    private static boolean fps_fg;
    public static OnCallbackListener onVideoStatsCBListener;
    private static byte[][] m_RecordBUF;
    private static int m_cRecordBUF;
    private static int m_irRecordBUF;
    private static int m_iwRecordBUF;
    byte[] wBUF = null;
    byte[] m_Queue = null;

    native void SRIF_Initialize();

    public SRInterface() {
        printlog.d(THIS_FILE, "SRInterface Constructor is called... ");
    }

    public SRInterface(Context context) {
        printlog.d(THIS_FILE, "SRInterface Constructor is called... ");
        this.SRIF_Initialize();
        if (this.mCMIF == null) {
            this.mCMIF = new CMInterface();
        }
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        SRInterface.DefaultDisplay.width = size.x;
        SRInterface.DefaultDisplay.height = size.y;
        printlog.d(THIS_FILE, "displayInfo.displayWidth : " + SRInterface.DefaultDisplay.width);
        printlog.d(THIS_FILE, "displayInfo.displayHeight : " + SRInterface.DefaultDisplay.height);
        if (SRInterface.DefaultDisplay.width == 720) {
            SRInterface.scaleSize.width = SRInterface.DefaultDisplay.width;
            SRInterface.scaleSize.height = 960;
        } else if (SRInterface.DefaultDisplay.width == 480) {
            SRInterface.scaleSize.width = SRInterface.DefaultDisplay.width;
            SRInterface.scaleSize.height = 640;
        } else {
            SRInterface.scaleSize.width = SRInterface.DefaultDisplay.width;
            SRInterface.scaleSize.height = SRInterface.DefaultDisplay.height;
        }
        scale = context.getResources().getDisplayMetrics().density;
        scaleDpi = context.getResources().getDisplayMetrics().densityDpi;
        printlog.i(THIS_FILE, "displayInfo.scale : " + scale);
        printlog.i(THIS_FILE, "displayInfo.scaleDpi : " + scaleDpi);
        SRInterface.SRIF_VSIZE_set("1");
        m_MediaDecoder = new MediaDecoder();
    }

    public VideoSize SRIF_DefaultDisplay_get() {
        return DefaultDisplay;
    }

    public int SRIF_DensityDpi_get() {
        return scaleDpi;
    }

    public void SRIF_CameraID_set(int cameraId) {
        CameraID = cameraId;
        this.stopVideoRecording();
    }

    public int SRIF_CameraID_get() {
        return CameraID;
    }

    public final void setEncodingView(SurfaceView sv) {
        SRInterface.SRIF_VSIZE_set("1");
        SurfaceHolder holder = sv.getHolder();
        holder.setType(3);
        holder.setKeepScreenOn(true);
        holder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceDestroyed(SurfaceHolder holder) {
                printlog.i(SRInterface.THIS_FILE, "surfaceDestroyed...");
                SRInterface.this.stopVideoRecording();
            }

            public void surfaceCreated(SurfaceHolder holder) {
                printlog.i(SRInterface.THIS_FILE, "surfaceCreated changed... Encoding...");
                SRInterface.this.tryToStartVideoRecording(holder);
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                printlog.i(SRInterface.THIS_FILE, "surfaceChanged changed... Encoding...");
            }
        });
    }

    public void SRIF_VideoSize_set(int width, int height) {
        SRInterface.vsize.width = width;
        SRInterface.vsize.height = height;
    }

    public VideoSize SRIF_VideoSize_get() {
        return vsize;
    }

    public static void SRIF_VSIZE_set(String videoSize) {
        printlog.d(THIS_FILE, "videoSize : " + videoSize);
        if (SRInterface.vsize.width == 0) {
            if (videoSize.equals("0")) {
                SRInterface.vsize.width = 176;
                SRInterface.vsize.height = 144;
            } else if (videoSize.equals("1")) {
                SRInterface.vsize.width = 352;
                SRInterface.vsize.height = 288;
            } else if (videoSize.equals("4")) {
                SRInterface.vsize.width = 176;
                SRInterface.vsize.height = 144;
            } else if (videoSize.equals("2")) {
                SRInterface.vsize.width = 640;
                SRInterface.vsize.height = 480;
            } else {
                printlog.e(THIS_FILE, " Not supported vsize...");
            }
        } else {
            printlog.e(THIS_FILE, " Already set vsize...");
        }
    }

    public final void setDecodingView(SurfaceView sv) {
        printlog.e(THIS_FILE, "setRenderSurfaceView is called... : ");
        SRInterface.SRIF_VSIZE_set("1");
        if (m_Bitmap == null) {
            printlog.e(THIS_FILE, "dddd m_Bitmap is null setDecodingView width " + SRInterface.vsize.width + " height " + SRInterface.vsize.height);
            m_Bitmap = Bitmap.createBitmap((int)SRInterface.vsize.height, (int)SRInterface.vsize.width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            m_BMPBUF = new int[SipManager.VIDEO_MAX_SIZE.width * SipManager.VIDEO_MAX_SIZE.width];
        }
        if (m_DecodingView == null) {
            m_DecodingView = sv;
            m_MediaDecoder.start();
            m_MediaDecoder.configure(m_DecodingView.getHolder().getSurface(), 352, 288);
        }
    }

    public static void jOpenCapture(int videoSize) {
        printlog.d(THIS_FILE, "bbbb jOpenCapture is called... : " + videoSize);
        SRInterface.SRIF_VSIZE_set(Integer.toString(videoSize));
        if (m_Bitmap == null) {
            printlog.e(THIS_FILE, "dddd m_Bitmap is null jOpenCapture");
            m_Bitmap = Bitmap.createBitmap((int)SRInterface.vsize.height, (int)SRInterface.vsize.width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            m_BMPBUF = new int[SipManager.VIDEO_MAX_SIZE.width * SipManager.VIDEO_MAX_SIZE.width];
        }
        m_cRecordBUF = 4;
        m_RecordBUF = new byte[m_cRecordBUF][SRInterface.vsize.width * SRInterface.vsize.height * 3 / 2];
    }

    public static void jCloseCapture(int i) {
        SRInterface.vsize.width = 0;
        m_DecodingView = null;
        m_Bitmap = null;
    }

    public static int jCaptureVideoData(byte[] buf, int size) {
        int sizeRead = -1;
        if (0 < (m_iwRecordBUF + m_cRecordBUF - m_irRecordBUF) % m_cRecordBUF) {
            sizeRead = SRInterface.vsize.width * SRInterface.vsize.height * 3 / 2;
            SRInterface.decodeYUV420P2(buf, m_RecordBUF[m_irRecordBUF], SRInterface.vsize.width, SRInterface.vsize.height);
            m_irRecordBUF = (m_irRecordBUF + 1) % m_cRecordBUF;
        }
        return sizeRead;
    }

    public static void jOpenDisplay(int videoSize) {
        SRInterface.SRIF_VSIZE_set(Integer.toString(videoSize));
        Process.setThreadPriority((int)-4);
        if (m_Bitmap == null) {
            try {
                printlog.e(THIS_FILE, String.format("dddd m_Bitmap is null jOpenDisplay vsize.height=%d, vsize.width=%d", SRInterface.vsize.height, SRInterface.vsize.width));
                m_Bitmap = Bitmap.createBitmap((int)SRInterface.vsize.height, (int)SRInterface.vsize.width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                m_BMPBUF = new int[SipManager.VIDEO_MAX_SIZE.width * SipManager.VIDEO_MAX_SIZE.width];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void jCloseDisplay(int i) {
        SRInterface.vsize.width = 0;
        m_DecodingView = null;
        m_Bitmap = null;
        m_MediaDecoder.stop();
    }

    public void SRIF_FPS_Check(int start) {
        if (start == 1) {
            this.ThreadStart();
            fps_fg = true;
        } else {
            this.ThreadStop();
            fps_fg = false;
        }
        fc = 0L;
    }

    public boolean SRIF_FPS_Stats_get() {
        return fps_fg;
    }

    private void ThreadStart() {
        if (this.mThread == null) {
            this.mThread = new myThread(true);
            this.mThread.start();
        }
    }

    private void ThreadStop() {
        if (this.mThread != null) {
            this.mThread.stopThread();
            this.mThread = null;
        }
    }

    public void setOnVideoStatsCBListener(OnCallbackListener listener) {
        onVideoStatsCBListener = listener;
    }

    private void dispatchVideoStatsCBEvent(long fps) {
        if (onVideoStatsCBListener != null) {
            onVideoStatsCBListener.OnFPSChanged(fps);
        }
    }

    public static void MediaCodec_buf(byte[] buf, int len) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SRInterface.decodeYUV420P(m_BMPBUF, buf, SRInterface.vsize.width, SRInterface.vsize.height);
            Bitmap image = Bitmap.createBitmap((int)SRInterface.vsize.width, (int)SRInterface.vsize.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            image.setPixels(m_BMPBUF, 0, SRInterface.vsize.width, 0, 0, SRInterface.vsize.width, SRInterface.vsize.height);
            if (m_bCameraPic) {
                File fileCacheItem = new File(m_strFilePath);
                FileOutputStream out1 = null;
                out1 = new FileOutputStream(fileCacheItem);
                image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out1);
                ((OutputStream)out1).close();
                m_bCameraPic = false;
            }
            SurfaceHolder holder = m_DecodingView.getHolder();
            Surface sf = holder.getSurface();
            Rect rcBMP = new Rect(0, 0, SRInterface.vsize.width, SRInterface.vsize.height);
            Rect rcWND = new Rect(0, 0, m_DecodingView.getWidth(), m_DecodingView.getHeight());
            Paint testPaint = new Paint(1);
            Canvas canvas = sf.lockCanvas(null);
            canvas.drawBitmap(image, rcBMP, rcWND, testPaint);
            sf.unlockCanvasAndPost(canvas);
        }
        catch (IllegalArgumentException e) {
            printlog.e(THIS_FILE, "jDisplayVideoData Error1");
            e.printStackTrace();
        }
        catch (Surface.OutOfResourcesException e) {
            printlog.e(THIS_FILE, "jDisplayVideoData Error2");
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            printlog.e(THIS_FILE, "jDisplayVideoData Error3");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int jDisplayVideoData(byte[] buf, int size) {
        m_MediaDecoder.decodeSample(buf, 0, size, 0L, 0);
        return 0;
    }

    public void setPicture(String strPATH) {
        m_strFilePath = strPATH;
        m_bCameraPic = true;
    }

    public void setEncoding(boolean bSet) {
        m_bCameraEnc = bSet;
    }

    private void saveView(View view) {
        Bitmap b = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        if (b != null) {
            try {
                File fileCacheItem = new File(m_strFilePath);
                Canvas c = new Canvas(b);
                view.draw(c);
                FileOutputStream fos = new FileOutputStream(fileCacheItem);
                if (fos != null) {
                    b.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                    fos.close();
                }
            }
            catch (Exception e) {
                Log.e((String)"testSaveView", (String)("Exception: " + e.toString()));
            }
        }
    }

    public static Bitmap viewToBitmap(View view) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        if (view instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)view;
            surfaceView.setZOrderOnTop(true);
            surfaceView.draw(canvas);
            surfaceView.setZOrderOnTop(false);
            return bitmap;
        }
        view.draw(canvas);
        return bitmap;
    }

    public void tryToStartVideoRecording(SurfaceHolder holder) {
        Log.v((String)"yjyoon", (String)("CameraID=" + CameraID));
        this.m_Camera = Camera.open((int)CameraID);
        this.m_Camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int error, Camera camera) {
                printlog.e(SRInterface.THIS_FILE, "Camera error : " + error);
            }
        });
        Camera.Parameters m_CameraParams = this.m_Camera.getParameters();
        printlog.i(THIS_FILE, "m_CameraParams.flatten() : " + m_CameraParams.flatten());
        List arSize = m_CameraParams.getSupportedPreviewSizes();
        List arfps = m_CameraParams.getSupportedPreviewFrameRates();
        List arPF = m_CameraParams.getSupportedPreviewFormats();
        for (Camera.Size size : arSize) {
            printlog.d(THIS_FILE, "cccc size.width : " + size.width);
            printlog.d(THIS_FILE, "cccc size.height : " + size.height);
        }
        for (Integer fps : arfps) {
            printlog.d(THIS_FILE, "cccc fps : " + fps);
        }
        for (Integer PF : arPF) {
            printlog.d(THIS_FILE, "cccc PF : " + PF);
        }
        Log.d((String)THIS_FILE, (String)("vsize.width : " + SRInterface.vsize.width + " vsize.height : " + SRInterface.vsize.height));
        m_CameraParams.setPreviewSize(SRInterface.vsize.width, SRInterface.vsize.height);
        int fps = Integer.parseInt(this.mCMIF.CERES_VCodec_FrameRate_get());
        m_CameraParams.setPreviewFrameRate(fps);
        Log.d((String)THIS_FILE, (String)("mCMIF.CERES_VCodec_FrameRate_get()) : " + fps));
        if (fps <= 15) {
            m_CameraParams.set("cam_mode", 0);
        } else {
            m_CameraParams.set("cam_mode", 1);
        }
        this.m_Camera.setDisplayOrientation(0);
        this.m_Camera.setParameters(m_CameraParams);
        printlog.i(THIS_FILE, "cccc m_CameraParams.getPreviewFormat() : " + m_CameraParams.getPreviewFormat());
        printlog.i(THIS_FILE, "cccc m_CameraParams.get(redeye-reduction-values) : " + m_CameraParams.get("redeye-reduction-values"));
        printlog.i(THIS_FILE, "cccc m_CameraParams.get(iso-values) : " + m_CameraParams.get("iso-values"));
        printlog.i(THIS_FILE, "cccc m_CameraParams.get(preview-frame-rate) : " + m_CameraParams.get("preview-frame-rate"));
        printlog.i(THIS_FILE, "cccc m_CameraParams.get(preview-fps-range-values) : " + m_CameraParams.get("preview-fps-range-values"));
        printlog.i(THIS_FILE, "cccc m_CameraParams.get(cam_mode) : " + m_CameraParams.get("cam_mode"));
        try {
            this.m_Camera.setPreviewDisplay(holder);
        }
        catch (Throwable t) {
            printlog.e(THIS_FILE, "Exception in Video capture setPreviewDisplay()", t);
        }
        try {
            this.m_Camera.startPreview();
        }
        catch (Throwable e) {
            printlog.e(THIS_FILE, "Can't start camera preview");
        }
        m_irRecordBUF = 0;
        m_iwRecordBUF = 0;
        this.m_Camera.addCallbackBuffer(m_RecordBUF[m_iwRecordBUF]);
        this.m_Camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data, Camera camera) {
                if (m_bCameraEnc) {
                    m_iwRecordBUF = (m_iwRecordBUF + 1) % m_cRecordBUF;
                    if (m_irRecordBUF == m_iwRecordBUF) {
                        m_irRecordBUF = (m_irRecordBUF + 1) % m_cRecordBUF;
                    }
                }
                SRInterface.this.m_Camera.addCallbackBuffer(m_RecordBUF[m_iwRecordBUF]);
            }
        });
    }

    static byte[] YV12toNV21(byte[] input, int width, int height) {
        int size = width * height;
        int quarter = size / 4;
        int vPosition = size;
        int uPosition = size + quarter;
        byte[] yuv = new byte[width * height * 3 / 2];
        System.arraycopy(input, 0, yuv, 0, size);
        for (int i = 0; i < quarter; ++i) {
            yuv[size + i * 2] = input[vPosition + i];
            yuv[size + i * 2 + 1] = input[uPosition + i];
        }
        return yuv;
    }

    byte[] getNV21(int inputWidth, int inputHeight, Bitmap scaled) {
        try {
            int[] argb = new int[inputWidth * inputHeight];
            scaled.getPixels(argb, 0, inputWidth, 0, 0, inputWidth, inputHeight);
            byte[] yuv = new byte[inputWidth * inputHeight * 3 / 2];
            yuv = this.encodeYUV420SP(argb, inputWidth, inputHeight);
            scaled.recycle();
            return yuv;
        }
        catch (Exception e) {
            Log.e((String)"KSJ", (String)"[Exception] getNV21(int inputWidth, int inputHeight, Bitmap scaled)");
            e.printStackTrace();
            return null;
        }
    }

    byte[] encodeYUV420SP(int[] argb, int width, int height) {
        try {
            int frameSize = width * height;
            byte[] yuv = new byte[width * height * 3 / 2];
            int yIndex = 0;
            int uvIndex = frameSize;
            int index = 0;
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int a = (argb[index] & 0xFF000000) >> 24;
                    int R2 = (argb[index] & 0xFF0000) >> 16;
                    int G = (argb[index] & 0xFF00) >> 8;
                    int B = (argb[index] & 0xFF) >> 0;
                    int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                    int V = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                    int U = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                    yuv[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                    if (j % 2 == 0 && index % 2 == 0) {
                        yuv[uvIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
                        yuv[uvIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                    }
                    ++index;
                }
            }
            return yuv;
        }
        catch (Exception e) {
            Log.e((String)"KSJ", (String)"[Exception] encodeYUV420SP(int[] argb, int width, int height)");
            e.printStackTrace();
            return null;
        }
    }

    public static void decodeYUV420SP(int[] rgb, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        int rotateYp = 0;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = (0xFF & yuv420sp[yp]) - 16;
                if (y < 0) {
                    y = 0;
                }
                if ((i & 1) == 0) {
                    v = (0xFF & yuv420sp[uvp++]) - 128;
                    u = (0xFF & yuv420sp[uvp++]) - 128;
                }
                int y1192 = 1192 * y;
                int r = y1192 + 1634 * v;
                int g = y1192 - 833 * v - 400 * u;
                int b = y1192 + 2066 * u;
                if (r < 0) {
                    r = 0;
                } else if (r > 262143) {
                    r = 262143;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 262143) {
                    g = 262143;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 262143) {
                    b = 262143;
                }
                rotateYp = (width - i - 1) * height + j;
                rgb[rotateYp] = 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
                ++i;
                ++yp;
            }
        }
    }

    public static void decodeYUV420SP1(int[] rgba, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = yuv420sp[yp] + 127;
                if ((i & 1) == 0) {
                    v = yuv420sp[uvp++] + 127;
                    u = yuv420sp[uvp++] + 127;
                }
                rgba[yp] = -16777216 + (y << 16) | u << 8 | v;
                ++i;
                ++yp;
            }
        }
    }

    public static void decodeYUV420P(int[] rgb, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        boolean rotateYp = false;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int u = 0;
            int v = 0;
            int up = frameSize + (j >> 2) * width;
            int vp = frameSize / 4 * 5 + (j >> 2) * width;
            int i = 0;
            while (i < width) {
                int y = (0xFF & yuv420sp[yp]) - 16;
                if (y < 0) {
                    y = 0;
                }
                if ((i & 1) == 0) {
                    v = (0xFF & yuv420sp[vp++]) - 128;
                    u = (0xFF & yuv420sp[up++]) - 128;
                }
                int y1192 = 1192 * y;
                int r = y1192 + 1634 * v;
                int g = y1192 - 833 * v - 400 * u;
                int b = y1192 + 2066 * u;
                if (r < 0) {
                    r = 0;
                } else if (r > 262143) {
                    r = 262143;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 262143) {
                    g = 262143;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 262143) {
                    b = 262143;
                }
                rgb[yp] = 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
                ++i;
                ++yp;
            }
        }
    }

    public static void decodeYUV420SP3(int[] rgba, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = (0xFF & yuv420sp[yp]) - 16;
                if (y < 0) {
                    y = 0;
                }
                if ((i & 1) == 0) {
                    v = (0xFF & yuv420sp[uvp++]) - 128;
                    u = (0xFF & yuv420sp[uvp++]) - 128;
                }
                int y1192 = 1192 * y;
                int r = y1192 + 1634 * v;
                int g = y1192 - 833 * v - 400 * u;
                int b = y1192 + 2066 * u;
                if (r < 0) {
                    r = 0;
                } else if (r > 262143) {
                    r = 262143;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 262143) {
                    g = 262143;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 262143) {
                    b = 262143;
                }
                rgba[yp] = 0xFF000000 | r << 14 & 0xFF0000 | g >> 6 & 0xFF00 | b >> 10 & 0xFF;
                ++i;
                ++yp;
            }
        }
    }

    public static void decodeYUV420SP4(int[] rgba, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = (0xFF & yuv420sp[yp]) - 16;
                if (y < 0) {
                    y = 0;
                }
                if ((i & 1) == 0) {
                    u = (0xFF & yuv420sp[uvp++]) - 128;
                    v = (0xFF & yuv420sp[uvp++]) - 128;
                }
                int y1192 = 1192 * y;
                int r = y1192 + 1634 * v;
                int g = y1192 - 833 * v - 400 * u;
                int b = y1192 + 2066 * u;
                r = Math.max(0, Math.min(r, 262143));
                g = Math.max(0, Math.min(g, 262143));
                b = Math.max(0, Math.min(b, 262143));
                rgba[yp] = 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
                ++i;
                ++yp;
            }
        }
    }

    public static void decodeYUV420SP2(int[] out, byte[] fg, int width, int height) throws NullPointerException, IllegalArgumentException {
        int sz = width * height;
        if (out == null) {
            throw new NullPointerException("buffer out is null");
        }
        if (out.length < sz) {
            throw new IllegalArgumentException("buffer out size " + out.length + " < minimum " + sz);
        }
        if (fg == null) {
            throw new NullPointerException("buffer 'fg' is null");
        }
        if (fg.length < sz) {
            throw new IllegalArgumentException("buffer fg size " + fg.length + " < minimum " + sz * 3 / 2);
        }
        int frameSize = width * height;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int y = 0xFF & fg[i * width + j];
                int u = 0xFF & fg[frameSize + (i >> 1) * width + (j & 0xFFFFFFFE) + 0];
                int v = 0xFF & fg[frameSize + (i >> 1) * width + (j & 0xFFFFFFFE) + 1];
                y = y < 16 ? 16 : y;
                int r = Math.round(1.164f * (float)(y - 16) + 1.596f * (float)(v - 128));
                int g = Math.round(1.164f * (float)(y - 16) - 0.813f * (float)(v - 128) - 0.391f * (float)(u - 128));
                int b = Math.round(1.164f * (float)(y - 16) + 2.018f * (float)(u - 128));
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                out[i * width + j] = -16777216 + (b << 16) + (g << 8) + r;
            }
        }
    }

    public static void decodeYUV420P2(byte[] yuv420p, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        int uvSize = frameSize / 2;
        int vSize = uvSize / 2;
        int up = frameSize;
        int vp = frameSize / 4 * 5;
        if (CameraID == 1) {
            System.arraycopy(yuv420sp, 0, yuv420p, 0, frameSize);
            for (int i = 0; i < vSize; ++i) {
                yuv420p[up + i] = yuv420sp[up + i * 2 + 1];
                yuv420p[vp + i] = yuv420sp[up + i * 2];
            }
        } else {
            int i;
            for (i = 0; i < frameSize; ++i) {
                yuv420p[i] = yuv420sp[frameSize - i - 1];
            }
            for (i = 0; i < vSize; ++i) {
                yuv420p[up + (vSize - i - 1)] = yuv420sp[up + i * 2 + 1];
                yuv420p[vp + (vSize - i - 1)] = yuv420sp[up + i * 2];
            }
        }
    }

    public void stopVideoRecording() {
        if (this.m_Camera != null) {
            this.m_Camera.setPreviewCallbackWithBuffer(null);
            this.m_Camera.stopPreview();
            this.m_Camera.release();
            this.m_Camera = null;
        }
    }

    static {
        m_strFilePath = "";
        m_bCameraPic = false;
        m_bCameraEnc = false;
        m_iCameraEnc = 0;
        m_DecodingView = null;
        vsize = new VideoSize(0, 0);
        st2 = 0L;
        et2 = 0L;
        fc = 0L;
        handler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        printlog.i(SRInterface.THIS_FILE, "dt 1sec frame count : " + fc);
                        fc = 0L;
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
        fps_fg = false;
        m_RecordBUF = null;
        m_cRecordBUF = 0;
        m_irRecordBUF = 0;
        m_iwRecordBUF = 0;
    }

    public static class SRElementList {
    }

    public static class SRQueueInformation {
        public int m_sizeQMin;
        public int m_sizeQMax;
        public int m_sizeQPass;
        public int m_sizeQFill;
    }

    class myThread
    extends Thread {
        private boolean isPlay = false;

        public myThread(boolean isPlay) {
            this.isPlay = isPlay;
        }

        public void stopThread() {
            this.isPlay = !this.isPlay;
        }

        public boolean isPlayThread() {
            return this.isPlay;
        }

        @Override
        public void run() {
            super.run();
            while (this.isPlay) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    printlog.e(SRInterface.THIS_FILE, "myThread, Run, Thread.sleep : Error.");
                    e.printStackTrace();
                }
                SRInterface.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        SRInterface.this.dispatchVideoStatsCBEvent(fc);
                        printlog.i(SRInterface.THIS_FILE, "dt fc : " + fc);
                        fc = 0L;
                    }
                });
            }
        }
    }

    public static interface OnCallbackListener {
        public void OnFPSChanged(long var1);
    }

    public static final class VideoSize {
        public int width;
        public int height;

        public VideoSize() {
        }

        public VideoSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

