/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class WallpadRFCardData
extends wallpaddbmgr {
    private static final String TAG = "WallpadRFCardData";
    public static final int MAX_SAVE_COUNT = 20;
    public List<RfCardDataClass> SyncData = new ArrayList<RfCardDataClass>();

    public WallpadRFCardData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("RFCardDB")) {
            try {
                if (this.wdb != null) {
                    this.wdb.execSQL("create table RFCardDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT,  keyval  text unique, inYear  INTEGER, inMonth  INTEGER, inDay  INTEGER, inHour INTEGER, inMIN INTEGER, inSec INTEGER);");
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    public boolean isExist(byte[] inCardNum) {
        if (inCardNum == null) {
            Log.w((String)TAG, (String)"[isExist] Param : inCardNum is null !!!");
            return false;
        }
        if (inCardNum.length != 4) {
            Log.w((String)TAG, (String)("[isExist] Param : inCardNum Length Not Match !!! (Len:" + inCardNum.length + ")"));
            return false;
        }
        try {
            String Indata = String.format("%02x:%02x:%02x:%02x", inCardNum[0], inCardNum[1], inCardNum[2], inCardNum[3]);
            String query = "select count() from RFCardDB where keyval = \"" + Indata + "\";";
            if (this.wdb != null) {
                Cursor cursor = this.wdb.rawQuery(query, null);
                while (cursor.moveToNext()) {
                    if (cursor.getInt(0) <= 0) continue;
                    return true;
                }
                cursor.close();
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[isExist] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
        }
        return false;
    }

    public int SetSaveRfCardData(byte[] inCardNum) {
        if (inCardNum == null) {
            Log.w((String)TAG, (String)"[SetSaveRfCardData] Param : inCardNum is null !!!");
            return -300;
        }
        if (inCardNum.length != 4) {
            Log.w((String)TAG, (String)("[SetSaveRfCardData] Param : inCardNum Length Not Match !!! (Len:" + inCardNum.length + ")"));
            return -300;
        }
        int Count = this.getCount();
        if (Count >= 20 || Count < 0) {
            Log.w((String)TAG, (String)("[SetSaveRfCardData] getCount() Error !!! (Count:" + Count + ")"));
            return -300;
        }
        try {
            String Indata = String.format("%02x:%02x:%02x:%02x", inCardNum[0], inCardNum[1], inCardNum[2], inCardNum[3]);
            GregorianCalendar cal = new GregorianCalendar();
            ContentValues values = new ContentValues();
            values.put("keyval", Indata);
            values.put("inYear", Integer.valueOf(cal.get(1)));
            values.put("inMonth", Integer.valueOf(cal.get(2) + 1));
            values.put("inDay", Integer.valueOf(cal.get(5)));
            values.put("inHour", Integer.valueOf(cal.get(11)));
            values.put("inMIN", Integer.valueOf(cal.get(12)));
            values.put("inSec", Integer.valueOf(cal.get(13)));
            if (this.wdb != null) {
                long ret = this.wdb.insert("RFCardDB", null, values);
                return (int)ret;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[SetSaveRfCardData] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return -100000;
        }
        return -100000;
    }

    public int SetDelRfCardData(byte index) {
        if (index != -1) {
            int Count = this.getCount();
            if (index < 0 || index >= Count) {
                Log.w((String)TAG, (String)("[SetDelRfCardData] Param : index  Out Of Range !!! (index:" + index + ")"));
                return -300;
            }
        }
        if (this.SyncData == null) {
            Log.w((String)TAG, (String)"[SetDelRfCardData] SyncData is null ( GetRfCardData() Execution !!! )");
            return -300;
        }
        try {
            if (index == -1) {
                String sqldata = "delete from RFCardDB;";
                if (this.wdb != null) {
                    this.wdb.execSQL(sqldata);
                }
            } else if (this.wdb != null) {
                Cursor cursor = this.wdb.rawQuery("select seqnum from RFCardDB;", null);
                int seqnum = 0;
                try {
                    boolean bRet = cursor.moveToPosition((int)index);
                    if (!bRet) {
                        cursor.close();
                        Log.w((String)TAG, (String)"[SetDelRfCardData] moveToPosition return false !!!");
                        return -5;
                    }
                    seqnum = cursor.getInt(0);
                    cursor.close();
                    if (seqnum <= 0) {
                        Log.w((String)TAG, (String)("[SetDelRfCardData] seqnum Out Of Range !!! (seqnum:" + seqnum + ")"));
                        return -6;
                    }
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    cursor.close();
                    return -100;
                }
                catch (Exception e) {
                    cursor.close();
                    Log.e((String)TAG, (String)"[SetDelRfCardData] Exception Error #2 !!!");
                    LogUtil.errorLogInfo("", TAG, e);
                    return -100;
                }
                String whereClause = "seqnum = " + seqnum;
                int ret = this.wdb.delete("RFCardDB", whereClause, null);
                if (ret < 0) {
                    Log.w((String)TAG, (String)("[SetDelRfCardData] delete Error (ret:" + ret + ")"));
                    return -10;
                }
                return 0;
            }
            return 0;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[SetDelRfCardData] Exception Error");
            LogUtil.errorLogInfo("", TAG, e);
            return -100000;
        }
    }

    public List<RfCardDataClass> GetRfCardData() {
        try {
            String query = "select seqnum, keyval, inYear, inMonth, inDay, inHour, inMIN, inSec from RFCardDB order by seqnum asc;";
            if (this.wdb != null) {
                Cursor cursor = this.wdb.rawQuery(query, null);
                this.SyncData.clear();
                while (cursor.moveToNext()) {
                    RfCardDataClass getdata = new RfCardDataClass();
                    getdata.seqnum = cursor.getInt(0);
                    String[] KeyData = cursor.getString(1).split(":");
                    getdata.CardData = new byte[]{(byte)Integer.parseInt(KeyData[0], 16), (byte)Integer.parseInt(KeyData[1], 16), (byte)Integer.parseInt(KeyData[2], 16), (byte)Integer.parseInt(KeyData[3], 16)};
                    getdata.Cal = new GregorianCalendar();
                    getdata.Cal.set(1, cursor.getInt(2));
                    getdata.Cal.set(2, cursor.getInt(3) - 1);
                    getdata.Cal.set(5, cursor.getInt(4));
                    getdata.Cal.set(11, cursor.getInt(5));
                    getdata.Cal.set(12, cursor.getInt(6));
                    getdata.Cal.set(13, cursor.getInt(7));
                    this.SyncData.add(getdata);
                }
                cursor.close();
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return null;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
        return this.SyncData;
    }

    public int getCount() {
        String query = "select count(*) from RFCardDB;";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                String getdata = cursor.getString(0).trim();
                try {
                    return Integer.parseInt(getdata);
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    return -999;
                }
                catch (Exception e) {
                    return -999;
                }
            }
            cursor.close();
        }
        return -1000;
    }

    public static class RfCardDataClass {
        int seqnum;
        public byte[] CardData;
        public Calendar Cal;
    }
}

