/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.artncore.commons.DataClasses;
import java.util.ArrayList;
import java.util.List;

public class WallpadCarEventInfo
extends wallpaddbmgr {
    private static final String TAG = "WallpadCarEventInfo";

    public WallpadCarEventInfo(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("CarEventDB")) {
            try {
                this.wdb.execSQL("create table CarEventDB (regdate DATE DEFAULT (datetime('now','localtime')), move_info text, car_num text, loc_info text, message text);");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void DeleteAllCarEventInfo() {
        String query = "DELETE FROM CarEventDB;";
        this.wdb.execSQL(query);
    }

    public void DeleteCarEventInfo(String carNum) {
        String query = "DELETE FROM CarEventDB where car_num = " + carNum + ";";
        this.wdb.execSQL(query);
    }

    public void DeleteCarEventData(String Count) {
        String sqlStr = "DELETE FROM CarEventDB where regdate in (select regdate from CarEventDB limit " + Count + ");";
        this.wdb.execSQL(sqlStr);
    }

    public void UpdateParkInfo(String Movinfo, String CarNum, String LocInfo, String Msg) {
        ContentValues values = new ContentValues();
        values.put("move_info", Movinfo);
        values.put("car_num", CarNum);
        values.put("loc_info", LocInfo);
        values.put("message", Msg);
        this.wdb.insert("CarEventDB", null, values);
    }

    public int RowCountCarEventInfo() {
        String query = "select count(*) from CarEventDB;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        if (cursor.moveToNext()) {
            String getdata = cursor.getString(0).trim();
            try {
                return Integer.parseInt(getdata);
            }
            catch (Exception e) {
                return -999;
            }
        }
        cursor.close();
        return -999;
    }

    public List<String[]> GetCarEventInfo() {
        String query = "select * from CarEventDB order by regdate desc;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        ArrayList<String[]> RetList = new ArrayList<String[]>();
        while (cursor.moveToNext()) {
            String[] retval = new String[]{cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4)};
            RetList.add(retval);
        }
        cursor.close();
        return RetList;
    }

    public DataClasses.CarEventData[] getCarEventData() {
        List<String[]> RetList = this.GetCarEventInfo();
        if (RetList == null) {
            Log.d((String)TAG, (String)"if(RetList == null)");
            return null;
        }
        if (RetList.size() == 0) {
            Log.d((String)TAG, (String)"if(RetList.size() == 0)");
            return null;
        }
        DataClasses.CarEventData[] carEventData = new DataClasses.CarEventData[RetList.size()];
        try {
            for (int i = 0; i < RetList.size(); ++i) {
                carEventData[i] = new DataClasses.CarEventData();
                String Info2 = RetList.get(i)[0];
                Info2 = Info2.replace('-', '_');
                Info2 = Info2.replace(' ', '_');
                String[] SplitedInfo = (Info2 = Info2.replace(':', '_')).split("_");
                if (SplitedInfo.length != 6) {
                    Log.d((String)TAG, (String)"if(SplitedInfo.length != 6)");
                    return null;
                }
                carEventData[i].time.set(Integer.parseInt(SplitedInfo[0]), Integer.parseInt(SplitedInfo[1]) - 1, Integer.parseInt(SplitedInfo[2]), Integer.parseInt(SplitedInfo[3]), Integer.parseInt(SplitedInfo[4]), Integer.parseInt(SplitedInfo[5]));
                if (RetList.get(i)[1].equalsIgnoreCase("in")) {
                    carEventData[i].EventType = 1;
                } else if (RetList.get(i)[1].equalsIgnoreCase("out")) {
                    carEventData[i].EventType = 2;
                } else if (RetList.get(i)[1].equalsIgnoreCase("park")) {
                    carEventData[i].EventType = 3;
                }
                carEventData[i].CarNum = RetList.get(i)[2];
                carEventData[i].location = RetList.get(i)[3];
                carEventData[i].message = RetList.get(i)[4];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return carEventData;
    }
}

