/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class SmartKeyRfDoorAPI
extends WallPadDevAPI {
    private final String TAG = "SmartKeyRfDoorAPI";
    private final boolean DEBUG_LOG_ON = true;
    public static final byte STATUS_REGMODE_START = 0;
    public static final byte STATUS_REGMODE_KEY_COMPLETE = 16;
    public static final byte STATUS_REGMODE_KEY_ALREADY = 32;
    public static final byte STATUS_REGMODE_ER_WIRELESSCOMMFAIL = 48;
    public static final byte STATUS_REGMODE_ER_DBWRITE = 64;
    public static final byte STATUS_REGMODE_END = -96;
    public static final byte STATUS_REGMODE_FULL = -80;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"SmartKeyRfDoorAPI", (String)s);
    }

    public SmartKeyRfDoorAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("SmartKeyRfDoorAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "SMARTKEY_RFDOOR";
        this.data = new Data();
    }

    public int Refresh() {
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = "NOSINKCTRL";
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, 0, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            StatusList nStat = new StatusList();
            SensorValue nSensor = new SensorValue();
            int index = 1;
            nStat.bDoorBtnStatus = Boolean.parseBoolean(retData[index++]);
            nStat.bSensorDetect = Boolean.parseBoolean(retData[index++]);
            nStat.bLedStatus = Boolean.parseBoolean(retData[index++]);
            nStat.bCameraStatus = Boolean.parseBoolean(retData[index++]);
            nStat.bLedAuto = Boolean.parseBoolean(retData[index++]);
            nStat.bCameraAuto = Boolean.parseBoolean(retData[index++]);
            nStat.bError = Boolean.parseBoolean(retData[index++]);
            nStat.SmartKeyCount = Byte.parseByte(retData[index++]);
            this.data.status = nStat;
            nSensor.Sensor_Sensitivity = Byte.parseByte(retData[index++]);
            nSensor.Sensor_DetectTime = Byte.parseByte(retData[index++]);
            nSensor.Sensor_LedMode = Byte.parseByte(retData[index++]);
            nSensor.Sensor_RSSI_Read = Byte.parseByte(retData[index++]);
            nSensor.Sensor_RSSI_Write = Byte.parseByte(retData[index++]);
            nSensor.Sensor_DetectRatio = Byte.parseByte(retData[index++]);
            nSensor.Sensor_CameraMode = Byte.parseByte(retData[index++]);
            this.data.sensorValue = nSensor;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "SmartKeyRfDoorAPI", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"SmartKeyRfDoorAPI", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "SmartKeyRfDoorAPI", e);
            return -1;
        }
        return 0;
    }

    public int SetRegisterModeStart() {
        return this.SendNReadCMD_int("SINKCTRL", "SetRegisterModeStart", 0, 0, 0, 0, 0);
    }

    public int SetRegisterModeStart_TestInit() {
        return this.SendNReadCMD_int("SINKCTRL", "SetRegisterModeStart", 1, 0, 0, 0, 0);
    }

    public int SetRegisterModeNext() {
        return this.SendNReadCMD_int("SINKCTRL", "SetRegisterModeNext", 0, 0, 0, 0, 0);
    }

    public int SetRegisterModeEnd() {
        return this.SendNReadCMD_int("SINKCTRL", "SetRegisterModeEnd", 0, 0, 0, 0, 0);
    }

    public int SetDeleteKey(boolean AllKey, int keyRegNo) {
        int DeleteAll = 0;
        int KeyRegNo = keyRegNo;
        if (AllKey) {
            DeleteAll = 1;
            KeyRegNo = 0;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetDeleteKey", DeleteAll, KeyRegNo, 0, 0, 0);
    }

    public String SetSensorConfig(byte Sensing, byte Time) {
        boolean Act = true;
        Log.d((String)"SmartKeyRfDoorAPI", (String)("[SetSensorConfig] - start Sensing: " + Sensing + " / Time: " + this.getInt(Time)));
        if (Sensing < 1 || Sensing > 5) {
            if (Sensing == -1) {
                Act = true;
            } else {
                Log.e((String)"SmartKeyRfDoorAPI", (String)("[SetSensorConfig] - Sensing Range ERROR : " + Sensing));
                Act = false;
            }
        }
        if (this.getInt(Time) < 1 || this.getInt(Time) > 250) {
            if (Time == -1) {
                Act = true;
            } else {
                Log.e((String)"SmartKeyRfDoorAPI", (String)("[SetSensorConfig] - Time Range ERROR :" + Time));
                Act = false;
            }
        }
        if (Act) {
            return this.SendNReadCMD_str("SINKCTRL", "SetSensorConfig", Sensing, Time, 0, 0, 0);
        }
        return "ERROR";
    }

    public int SetLEDmode(byte mode) {
        if ((mode < 0 || mode > 6) && mode != -1) {
            Log.w((String)"SmartKeyRfDoorAPI", (String)"[SetLEDmode] - mode Range ERROR !!!");
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLEDmode", mode, 0, 0, 0, 0);
    }

    public int SetRSSImode(byte mode, byte level) {
        if (mode < 0 || mode > 2) {
            Log.w((String)"SmartKeyRfDoorAPI", (String)"[SetRSSImode] - mode Range ERROR !!!");
            return -1;
        }
        if ((level < -100 || level > 100) && level != -1) {
            Log.w((String)"SmartKeyRfDoorAPI", (String)"[SetRSSImode] - level Range ERROR !!!");
            return -2;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetRSSImode", mode, level, 0, 0, 0);
    }

    public int SetStrangerDetectRatio(byte level) {
        if ((level < 0 || level > 100) && level != -1) {
            Log.w((String)"SmartKeyRfDoorAPI", (String)"[SetStrangerDetectRatio] - level Range ERROR !!!");
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetStrangerDetectRatio", level, 0, 0, 0, 0);
    }

    public int SetCAMERAmode(byte mode) {
        if ((mode < 0 || mode > 3) && mode != -1) {
            Log.w((String)"SmartKeyRfDoorAPI", (String)"[SetCAMERAmode] - mode Range ERROR !!!");
            return -1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetCAMERAmode", mode, 0, 0, 0, 0);
    }

    public int getInt(byte in) {
        if (in < 0) {
            return in + 256;
        }
        return in;
    }

    public static class Data {
        public StatusList status = null;
        public SensorValue sensorValue = null;
    }

    private class SensorValue {
        private byte Sensor_Sensitivity = 0;
        private byte Sensor_DetectTime = 0;
        private byte Sensor_LedMode = (byte)-1;
        private byte Sensor_RSSI_Read;
        private byte Sensor_RSSI_Write;
        private byte Sensor_DetectRatio;
        private byte Sensor_CameraMode = (byte)-1;

        private SensorValue() {
            this.Sensor_DetectRatio = (byte)100;
            this.Sensor_RSSI_Read = (byte)-101;
            this.Sensor_RSSI_Write = (byte)-101;
        }

        public String ToDebugString() {
            String retStr = "==========================\r\nSensorValue\r\n==========================\r\nSensor_Sensitivity : " + this.Sensor_Sensitivity + "\r\nSensor_DetectTime  : " + this.Sensor_DetectTime + "\r\nSensor_DetectRatio : " + this.Sensor_DetectRatio + "\r\nSensor_RSSI_Read   : " + this.Sensor_RSSI_Read + "\r\nSensor_RSSI_Write  : " + this.Sensor_RSSI_Write + "\r\nSensor_LedMode     : " + this.Sensor_LedMode + "\r\nSensor_CameraMode  : " + this.Sensor_CameraMode + "\r\n==========================";
            return retStr;
        }
    }

    private class StatusList {
        private boolean bSensorDetect = false;
        private boolean bCameraStatus = false;
        private boolean bLedStatus = false;
        private boolean bCameraAuto = false;
        private boolean bLedAuto = false;
        private boolean bDoorBtnStatus = false;
        private boolean bError = false;
        private byte SmartKeyCount = 0;

        private StatusList() {
        }

        public String ToDebugString() {
            String retStr = "==========================\r\nStatusList\r\n==========================\r\nbSensorDetect  : " + this.bSensorDetect + "\r\nbLedStatus     : " + this.bLedStatus + "\r\nbCameraStatus  : " + this.bCameraStatus + "\r\nbLedAuto       : " + this.bLedAuto + "\r\nbCameraAuto    : " + this.bCameraAuto + "\r\nbDoorBtnStatus : " + this.bDoorBtnStatus + "\r\nbError         : " + this.bError + "\r\nSmartKeyCount  : " + this.SmartKeyCount + "\r\n==========================";
            return retStr;
        }
    }

    static class SmartRFcamLEDmode {
        public static final byte LED_OFF = 0;
        public static final byte LED_ON = 1;
        public static final byte LED_FLASH1 = 2;
        public static final byte LED_FLASH2 = 3;
        public static final byte LED_FLASH3 = 4;

        SmartRFcamLEDmode() {
        }
    }
}

