/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class ElectricRange_API
extends WallPadDevAPI {
    private final String TAG = "ElectricRange_API";
    private final boolean DEBUG_LOG_ON = true;
    public Data data;

    private void DebugLogOutput(String s) {
        Log.d((String)"ElectricRange_API", (String)s);
    }

    public ElectricRange_API(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("ElectricRange_API create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "ELECTRIC_RANGE";
        this.data = new Data();
        this.GetDeviceCount();
    }

    public ElectricRange_API() {
        this.DebugLogOutput("ElectricRange_API create public()");
        this.ErrorCode = new APIErrorCode();
        this.TitleStr = "ELECTRIC_RANGE";
        this.data = new Data();
        this.GetDeviceCount();
    }

    public int Refresh(byte Index, boolean real) {
        if (this.data.DeviceCnt <= 0 && this.GetDeviceCount() < 0) {
            Log.w((String)"ElectricRange_API", (String)"[Refresh] data.DeviceCnt is '0' - Not Yet !!!");
            return -110;
        }
        if (Index != -1 && (Index < 0 || Index >= this.data.DeviceCnt)) {
            Log.w((String)"ElectricRange_API", (String)("[Refresh] Param - Index  Out Of Range !!! (Index:" + String.format("0x%02X", Index) + ")"));
            return -300;
        }
        String MainCMD = null;
        String SubCMD = "Refresh";
        MainCMD = real ? "SINKCTRL" : "NOSINKCTRL";
        if (Index == -1) {
            String ret;
            int i;
            for (i = 0; i < this.data.DeviceCnt && this.ProcResult(ret = this.SendNReadCMD_str(MainCMD, SubCMD, i, 0, 0, 0, 0)) >= 0; ++i) {
            }
            if (i < this.data.DeviceCnt) {
                return -1;
            }
            return 0;
        }
        String ret = this.SendNReadCMD_str(MainCMD, SubCMD, Index, 0, 0, 0, 0);
        return this.ProcResult(ret);
    }

    private int ProcResult(String ret) {
        this.DebugLogOutput("ProcResult : " + ret);
        try {
            boolean Install;
            String[] retData = ret.split(";");
            if (retData == null) {
                return -101;
            }
            if (retData[0].equals("FAIL")) {
                return Integer.parseInt(retData[1]);
            }
            if (!retData[0].equals("SUCCESS")) {
                return -1;
            }
            DataClasses.ElectricRange Device2 = new DataClasses.ElectricRange();
            int index = 1;
            byte Current = Byte.parseByte(retData[index++]);
            if (Install = Boolean.parseBoolean(retData[index++])) {
                Device2.info.FireHoleCount = Byte.parseByte(retData[index++]);
                Device2.info.Vender = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Year = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Month = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Day = Byte.parseByte(retData[index++]);
                Device2.info.FwVer_Number = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Main = Byte.parseByte(retData[index++]);
                Device2.info.ProtocolVer_Sub = Byte.parseByte(retData[index++]);
                Device2.info.Model_Number = Byte.parseByte(retData[index++]);
                Device2.setCount(Device2.info.FireHoleCount);
                if (Device2.device.FireHoleCount > 0) {
                    byte Kind = 0;
                    byte Status2 = 0;
                    byte RemainHeat = 0;
                    byte Mode = 0;
                    byte Level2 = 0;
                    byte Timer_Upper = 0;
                    byte Timer_Lower = 0;
                    byte FaultByte = 0;
                    for (byte j = 0; j < Device2.device.FireHoleCount; j = (byte)(j + 1)) {
                        Kind = Byte.parseByte(retData[index++]);
                        Status2 = Byte.parseByte(retData[index++]);
                        RemainHeat = Byte.parseByte(retData[index++]);
                        Mode = Byte.parseByte(retData[index++]);
                        Level2 = Byte.parseByte(retData[index++]);
                        Timer_Upper = Byte.parseByte(retData[index++]);
                        Timer_Lower = Byte.parseByte(retData[index++]);
                        FaultByte = Byte.parseByte(retData[index++]);
                        Device2.device.FireHoles[j].Kind = Kind;
                        Device2.device.FireHoles[j].Status = Status2;
                        Device2.device.FireHoles[j].RemainHeat = RemainHeat;
                        Device2.device.FireHoles[j].Mode = Mode;
                        Device2.device.FireHoles[j].Level = Level2;
                        Device2.device.FireHoles[j].Timer_Upper = Timer_Upper;
                        Device2.device.FireHoles[j].Timer_Lower = Timer_Lower;
                        Device2.device.FireHoles[j].Fault = new DataClasses.ElectricRange.FAULT(FaultByte);
                    }
                }
            } else {
                Device2.info.Install = false;
            }
            this.data.Device[Current] = Device2;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "ElectricRange_API", re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"ElectricRange_API", (String)"[Exception Error] ProcResult");
            LogUtil.errorLogInfo("", "ElectricRange_API", e);
            return -1;
        }
        return 0;
    }

    private int GetDeviceCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetDeviceCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                byte DeviceCount = Byte.parseByte(retlist[index++]);
                if (DeviceCount > 0) {
                    this.data.DeviceCnt = DeviceCount;
                    this.data.Device = new DataClasses.ElectricRange[DeviceCount];
                    return 0;
                }
                return -1;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "ElectricRange_API", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"ElectricRange_API", (String)("[GetDeviceCount] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "ElectricRange_API", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    private boolean DeviceIndexRangeCheck(byte Index) {
        try {
            if (Index < 0 || Index >= this.data.DeviceCnt) {
                return Index == -1;
            }
            return true;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", "ElectricRange_API", re);
            return false;
        }
        catch (Exception e) {
            Log.e((String)"ElectricRange_API", (String)"[Exception Error] DeviceIndexRangeCheck");
            LogUtil.errorLogInfo("", "ElectricRange_API", e);
            return false;
        }
    }

    public int SetTurnOff(byte Index, byte fireHoleIdx, boolean OnOff) {
        if (this.data.DeviceCnt <= 0) {
            Log.w((String)"ElectricRange_API", (String)"[SetTurnOff] DeviceCnt is '0'  Not Yet !!!");
            return -1;
        }
        if (!this.DeviceIndexRangeCheck(Index)) {
            Log.w((String)"ElectricRange_API", (String)("[SetTurnOff] Param - Index  : Out Of Range (Index:" + Index + ")"));
            return -2;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetTurnOff", Index, fireHoleIdx, 0, 0, 0);
    }

    public static class Data {
        public byte DeviceCnt = 0;
        public DataClasses.ElectricRange[] Device = null;
    }
}

