/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class WallpadMobileDeviceData
extends wallpaddbmgr {
    private static final String TAG = "WallpadMobileDeviceData";
    public static final String MobileDeviceAdd_BR = "MOBILE_DEVICE_ADD_BR";
    public static final int AUTH_NUMBER = 2;
    public static final int ADD_FINISH = 3;
    public static final String MobileDeviceDel_BR = "MOBILE_DEVICE_DEL_BR";
    public static final int DEL_FINISH = 3;

    public WallpadMobileDeviceData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("MobileDeviceDB")) {
            try {
                Log.i((String)TAG, (String)"[Create] CreateMobileDeviceDB");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table MobileDeviceDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, uid text, name text, regdate DATE DEFAULT (datetime('now','localtime')));");
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Create] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    public int Register(String Uid, String Name) {
        if (Uid == null) {
            Log.w((String)TAG, (String)"[Update] Param - Uid  is null !!!");
            return -1;
        }
        if (Name == null) {
            Log.w((String)TAG, (String)"[Update] Param - Name  is null !!!");
            return -2;
        }
        int ret = 0;
        int ExistId = this.isExistMobileDevice(Uid);
        if (ExistId > 0) {
            Log.w((String)TAG, (String)"[Register] isExistMobileDevice - Find !!!");
            this.DeleteEachUid(Uid);
        }
        ContentValues values = new ContentValues();
        values.put("uid", Uid);
        values.put("name", Name);
        if (this.wdb != null) {
            ret = (int)this.wdb.insert("MobileDeviceDB", null, values);
        }
        if (ret < 0) {
            return -10;
        }
        return 0;
    }

    public void DeleteEachUid(String Uid) {
        if (Uid == null) {
            Log.w((String)TAG, (String)"[Update] Param - Uid  is null !!!");
            return;
        }
        String sqlStr = "DELETE FROM MobileDeviceDB where uid=\"" + Uid + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void DeleteEachName(String name) {
        if (name == null) {
            Log.w((String)TAG, (String)"[Update] Param - name  is null !!!");
            return;
        }
        String sqlStr = "DELETE FROM MobileDeviceDB where name=\"" + name + "\";";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public void UnRegisterAll() {
        String sqlStr = "DELETE FROM MobileDeviceDB;";
        if (this.wdb != null) {
            this.wdb.execSQL(sqlStr);
        }
    }

    public int isExistMobileDevice(String Uid) {
        String query = "select count(*) from MobileDeviceDB where uid=\"" + Uid + "\";";
        String getdata = null;
        if (Uid == null) {
            Log.w((String)TAG, (String)"[isExistMobileDevice] Param - Uid  is null !!!");
            return -10;
        }
        try {
            Cursor cursor;
            if (this.wdb != null && (cursor = this.wdb.rawQuery(query, null)) != null) {
                while (cursor.moveToNext()) {
                    getdata = cursor.getString(0).trim();
                }
                cursor.close();
                return Integer.parseInt(getdata);
            }
            return -999;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -999;
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", TAG, e);
            return -999;
        }
    }

    public List<MobileDeviceClass> GetMobileDeviceData() {
        ArrayList<MobileDeviceClass> SyncData = new ArrayList<MobileDeviceClass>();
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select seqnum, uid, name, regdate from MobileDeviceDB order by regdate asc;", null);
            try {
                while (cursor.moveToNext()) {
                    MobileDeviceClass getdata = new MobileDeviceClass();
                    getdata.seq = cursor.getInt(0);
                    getdata.Uid = cursor.getString(1);
                    getdata.Name = cursor.getString(2);
                    getdata.regdate = cursor.getString(3);
                    SyncData.add(getdata);
                }
                cursor.close();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                SyncData.clear();
                return null;
            }
            catch (Exception e) {
                cursor.close();
                SyncData.clear();
                Log.e((String)TAG, (String)"[GetMobileDeviceData] Exception Error");
                LogUtil.errorLogInfo("", TAG, e);
                return null;
            }
        }
        return SyncData;
    }

    public String ToDebugMobileDeviceData(List<MobileDeviceClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "MobileDeviceClass\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            MobileDeviceClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString();
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public static class MobileDeviceClass {
        public int seq = -1;
        public String Uid = null;
        public String Name = null;
        public String regdate = null;

        public String ToDebugString() {
            String retStr = "==========================\r\nseq             : " + this.seq + "\r\n==========================\r\nUid            : " + this.Uid + "\r\nName           : " + this.Name + "\r\nregdate           : " + this.regdate + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }
}

