/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;
import com.util.LogUtil;

public class RFDoorCamAPI
extends WallPadDevAPI {
    private final String TAG = "RFDoorCamAPI";
    private final boolean DEBUG_LOG_ON = true;
    public static final byte STATUS_REGMODE_START = 0;
    public static final byte STATUS_REGMODE_KEY_COMPLETE = 32;
    public static final byte STATUS_REGMODE_KEY_ALREADY = 64;
    public static final byte STATUS_REGMODE_ER_DBWRITE = 96;
    public static final byte STATUS_REGMODE_FULL = -32;
    private byte WpadStatus;

    private void DebugLogOutput(String s) {
        Log.d((String)"RFDoorCamAPI", (String)s);
    }

    public RFDoorCamAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("RFDoorCamAPI create " + devctrcmd);
        this.WpadStatus = 0;
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "RFDOORCAM";
    }

    private int GetWpadStatus() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetWpadStatus", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length != 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                index = 1;
                this.WpadStatus = Byte.parseByte(retlist[index++]);
                return 0;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", "RFDoorCamAPI", re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)"RFDoorCamAPI", (String)("[Refresh] - [Exception Error] Parse (" + index + ")"));
                LogUtil.errorLogInfo("", "RFDoorCamAPI", e);
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        return -1;
    }

    public int SetDoorCamUseOnOff(boolean OnOff) {
        int ret = this.GetWpadStatus();
        if (ret != 0) {
            Log.w((String)"RFDoorCamAPI", (String)("[SetDoorCamUseOnOff] GetWpadStatus Error (ret:" + ret + ")"));
            return ret;
        }
        if (OnOff) {
            if (this.WpadStatus == 64) {
                this.DebugLogOutput("[SetDoorCamUseOnOff] - That have already been set.");
                return 0;
            }
        } else if (this.WpadStatus != 64) {
            this.DebugLogOutput("[SetDoorCamUseOnOff] - That has already been turned off.");
            return 0;
        }
        int ByteOnOff = 0;
        if (OnOff) {
            ByteOnOff = 1;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetDoorCamUseOnOff", ByteOnOff, 0, 0, 0, 0);
    }

    public int SetRegisterModeStart() {
        return this.SendNReadCMD_int("SINKCTRL", "SetRegisterModeStart", 0, 0, 0, 0, 0);
    }

    public int SetRegisterModeEnd() {
        return this.SendNReadCMD_int("SINKCTRL", "SetRegisterModeEnd", 0, 0, 0, 0, 0);
    }
}

