/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import ceres.utils.PreferencesWrapper;
import ceres.utils.printlog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Compatibility {
    private static final String THIS_FILE = "Compatibility";
    private static int currentApi = 0;
    private static List<ResolveInfo> callIntents = null;
    private static Boolean canMakeGSMCall = null;
    private static Boolean canMakeSkypeCall = null;

    public static int getApiLevel() {
        if (currentApi > 0) {
            return currentApi;
        }
        if (Build.VERSION.SDK.equalsIgnoreCase("3")) {
            currentApi = 3;
        } else {
            try {
                Field f = Build.VERSION.class.getDeclaredField("SDK_INT");
                currentApi = (Integer)f.get(null);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return currentApi;
    }

    public static boolean isCompatible(int apiLevel) {
        return Compatibility.getApiLevel() >= apiLevel;
    }

    public static int getInCallStream() {
        if (Build.BRAND.equalsIgnoreCase("archos")) {
            return 3;
        }
        return 0;
    }

    public static boolean shouldUseRoutingApi() {
        printlog.d(THIS_FILE, "Current device " + Build.BRAND + " - " + Build.DEVICE);
        if (Build.PRODUCT.equalsIgnoreCase("htc_supersonic")) {
            return true;
        }
        return !Compatibility.isCompatible(4);
    }

    public static boolean shouldUseModeApi() {
        printlog.d(THIS_FILE, "Current device " + Build.BRAND + " - " + Build.DEVICE);
        if (Build.DEVICE.equalsIgnoreCase("blade")) {
            return true;
        }
        if (Build.DEVICE.equalsIgnoreCase("GT-I5500")) {
            return true;
        }
        if (Build.PRODUCT.equalsIgnoreCase("htc_supersonic")) {
            return true;
        }
        if (Build.DEVICE.equalsIgnoreCase("LG-P500")) {
            return true;
        }
        return Build.DEVICE.equalsIgnoreCase("U8150") || Build.DEVICE.equalsIgnoreCase("U8110");
    }

    public static String guessInCallMode() {
        if (Build.BRAND.equalsIgnoreCase("sdg")) {
            return "3";
        }
        if (Build.DEVICE.equalsIgnoreCase("blade")) {
            return Integer.toString(2);
        }
        if (!Compatibility.isCompatible(5)) {
            return Integer.toString(2);
        }
        return Integer.toString(0);
    }

    public static String getCpuAbi() {
        if (Compatibility.isCompatible(4)) {
            try {
                Field field = Build.class.getField("CPU_ABI");
                return field.get(null).toString();
            }
            catch (Exception e) {
                printlog.w(THIS_FILE, "Announce to be android 1.6 but no CPU ABI field", e);
            }
        }
        return "armeabi";
    }

    private static boolean needPspWorkaround(PreferencesWrapper preferencesWrapper) {
        if (Build.DEVICE.equalsIgnoreCase("passion")) {
            return true;
        }
        if (Build.PRODUCT.toLowerCase().startsWith("htc") || Build.BRAND.toLowerCase().startsWith("htc") || Build.PRODUCT.toLowerCase().equalsIgnoreCase("inc")) {
            return !Build.DEVICE.equalsIgnoreCase("hero") && !Build.DEVICE.equalsIgnoreCase("magic") && !Build.DEVICE.equalsIgnoreCase("tatoo") && !Build.DEVICE.equalsIgnoreCase("dream") && !Build.DEVICE.equalsIgnoreCase("legend");
        }
        if (Build.BRAND.toLowerCase().startsWith("dell") && Build.DEVICE.equalsIgnoreCase("streak")) {
            return true;
        }
        return Build.DEVICE.toLowerCase().contains("milestone2");
    }

    private static boolean needToneWorkaround(PreferencesWrapper prefWrapper) {
        return Build.PRODUCT.toLowerCase().startsWith("gt-i5800") || Build.PRODUCT.toLowerCase().startsWith("gt-i5801");
    }

    private static void resetCodecsSettings(PreferencesWrapper preferencesWrapper) {
        boolean supportFloating = Compatibility.getCpuAbi().equalsIgnoreCase("armeabi-v7a");
        preferencesWrapper.setCodecPriority("PCMU/8000/1", "video", "60");
        preferencesWrapper.setCodecPriority("PCMA/8000/1", "video", "50");
        preferencesWrapper.setCodecPriority("speex/8000/1", "video", "220");
        preferencesWrapper.setCodecPriority("speex/16000/1", "video", "0");
        preferencesWrapper.setCodecPriority("speex/32000/1", "video", "0");
        preferencesWrapper.setCodecPriority("GSM/8000/1", "video", "230");
        preferencesWrapper.setCodecPriority("G722/16000/1", "video", "0");
        preferencesWrapper.setCodecPriority("G729/8000/1", "video", "0");
        preferencesWrapper.setCodecPriority("iLBC/8000/1", "video", supportFloating ? "240" : "0");
        preferencesWrapper.setCodecPriority("SILK/8000/1", "video", "235");
        preferencesWrapper.setCodecPriority("SILK/12000/1", "video", "0");
        preferencesWrapper.setCodecPriority("SILK/16000/1", "video", "0");
        preferencesWrapper.setCodecPriority("SILK/24000/1", "video", "0");
        preferencesWrapper.setCodecPriority("CODEC2/8000/1", "video", "237");
        preferencesWrapper.setCodecPriority("PCMU/8000/1", "audio", "60");
        preferencesWrapper.setCodecPriority("PCMA/8000/1", "audio", "50");
        preferencesWrapper.setCodecPriority("speex/8000/1", "audio", "70");
        preferencesWrapper.setCodecPriority("speex/16000/1", "audio", "219");
        preferencesWrapper.setCodecPriority("speex/32000/1", "audio", "220");
        preferencesWrapper.setCodecPriority("GSM/8000/1", "audio", "10");
        preferencesWrapper.setCodecPriority("G722/16000/1", "audio", "235");
        preferencesWrapper.setCodecPriority("G729/8000/1", "audio", "0");
        preferencesWrapper.setCodecPriority("iLBC/8000/1", "audio", supportFloating ? "100" : "0");
        preferencesWrapper.setCodecPriority("SILK/8000/1", "audio", "80");
        preferencesWrapper.setCodecPriority("SILK/12000/1", "audio", "75");
        preferencesWrapper.setCodecPriority("SILK/16000/1", "audio", "230");
        preferencesWrapper.setCodecPriority("SILK/24000/1", "audio", "240");
        preferencesWrapper.setCodecPriority("CODEC2/8000/1", "audio", "0");
        preferencesWrapper.setPreferenceStringValue("band_for_wifi", "audio");
        preferencesWrapper.setPreferenceStringValue("band_for_other", "audio");
        preferencesWrapper.setPreferenceStringValue("band_for_3g", "video");
        preferencesWrapper.setPreferenceStringValue("band_for_gprs", "video");
        preferencesWrapper.setPreferenceStringValue("band_for_edge", "video");
    }

    public static void setFirstRunParameters(PreferencesWrapper preferencesWrapper) {
        Compatibility.resetCodecsSettings(preferencesWrapper);
        preferencesWrapper.setPreferenceStringValue("snd_media_quality", Compatibility.getCpuAbi().equalsIgnoreCase("armeabi-v7a") ? "4" : "3");
        preferencesWrapper.setPreferenceStringValue("snd_auto_close_time", Compatibility.isCompatible(4) ? "1" : "5");
        preferencesWrapper.setPreferenceStringValue("snd_clock_rate", Compatibility.isCompatible(4) ? "16000" : "8000");
        preferencesWrapper.setPreferenceBooleanValue("echo_cancellation", Compatibility.isCompatible(4));
        preferencesWrapper.setPreferenceBooleanValue("keep_awake_incall", Compatibility.needPspWorkaround(preferencesWrapper));
        if (Build.PRODUCT.equalsIgnoreCase("SPH-M900")) {
            preferencesWrapper.setPreferenceBooleanValue("invert_proximity_sensor", true);
        }
        if (Build.DEVICE.toUpperCase().startsWith("GT-I9000")) {
            preferencesWrapper.setPreferenceFloatValue("snd_mic_level", 0.4f);
            preferencesWrapper.setPreferenceFloatValue("snd_speaker_level", 0.2f);
            preferencesWrapper.setPreferenceBooleanValue("use_soft_volume", true);
        }
        if (Build.PRODUCT.equalsIgnoreCase("htc_supersonic")) {
            preferencesWrapper.setPreferenceFloatValue("snd_mic_level", 0.5f);
            preferencesWrapper.setPreferenceFloatValue("snd_speaker_level", 1.5f);
        }
        preferencesWrapper.setPreferenceBooleanValue("use_routing_api", Compatibility.shouldUseRoutingApi());
        preferencesWrapper.setPreferenceBooleanValue("use_mode_api", Compatibility.shouldUseModeApi());
        preferencesWrapper.setPreferenceBooleanValue("set_audio_generate_tone", Compatibility.needToneWorkaround(preferencesWrapper));
    }

    public static boolean useFlipAnimation() {
        return !Build.BRAND.equalsIgnoreCase("archos");
    }

    public static String ModelNameTest() {
        printlog.i("ModelNameTest", "ModelNameTest BOARD: " + Build.BOARD);
        printlog.i("ModelNameTest", "ModelNameTest BRAND: " + Build.BRAND);
        printlog.i("ModelNameTest", "ModelNameTest CPU_ABI: " + Build.CPU_ABI);
        printlog.i("ModelNameTest", "ModelNameTest DEVICE: " + Build.DEVICE);
        printlog.i("ModelNameTest", "ModelNameTest DISPLAY: " + Build.DISPLAY);
        printlog.i("ModelNameTest", "ModelNameTest FINGERPRINT: " + Build.FINGERPRINT);
        printlog.i("ModelNameTest", "ModelNameTest HOST: " + Build.HOST);
        printlog.i("ModelNameTest", "ModelNameTest ID: " + Build.ID);
        printlog.i("ModelNameTest", "ModelNameTest MANUFACTURER: " + Build.MANUFACTURER);
        printlog.i("ModelNameTest", "ModelNameTest MODEL: " + Build.MODEL);
        printlog.i("ModelNameTest", "ModelNameTest PRODUCT: " + Build.PRODUCT);
        printlog.i("ModelNameTest", "ModelNameTest TAGS: " + Build.TAGS);
        printlog.i("ModelNameTest", "ModelNameTest TIME: " + Build.TIME);
        printlog.i("ModelNameTest", "ModelNameTest TYPE: " + Build.TYPE);
        printlog.i("ModelNameTest", "ModelNameTest USER: " + Build.USER);
        return Build.BOARD;
    }

    public static List<ResolveInfo> getPossibleActivities(Context ctxt, Intent i) {
        PackageManager pm = ctxt.getPackageManager();
        try {
            return pm.queryIntentActivities(i, 65600);
        }
        catch (NullPointerException e) {
            return new ArrayList<ResolveInfo>();
        }
    }

    public static Intent getPriviledgedIntent(String number) {
        Intent i = new Intent("android.intent.action.CALL_PRIVILEGED");
        Uri.Builder b = new Uri.Builder();
        b.scheme("tel").appendPath(number);
        i.setData(b.build());
        return i;
    }

    public static final List<ResolveInfo> getIntentsForCall(Context ctxt) {
        if (callIntents == null) {
            callIntents = Compatibility.getPossibleActivities(ctxt, Compatibility.getPriviledgedIntent("123"));
        }
        return callIntents;
    }

    public static boolean canResolveIntent(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static boolean canMakeGSMCall(Context context) {
        PreferencesWrapper prefs = new PreferencesWrapper(context);
        if (prefs.getGsmIntegrationType() == 0) {
            if (canMakeGSMCall == null) {
                Intent intentMakePstnCall = new Intent("android.intent.action.CALL");
                intentMakePstnCall.setData(Uri.fromParts((String)"tel", (String)"12345", null));
                canMakeGSMCall = Compatibility.canResolveIntent(context, intentMakePstnCall);
            }
            return canMakeGSMCall;
        }
        return prefs.getGsmIntegrationType() != 2;
    }

    public static boolean canMakeSkypeCall(Context context) {
        if (canMakeSkypeCall == null) {
            try {
                PackageInfo skype = context.getPackageManager().getPackageInfo("com.skype.raider", 0);
                if (skype != null) {
                    canMakeSkypeCall = true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                canMakeSkypeCall = false;
            }
        }
        return canMakeSkypeCall;
    }

    public static void updateVersion(PreferencesWrapper prefWrapper, int lastSeenVersion, int runningVersion) {
        if (lastSeenVersion < 14) {
            if (Build.DEVICE.toUpperCase().startsWith("GT-I9000")) {
                prefWrapper.setPreferenceFloatValue("snd_mic_level", 0.4f);
                prefWrapper.setPreferenceFloatValue("snd_speaker_level", 0.2f);
            }
            if (TextUtils.isEmpty((CharSequence)prefWrapper.getStunServer())) {
                prefWrapper.setPreferenceStringValue("stun_server", "stun.counterpath.com");
            }
        }
        if (lastSeenVersion < 15) {
            prefWrapper.setPreferenceBooleanValue("enable_stun", false);
        }
        if (lastSeenVersion < 369 && Build.DEVICE.toUpperCase().startsWith("GT-I9000")) {
            prefWrapper.setPreferenceBooleanValue("use_soft_volume", true);
        }
        if (lastSeenVersion < 385) {
            if (Compatibility.needPspWorkaround(prefWrapper)) {
                prefWrapper.setPreferenceBooleanValue("keep_awake_incall", true);
            }
            prefWrapper.setPreferenceBooleanValue("use_routing_api", Compatibility.shouldUseRoutingApi());
            prefWrapper.setPreferenceBooleanValue("use_mode_api", Compatibility.shouldUseModeApi());
            prefWrapper.setPreferenceStringValue("sip_audio_mode", Compatibility.guessInCallMode());
        }
        if (lastSeenVersion < 394) {
            prefWrapper.setPreferenceBooleanValue("keep_awake_incall", Compatibility.needPspWorkaround(prefWrapper));
        }
        if (lastSeenVersion < 575) {
            prefWrapper.setPreferenceStringValue("thread_count", "3");
            prefWrapper.setPreferenceBooleanValue("set_audio_generate_tone", Compatibility.needToneWorkaround(prefWrapper));
            if (lastSeenVersion > 0) {
                prefWrapper.setPreferenceBooleanValue("has_already_setup_service", true);
            }
            prefWrapper.setPreferenceBooleanValue("enable_qos", false);
            if (Build.PRODUCT.equalsIgnoreCase("htc_supersonic")) {
                prefWrapper.setPreferenceFloatValue("snd_mic_level", 0.5f);
                prefWrapper.setPreferenceFloatValue("snd_speaker_level", 1.5f);
                prefWrapper.setPreferenceBooleanValue("use_routing_api", true);
            }
            prefWrapper.setPreferenceBooleanValue("use_mode_api", Compatibility.shouldUseModeApi());
            prefWrapper.setPreferenceBooleanValue("keep_awake_incall", Compatibility.needPspWorkaround(prefWrapper));
            if (Build.PRODUCT.equalsIgnoreCase("SPH-M900")) {
                prefWrapper.setPreferenceBooleanValue("invert_proximity_sensor", true);
            }
        }
        if (lastSeenVersion < 591) {
            Compatibility.resetCodecsSettings(prefWrapper);
        }
    }
}

