/*
 * Decompiled with CFR 0.152.
 */
package ceres.service;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class MyTCPServer {
    private static final String TAG = "TCPServer";
    private static int PORT = 4001;
    private static MyTCPServer mMyTCPServer;
    private TCPServerThread mServerThread;
    private Context mContext;
    private BufferedReader mInputBuffer;
    private BufferedWriter mOutputBuffer;
    private Handler mHandler;

    public MyTCPServer(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
    }

    public static MyTCPServer getInstance(Context context, Handler handler) {
        if (mMyTCPServer == null) {
            mMyTCPServer = new MyTCPServer(context, handler);
        }
        return mMyTCPServer;
    }

    public void start() {
        if (this.mServerThread == null) {
            this.mServerThread = new TCPServerThread();
            this.mServerThread.start();
        }
    }

    class TCPServerThread
    extends Thread {
        private Boolean working = true;
        private ServerSocket mServerSocket;
        private Socket client;
        private String clientIP;
        DataOutputStream output;
        DataInputStream input;

        @Override
        public void run() {
            Thread.currentThread().setName("MyTCPServer");
            try {
                this.mServerSocket = new ServerSocket(PORT);
                while (this.working.booleanValue()) {
                    this.client = this.mServerSocket.accept();
                    this.clientIP = this.client.getInetAddress().getHostAddress();
                    MyTCPServer.this.mOutputBuffer = new BufferedWriter(new OutputStreamWriter(this.client.getOutputStream()));
                    MyTCPServer.this.mInputBuffer = new BufferedReader(new InputStreamReader(this.client.getInputStream()), 10);
                    while (!this.client.isClosed()) {
                        String data = MyTCPServer.this.mInputBuffer.readLine();
                        if (data == null) continue;
                        Log.v((String)MyTCPServer.TAG, (String)("read: " + data));
                        if (!data.equals("HEY")) continue;
                        MyTCPServer.this.mOutputBuffer.write("ACK", 0, "ACK".length());
                        MyTCPServer.this.mOutputBuffer.flush();
                        Message msg = MyTCPServer.this.mHandler.obtainMessage(100, (Object)this.clientIP);
                        MyTCPServer.this.mHandler.sendMessage(msg);
                    }
                }
            }
            catch (IOException e) {
                Log.v((String)MyTCPServer.TAG, (String)"Fail TCPServer!!");
                e.printStackTrace();
            }
        }

        public void cancel() {
            this.working = false;
        }
    }
}

