/*
 * Decompiled with CFR 0.152.
 */
package ceres.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import ceres.api.AECParam;
import ceres.api.Configuration;
import ceres.api.SpamList;
import ceres.cminterface.CMInterface;
import ceres.utils.printlog;

public class DBAdapter {
    static String THIS_FILE = "DBAdapter";
    static CMInterface mCMIF;
    private static final String DATABASE_NAME = "com.cnstec.db";
    private static final int DATABASE_VERSION = 17;
    private static final String CALLLOGS_TABLE_NAME = "calllogs";
    private static final String TABLE_CALLLOGS_CREATE = "CREATE TABLE IF NOT EXISTS calllogs (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT,numberlabel TEXT,numbertype INTEGER,date INTEGER,duration INTEGER,new INTEGER,number TEXT,type INTEGER);";
    public static final String MCONFTB = "mconftb";
    private static final String TABLE_MCONFTB_CREATE = "CREATE TABLE IF NOT EXISTS mconftb (_id INTEGER PRIMARY KEY AUTOINCREMENT,phone_number TEXT,one_number TEXT,address TEXT,password TEXT,auth_id TEXT,proxy_addr TEXT,proxy_port TEXT,reg_addr TEXT,reg_port TEXT,local_port TEXT,local_media_port TEXT,remote_media_port TEXT,provider TEXT,acodec_pri TEXT,vcodec_pri TEXT,reregtime TEXT,sessiontime TEXT,session_expire_time TEXT,transaction_time TEXT,dtmf_type TEXT,url_type TEXT,srtpoption TEXT,ptime TEXT,aeconoff TEXT,jbminmax TEXT,onenumonoff TEXT,spamonoff TEXT,redirectoption TEXT,hwsamplingrate TEXT,vad_onoff TEXT,ns_onoff TEXT,cng_onoff TEXT,audio_mode TEXT,log_lv_sip TEXT,log_lv_rtp TEXT,log_lv_cm TEXT,log_lv_mcm TEXT,log_lv_mmm TEXT,log_lv_ui TEXT,sdc_onoff TEXT,video_onoff TEXT,video_size TEXT,vcodec_framerate TEXT,vcodec_bandwidth TEXT,vcodec_maxbr TEXT,vcodec_h264_pmode TEXT,vcodec_mpeg4ves_pli TEXT);";
    public static final String AECTNTB = "aectntb";
    private static final String TABLE_AECTNTB_CREATE = "CREATE TABLE IF NOT EXISTS aectntb (_id INTEGER PRIMARY KEY AUTOINCREMENT,memo TEXT,delay TEXT,time_span TEXT,erl TEXT,dynamic_vol_mic TEXT,dynamic_vol_mic_min TEXT,update_speed TEXT,weight_max_index TEXT,weight_scale TEXT,date INTEGER);";
    private static final String SPAMLTB = "spamltb";
    private static final String TABLE_SPAMLTB_CREATE = "CREATE TABLE IF NOT EXISTS spamltb (_id INTEGER PRIMARY KEY AUTOINCREMENT,spamnumber TEXT);";
    private final Context context;
    private DatabaseHelper databaseHelper;
    private SQLiteDatabase db;
    private boolean opened = false;
    public static final int AEC_ID_INDEX = 0;
    public static final int AEC_MEMO_INDEX = 1;
    public static final int AEC_DELAY_INDEX = 2;
    private static final String[] logs_projection;
    public static final int ID_COLUMN_INDEX = 0;
    public static final int CALLER_NAME_COLUMN_INDEX = 1;
    public static final int CALLER_NUMBERLABEL_COLUMN_INDEX = 2;
    public static final int CALLER_NUMBERTYPE_COLUMN_INDEX = 3;
    public static final int DURATION_COLUMN_INDEX = 4;
    public static final int DATE_COLUMN_INDEX = 5;
    public static final int NEW_COLUMN_INDEX = 6;
    public static final int NUMBER_COLUMN_INDEX = 7;
    public static final int CALL_TYPE_COLUMN_INDEX = 8;

    public DBAdapter(Context aContext) {
        this.context = aContext;
        this.databaseHelper = new DatabaseHelper(this.context);
    }

    public DBAdapter open() throws SQLException {
        this.db = this.databaseHelper.getWritableDatabase();
        this.opened = true;
        return this;
    }

    public void close() {
        this.databaseHelper.close();
        this.opened = false;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public long insertConf(Configuration conf) {
        ContentValues temp = new ContentValues();
        temp = conf.getDbContentValues();
        long raws = this.db.insert(MCONFTB, null, temp);
        printlog.i(THIS_FILE, "raws : " + raws);
        return raws;
    }

    public boolean updateConf(Configuration conf) {
        printlog.i(THIS_FILE, "Conf.getDisplayName() : " + conf.getDisplayName());
        printlog.i(THIS_FILE, "Conf._id : " + conf._id);
        return this.db.update(MCONFTB, conf.getDbContentValues(), "_id=" + conf._id, null) > 0;
    }

    public int getConfId() {
        int _id = 0;
        Cursor c = this.db.query(MCONFTB, null, null, null, null, null, null);
        while (c.moveToNext()) {
            _id = c.getInt(0);
        }
        printlog.i(THIS_FILE, "getConfId : " + _id);
        return _id;
    }

    public Configuration getConfValue(long conf_id) {
        try {
            Cursor c = this.db.query(MCONFTB, Configuration.full_projection, "_id=" + conf_id, null, null, null, null);
            int numRows = c.getCount();
            if (numRows == 0) {
                return new Configuration();
            }
            printlog.i(THIS_FILE, "numRows " + numRows);
            if (numRows > 0) {
                c.moveToFirst();
                Configuration conf = new Configuration();
                conf.createFromDb(c);
                c.close();
                return conf;
            }
            c.close();
        }
        catch (SQLException e) {
            printlog.e("Exception on query", e.toString());
        }
        return null;
    }

    public boolean deleteConf(Configuration conf) {
        return this.db.delete(MCONFTB, "_id=" + conf._id, null) > 0;
    }

    public long insertSpamNumber(SpamList number) {
        ContentValues temp = new ContentValues();
        temp = number.getDbContentValues();
        long raws = this.db.insert(SPAMLTB, null, temp);
        printlog.i(THIS_FILE, "raws : " + raws);
        return raws;
    }

    public boolean updateSpamNumber(SpamList number) {
        printlog.i(THIS_FILE, "Conf._id : " + number._id);
        return this.db.update(SPAMLTB, number.getDbContentValues(), "_id=" + number._id, null) > 0;
    }

    public SpamList getSpamList(long _id) {
        try {
            Cursor c = this.db.query(SPAMLTB, SpamList.full_projection, "_id=" + _id, null, null, null, null);
            int numRows = c.getCount();
            if (numRows == 0) {
                return new SpamList();
            }
            printlog.i(THIS_FILE, "numRows " + numRows);
            if (numRows > 0) {
                c.moveToFirst();
                SpamList conf = new SpamList();
                conf.createFromDb(c);
                c.close();
                return conf;
            }
            c.close();
        }
        catch (SQLException e) {
            printlog.e("Exception on query", e.toString());
        }
        return null;
    }

    public boolean deleteSpamNumber(SpamList number) {
        return this.db.delete(SPAMLTB, "_id=" + number._id, null) > 0;
    }

    public long insertAECParam(AECParam param) {
        ContentValues temp = new ContentValues();
        temp = param.getDbContentValues();
        long raws = this.db.insert(AECTNTB, null, temp);
        printlog.i(THIS_FILE, "raws : " + raws);
        return raws;
    }

    public boolean updateAECParam(AECParam param) {
        printlog.i(THIS_FILE, "Conf._id : " + param._id);
        return this.db.update(AECTNTB, param.getDbContentValues(), "_id=" + param._id, null) > 0;
    }

    public Cursor getAllAECParamLogs() {
        return this.db.query(AECTNTB, AECParam.full_projection, null, null, null, null, "_id desc");
    }

    public AECParam selectRecentApplyAECParam() {
        try {
            Cursor c = this.db.query(AECTNTB, AECParam.full_projection, null, null, null, null, "date desc");
            int numRows = c.getCount();
            if (numRows == 0) {
                return new AECParam();
            }
            printlog.i(THIS_FILE, "numRows " + numRows);
            if (numRows > 0) {
                c.moveToFirst();
                AECParam param = new AECParam();
                param.createFromDb(c);
                c.close();
                return param;
            }
            c.close();
        }
        catch (SQLException e) {
            printlog.e("Exception on query", e.toString());
        }
        return null;
    }

    public AECParam selectAECParam(long _id) {
        try {
            Cursor c = this.db.query(AECTNTB, AECParam.full_projection, "_id=" + _id, null, null, null, null);
            int numRows = c.getCount();
            if (numRows == 0) {
                return new AECParam();
            }
            printlog.i(THIS_FILE, "numRows " + numRows);
            if (numRows > 0) {
                c.moveToFirst();
                AECParam param = new AECParam();
                param.createFromDb(c);
                c.close();
                return param;
            }
            c.close();
        }
        catch (SQLException e) {
            printlog.e("Exception on query", e.toString());
        }
        return null;
    }

    public boolean deleteOneAECParamLog(int aecParamlogId) {
        return this.db.delete(AECTNTB, "_id=" + aecParamlogId, null) > 0;
    }

    public boolean deleteAllAECParamLogs() {
        return this.db.delete(AECTNTB, null, null) > 0;
    }

    public long insertCallLog(ContentValues args) {
        long result = this.db.insert(CALLLOGS_TABLE_NAME, null, args);
        this.removeCallLogExpiredEntries();
        return result;
    }

    public int getNbrOfCallLogs() {
        Cursor c = this.db.rawQuery("SELECT COUNT(_id) FROM calllogs;", null);
        int numRows = 0;
        if (c.getCount() > 0) {
            c.moveToFirst();
            numRows = c.getInt(0);
        }
        c.close();
        return numRows;
    }

    public Cursor getAllCallLogs() {
        return this.db.query(CALLLOGS_TABLE_NAME, logs_projection, null, null, null, null, "date DESC");
    }

    public Cursor getCallLog(int logId) {
        if (logId < 0) {
            return null;
        }
        try {
            return this.db.query(CALLLOGS_TABLE_NAME, logs_projection, "_id=" + logId, null, null, null, null);
        }
        catch (SQLException e) {
            printlog.e(THIS_FILE, "Exception on query", e);
            return null;
        }
    }

    public boolean deleteOneCallLog(int calllogId) {
        return this.db.delete(CALLLOGS_TABLE_NAME, "_id=" + calllogId, null) > 0;
    }

    public boolean deleteAllCallLogs() {
        return this.db.delete(CALLLOGS_TABLE_NAME, null, null) > 0;
    }

    private void removeCallLogExpiredEntries() {
        this.db.delete(CALLLOGS_TABLE_NAME, "_id IN (SELECT _id FROM calllogs ORDER BY date DESC LIMIT -1 OFFSET 500)", null);
    }

    static {
        logs_projection = new String[]{"_id", "name", "numberlabel", "numbertype", "duration", "date", "new", "number", "type"};
    }

    public static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, DBAdapter.DATABASE_NAME, null, 17);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(DBAdapter.TABLE_CALLLOGS_CREATE);
            db.execSQL(DBAdapter.TABLE_SPAMLTB_CREATE);
            db.execSQL(DBAdapter.TABLE_MCONFTB_CREATE);
            db.execSQL(DBAdapter.TABLE_AECTNTB_CREATE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            printlog.w(THIS_FILE, "Upgrading database from version " + oldVersion + " to " + newVersion);
            this.onCreate(db);
        }
    }
}

