/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.artncore.WallPadDataMgr.WallpadDeviceSet;
import com.artncore.WallPadDataMgr.WallpadStatusData;
import com.artncore.commons.DataClasses;
import com.artncore.commons.KNX_DataClasses;
import com.artncore.commons.Sdb_DataClasses;
import com.artncore.wallpadapi.AirQualitySensorAPI;
import com.artncore.wallpadapi.AllLightAPI;
import com.artncore.wallpadapi.AllLightHDCAPI;
import com.artncore.wallpadapi.CutOffConcentAPI;
import com.artncore.wallpadapi.DLockAPI;
import com.artncore.wallpadapi.ElectricRange_API;
import com.artncore.wallpadapi.EnergyMeterAPI;
import com.artncore.wallpadapi.EnergyModuleAPI;
import com.artncore.wallpadapi.FP_DlockAPI;
import com.artncore.wallpadapi.GasAPI;
import com.artncore.wallpadapi.HeatingV1API;
import com.artncore.wallpadapi.HeatingV2API;
import com.artncore.wallpadapi.IGW200dAPI;
import com.artncore.wallpadapi.IGW300API;
import com.artncore.wallpadapi.InRoomDetectSensor_API;
import com.artncore.wallpadapi.IntLightAPI;
import com.artncore.wallpadapi.KnxAPI;
import com.artncore.wallpadapi.KnxVentiAPI;
import com.artncore.wallpadapi.Knx_LivingRoomLightAPI;
import com.artncore.wallpadapi.LedDimmingKCC_API;
import com.artncore.wallpadapi.LightAPI;
import com.artncore.wallpadapi.LouverAPI;
import com.artncore.wallpadapi.MultiSwitchAPI;
import com.artncore.wallpadapi.PhonNRemocon;
import com.artncore.wallpadapi.PurityAPI;
import com.artncore.wallpadapi.RFDoorCamAPI;
import com.artncore.wallpadapi.RealTimeMeterAPI;
import com.artncore.wallpadapi.SdbAPI;
import com.artncore.wallpadapi.Sdb_LivingRoomLightAPI;
import com.artncore.wallpadapi.ServiceConnect;
import com.artncore.wallpadapi.SmartKeyRfDoorAPI;
import com.artncore.wallpadapi.SmartSwitchEvtAPI;
import com.artncore.wallpadapi.SmartSwitchPolAPI;
import com.artncore.wallpadapi.SystemAirconAPI;
import com.artncore.wallpadapi.UksAPI;
import com.artncore.wallpadapi.VentiAPI;
import com.util.LogUtil;
import kr.co.icontrols.wallpadsupport.Version;

public class WallPadAPI {
    private static final String TAG = "WallPadAPI";
    public ServiceConnect SvcCon;
    private Context mContext;
    private int mModelType = Version.getModelType();
    private static boolean mHDCIntLightType = false;
    private LivingLightDelayedBlink mLivingLightDelayedBlink = null;

    public static boolean Get_HDCIntLightType() {
        return mHDCIntLightType;
    }

    public WallPadAPI(Context ctx) {
        this.SvcCon = new ServiceConnect(ctx);
        this.mContext = ctx;
        this.getHDCIntLightType(ctx);
    }

    public int getGatewayType() {
        try {
            WallpadDeviceSet mWallpadDeviceSet = new WallpadDeviceSet(this.mContext);
            int nGWType = mWallpadDeviceSet.GetGatewayModelKindInfo();
            mWallpadDeviceSet.closeDB();
            return nGWType;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] getGatewayType()");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
    }

    private void getHDCIntLightType(Context ctx) {
        try {
            if (!Version.getGatewayUsage()) {
                return;
            }
            mHDCIntLightType = false;
            WallpadDeviceSet devset = new WallpadDeviceSet(ctx);
            int[] setdata = devset.Get_Light_info();
            devset.closeDB();
            if (setdata == null) {
                return;
            }
            if (setdata.length < 2) {
                return;
            }
            if (setdata[0] != 1) {
                return;
            }
            if (setdata[1] == 15) {
                mHDCIntLightType = false;
            } else if (setdata[1] == 16) {
                mHDCIntLightType = true;
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] getHDCIntLightType(Context ctx)");
            LogUtil.errorLogInfo("", TAG, e);
        }
    }

    public int SetDevService_DoorCamUseOnOff(boolean OnOff) {
        try {
            WallpadDeviceSet devset = new WallpadDeviceSet(this.mContext);
            int[] setdata = devset.Get_RFDoorCAM_Info();
            devset.closeDB();
            boolean bSet = false;
            if (setdata[0] == 1 && setdata[1] == 52) {
                bSet = true;
            }
            if (bSet) {
                RFDoorCamAPI rFDoorCamAPI = this.Get_RFDoorCamController();
                if (rFDoorCamAPI == null) {
                    Log.w((String)TAG, (String)"[SetDevService_DoorCamUseOnOff] Get_RFDoorCamController  is  null !!!");
                    return -1000;
                }
                int ret = rFDoorCamAPI.SetDoorCamUseOnOff(OnOff);
                Log.d((String)TAG, (String)("[SetDevService_DoorCamUseOnOff] OnOff : " + OnOff + ", ret : " + ret));
                return ret;
            }
            return -1010;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception Error] SetDevService_DoorCamUseOnOff");
            LogUtil.errorLogInfo("", TAG, e);
            return -100000;
        }
    }

    public int SetBatchSwitchStatus(boolean onoff) {
        try {
            if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570) {
                WallpadDeviceSet wds = new WallpadDeviceSet(this.mContext);
                int nDPType = wds.Get_DistributionPannelType_Info();
                wds.closeDB();
                Log.d((String)TAG, (String)("[SetBatchSwitchStatus] nDPType [" + nDPType + "]"));
                int ret = -1;
                if (nDPType == 1) {
                    SdbAPI sdbAPI = this.Get_SdbController();
                    if (sdbAPI == null) {
                        return -1;
                    }
                    ret = sdbAPI.AllLightOnOff(onoff);
                } else if (nDPType == 2) {
                    KnxAPI knxAPI = this.Get_KnxController();
                    if (knxAPI == null) {
                        return -1;
                    }
                    ret = knxAPI.AllLightOnOff(onoff);
                } else {
                    SdbAPI sdbAPI = this.Get_SdbController();
                    if (sdbAPI == null) {
                        return -1;
                    }
                    ret = sdbAPI.AllLightOnOff(onoff);
                }
                return ret;
            }
            if (this.mModelType == 11100 || this.mModelType == 31120 || this.mModelType == 31520) {
                if (!WallPadAPI.Get_HDCIntLightType()) {
                    AllLightHDCAPI allLightHDCAPI = this.Get_AllLightHDCController();
                    if (allLightHDCAPI == null) {
                        return -1;
                    }
                    int ret = allLightHDCAPI.AllLightControl(onoff);
                    return ret;
                }
                IntLightAPI intLightAPI = this.Get_IntLightController();
                if (intLightAPI == null) {
                    return -1;
                }
                int ret = intLightAPI.AllLightControl(onoff);
                return ret;
            }
            WallpadDeviceSet devSet = new WallpadDeviceSet(this.mContext);
            int[] batchinfo = devSet.Get_BatchSW_Info();
            devSet.closeDB();
            if (batchinfo[0] == 0) {
                return -1;
            }
            if (batchinfo[1] == 21) {
                AllLightAPI allLightAPI = this.Get_AllLightController();
                if (allLightAPI == null) {
                    return -2;
                }
                return allLightAPI.SetAllLightOnOff(onoff);
            }
            if (batchinfo[1] == 22) {
                SmartSwitchPolAPI smartSwitchPolAPI = this.Get_SmartSwitchPolController();
                if (smartSwitchPolAPI == null) {
                    return -2;
                }
                return smartSwitchPolAPI.SetAllLightOnOff(onoff);
            }
            return -3;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] SetBatchSwitchStatus(boolean onoff)");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
    }

    public int GetBatchSwitchStatus() {
        int ret;
        block27: {
            ret = -100;
            try {
                if (this.mModelType == 31100 || this.mModelType == 31500 || this.mModelType == 31170 || this.mModelType == 31570) {
                    WallpadDeviceSet wds = new WallpadDeviceSet(this.mContext);
                    int nDPType = wds.Get_DistributionPannelType_Info();
                    wds.closeDB();
                    Log.d((String)TAG, (String)("[GetBatchSwitchStatus] nDPType [" + nDPType + "]"));
                    if (nDPType == 1) {
                        SdbAPI sdbAPI = this.Get_SdbController();
                        if (sdbAPI == null) {
                            return -1;
                        }
                        ret = sdbAPI.Refresh(SdbAPI.DEVICE_INDEX.ENERGY_CONT, (byte)-1);
                        if (ret < 0) {
                            return -2;
                        }
                        if (sdbAPI.data.EnergyController.Data.BatchOffStatus == Sdb_DataClasses.BATCHOFF_STATUS.SET) {
                            return 0;
                        }
                        return 1;
                    }
                    if (nDPType == 2) {
                        KnxAPI knxAPI = this.Get_KnxController();
                        if (knxAPI == null) {
                            return -1;
                        }
                        ret = knxAPI.Refresh(KnxAPI.DEVICE_INDEX.MASTER_CONT, (byte)-1);
                        if (ret < 0) {
                            return -2;
                        }
                        if (knxAPI.data.MasterController.Data.BatchOffStatus == KNX_DataClasses.BATCHOFF_STATUS.SET) {
                            return 0;
                        }
                        return 1;
                    }
                    SdbAPI sdbAPI = this.Get_SdbController();
                    if (sdbAPI == null) {
                        return -1;
                    }
                    ret = sdbAPI.Refresh(SdbAPI.DEVICE_INDEX.ENERGY_CONT, (byte)-1);
                    if (ret < 0) {
                        return -2;
                    }
                    if (sdbAPI.data.EnergyController.Data.BatchOffStatus == Sdb_DataClasses.BATCHOFF_STATUS.SET) {
                        return 0;
                    }
                    return 1;
                }
                if (this.mModelType == 11100 || this.mModelType == 31120 || this.mModelType == 31520) {
                    if (!WallPadAPI.Get_HDCIntLightType()) {
                        AllLightHDCAPI allLightHDCAPI = this.Get_AllLightHDCController();
                        if (allLightHDCAPI == null) {
                            return -1;
                        }
                        ret = allLightHDCAPI.data.AllLightStatus ? 1 : 0;
                    } else {
                        IntLightAPI intLightAPI = this.Get_IntLightController();
                        if (intLightAPI == null) {
                            return -1;
                        }
                        if (intLightAPI.Refresh(false) < 0) {
                            return -2;
                        }
                        ret = intLightAPI.data.AllLightStatus ? 1 : 0;
                    }
                    break block27;
                }
                WallpadDeviceSet devSet = new WallpadDeviceSet(this.mContext);
                int[] batchinfo = devSet.Get_BatchSW_Info();
                devSet.closeDB();
                if (batchinfo[0] == 0) {
                    return -1;
                }
                if (batchinfo[1] == 21) {
                    AllLightAPI allLightAPI = this.Get_AllLightController();
                    if (allLightAPI == null) {
                        return -1;
                    }
                    if (allLightAPI.Refresh(false) == 0) {
                        ret = allLightAPI.data.AllLightOnOff ? 1 : 0;
                        break block27;
                    }
                    return -2;
                }
                if (batchinfo[1] != 22) break block27;
                SmartSwitchPolAPI smartSwitchPolAPI = this.Get_SmartSwitchPolController();
                if (smartSwitchPolAPI == null) {
                    return -1;
                }
                if (smartSwitchPolAPI.Refresh(false) == 0) {
                    ret = smartSwitchPolAPI.data.AllLightOnOff ? 1 : 0;
                    break block27;
                }
                return -2;
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                return -100;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Exception] GetBatchSwitchStatus()");
                LogUtil.errorLogInfo("", TAG, e);
                return -100;
            }
        }
        return ret;
    }

    public boolean Check_Connect() {
        return this.SvcCon.devctrcmd != null;
    }

    public void Pause() {
        this.SvcCon.Pause();
    }

    public void Resume() {
        this.SvcCon.Resume();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int SetDoorLock_Open() {
        if (Version.getGatewayUsage()) {
            WallpadDeviceSet devset = new WallpadDeviceSet(this.mContext);
            int[] Doorinfo = devset.Get_DoorLock_Info();
            devset.closeDB();
            if (Doorinfo == null) {
                Log.w((String)TAG, (String)"[SetDoorLock_Open] Doorinfo - null");
                return -101;
            }
            if (Doorinfo.length < 2) {
                Log.w((String)TAG, (String)("[SetDoorLock_Open] Doorinfo length Error - Len:" + Doorinfo.length));
                return -102;
            }
            if (Doorinfo[0] == 0) {
                Log.w((String)TAG, (String)"[SetDoorLock_Open] Doorinfo UnUsed !!!");
                return -103;
            }
            if (Doorinfo[1] == 31) {
                DLockAPI dLockAPI = null;
                dLockAPI = this.Get_DLockController();
                if (dLockAPI == null) {
                    Log.w((String)TAG, (String)"[SetDoorLock_Open] dLockAPI - null");
                    return -104;
                }
                int ret = dLockAPI.SetDoorOpen();
                if (ret >= 0) return 0;
                Log.e((String)TAG, (String)("[SetDoorLock_Open] dLockAPI.SetDoorOpen()  Error (" + ret + ")   ErrorCode = " + dLockAPI.ErrorCode.ErrStr()));
                return ret;
            }
            if (Doorinfo[1] == 32) {
                if (this.mModelType == 11100) {
                    IGW200dAPI iGW200dAPI = null;
                    iGW200dAPI = this.Get_IGW200dController();
                    if (iGW200dAPI == null) {
                        Log.w((String)TAG, (String)"[SetDoorLock_Open] Get_IGW200dController - null");
                        return -105;
                    }
                    int ret = iGW200dAPI.SetWddrCont(true);
                    if (ret >= 0) return 0;
                    Log.e((String)TAG, (String)("[SetDoorLock_Open] iGW200dAPI.SetWddrCont(true)  Error (" + ret + ")   ErrorCode = " + iGW200dAPI.ErrorCode.ErrStr()));
                    return ret;
                }
                if (this.mModelType != 31100 && this.mModelType != 31500 && this.mModelType != 31170 && this.mModelType != 31570 && this.mModelType != 31120 && this.mModelType != 31520) return 0;
                IGW300API iGW300API = null;
                iGW300API = this.Get_IGW300Controller();
                if (iGW300API == null) {
                    Log.w((String)TAG, (String)"[SetDoorLock_Open] Get_IGW300dController - null");
                    return -106;
                }
                int ret = iGW300API.SetWddrCont(true);
                if (ret >= 0) return 0;
                Log.e((String)TAG, (String)("[SetDoorLock_Open] iGW300API.SetWddrCont(true)  Error (" + ret + ")   ErrorCode = " + iGW300API.ErrorCode.ErrStr()));
                return ret;
            }
            Log.e((String)TAG, (String)("[SetDoorLock_Open] DoorLock Type Error (Type:" + Doorinfo[1] + ")"));
            return -107;
        }
        WallpadDeviceSet devset = new WallpadDeviceSet(this.mContext);
        int[] DoorCamType = devset.Get_RFDoorCAM_Info();
        if (DoorCamType[1] == 54) {
            UksAPI mUksAPI = this.Get_UksController();
            if (mUksAPI == null) return 0;
            int nResult = mUksAPI.SetDoorOpen();
            Log.i((String)TAG, (String)("[SetDoorLock_Open] UKS nResult [" + nResult + "]"));
            if (0 <= nResult) {
                Log.i((String)TAG, (String)"[SetDoorLock_Open] UKS Door open success!!");
                return nResult;
            }
            Log.w((String)TAG, (String)"[SetDoorLock_Open] UKS Door open fail!!");
            return -107;
        }
        int ret = this.DeviceIOControl("DEVIOCTR;RFDOORLOCKCMD;1");
        if (ret >= 0) return 0;
        Log.e((String)TAG, (String)("[SetDoorLock_Open] mModelType = Other  Error (ret:" + ret + ")"));
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int SetDoorLock_Open_ForRFCamera() {
        if (Version.getGatewayUsage()) {
            WallpadDeviceSet devset = new WallpadDeviceSet(this.mContext);
            int[] Doorinfo = devset.Get_DoorLock_Info();
            devset.closeDB();
            if (Doorinfo == null) {
                Log.w((String)TAG, (String)"[SetDoorLock_Open] Doorinfo - null");
                return -101;
            }
            if (Doorinfo.length < 2) {
                Log.w((String)TAG, (String)("[SetDoorLock_Open] Doorinfo length Error - Len:" + Doorinfo.length));
                return -102;
            }
            if (Doorinfo[0] == 0) {
                Log.w((String)TAG, (String)"[SetDoorLock_Open] Doorinfo UnUsed !!!");
                return -103;
            }
            if (Doorinfo[1] == 31) return 0;
            if (Doorinfo[1] == 32) {
                if (this.mModelType == 11100) {
                    IGW200dAPI iGW200dAPI = null;
                    iGW200dAPI = this.Get_IGW200dController();
                    if (iGW200dAPI == null) {
                        Log.w((String)TAG, (String)"[SetDoorLock_Open] Get_IGW200dController - null");
                        return -105;
                    }
                    int ret = iGW200dAPI.SetWddrCont(true);
                    if (ret >= 0) return 0;
                    Log.e((String)TAG, (String)("[SetDoorLock_Open] iGW200dAPI.SetWddrCont(true)  Error (" + ret + ")   ErrorCode = " + iGW200dAPI.ErrorCode.ErrStr()));
                    return ret;
                }
                if (this.mModelType != 31100 && this.mModelType != 31500 && this.mModelType != 31170 && this.mModelType != 31570 && this.mModelType != 31120 && this.mModelType != 31520) return 0;
                IGW300API iGW300API = null;
                iGW300API = this.Get_IGW300Controller();
                if (iGW300API == null) {
                    Log.w((String)TAG, (String)"[SetDoorLock_Open] Get_IGW300Controller - null");
                    return -106;
                }
                int ret = iGW300API.SetWddrCont(true);
                if (ret >= 0) return 0;
                Log.e((String)TAG, (String)("[SetDoorLock_Open] iGW300API.SetWddrCont(true)  Error (" + ret + ")   ErrorCode = " + iGW300API.ErrorCode.ErrStr()));
                return ret;
            }
            Log.e((String)TAG, (String)("[SetDoorLock_Open] DoorLock Type Error (Type:" + Doorinfo[1] + ")"));
            return -107;
        }
        int ret = this.DeviceIOControl("DEVIOCTR;RFDOORLOCKCMD;1");
        if (ret >= 0) return 0;
        Log.e((String)TAG, (String)("[SetDoorLock_Open] mModelType = Other  Error (ret:" + ret + ")"));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int SetDoorLock_RfReg() {
        if (!Version.getGatewayUsage()) {
            int ret = this.DeviceIOControl("DEVIOCTR;RFDOORLOCKCMD;0");
            if (ret >= 0) return 0;
            Log.e((String)TAG, (String)("[SetDoorLock_RfReg] mModelType = Other  Error (ret:" + ret + ")"));
            return ret;
        }
        WallpadDeviceSet devset = new WallpadDeviceSet(this.mContext);
        int[] Doorinfo = devset.Get_DoorLock_Info();
        devset.closeDB();
        if (Doorinfo == null) {
            Log.w((String)TAG, (String)"[SetDoorLock_RfReg] Doorinfo - null");
            return -101;
        }
        if (Doorinfo.length < 2) {
            Log.w((String)TAG, (String)("[SetDoorLock_RfReg] Doorinfo length Error - Len:" + Doorinfo.length));
            return -102;
        }
        if (Doorinfo[0] == 0) {
            Log.w((String)TAG, (String)"[SetDoorLock_RfReg] Doorinfo UnUsed !!!");
            return -103;
        }
        if (Doorinfo[1] != 32) {
            Log.e((String)TAG, (String)("[SetDoorLock_RfReg] DoorLock Type Error (Type:" + Doorinfo[1] + ")"));
            return -106;
        }
        if (this.getGatewayType() == 200) {
            IGW200dAPI iGW200dAPI = null;
            iGW200dAPI = this.Get_IGW200dController();
            if (iGW200dAPI == null) {
                Log.w((String)TAG, (String)"[SetDoorLock_RfReg] Get_IGW200dController - null");
                return -104;
            }
            int ret = iGW200dAPI.SetWddrCont(false);
            if (ret >= 0) return 0;
            Log.e((String)TAG, (String)("[SetDoorLock_RfReg] iGW200dAPI.SetWddrCont(false)  Error (" + ret + ")   ErrorCode = " + iGW200dAPI.ErrorCode.ErrStr()));
            return ret;
        }
        if (this.getGatewayType() != 300) {
            Log.w((String)TAG, (String)("[SetDoorLock_RfReg] Not supported gateway type -> " + this.getGatewayType()));
            return 0;
        }
        IGW300API iGW300API = null;
        iGW300API = this.Get_IGW300Controller();
        if (iGW300API == null) {
            Log.w((String)TAG, (String)"[SetDoorLock_RfReg] Get_IGW300Controller - null");
            return -105;
        }
        int ret = iGW300API.SetWddrCont(false);
        if (ret >= 0) return 0;
        Log.e((String)TAG, (String)("[SetDoorLock_RfReg] iGW300API.SetWddrCont(false)  Error (" + ret + ")   ErrorCode = " + iGW300API.ErrorCode.ErrStr()));
        return ret;
    }

    private int DeviceIOControl(String cmd) {
        try {
            if (this.SvcCon.devctrcmd == null) {
                return -1;
            }
            this.SvcCon.devctrcmd.Control_Device(cmd);
        }
        catch (RemoteException e) {
            LogUtil.errorLogInfo("", TAG, e);
            return -1;
        }
        return 0;
    }

    private void sendBRRFDoorlockOpen() {
        try {
            Intent mIntent = new Intent();
            mIntent.setAction("WALLPAD_NOTIFY");
            mIntent.putExtra("KIND", 1081);
            this.mContext.sendBroadcast(mIntent);
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
        }
        catch (Exception e) {
            LogUtil.errorLogInfo("", TAG, e);
        }
    }

    public PurityAPI Get_PurityController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new PurityAPI(this.SvcCon.devctrcmd);
    }

    public SystemAirconAPI Get_AirconController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new SystemAirconAPI(this.SvcCon.devctrcmd);
    }

    public LouverAPI Get_LouverController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new LouverAPI(this.SvcCon.devctrcmd);
    }

    public VentiAPI Get_VentiController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new VentiAPI(this.SvcCon.devctrcmd);
    }

    public KnxVentiAPI Get_KnxVentiController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new KnxVentiAPI(this.SvcCon.devctrcmd);
    }

    public GasAPI Get_GasController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new GasAPI(this.SvcCon.devctrcmd);
    }

    public LightAPI Get_LightController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new LightAPI(this.SvcCon.devctrcmd);
    }

    public AllLightAPI Get_AllLightController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new AllLightAPI(this.SvcCon.devctrcmd);
    }

    public PhonNRemocon Get_PhonNRemoconController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new PhonNRemocon(this.SvcCon.devctrcmd);
    }

    public MultiSwitchAPI Get_MultiSwitchController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new MultiSwitchAPI(this.SvcCon.devctrcmd);
    }

    public RFDoorCamAPI Get_RFDoorCamController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new RFDoorCamAPI(this.SvcCon.devctrcmd);
    }

    public RealTimeMeterAPI Get_RealTimeMeterController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new RealTimeMeterAPI(this.SvcCon.devctrcmd);
    }

    public IGW200dAPI Get_IGW200dController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new IGW200dAPI(this.SvcCon.devctrcmd);
    }

    public IGW300API Get_IGW300Controller() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new IGW300API(this.SvcCon.devctrcmd);
    }

    public IntLightAPI Get_IntLightController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new IntLightAPI(this.SvcCon.devctrcmd);
    }

    public AllLightHDCAPI Get_AllLightHDCController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new AllLightHDCAPI(this.SvcCon.devctrcmd);
    }

    public EnergyModuleAPI Get_EnergyModuleController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new EnergyModuleAPI(this.SvcCon.devctrcmd);
    }

    public CutOffConcentAPI Get_CutOffConcentController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new CutOffConcentAPI(this.SvcCon.devctrcmd);
    }

    public EnergyMeterAPI Get_EnergyMeterController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new EnergyMeterAPI(this.SvcCon.devctrcmd);
    }

    public HeatingV1API Get_HeatingV1Controller() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new HeatingV1API(this.SvcCon.devctrcmd);
    }

    public HeatingV2API Get_HeatingV2Controller() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new HeatingV2API(this.SvcCon.devctrcmd);
    }

    public SmartSwitchEvtAPI Get_SmartSwitchEvtController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new SmartSwitchEvtAPI(this.SvcCon.devctrcmd);
    }

    public SmartSwitchPolAPI Get_SmartSwitchPolController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new SmartSwitchPolAPI(this.SvcCon.devctrcmd);
    }

    public SmartKeyRfDoorAPI Get_SmartKeyRfDoorController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new SmartKeyRfDoorAPI(this.SvcCon.devctrcmd);
    }

    public DLockAPI Get_DLockController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new DLockAPI(this.SvcCon.devctrcmd);
    }

    public FP_DlockAPI Get_FP_DLockController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new FP_DlockAPI(this.SvcCon.devctrcmd);
    }

    public LedDimmingKCC_API Get_KCCDimmingController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new LedDimmingKCC_API(this.SvcCon.devctrcmd);
    }

    public UksAPI Get_UksController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new UksAPI(this.SvcCon.devctrcmd);
    }

    public SdbAPI Get_SdbController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new SdbAPI(this.SvcCon.devctrcmd);
    }

    public Sdb_LivingRoomLightAPI Get_Sdb_LivingRoomLightAPI() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new Sdb_LivingRoomLightAPI(this.SvcCon.devctrcmd);
    }

    public KnxAPI Get_KnxController() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new KnxAPI(this.SvcCon.devctrcmd);
    }

    public Knx_LivingRoomLightAPI Get_Knx_LivingRoomLightAPI() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new Knx_LivingRoomLightAPI(this.SvcCon.devctrcmd);
    }

    public AirQualitySensorAPI Get_SensorAp_API() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new AirQualitySensorAPI(this.SvcCon.devctrcmd);
    }

    public InRoomDetectSensor_API Get_InRoomDetectSensor_API() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new InRoomDetectSensor_API(this.SvcCon.devctrcmd);
    }

    public ElectricRange_API Get_ElectricRange_API() {
        if (this.SvcCon.devctrcmd == null) {
            return null;
        }
        return new ElectricRange_API(this.SvcCon.devctrcmd);
    }

    public int DeviceBatchControl(int DevType, boolean OnOff) {
        String Tag;
        block48: {
            Tag = "DeviceAllControl";
            Log.d((String)Tag, (String)("DeviceAllControl Start (DevType:" + DevType + " , OnOff:" + OnOff + ")"));
            if (this.SvcCon.devctrcmd == null) {
                Log.w((String)Tag, (String)"SvcCon.devctrcmd is null !!!");
                return -100;
            }
            switch (DevType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    Log.w((String)Tag, (String)("Input Param [DevType] is Out of Range !!! (DevType:" + DevType + ")"));
                    return -101;
                }
            }
            try {
                byte i;
                int ret = -1;
                if (DevType == 0) {
                    return this.SetBatchSwitchStatus(OnOff);
                }
                if (DevType == 1) {
                    int DeviceKind = this.GetHeatingKind();
                    if (DeviceKind == 1) {
                        HeatingV1API heatingV1API = this.Get_HeatingV1Controller();
                        ret = heatingV1API.SetPause(OnOff);
                        if (ret < 0) {
                            Log.e((String)Tag, (String)("heatingV1API.SetPause Error (" + ret + ")   ErrorCode = " + heatingV1API.ErrorCode.ErrStr()));
                            return ret;
                        }
                        break block48;
                    }
                    if (DeviceKind == 2) {
                        HeatingV2API heatingV2API = this.Get_HeatingV2Controller();
                        if (heatingV2API == null) {
                            Log.w((String)Tag, (String)"Get_HeatingV2Controller  is  null");
                            return -1003;
                        }
                        byte ChangeMode = DataClasses.HeatingV2.MODE.Idle;
                        if (heatingV2API.data.Device.info.Support.Pause) {
                            ChangeMode = OnOff ? DataClasses.HeatingV2.MODE.Pause : DataClasses.HeatingV2.MODE.PauseRelease;
                        } else if (heatingV2API.data.Device.info.Support.Outing) {
                            ChangeMode = OnOff ? DataClasses.HeatingV2.MODE.Outing : DataClasses.HeatingV2.MODE.OutingRelease;
                        }
                        if (ChangeMode != DataClasses.HeatingV2.MODE.Idle && (ret = heatingV2API.SetAllRoomStatus(ChangeMode)) < 0) {
                            Log.e((String)Tag, (String)("heatingV2API.SetAllRoomStatus Error (" + ret + ")   ErrorCode = " + heatingV2API.ErrorCode.ErrStr()));
                            return ret;
                        }
                        break block48;
                    }
                    return -1001;
                }
                if (DevType == 2) {
                    GasAPI gasAPI = null;
                    gasAPI = this.Get_GasController();
                    if (gasAPI == null) {
                        Log.w((String)Tag, (String)"Get_GasController - null");
                        return -1000;
                    }
                    int Ret = gasAPI.SetClose((byte)-1);
                    if (Ret < 0) {
                        Log.e((String)Tag, (String)("gasAPI.SetClose Error (" + ret + ")   ErrorCode = " + gasAPI.ErrorCode.ErrStr()));
                        return ret;
                    }
                    break block48;
                }
                if (DevType == 3) {
                    WallpadDeviceSet wds = new WallpadDeviceSet(this.mContext);
                    int nDistributionPanelType = wds.Get_DistributionPannelType_Info();
                    wds.closeDB();
                    if (nDistributionPanelType == 2) {
                        KnxVentiAPI ventiAPI = null;
                        ventiAPI = this.Get_KnxVentiController();
                        if (ventiAPI == null) {
                            Log.w((String)Tag, (String)"Get_KnxVentiController() - null");
                            return -1000;
                        }
                        for (int i2 = 0; i2 < 3; ++i2) {
                            ret = ventiAPI.SetOnOff((byte)i2, OnOff);
                            if (ret >= 0) continue;
                            Log.e((String)TAG, (String)("ventiAPI.SetOnOff(" + OnOff + ") Error (" + ret + ")   ErrorCode = " + ventiAPI.ErrorCode.ErrStr()));
                        }
                    } else {
                        VentiAPI ventiAPI = null;
                        ventiAPI = this.Get_VentiController();
                        if (ventiAPI == null) {
                            Log.w((String)Tag, (String)"Get_VentiController() - null");
                            return -1000;
                        }
                        ret = ventiAPI.SetOnOff(OnOff);
                        if (ret < 0) {
                            Log.e((String)Tag, (String)("ventiAPI.SetOnOff(" + OnOff + ") Error (" + ret + ")   ErrorCode = " + ventiAPI.ErrorCode.ErrStr()));
                            return ret;
                        }
                    }
                    break block48;
                }
                if (DevType == 5) {
                    KnxVentiAPI ventiAPI = null;
                    ventiAPI = this.Get_KnxVentiController();
                    if (ventiAPI == null) {
                        Log.w((String)Tag, (String)"Get_VentiController() - null");
                        return -1000;
                    }
                    ret = ventiAPI.SetOnOff(OnOff);
                    if (ret < 0) {
                        Log.e((String)Tag, (String)("ventiAPI.SetOnOff(" + OnOff + ") Error (" + ret + ")   ErrorCode = " + ventiAPI.ErrorCode.ErrStr()));
                        return ret;
                    }
                    break block48;
                }
                if (DevType != 4) break block48;
                boolean livingLightOn = false;
                boolean hallwayLightOn = false;
                boolean kitchenlightOn = false;
                try {
                    String[] lights;
                    WallpadStatusData wsd = new WallpadStatusData(this.mContext);
                    String welcomeStr = wsd.Get_WelcomeLight_Selected();
                    wsd.closeDB();
                    if (welcomeStr != null && (lights = welcomeStr.split("/")).length == 3) {
                        if (lights[0].equals("1")) {
                            Log.d((String)TAG, (String)"[DeviceBatchControl] - livingLight On !!!");
                            livingLightOn = true;
                        } else {
                            Log.d((String)TAG, (String)"[DeviceBatchControl] - livingLight Off !!!");
                        }
                        if (lights[1].equals("1")) {
                            Log.d((String)TAG, (String)"[DeviceBatchControl] - hallwayLightOn On !!!");
                            hallwayLightOn = true;
                        } else {
                            Log.d((String)TAG, (String)"[DeviceBatchControl] - hallwayLightOn Off !!!");
                        }
                        if (lights[2].equals("1")) {
                            Log.d((String)TAG, (String)"[DeviceBatchControl] - kitchenlightOn On !!!");
                            kitchenlightOn = true;
                        } else {
                            Log.d((String)TAG, (String)"[DeviceBatchControl] - kitchenlightOn Off !!!");
                        }
                    }
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    return -103;
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"[DeviceBatchControl] - Get WelcomeLight Selected FAIL !!!");
                    LogUtil.errorLogInfo("", TAG, ex);
                    return -103;
                }
                SdbAPI sdbAPI = null;
                Sdb_LivingRoomLightAPI sdb_livingRoomLightAPI = null;
                sdbAPI = this.Get_SdbController();
                sdb_livingRoomLightAPI = this.Get_Sdb_LivingRoomLightAPI();
                if (sdb_livingRoomLightAPI == null) {
                    Log.w((String)Tag, (String)"[DeviceBatchControl] - Get_Sdb_LivingRoomLightAPI() - null");
                    return -1001;
                }
                sdb_livingRoomLightAPI.Refresh();
                if (sdb_livingRoomLightAPI.data.Info.LightCount != 0 && livingLightOn) {
                    byte livIndex = 0;
                    for (i = 0; i < sdb_livingRoomLightAPI.data.Info.LightCount; i = (byte)(i + 1)) {
                        if (sdb_livingRoomLightAPI.data.Data.LedLight[i].Info.Code.Usage != Sdb_DataClasses.LEDLIGHT_USAGE_CODE.LIVINGROOM) continue;
                        livIndex = i;
                        Log.d((String)TAG, (String)("[DeviceBatchControl] - livIndex : " + livIndex));
                        break;
                    }
                    if ((ret = sdb_livingRoomLightAPI.SetLightOnOff(livIndex, true)) < 0) {
                        Log.e((String)Tag, (String)("[DeviceBatchControl] - sdb_livingRoomLightAPI.SetLightOnOff(" + OnOff + ") Error (" + ret + ")   ErrorCode = " + sdb_livingRoomLightAPI.ErrorCode.ErrStr()));
                        return ret;
                    }
                }
                if (sdb_livingRoomLightAPI.data.Info.LightGroup.Exist_Hallway && hallwayLightOn && sdb_livingRoomLightAPI.data.Info.LightCount != 0) {
                    byte hallwayIndex = 0;
                    for (i = 0; i < sdb_livingRoomLightAPI.data.Info.LightCount; i = (byte)(i + 1)) {
                        if (sdb_livingRoomLightAPI.data.Data.LedLight[i].Info.Code.Usage != Sdb_DataClasses.LEDLIGHT_USAGE_CODE.HALLWAY) continue;
                        hallwayIndex = i;
                        Log.d((String)TAG, (String)("[DeviceBatchControl] - hallwayIndex : " + hallwayIndex));
                        break;
                    }
                    if ((ret = sdb_livingRoomLightAPI.SetLightOnOff(hallwayIndex, true)) < 0) {
                        Log.e((String)Tag, (String)("[DeviceBatchControl] - sdb_livingRoomLightAPI.SetLightOnOff(" + OnOff + ") Error (" + ret + ")   ErrorCode = " + sdb_livingRoomLightAPI.ErrorCode.ErrStr()));
                        return ret;
                    }
                }
                sdbAPI.Refresh((byte)-1, (byte)-1);
                if (sdbAPI.data.BadRoom_EnergyMeter[0].Info.LightCount != 0 && kitchenlightOn && (ret = sdbAPI.SetLightOnOff((byte)0, (byte)-1, true)) < 0) {
                    Log.e((String)Tag, (String)("[DeviceBatchControl] - sdbAPI.SetLightOnOff(" + OnOff + ") Error (" + ret + ")   ErrorCode = " + sdbAPI.ErrorCode.ErrStr()));
                    return ret;
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                return -102;
            }
            catch (Exception e) {
                Log.e((String)Tag, (String)"[Exception Error] !!!!!");
                LogUtil.errorLogInfo("", TAG, e);
                return -102;
            }
        }
        Log.d((String)Tag, (String)"DeviceAllControl OK!!!");
        return 0;
    }

    public int SetAutoIGALStatusClear(boolean OnOff) {
        Log.d((String)TAG, (String)("[SetAutoIGALStatusClear] ALL SET START (" + OnOff + ")"));
        if (this.mModelType != 11100 && this.mModelType != 31120 && this.mModelType != 31520) {
            Log.w((String)TAG, (String)("[SetAutoIGALStatusClear] Not Support ModelType : " + this.mModelType));
            return -1;
        }
        int onoff = 0;
        if (OnOff) {
            onoff = 1;
        }
        int ret = -1;
        Log.d((String)TAG, (String)("[SetAutoIGALStatusClear] ENERGYMETER SET : " + OnOff));
        ret = this.SendNReadCMD_int("ENERGYMETER", "SINKCTRL", "SetAutoIGALStatusClear", onoff, 0, 0, 0, 0);
        Log.d((String)TAG, (String)("[SetAutoIGALStatusClear] INTLIGHT SET : " + OnOff));
        ret = this.SendNReadCMD_int("INTLIGHT", "SINKCTRL", "SetAutoIGALStatusClear", onoff, 0, 0, 0, 0);
        if (ret < 0) {
            Log.e((String)TAG, (String)("[SetAutoIGALStatusClear] INTLIGHT SET Error (ret : " + ret + ")"));
            return ret;
        }
        Log.d((String)TAG, (String)"[SetAutoIGALStatusClear] ALL SET OK!!!");
        return 0;
    }

    public boolean GetAutoIGALStatusClear() {
        Log.d((String)TAG, (String)"[GetAutoIGALStatusClear] START ()");
        if (this.mModelType != 11100) {
            Log.w((String)TAG, (String)("[GetAutoIGALStatusClear] Not Support ModelType : " + this.mModelType));
            return false;
        }
        int EnergyMeterRet = -1;
        Log.d((String)TAG, (String)"[GetAutoIGALStatusClear] ENERGYMETER");
        EnergyMeterRet = this.SendNReadCMD_int("ENERGYMETER", "SINKCTRL", "GetAutoIGALStatusClear", 0, 0, 0, 0, 0);
        if (EnergyMeterRet < 0) {
            Log.e((String)TAG, (String)("[GetAutoIGALStatusClear] ENERGYMETER SET Error (ret : " + EnergyMeterRet + ")"));
            return false;
        }
        Log.d((String)TAG, (String)("[GetAutoIGALStatusClear] ENERGYMETER - (EnergyMeterRet:" + EnergyMeterRet + ")"));
        Log.d((String)TAG, (String)"[GetAutoIGALStatusClear] INTLIGHT");
        int IntLightRet = this.SendNReadCMD_int("INTLIGHT", "SINKCTRL", "GetAutoIGALStatusClear", 0, 0, 0, 0, 0);
        if (IntLightRet < 0) {
            Log.e((String)TAG, (String)("[GetAutoIGALStatusClear] INTLIGHT SET Error (ret : " + IntLightRet + ")"));
            return false;
        }
        Log.d((String)TAG, (String)("[GetAutoIGALStatusClear] INTLIGHT - (IntLightRet:" + IntLightRet + ")"));
        boolean bRet = false;
        if (EnergyMeterRet != 0 && IntLightRet != 0) {
            bRet = true;
        }
        Log.d((String)TAG, (String)("[GetAutoIGALStatusClear] OK!!! - " + bRet));
        return bRet;
    }

    public int GetHeatingKind() {
        String FUNC_NAME = "[GetHeatingKind]";
        try {
            int DeviceKind;
            String ret = this.SendNReadCMD_str("HEATINGFINDER", "NOSINKCTRL", "Refresh", 0, 0, 0, 0, 0);
            if (ret == null) {
                Log.w((String)TAG, (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            if (retData == null) {
                Log.w((String)TAG, (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)TAG, (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)TAG, (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            int index = 1;
            if ((DeviceKind = Integer.parseInt(retData[index++])) == 10001) {
                return 1;
            }
            if (DeviceKind == 10002) {
                return 2;
            }
            Log.w((String)TAG, (String)("[GetHeatingKind] DeviceKind  Out Of Range (DeviceKind:" + DeviceKind + ")"));
            return -108;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100000;
        }
        catch (Exception e) {
            Log.e((String)"WallPadDevAPI", (String)"[GetHeatingKind] Exception Error - ()");
            LogUtil.errorLogInfo("", TAG, e);
            return -100000;
        }
    }

    public boolean SetLivingLightDelayedBlink(int Count, long DelayMs) {
        Log.i((String)TAG, (String)("[SetLivingLightDelayedBlink] Count : " + Count + ", DelayMs : " + DelayMs));
        if (Count <= 0 || Count > 10) {
            Log.w((String)TAG, (String)("[SetLivingLightDelayedBlink] Param : Count . Out Of Range !!!(Count:" + Count + ")"));
            return false;
        }
        if (DelayMs < 100L || DelayMs > 10000L) {
            Log.w((String)TAG, (String)("[SetLivingLightDelayedBlink] Param : DelayMs . Out Of Range !!!(DelayMs:" + DelayMs + ")"));
            return false;
        }
        if (this.mModelType != 11100) {
            if (this.mModelType == 11110) {
                if (this.mLivingLightDelayedBlink != null && this.mLivingLightDelayedBlink.isRun()) {
                    Log.w((String)TAG, (String)"[SetLivingLightDelayedBlink] isRun...");
                    return false;
                }
                int LivingLightType = 0;
                try {
                    int[] Get_Light_info = null;
                    try {
                        WallpadDeviceSet wallpadDeviceSet = new WallpadDeviceSet(this.mContext);
                        Get_Light_info = wallpadDeviceSet.Get_Light_info();
                        wallpadDeviceSet.closeDB();
                    }
                    catch (RuntimeException re) {
                        LogUtil.errorLogInfo("", TAG, re);
                        return false;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"[SetLivingLightDelayedBlink] Exception Error(DB : Open-Get-Close)");
                        LogUtil.errorLogInfo("", TAG, e);
                        return false;
                    }
                    if (Get_Light_info == null) {
                        return false;
                    }
                    if (Get_Light_info[0] == 0) {
                        Log.w((String)TAG, (String)"[SetLivingLightDelayedBlink] LivingLight Not Setting !!!");
                        return false;
                    }
                    LivingLightType = Get_Light_info[1];
                    switch (LivingLightType) {
                        case 11: {
                            break;
                        }
                        case 12: {
                            break;
                        }
                        default: {
                            Log.w((String)TAG, (String)"[SetLivingLightDelayedBlink] Get_Light_info[1] Type Out Of Range !!!");
                            return false;
                        }
                    }
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    return false;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"[SetLivingLightDelayedBlink] Exception Error(Get DB)");
                    LogUtil.errorLogInfo("", TAG, e);
                    return false;
                }
                this.mLivingLightDelayedBlink = new LivingLightDelayedBlink(LivingLightType, Count, DelayMs);
                return true;
            }
            if (this.mModelType == 11120 || this.mModelType == 11130) {
                // empty if block
            }
        }
        Log.w((String)TAG, (String)("[SetLivingLightDelayedBlink] Not Support Model : " + Version.getModelType()));
        return false;
    }

    protected int SendNReadCMD_int(String TitleStr, String MainCMD, String SubCMD, int param1, int param2, int param3, int param4, int param5) {
        if (MainCMD == null) {
            return -1;
        }
        if (SubCMD == null) {
            return -2;
        }
        String CmdStr = String.format("%s;%s;%s:%d:%d:%d:%d:%d", TitleStr, MainCMD, SubCMD, param1, param2, param3, param4, param5);
        try {
            String ret = this.SendCMD(CmdStr);
            String[] retlist = ret.split(";");
            if (retlist == null) {
                return -101;
            }
            if (retlist[0].equals("SUCCESS")) {
                if (retlist.length == 1) {
                    return 0;
                }
                return Integer.parseInt(retlist[1]);
            }
            if (retlist.length >= 2) {
                return Integer.parseInt(retlist[1]);
            }
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_int] Error : " + retlist[0]));
            return -101;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -1;
        }
        catch (Exception e) {
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_int] Exception Error - (" + CmdStr + ")"));
            LogUtil.errorLogInfo("", TAG, e);
            return -1;
        }
    }

    protected String SendNReadCMD_str(String TitleStr, String MainCMD, String SubCMD, int param1, int param2, int param3, int param4, int param5) {
        String CmdStr = String.format("%s;%s;%s:%d:%d:%d:%d:%d", TitleStr, MainCMD, SubCMD, param1, param2, param3, param4, param5);
        try {
            String ret = this.SendCMD(CmdStr);
            return ret;
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return null;
        }
        catch (Exception e) {
            Log.e((String)"WallPadDevAPI", (String)("[SendNReadCMD_str] Exception Error - (" + CmdStr + ")"));
            LogUtil.errorLogInfo("", TAG, e);
            return null;
        }
    }

    private String SendCMD(String CMD) {
        String ret;
        Log.d((String)"AIDLTEST", (String)("Enter SendCMD " + CMD));
        try {
            Log.i((String)"AIDLTEST", (String)(" before call AIDL [" + CMD + "] " + this.SvcCon.devctrcmd));
            if (this.SvcCon.devctrcmd == null) {
                return "FAIL;-1000";
            }
            ret = this.SvcCon.devctrcmd.Control_Device(CMD);
        }
        catch (RemoteException e) {
            Log.e((String)"AIDLTEST", (String)"Catch Exception Afer Send Data to Service");
            LogUtil.errorLogInfo("", TAG, e);
            return "EXCEPTION";
        }
        return ret;
    }

    public void BroadcastNotiCount(Context ctx, String action, String extra, int count) {
        Intent intentBR = new Intent();
        intentBR.setAction(action);
        intentBR.putExtra(extra, count);
        ctx.sendBroadcast(intentBR);
    }

    private class LivingLightDelayedBlink {
        private final int STOP = 0;
        private final int START = 1;
        private final int ING = 2;
        private boolean Run = false;
        private boolean FirstLightStatus = false;
        private boolean LightStatus = false;
        private int RunCount = 0;
        private int BlinkCount;
        private long BlinkDelayMs;
        private Handler BlinkHandler;
        private LightAPI lightAPI;
        private MultiSwitchAPI multiSwitchAPI;

        private LivingLightDelayedBlink(int nLightType, int nCount, long nDelayMs) {
            this.BlinkCount = nCount;
            this.BlinkDelayMs = nDelayMs;
            this.LoadingDriver(nLightType);
            this.BlinkHandler = new Handler(){

                @SuppressLint(value={"HandlerLeak"})
                public void handleMessage(Message msg) {
                    boolean bRet = false;
                    switch (msg.what) {
                        case 0: {
                            if (LivingLightDelayedBlink.this.getLight() != LivingLightDelayedBlink.this.FirstLightStatus) {
                                LivingLightDelayedBlink.this.setLight(LivingLightDelayedBlink.this.FirstLightStatus);
                            }
                            LivingLightDelayedBlink.this.Run = false;
                            break;
                        }
                        case 1: {
                            LivingLightDelayedBlink.this.Run = true;
                            LivingLightDelayedBlink.this.FirstLightStatus = LivingLightDelayedBlink.this.getLight();
                            LivingLightDelayedBlink.this.LightStatus = LivingLightDelayedBlink.this.FirstLightStatus;
                            Log.i((String)WallPadAPI.TAG, (String)("[LivingLightDelayedBlink] START - FirstLightStatus : " + LivingLightDelayedBlink.this.FirstLightStatus));
                            if (LivingLightDelayedBlink.this.LightStatus) {
                                LivingLightDelayedBlink.this.LightStatus = false;
                            } else {
                                LivingLightDelayedBlink.this.LightStatus = true;
                            }
                            bRet = LivingLightDelayedBlink.this.setLight(LivingLightDelayedBlink.this.LightStatus);
                            Log.i((String)WallPadAPI.TAG, (String)("LivingLightDelayedBlink] START - setLight:" + bRet));
                            LivingLightDelayedBlink.this.RunCount++;
                            if (LivingLightDelayedBlink.this.BlinkCount > 1) {
                                this.sendEmptyMessageDelayed(2, LivingLightDelayedBlink.this.BlinkDelayMs);
                                break;
                            }
                            this.sendEmptyMessageDelayed(0, LivingLightDelayedBlink.this.BlinkDelayMs);
                            break;
                        }
                        case 2: {
                            if (LivingLightDelayedBlink.this.LightStatus) {
                                LivingLightDelayedBlink.this.LightStatus = false;
                            } else {
                                LivingLightDelayedBlink.this.LightStatus = true;
                            }
                            Log.i((String)WallPadAPI.TAG, (String)("[LivingLightDelayedBlink] ING - LightStatus : " + LivingLightDelayedBlink.this.LightStatus));
                            bRet = LivingLightDelayedBlink.this.setLight(LivingLightDelayedBlink.this.LightStatus);
                            Log.i((String)WallPadAPI.TAG, (String)("LivingLightDelayedBlink] ING - setLight:" + bRet + ", RunCount : " + LivingLightDelayedBlink.this.RunCount));
                            if (LivingLightDelayedBlink.this.FirstLightStatus != LivingLightDelayedBlink.this.LightStatus) {
                                LivingLightDelayedBlink.this.RunCount++;
                                if (LivingLightDelayedBlink.this.RunCount >= LivingLightDelayedBlink.this.BlinkCount) {
                                    this.sendEmptyMessageDelayed(0, LivingLightDelayedBlink.this.BlinkDelayMs);
                                    break;
                                }
                                this.sendEmptyMessageDelayed(2, LivingLightDelayedBlink.this.BlinkDelayMs);
                                break;
                            }
                            this.sendEmptyMessageDelayed(2, LivingLightDelayedBlink.this.BlinkDelayMs);
                        }
                    }
                }
            };
            this.BlinkHandler.sendEmptyMessage(1);
        }

        public boolean isRun() {
            return this.Run;
        }

        private void LoadingDriver(int LightType) {
            this.lightAPI = null;
            this.multiSwitchAPI = null;
            switch (LightType) {
                case 11: {
                    this.lightAPI = WallPadAPI.this.Get_LightController();
                    break;
                }
                case 12: {
                    this.multiSwitchAPI = WallPadAPI.this.Get_MultiSwitchController();
                    break;
                }
                default: {
                    Log.w((String)WallPadAPI.TAG, (String)("LoadingDriver - Param : LightType Out Of Range !!!(LightType:" + LightType));
                }
            }
        }

        private boolean setLight(boolean OnOff) {
            if (this.lightAPI != null) {
                int ret = this.lightAPI.SetLightOnOff((byte)-1, OnOff);
                return ret >= 0;
            }
            if (this.multiSwitchAPI != null) {
                int ret = this.multiSwitchAPI.SetLightOnOff((byte)0, (byte)-1, OnOff);
                return ret >= 0;
            }
            return false;
        }

        private boolean getLight() {
            if (this.lightAPI != null) {
                this.lightAPI.Refresh(false);
                for (int i = 0; i < this.lightAPI.data.LightCount; ++i) {
                    if (!this.lightAPI.data.OnOff[i]) continue;
                    return true;
                }
                return false;
            }
            if (this.multiSwitchAPI != null) {
                this.multiSwitchAPI.Refresh((byte)0, false);
                if (this.multiSwitchAPI.data.DeviceCnt == 0) {
                    return false;
                }
                if (this.multiSwitchAPI.data.Device == null) {
                    return false;
                }
                for (int i = 0; i < this.multiSwitchAPI.data.Device[0].device.LightCount; ++i) {
                    if (!this.multiSwitchAPI.data.Device[0].device.GetLightOnOff(i)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static final class DEV_BATCH_CTRL__TYPE {
        public static final int ALL_LIGHT = 0;
        public static final int HEATING = 1;
        public static final int GAS = 2;
        public static final int VENTI = 3;
        public static final int WELCOME_LIGHT = 4;
        public static final int KNX_VENTI = 5;
    }
}

