/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.util.Pair;
import ceres.utils.CustomDistribution;
import ceres.utils.PreferencesWrapper;
import ceres.utils.printlog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;

public class CollectLogs {
    private static final Object LINE_SEPARATOR = "\n";
    private static final String THIS_FILE = "Collect Logs";

    public static final Pair<StringBuilder, File> getLogs() {
        StringBuilder log = new StringBuilder();
        File outFile = null;
        try {
            String line;
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add("logcat");
            File dir = PreferencesWrapper.getLogsFolder();
            if (dir != null) {
                Date d = new Date();
                outFile = new File(dir.getAbsoluteFile() + File.separator + "logs_" + DateFormat.format((CharSequence)"MM-dd-yy_kkmmss", (Date)d) + ".txt");
                commandLine.add("-f");
                commandLine.add(outFile.getAbsolutePath());
                printlog.d(THIS_FILE, commandLine.toString());
            }
            commandLine.add("-d");
            commandLine.add("D");
            Process process = Runtime.getRuntime().exec(commandLine.toArray(new String[0]));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                log.append(line);
                log.append(LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            printlog.e(THIS_FILE, "Collect logs failed : ", e);
            log.append("Unable to get logs : " + e.toString());
        }
        return new Pair((Object)log, outFile);
    }

    public static final StringBuilder getDeviceInfo() {
        StringBuilder log = new StringBuilder();
        log.append("Here are important informations about Device : ");
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.BOARD : " + Build.BOARD);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.BRAND : " + Build.BRAND);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.DEVICE : " + Build.DEVICE);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.ID : " + Build.ID);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.MODEL : " + Build.MODEL);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.PRODUCT : " + Build.PRODUCT);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.TAGS : " + Build.TAGS);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.VERSION.INCREMENTAL : " + Build.VERSION.INCREMENTAL);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.VERSION.RELEASE : " + Build.VERSION.RELEASE);
        log.append(LINE_SEPARATOR);
        log.append("android.os.Build.VERSION.SDK : " + Build.VERSION.SDK);
        log.append(LINE_SEPARATOR);
        try {
            log.append("android.os.Build.VERSION.SDK_INT : " + Build.VERSION.SDK_INT);
            log.append(LINE_SEPARATOR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return log;
    }

    public static final String getApplicationInfo(Context ctx) {
        String result = "";
        result = result + "Based on the GPL CSipSimple version : ";
        try {
            PackageInfo pinfo = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            result = result + pinfo.versionName + " r" + pinfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            printlog.e(THIS_FILE, "Impossible to find version of current package !!");
        }
        return result;
    }

    public static Intent getLogReportIntent(String userComment, Context ctx) {
        Pair<StringBuilder, File> logs = CollectLogs.getLogs();
        Intent sendIntent = new Intent("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.SUBJECT", "CSipSimple Error-Log report");
        sendIntent.putExtra("android.intent.extra.EMAIL", new String[]{CustomDistribution.getSupportEmail()});
        sendIntent.setType("text/plain");
        if (logs.second != null) {
            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)((File)logs.second)));
        }
        StringBuilder log = new StringBuilder();
        log.append(userComment);
        log.append(LINE_SEPARATOR);
        log.append(LINE_SEPARATOR);
        log.append(CollectLogs.getApplicationInfo(ctx));
        log.append(LINE_SEPARATOR);
        log.append((CharSequence)CollectLogs.getDeviceInfo());
        log.append(LINE_SEPARATOR);
        log.append((CharSequence)logs.first);
        log.append(LINE_SEPARATOR);
        log.append(LINE_SEPARATOR);
        log.append(userComment);
        sendIntent.putExtra("android.intent.extra.TEXT", log.toString());
        return sendIntent;
    }
}

