/*
 * Decompiled with CFR 0.152.
 */
package ceres.service;

import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import ceres.utils.Ringer;
import ceres.utils.printlog;

public class MediaManager {
    private static final String THIS_FILE = "MediaManager";
    public Context mContext;
    private AudioManager audioManager;
    private Ringer ringer;
    private boolean userWantSpeaker = false;
    private boolean userWantMicrophoneMute = false;
    private Intent mediaStateChangedIntent;
    private static final String ACTION_AUDIO_VOLUME_UPDATE = "org.openintents.audio.action_volume_update";
    private static final String EXTRA_STREAM_TYPE = "org.openintents.audio.extra_stream_type";
    private static final String EXTRA_VOLUME_INDEX = "org.openintents.audio.extra_volume_index";
    private static final String EXTRA_RINGER_MODE = "org.openintents.audio.extra_ringer_mode";
    private static final int EXTRA_VALUE_UNKNOWN = -9999;

    public MediaManager(Context context) {
        this.mContext = context;
        this.audioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.ringer = new Ringer(this.mContext);
    }

    public void startService() {
    }

    public void stopService() {
        printlog.i(THIS_FILE, "Remove media manager....");
    }

    public void startRing(String remoteContact) {
        if (!this.ringer.isRinging()) {
            printlog.d(THIS_FILE, "startRing....");
            this.ringer.ring(remoteContact, "content://settings/system/ringtone");
        } else {
            printlog.d(THIS_FILE, "startRing Already ringing ....");
        }
    }

    public void stopRing() {
        if (this.ringer.isRinging()) {
            printlog.d(THIS_FILE, "stopRing Already ringing ....");
            this.ringer.stopRing();
        }
    }

    public void stopAnnoucing() {
        this.stopRing();
    }

    public void resetSettings() {
        this.userWantMicrophoneMute = false;
        this.userWantSpeaker = false;
    }

    public void toggleMute() {
        this.setMicrophoneMute(!this.userWantMicrophoneMute);
    }

    public synchronized void setMicrophoneMute(boolean on) {
        if (on != this.userWantMicrophoneMute) {
            this.userWantMicrophoneMute = on;
            this.broadcastMediaChanged();
        }
    }

    public synchronized void setSpeakerphoneOn(boolean on) {
        this.audioManager.setSpeakerphoneOn(on);
    }

    public synchronized void setBluetoothOn(boolean on) {
        printlog.d(THIS_FILE, "Set BT " + on);
        this.broadcastMediaChanged();
    }

    public MediaState getMediaState() {
        MediaState mediaState = new MediaState();
        mediaState.isMicrophoneMute = this.userWantMicrophoneMute;
        mediaState.canMicrophoneMute = true;
        mediaState.isSpeakerphoneOn = this.userWantSpeaker;
        mediaState.canSpeakerphoneOn = !mediaState.isBluetoothScoOn;
        return mediaState;
    }

    public void broadcastMediaChanged() {
        this.mContext.sendBroadcast(this.mediaStateChangedIntent);
    }

    private void broadcastVolumeWillBeUpdated(int streamType, int index) {
        Intent notificationIntent = new Intent(ACTION_AUDIO_VOLUME_UPDATE);
        notificationIntent.putExtra(EXTRA_STREAM_TYPE, streamType);
        notificationIntent.putExtra(EXTRA_VOLUME_INDEX, index);
        notificationIntent.putExtra(EXTRA_RINGER_MODE, -9999);
        this.mContext.sendBroadcast(notificationIntent, null);
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        this.broadcastVolumeWillBeUpdated(streamType, index);
        this.audioManager.setStreamVolume(streamType, index, flags);
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        this.broadcastVolumeWillBeUpdated(streamType, -9999);
        this.audioManager.adjustStreamVolume(streamType, direction, flags);
        if (streamType == 2) {
            this.ringer.updateRingerMode();
        }
    }

    public boolean isUserWantMicrophoneMute() {
        return this.userWantMicrophoneMute;
    }

    public class MediaState {
        public boolean isMicrophoneMute = false;
        public boolean isSpeakerphoneOn = false;
        public boolean isBluetoothScoOn = false;
        public boolean canMicrophoneMute = true;
        public boolean canSpeakerphoneOn = true;
        public boolean canBluetoothSco = false;

        public boolean equals(Object o) {
            if (o != null && o.getClass() == MediaState.class) {
                MediaState oState = (MediaState)o;
                return oState.isBluetoothScoOn == this.isBluetoothScoOn && oState.isMicrophoneMute == this.isMicrophoneMute && oState.isSpeakerphoneOn == this.isSpeakerphoneOn && oState.canBluetoothSco == this.canBluetoothSco && oState.canSpeakerphoneOn == this.canSpeakerphoneOn && oState.canMicrophoneMute == this.canMicrophoneMute;
            }
            return super.equals(o);
        }
    }
}

