/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.TextUtils;
import ceres.api.SipConfigManager;
import ceres.utils.Compatibility;
import ceres.utils.CustomDistribution;
import ceres.utils.printlog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PreferencesWrapper {
    public static final String HAS_BEEN_QUIT = "has_been_quit";
    public static final String USER_AGENT = "user_agent";
    public static final String IS_ADVANCED_USER = "is_advanced_user";
    public static final String HAS_ALREADY_SETUP = "has_already_setup";
    public static final String HAS_ALREADY_SETUP_SERVICE = "has_already_setup_service";
    private static final String THIS_FILE = "PreferencesWrapper";
    private SharedPreferences prefs;
    private ConnectivityManager connectivityManager;
    private ContentResolver resolver;
    private static final HashMap<String, String> STRING_PREFS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(PreferencesWrapper.USER_AGENT, CustomDistribution.getUserAgent());
            this.put("log_level", PreferencesWrapper.DTMF_MODE_RTP);
            this.put("use_srtp", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("network_udp_transport_port", "5060");
            this.put("network_tcp_transport_port", "5060");
            this.put("network_tls_transport_port", "5061");
            this.put("keep_alive_interval_wifi", "100");
            this.put("keep_alive_interval_mobile", "40");
            this.put("network_rtp_port", "4000");
            this.put("override_nameserver", "");
            this.put("snd_auto_close_time", PreferencesWrapper.DTMF_MODE_RTP);
            this.put("echo_cancellation_tail", "200");
            this.put("echo_mode", PreferencesWrapper.DTMF_MODE_INBAND);
            this.put("snd_media_quality", "4");
            this.put("snd_clock_rate", "16000");
            this.put("snd_ptime", "20");
            this.put("bits_per_sample", "16");
            this.put("sip_audio_mode", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("thread_count", PreferencesWrapper.DTMF_MODE_INFO);
            this.put("stun_server", "stun.counterpath.com");
            this.put("turn_server", "");
            this.put("tls_method", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("dscp_val", "26");
            this.put("dtmf_mode", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("gsm_integration_type", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("dial_press_tone_mode", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("dial_press_vibrate_mode", PreferencesWrapper.DTMF_MODE_AUTO);
            this.put("default_caller_id", "");
        }
    };
    private static final HashMap<String, Boolean> BOOLEAN_PREFS = new HashMap<String, Boolean>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("lock_wifi", true);
            this.put("enable_tcp", true);
            this.put("enable_udp", true);
            this.put("enable_tls", false);
            this.put("use_ipv6", false);
            this.put("enable_dns_srv", false);
            this.put("enable_ice", false);
            this.put("enable_turn", false);
            this.put("enable_stun", false);
            this.put("enable_qos", false);
            this.put("tls_verify_server", false);
            this.put("use_wifi_in", true);
            this.put("use_wifi_out", true);
            this.put("use_other_in", true);
            this.put("use_other_out", true);
            this.put("use_3g_in", false);
            this.put("use_3g_out", false);
            this.put("use_gprs_in", false);
            this.put("use_gprs_out", false);
            this.put("use_edge_in", false);
            this.put("use_edge_out", false);
            this.put("echo_cancellation", false);
            this.put("enable_vad", false);
            this.put("use_soft_volume", false);
            this.put("use_routing_api", false);
            this.put("use_mode_api", false);
            this.put("has_io_queue", false);
            this.put("set_audio_generate_tone", true);
            this.put("prevent_screen_rotation", true);
            this.put("keep_awake_incall", false);
            this.put("invert_proximity_sensor", false);
            this.put("icon_in_status_bar", true);
            this.put("use_partial_wake_lock", false);
            this.put("auto_record_calls", false);
        }
    };
    private static final HashMap<String, Float> FLOAT_PREFS = new HashMap<String, Float>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("snd_mic_level", Float.valueOf(1.0f));
            this.put("snd_speaker_level", Float.valueOf(1.0f));
        }
    };
    public static final String DTMF_MODE_AUTO = "0";
    public static final String DTMF_MODE_RTP = "1";
    public static final String DTMF_MODE_INBAND = "2";
    public static final String DTMF_MODE_INFO = "3";
    public static final int GSM_TYPE_AUTO = 0;
    public static final int GSM_TYPE_FORCE = 1;
    public static final int GSM_TYPE_PREVENT = 2;
    public static final int HEADSET_ACTION_CLEAR_CALL = 0;
    public static final int HEADSET_ACTION_MUTE = 1;
    public static final int HEADSET_ACTION_HOLD = 2;
    private static String CONFIG_FOLDER = "configs";
    private static String RECORDS_FOLDER = "records";
    private static String LOGS_FOLDER = "logs";

    public PreferencesWrapper(Context aContext) {
        this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)aContext);
        this.connectivityManager = (ConnectivityManager)aContext.getSystemService("connectivity");
        this.resolver = aContext.getContentResolver();
    }

    public void setPreferenceStringValue(String key, String value) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public void setPreferenceBooleanValue(String key, boolean value) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public void setPreferenceFloatValue(String key, float value) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putFloat(key, value);
        editor.commit();
    }

    private static String gPrefStringValue(SharedPreferences aPrefs, String key) {
        if (STRING_PREFS.containsKey(key)) {
            return aPrefs.getString(key, STRING_PREFS.get(key));
        }
        return null;
    }

    private static Boolean gPrefBooleanValue(SharedPreferences aPrefs, String key) {
        if (BOOLEAN_PREFS.containsKey(key)) {
            return aPrefs.getBoolean(key, BOOLEAN_PREFS.get(key).booleanValue());
        }
        return null;
    }

    private static Float gPrefFloatValue(SharedPreferences aPrefs, String key) {
        if (FLOAT_PREFS.containsKey(key)) {
            return Float.valueOf(aPrefs.getFloat(key, FLOAT_PREFS.get(key).floatValue()));
        }
        return null;
    }

    public String getPreferenceStringValue(String key) {
        return PreferencesWrapper.gPrefStringValue(this.prefs, key);
    }

    public Boolean getPreferenceBooleanValue(String key) {
        return PreferencesWrapper.gPrefBooleanValue(this.prefs, key);
    }

    public Float getPreferenceFloatValue(String key) {
        return PreferencesWrapper.gPrefFloatValue(this.prefs, key);
    }

    public int getPreferenceIntegerValue(String key) {
        try {
            return Integer.parseInt(this.getPreferenceStringValue(key));
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "Invalid " + key + " format : expect a int");
            return Integer.parseInt(STRING_PREFS.get(key));
        }
    }

    public void resetAllDefaultValues() {
        for (String key : STRING_PREFS.keySet()) {
            this.setPreferenceStringValue(key, STRING_PREFS.get(key));
        }
        for (String key : BOOLEAN_PREFS.keySet()) {
            this.setPreferenceBooleanValue(key, BOOLEAN_PREFS.get(key));
        }
        for (String key : FLOAT_PREFS.keySet()) {
            this.setPreferenceFloatValue(key, FLOAT_PREFS.get(key).floatValue());
        }
        Compatibility.setFirstRunParameters(this);
    }

    public static boolean isValidWifiConnectionFor(NetworkInfo ni, SharedPreferences aPrefs, String suffix) {
        boolean valid_for_wifi = PreferencesWrapper.gPrefBooleanValue(aPrefs, "use_wifi_" + suffix);
        if (valid_for_wifi && ni != null && ni.getType() == 1) {
            printlog.d(THIS_FILE, "Wifi state is now " + ni.getState().name());
            if (ni.getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMobileConnectionFor(NetworkInfo ni, SharedPreferences aPrefs, String suffix) {
        boolean valid_for_3g = PreferencesWrapper.gPrefBooleanValue(aPrefs, "use_3g_" + suffix);
        boolean valid_for_edge = PreferencesWrapper.gPrefBooleanValue(aPrefs, "use_edge_" + suffix);
        boolean valid_for_gprs = PreferencesWrapper.gPrefBooleanValue(aPrefs, "use_gprs_" + suffix);
        if ((valid_for_3g || valid_for_edge || valid_for_gprs) && ni != null && ni.getType() == 0 && ni.getState() == NetworkInfo.State.CONNECTED) {
            int subType = ni.getSubtype();
            if (valid_for_3g && subType >= 3) {
                return true;
            }
            if (valid_for_gprs && (subType == 1 || subType == 0)) {
                return true;
            }
            if (valid_for_edge && subType == 2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidOtherConnectionFor(NetworkInfo ni, SharedPreferences aPrefs, String suffix) {
        boolean valid_for_other = PreferencesWrapper.gPrefBooleanValue(aPrefs, "use_other_" + suffix);
        return valid_for_other && ni != null && ni.getType() != 0 && ni.getType() != 1 && ni.getState() == NetworkInfo.State.CONNECTED;
    }

    public static boolean isValidConnectionFor(NetworkInfo ni, SharedPreferences aPrefs, String suffix) {
        if (PreferencesWrapper.isValidWifiConnectionFor(ni, aPrefs, suffix)) {
            printlog.d(THIS_FILE, "We are valid for WIFI");
            return true;
        }
        if (PreferencesWrapper.isValidMobileConnectionFor(ni, aPrefs, suffix)) {
            printlog.d(THIS_FILE, "We are valid for MOBILE");
            return true;
        }
        if (PreferencesWrapper.isValidOtherConnectionFor(ni, aPrefs, suffix)) {
            printlog.d(THIS_FILE, "We are valid for OTHER");
            return true;
        }
        return false;
    }

    public boolean isValidConnectionForOutgoing() {
        NetworkInfo ni = this.connectivityManager.getActiveNetworkInfo();
        return PreferencesWrapper.isValidConnectionFor(ni, this.prefs, "out");
    }

    public boolean isValidConnectionForIncoming() {
        NetworkInfo ni = this.connectivityManager.getActiveNetworkInfo();
        return PreferencesWrapper.isValidConnectionFor(ni, this.prefs, "in");
    }

    public ArrayList<String> getAllIncomingNetworks() {
        String[] availableNetworks;
        ArrayList<String> incomingNetworks = new ArrayList<String>();
        for (String network : availableNetworks = new String[]{"3g", "edge", "gprs", "wifi", "other"}) {
            if (!this.getPreferenceBooleanValue("use_" + network + "_in").booleanValue()) continue;
            incomingNetworks.add(network);
        }
        return incomingNetworks;
    }

    public void disableAllForIncoming() {
        String[] availableNetworks;
        for (String network : availableNetworks = new String[]{"3g", "edge", "gprs", "wifi", "other"}) {
            this.setPreferenceBooleanValue("use_" + network + "_in", false);
        }
    }

    public boolean getLockWifi() {
        return this.getPreferenceBooleanValue("lock_wifi");
    }

    public int getUseSrtp() {
        int use_srtp = Integer.parseInt(this.getPreferenceStringValue("use_srtp"));
        return use_srtp;
    }

    public void setUseSrtp(int state) {
        this.setPreferenceStringValue("use_srtp", Integer.toString(state));
    }

    public boolean isTCPEnabled() {
        return this.getPreferenceBooleanValue("enable_tcp");
    }

    public boolean isUDPEnabled() {
        return this.getPreferenceBooleanValue("enable_udp");
    }

    public boolean isTLSEnabled() {
        return this.getPreferenceBooleanValue("enable_tls");
    }

    public boolean useIPv6() {
        return this.getPreferenceBooleanValue("use_ipv6");
    }

    private int getPrefPort(String key) {
        int port = this.getPreferenceIntegerValue(key);
        if (this.isValidPort(port)) {
            return port;
        }
        return Integer.parseInt(STRING_PREFS.get(key));
    }

    public int getUDPTransportPort() {
        return this.getPrefPort("network_udp_transport_port");
    }

    public int getTCPTransportPort() {
        return this.getPrefPort("network_tcp_transport_port");
    }

    public int getTLSTransportPort() {
        return this.getPrefPort("network_tls_transport_port");
    }

    public int getKeepAliveInterval() {
        NetworkInfo ni = this.connectivityManager.getActiveNetworkInfo();
        if (ni != null && ni.getType() == 1) {
            return this.getPreferenceIntegerValue("keep_alive_interval_wifi");
        }
        return this.getPreferenceIntegerValue("keep_alive_interval_mobile");
    }

    public int getRTPPort() {
        return this.getPrefPort("network_rtp_port");
    }

    public boolean enableDNSSRV() {
        return this.getPreferenceBooleanValue("enable_dns_srv");
    }

    public int getDSCPVal() {
        return this.getPreferenceIntegerValue("dscp_val");
    }

    public int getTLSMethod() {
        return this.getPreferenceIntegerValue("tls_method");
    }

    private boolean hasStunServer(String string) {
        String[] servers;
        for (String server : servers = this.getPreferenceStringValue("stun_server").split(",")) {
            if (!server.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void addStunServer(String server) {
        if (!this.hasStunServer(server)) {
            this.setPreferenceStringValue("stun_server", this.getPreferenceStringValue("stun_server") + "," + server);
        }
    }

    public String getUserAgent() {
        return this.getPreferenceStringValue(USER_AGENT);
    }

    public int getAutoCloseTime() {
        return this.getPreferenceIntegerValue("snd_auto_close_time");
    }

    public boolean hasEchoCancellation() {
        return this.getPreferenceBooleanValue("echo_cancellation");
    }

    public long getEchoCancellationTail() {
        if (!this.hasEchoCancellation()) {
            return 0L;
        }
        return this.getPreferenceIntegerValue("echo_cancellation_tail");
    }

    public int getEchoMode() {
        return this.getPreferenceIntegerValue("echo_mode");
    }

    public int getNoVad() {
        return this.getPreferenceBooleanValue("enable_vad") != false ? 0 : 1;
    }

    public long getMediaQuality() {
        String mediaQuality = this.getPreferenceStringValue("snd_media_quality");
        try {
            int prefsValue = Integer.parseInt(mediaQuality);
            if (prefsValue <= 10 && prefsValue >= 0) {
                return prefsValue;
            }
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "Audio quality " + mediaQuality + " not well formated");
        }
        return 4L;
    }

    public int getBitsPerSample() {
        try {
            return Integer.parseInt(this.getPreferenceStringValue("bits_per_sample"));
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "Bits per sample not well formated");
            return Integer.parseInt(STRING_PREFS.get("bits_per_sample"));
        }
    }

    public int getInCallMode() {
        String mode = this.getPreferenceStringValue("sip_audio_mode");
        try {
            return Integer.parseInt(mode);
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "In call mode " + mode + " not well formated");
            return 0;
        }
    }

    public long getClockRate() {
        String clockRate = this.getPreferenceStringValue("snd_clock_rate");
        try {
            return Integer.parseInt(clockRate);
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "Clock rate " + clockRate + " not well formated");
            return 16000L;
        }
    }

    public boolean getUseRoutingApi() {
        return this.getPreferenceBooleanValue("use_routing_api");
    }

    public boolean getUseModeApi() {
        return this.getPreferenceBooleanValue("use_mode_api");
    }

    public int getIceEnabled() {
        return this.getPreferenceBooleanValue("enable_ice") != false ? 1 : 0;
    }

    public int getTurnEnabled() {
        return this.getPreferenceBooleanValue("enable_turn") != false ? 1 : 0;
    }

    public String getStunServer() {
        return this.getPreferenceStringValue("stun_server");
    }

    public int getStunEnabled() {
        return this.getPreferenceBooleanValue("enable_stun") != false ? 1 : 0;
    }

    public String getTurnServer() {
        return this.getPreferenceStringValue("turn_server");
    }

    public short getCodecPriority(String codecName, String defaultValue) {
        NetworkInfo ni = this.connectivityManager.getActiveNetworkInfo();
        if (ni != null) {
            String currentBandType = this.prefs.getString(SipConfigManager.getBandTypeKey(ni.getType(), ni.getSubtype()), "audio");
            return this.getCodecPriority(codecName, currentBandType, defaultValue);
        }
        return (short)Integer.parseInt(defaultValue);
    }

    public short getCodecPriority(String codecName, String type, String defaultValue) {
        String key = SipConfigManager.getCodecKey(codecName, type);
        if (key != null) {
            return (short)Integer.parseInt(this.prefs.getString(key, defaultValue));
        }
        return (short)Integer.parseInt(defaultValue);
    }

    public void setCodecPriority(String codecName, String type, String newValue) {
        String key = SipConfigManager.getCodecKey(codecName, type);
        if (key != null) {
            this.setPreferenceStringValue(key, newValue);
        }
    }

    public boolean hasCodecPriority(String codecName) {
        NetworkInfo ni = this.connectivityManager.getActiveNetworkInfo();
        String[] codecParts = codecName.split("/");
        if (codecParts.length >= 2) {
            String currentBandType = this.prefs.getString(SipConfigManager.getBandTypeKey(ni.getType(), ni.getSubtype()), "audio");
            String key = SipConfigManager.getCodecKey(codecName, currentBandType);
            return this.prefs.contains(key);
        }
        return false;
    }

    public String getRingtone() {
        String ringtone = this.prefs.getString("ringtone", Settings.System.DEFAULT_RINGTONE_URI.toString());
        if (ringtone == null || TextUtils.isEmpty((CharSequence)ringtone)) {
            ringtone = Settings.System.DEFAULT_RINGTONE_URI.toString();
        }
        return ringtone;
    }

    public float getMicLevel() {
        return this.getPreferenceFloatValue("snd_mic_level").floatValue();
    }

    public float getSpeakerLevel() {
        return this.getPreferenceFloatValue("snd_speaker_level").floatValue();
    }

    public int getAudioFramePtime() {
        return this.getPreferenceIntegerValue("snd_ptime");
    }

    public int getHasIOQueue() {
        return this.getPreferenceBooleanValue("has_io_queue") != false ? 1 : 0;
    }

    public boolean generateForSetCall() {
        return this.getPreferenceBooleanValue("set_audio_generate_tone");
    }

    public boolean useSipInfoDtmf() {
        return this.getPreferenceStringValue("dtmf_mode").equalsIgnoreCase(DTMF_MODE_INFO);
    }

    public boolean forceDtmfInBand() {
        return this.getPreferenceStringValue("dtmf_mode").equalsIgnoreCase(DTMF_MODE_INBAND);
    }

    public boolean forceDtmfRTP() {
        return this.getPreferenceStringValue("dtmf_mode").equalsIgnoreCase(DTMF_MODE_RTP);
    }

    public long getThreadCount() {
        int value = this.getPreferenceIntegerValue("thread_count");
        if (value < 10) {
            return value;
        }
        return Integer.parseInt(STRING_PREFS.get("thread_count"));
    }

    public boolean getDialPressTone() {
        int mode = this.getPreferenceIntegerValue("dial_press_tone_mode");
        switch (mode) {
            case 0: {
                return Settings.System.getInt((ContentResolver)this.resolver, (String)"dtmf_tone", (int)1) == 1;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean getDialPressVibrate() {
        int mode = this.getPreferenceIntegerValue("dial_press_vibrate_mode");
        switch (mode) {
            case 0: {
                return Settings.System.getInt((ContentResolver)this.resolver, (String)"haptic_feedback_enabled", (int)1) == 1;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean startIsDigit() {
        return !this.prefs.getBoolean("start_with_text_dialer", false);
    }

    public boolean getUseAlternateUnlocker() {
        return this.prefs.getBoolean("use_alternate_unlocker", false);
    }

    public boolean useIntegrateDialer() {
        return this.prefs.getBoolean("integrate_with_native_dialer", true);
    }

    public boolean useIntegrateCallLogs() {
        return this.prefs.getBoolean("integrate_with_native_calllogs", true);
    }

    public boolean keepAwakeInCall() {
        return this.getPreferenceBooleanValue("keep_awake_incall");
    }

    public boolean invertProximitySensor() {
        return this.getPreferenceBooleanValue("invert_proximity_sensor");
    }

    public float getInitialVolumeLevel() {
        return (float)((double)this.prefs.getFloat("snd_stream_level", 8.0f) / 10.0);
    }

    public boolean usePartialWakeLock() {
        return this.getPreferenceBooleanValue("use_partial_wake_lock");
    }

    public boolean integrateWithMusicApp() {
        return this.prefs.getBoolean("integrate_with_native_music", true);
    }

    public int getLogLevel() {
        int prefsValue = this.getPreferenceIntegerValue("log_level");
        if (prefsValue <= 6 && prefsValue >= 1) {
            return prefsValue;
        }
        return 1;
    }

    public int getGsmIntegrationType() {
        int prefsValue = 1;
        String gsmType = this.getPreferenceStringValue("gsm_integration_type");
        try {
            prefsValue = Integer.parseInt(gsmType);
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "Gsm type " + gsmType + " not well formated");
        }
        return prefsValue;
    }

    public boolean showIconInStatusBar() {
        return this.getPreferenceBooleanValue("icon_in_status_bar");
    }

    public int getHeadsetAction() {
        try {
            return Integer.parseInt(this.prefs.getString("headset_action", DTMF_MODE_AUTO));
        }
        catch (NumberFormatException e) {
            printlog.e(THIS_FILE, "Headset action option not well formated");
            return 0;
        }
    }

    public boolean hasAlreadySetup() {
        return this.prefs.getBoolean(HAS_ALREADY_SETUP, false);
    }

    public boolean hasAlreadySetupService() {
        return this.prefs.getBoolean(HAS_ALREADY_SETUP_SERVICE, false);
    }

    private boolean isValidPort(int port) {
        return port > 0 && port < 65535;
    }

    private static File getStorageFolder() {
        File root = Environment.getExternalStorageDirectory();
        if (root.canWrite()) {
            File dir = new File(root.getAbsolutePath() + File.separator + "CSipSimple");
            dir.mkdirs();
            printlog.d(THIS_FILE, "Create directory " + dir.getAbsolutePath());
            return dir;
        }
        return null;
    }

    private static File getSubFolder(String subFolder) {
        File root = PreferencesWrapper.getStorageFolder();
        if (root != null) {
            File dir = new File(root.getAbsoluteFile() + File.separator + subFolder);
            dir.mkdirs();
            return dir;
        }
        return null;
    }

    public static File getConfigFolder() {
        return PreferencesWrapper.getSubFolder(CONFIG_FOLDER);
    }

    public static File getRecordsFolder() {
        return PreferencesWrapper.getSubFolder(RECORDS_FOLDER);
    }

    public static File getLogsFolder() {
        return PreferencesWrapper.getSubFolder(LOGS_FOLDER);
    }

    public static void cleanLogsFiles() {
        File logsFolder = PreferencesWrapper.getLogsFolder();
        if (logsFolder != null) {
            File[] files;
            for (File file : files = logsFolder.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public boolean isAdvancedUser() {
        return this.prefs.getBoolean(IS_ADVANCED_USER, false);
    }

    public void toogleExpertMode() {
        this.setPreferenceBooleanValue(IS_ADVANCED_USER, !this.isAdvancedUser());
    }

    public boolean hasBeenQuit() {
        return this.prefs.getBoolean(HAS_BEEN_QUIT, false);
    }

    public void setQuit(boolean quit) {
        this.setPreferenceBooleanValue(HAS_BEEN_QUIT, quit);
    }
}

