/*
 * Decompiled with CFR 0.152.
 */
package ceres.api;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import ceres.api.Configuration;
import ceres.cminterface.CMCallInfo;
import ceres.cminterface.CMInterface;
import ceres.cminterface.DupCallInfo;
import ceres.service.MediaManager;
import ceres.service.SipNotifications;
import ceres.utils.printlog;
import java.util.List;

public class UAStateReceiver
implements CMInterface.OnCallbackListener,
CMInterface.OnLoopbackListener {
    private static final String THIS_FILE = "UAStateReceiver";
    public static Context mContext;
    public static SipNotifications notificationManager;
    public static MediaManager mediaManager;
    private CMInterface mCMIF = null;
    Configuration.CALLTYPE mCALLTYPE = Configuration.CALLTYPE.NONE;
    String m_strRemoteNum = "";
    String strWallPadCallPackageName = "kr.co.icontrols.wallpadcall";
    private static long connectStart;

    public UAStateReceiver(Context context) {
        Log.v((String)"yjyoon", (String)"UAStateReceiver - Constructor");
        mContext = context;
        notificationManager = new SipNotifications(mContext);
        if (mediaManager == null) {
            mediaManager = new MediaManager(mContext);
        }
        if (this.mCMIF == null) {
            this.mCMIF = new CMInterface();
            this.mCMIF.setOnCallStateCBListener(this);
            this.mCMIF.setOnLoopbackCBListener(this);
        }
    }

    @Override
    public void OnCallStateChanged(CMCallInfo callInfo) {
        Configuration.CALLEVENTTYPE cALLEVENTTYPE = Configuration.CALLEVENTTYPE.NONE;
        Configuration.CALLTYPE cALLTYPE = Configuration.CALLTYPE.NONE;
        Intent Intent2 = new Intent();
        printlog.w(THIS_FILE, "callInfo. -------------------------------------------------");
        printlog.d(THIS_FILE, "callInfo.callState    : " + callInfo.callState);
        printlog.d(THIS_FILE, "callInfo.mediaType    : " + callInfo.mediaType);
        printlog.d(THIS_FILE, "callInfo.aCodecName    : " + callInfo.aCodecName);
        printlog.d(THIS_FILE, "callInfo.vCodecName    : " + callInfo.vCodecName);
        printlog.d(THIS_FILE, "callInfo.remoteNumber : " + callInfo.remoteNumber);
        int data = callInfo.callState;
        switch (data) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                cALLEVENTTYPE = Configuration.CALLEVENTTYPE.RECEIVE_CALL_ACK;
                this.mCALLTYPE = this.makeSIPID(callInfo.remoteNumber);
                this.m_strRemoteNum = callInfo.remoteNumber;
                Intent2.setAction("CERES_CALL");
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLOWNER, Configuration.CALLOWNER.NONE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLEVENTTYPE, cALLEVENTTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLTYPE, this.mCALLTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.REMOTEINFO, callInfo.remoteNumber);
                mContext.sendBroadcast(Intent2);
                break;
            }
            case 3: {
                notificationManager.showNotificationForCall(callInfo);
                Log.i((String)THIS_FILE, (String)"mCallback callback : INCOMING state : 3");
                Log.i((String)THIS_FILE, (String)"mCallback callback : getTopActivity : 2");
                cALLEVENTTYPE = Configuration.CALLEVENTTYPE.RECEIVE_CALL;
                if (this.mCALLTYPE == Configuration.CALLTYPE.NONE) {
                    this.m_strRemoteNum = callInfo.remoteNumber;
                    this.mCALLTYPE = this.makeSIPID(callInfo.remoteNumber);
                    this.runCallMainActivity(cALLEVENTTYPE, this.mCALLTYPE, callInfo.remoteNumber);
                    Handler mHandler = new Handler();
                    mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (UAStateReceiver.this.mCALLTYPE == Configuration.CALLTYPE.LOBBY) {
                                int l_callId = UAStateReceiver.this.mCMIF.getCallIndex();
                                UAStateReceiver.this.mCMIF.CERES_AcceptCall(l_callId, 3);
                            }
                        }
                    }, 500L);
                    break;
                }
                cALLTYPE = this.makeSIPID(callInfo.remoteNumber);
                Intent2.setAction("CERES_CALL_MULTI");
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLOWNER, Configuration.CALLOWNER.NONE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLEVENTTYPE, cALLEVENTTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLTYPE, cALLTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.REMOTEINFO, callInfo.remoteNumber);
                mContext.sendBroadcast(Intent2);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                printlog.d(THIS_FILE, "CMCallState.CONNECTED : callInfo.mediaType : " + callInfo.mediaType);
                cALLEVENTTYPE = Configuration.CALLEVENTTYPE.CONNECT_CALL;
                cALLTYPE = this.makeSIPID(callInfo.remoteNumber);
                Intent2.setAction("CERES_CALL");
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLOWNER, Configuration.CALLOWNER.NONE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLEVENTTYPE, cALLEVENTTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLTYPE, cALLTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.REMOTEINFO, callInfo.remoteNumber);
                mContext.sendBroadcast(Intent2);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (mediaManager != null) {
                    mediaManager.stopRing();
                }
                notificationManager.cancelCalls();
                Log.i((String)THIS_FILE, (String)"mCallback callback : RELEASED state : 7");
                UAStateReceiver.onBroadcastCallState(callInfo);
                cALLEVENTTYPE = Configuration.CALLEVENTTYPE.TERMINATE_CALL;
                cALLTYPE = this.makeSIPID(callInfo.remoteNumber);
                Intent2.setAction("CERES_CALL");
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLOWNER, Configuration.CALLOWNER.NONE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLEVENTTYPE, cALLEVENTTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.CALLTYPE, cALLTYPE.toString());
                Intent2.putExtra(Configuration.CALLTRIGGER.REMOTEINFO, callInfo.remoteNumber);
                mContext.sendBroadcast(Intent2);
                Log.i((String)THIS_FILE, (String)("m_strRemoteNum : " + this.m_strRemoteNum));
                Log.i((String)THIS_FILE, (String)("callInfo.remoteNumber : " + callInfo.remoteNumber));
                if (!this.m_strRemoteNum.equals(callInfo.remoteNumber)) break;
                this.mCALLTYPE = Configuration.CALLTYPE.NONE;
                Log.i((String)THIS_FILE, (String)"CALLTYPE RESET");
                break;
            }
            default: {
                Log.i((String)THIS_FILE, (String)"mCallback callback : DEFAULT state : ");
            }
        }
    }

    private String getTopActivity() {
        try {
            ActivityManager mActivityManager = (ActivityManager)mContext.getSystemService("activity");
            List mTaskInfo = mActivityManager.getRunningTasks(1);
            ComponentName mComponentName = ((ActivityManager.RunningTaskInfo)mTaskInfo.get((int)0)).topActivity;
            String strTopActivity = mComponentName.getPackageName();
            Log.i((String)THIS_FILE, (String)("[getTopActivity] strTopActivity [" + strTopActivity + "]"));
            return strTopActivity;
        }
        catch (Exception e) {
            Log.e((String)THIS_FILE, (String)"[Exception] getTopActivity()");
            e.printStackTrace();
            return null;
        }
    }

    public Configuration.CALLTYPE makeSIPID(String strIPAddress) {
        Configuration.CALLTYPE strType = Configuration.CALLTYPE.RESIDENCE;
        try {
            printlog.i(THIS_FILE, "[makeSIPID] strIPAddress : " + strIPAddress);
            String SIPID = "12345678_Resi_0101_0101_01";
            String dong = "101";
            String ho = "101";
            String strDeviceCnt = "01";
            String[] IP_Parse = strIPAddress.split("\\.");
            if (IP_Parse[2].equals("128")) {
                strType = Configuration.CALLTYPE.GUARD;
                ho = IP_Parse[3];
            } else if (IP_Parse[2].equals("0")) {
                strType = Configuration.CALLTYPE.LOBBY;
                ho = IP_Parse[3];
            } else if (IP_Parse[2].equals("201")) {
                strType = Configuration.CALLTYPE.IHUB;
                ho = IP_Parse[3];
            } else {
                strType = Configuration.CALLTYPE.RESIDENCE;
            }
            printlog.i(THIS_FILE, "[makeSIPID] SIPID : " + SIPID);
            return strType;
        }
        catch (Exception e) {
            Log.e((String)THIS_FILE, (String)("[Exception] MakeSIPID(...) : " + e));
            e.printStackTrace();
            return strType;
        }
    }

    public void runCallMainActivity(Configuration.CALLEVENTTYPE eEventType, Configuration.CALLTYPE eCallType, String strRemoteNum) {
        try {
            this.sendBR_AppFinish(mContext);
            Thread.sleep(500L);
            ComponentName mComponentName = new ComponentName("kr.co.icontrols.wallpadcall", "kr.co.icontrols.wallpadcall.MainActivity");
            Intent mIntent = new Intent("android.intent.action.MAIN");
            mIntent.putExtra(Configuration.CALLTRIGGER.CALLOWNER, Configuration.CALLOWNER.NONE.toString());
            mIntent.putExtra(Configuration.CALLTRIGGER.CALLEVENTTYPE, eEventType.toString());
            mIntent.putExtra(Configuration.CALLTRIGGER.CALLTYPE, eCallType.toString());
            mIntent.putExtra(Configuration.CALLTRIGGER.REMOTEINFO, strRemoteNum);
            mIntent.setFlags(0x10000000);
            mIntent.setComponent(mComponentName);
            mContext.startActivity(mIntent);
            Thread.sleep(500L);
        }
        catch (Exception e) {
            Log.e((String)"KSJ", (String)"[Exception] runCallMainActivity()");
            e.printStackTrace();
        }
    }

    private void sendBR_AppFinish(Context context) {
        try {
            printlog.i(THIS_FILE, "[sendBR_AppFinish] Send App Finish!!");
            Intent mIntent = new Intent();
            mIntent.setAction("kr.co.icontrols.wallpad.BR_APP_FINISH");
            context.sendBroadcast(mIntent);
        }
        catch (Exception e) {
            Log.e((String)THIS_FILE, (String)"[Exception] sendBR_AppFinish(Context context)");
            e.printStackTrace();
        }
    }

    private static void onBroadcastCallState(CMCallInfo callInfo) {
        Intent callStateChangedIntent = new Intent("com.cnstec.service.CALL_CHANGED");
        callStateChangedIntent.putExtra("call_info", (Parcelable)callInfo);
        printlog.i(THIS_FILE, "onBroadcastCallState SipManager.ACTION_SIP_CALL_CHANGED : ");
        mContext.sendBroadcast(callStateChangedIntent);
    }

    @Override
    public void OnAccRegChanged(int state) {
        switch (state) {
            case 1: {
                notificationManager.notifyRegisteredAccounts(1, this.mCMIF.CERES_PhoneNumber_get());
                break;
            }
            case 0: {
                notificationManager.cancelRegisters();
            }
        }
    }

    public static long getConnectStart() {
        return connectStart;
    }

    public static void setConnectStart(long elapsedRealtime) {
        printlog.d(THIS_FILE, "setConnectStart, elapsedRealtime : " + elapsedRealtime);
        connectStart = elapsedRealtime;
    }

    @Override
    public void OnMediaUpdated(int mediaDir) {
    }

    @Override
    public void OnLoopbackStateChanged(int state, int callType) {
        printlog.d(THIS_FILE, "OnLoopbackStateChanged, state : " + state);
        DupCallInfo callInfo = new DupCallInfo();
        callInfo.mediaType = callType;
        printlog.d(THIS_FILE, "OnLoopbackStateChanged, callType : " + callType);
        callInfo.aCodecName = callInfo.get_ACodecName(this.mCMIF.CMI_Loopback_AudioCodecInt_get());
        callInfo.vCodecName = callInfo.get_VCodecName(this.mCMIF.CMI_Loopback_VideoCodecInt_get());
        callInfo.vSizeName = callInfo.get_VSizeName(Integer.parseInt(this.mCMIF.CERES_VideoSize_get()));
        callInfo.remoteNumber = "Loopback";
        UAStateReceiver.setConnectStart(SystemClock.elapsedRealtime());
        if (callType == 1) {
            Intent InCallConnectedIntent = new Intent("com.cnstec.phone.action.ONCALL");
            InCallConnectedIntent.putExtra("mediaType", callInfo.mediaType);
            InCallConnectedIntent.putExtra("remoteNumber", callInfo.remoteNumber);
            InCallConnectedIntent.putExtra("aCodecName", callInfo.aCodecName);
            InCallConnectedIntent.putExtra("vCodecName", callInfo.vCodecName);
            InCallConnectedIntent.putExtra("vSizeName", callInfo.vSizeName);
            printlog.d(THIS_FILE, "callInfo.aCodecName :" + callInfo.aCodecName);
            printlog.d(THIS_FILE, "callInfo.vCodecName :" + callInfo.vCodecName);
            printlog.d(THIS_FILE, "callInfo.vSizeName  :" + callInfo.vSizeName);
            InCallConnectedIntent.setFlags(0x30000000);
            mContext.startActivity(InCallConnectedIntent);
        } else if (callType == 3) {
            Log.v((String)"yjyoon2", (String)"UAStateReceiver > OnLoopbackStateChanged > MEDIA_TYPE_VIDEO");
            Intent InVCallConnectedIntent = new Intent("com.cnstec.phone.action.VIDEO");
            InVCallConnectedIntent.putExtra("mediaType", callInfo.mediaType);
            InVCallConnectedIntent.putExtra("remoteNumber", callInfo.remoteNumber);
            InVCallConnectedIntent.putExtra("aCodecName", callInfo.aCodecName);
            InVCallConnectedIntent.putExtra("vCodecName", callInfo.vCodecName);
            InVCallConnectedIntent.putExtra("vSizeName", callInfo.vSizeName);
            printlog.d(THIS_FILE, "OnLoopbackStateChanged, callInfo.aCodecName :" + callInfo.aCodecName);
            printlog.d(THIS_FILE, "OnLoopbackStateChanged, callInfo.vCodecName :" + callInfo.vCodecName);
            printlog.d(THIS_FILE, "OnLoopbackStateChanged, callInfo.vSizeName  :" + callInfo.vSizeName);
            InVCallConnectedIntent.setFlags(0x30000000);
            mContext.startActivity(InVCallConnectedIntent);
        }
    }

    static {
        mediaManager = null;
        connectStart = 0L;
    }
}

