/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import com.util.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WallpadInterlayerNoiseData
extends wallpaddbmgr {
    private static final String TAG = "WallpadInterlayerNoiseData";
    private int MAX_COUNT = 100;
    public List<InterlayerNoiseDataClass> SyncData = new ArrayList<InterlayerNoiseDataClass>();

    public WallpadInterlayerNoiseData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("InterlayerNoiseTBL")) {
            try {
                Log.i((String)TAG, (String)"[Create] CreateInterlayerNoiseDB");
                if (this.wdb != null) {
                    this.wdb.execSQL("create table InterlayerNoiseTBL (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, Sensorid text, regdate DATE DEFAULT (datetime('now','localtime')) );");
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[Create] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
            }
        }
    }

    public int Insert(byte sensorid) {
        long ret;
        if (!KIND.RangeCheck(sensorid)) {
            Log.w((String)TAG, (String)("[Insert] Param - Sensor Id RangeCheck Error (" + sensorid + ")"));
            return -1;
        }
        int Count = this.getCount();
        if (Count < 0) {
            Log.w((String)TAG, (String)("[Insert] getCount() Error !!! (Count:" + Count + ")"));
            return -4;
        }
        if (Count >= this.MAX_COUNT) {
            int DelCount = Count - (this.MAX_COUNT - 1);
            for (int i = 0; i < DelCount; ++i) {
                int ret2 = this.Delete(0);
                if (ret2 >= 0) continue;
                Log.w((String)TAG, (String)("[Insert] Delete() Error !!! (ret:" + ret2 + ")"));
            }
        }
        ContentValues values = new ContentValues();
        values.put("Sensorid", Byte.valueOf(sensorid));
        if (this.wdb != null && (ret = this.wdb.insert("InterlayerNoiseTBL", null, values)) < 0L) {
            Log.e((String)TAG, (String)("insert error ret : " + ret));
            return -1;
        }
        return 0;
    }

    public int Delete(int index) {
        if (index < 0) {
            Log.w((String)TAG, (String)("[Delete] Param - index Out Of Range #1 !!! (index:" + index + ")"));
            return -1;
        }
        int Count = this.getCount();
        if (Count < 0) {
            Log.w((String)TAG, (String)("[Delete] getCount() Error !!! (Count:" + Count + ")"));
            return -2;
        }
        if (Count == 0) {
            Log.w((String)TAG, (String)"[Delete] Count is Zero !!!");
            return -3;
        }
        if (index >= Count) {
            Log.w((String)TAG, (String)("[Delete] Param - index Out Of Range #2 !!! (index:" + index + ", Count:" + Count + ")"));
            return -4;
        }
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select seqnum from InterlayerNoiseTBL;", null);
            int seqnum = 0;
            try {
                boolean bRet = cursor.moveToPosition(index);
                if (!bRet) {
                    cursor.close();
                    Log.w((String)TAG, (String)"[Delete] moveToPosition return false !!!");
                    return -5;
                }
                seqnum = cursor.getInt(0);
                cursor.close();
                if (seqnum <= 0) {
                    Log.w((String)TAG, (String)("[Delete] seqnum Out Of Range !!! (seqnum:" + seqnum + ")"));
                    return -6;
                }
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                return -100;
            }
            catch (Exception e) {
                cursor.close();
                Log.e((String)TAG, (String)"[Delete] Exception Error !!!");
                LogUtil.errorLogInfo("", TAG, e);
                return -100;
            }
            String whereClause = "seqnum = " + seqnum;
            int ret = this.wdb.delete("InterlayerNoiseTBL", whereClause, null);
            if (ret < 0) {
                Log.w((String)TAG, (String)("[Delete] delete Error (ret:" + ret + ")"));
                return -10;
            }
        }
        return 0;
    }

    public int DeleteAll() {
        int Count = this.getCount();
        if (Count < 0) {
            Log.w((String)TAG, (String)("[DeleteAll] getCount() Error !!! (Count:" + Count + ")"));
            return -1;
        }
        String sqldata = "delete from InterlayerNoiseTBL;";
        try {
            if (this.wdb != null) {
                this.wdb.execSQL(sqldata);
            }
        }
        catch (RuntimeException re) {
            LogUtil.errorLogInfo("", TAG, re);
            return -100;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[DeleteAll] Exception Error !!!");
            LogUtil.errorLogInfo("", TAG, e);
            return -100;
        }
        return 0;
    }

    public int getCount() {
        String query = "select count(*) from InterlayerNoiseTBL;";
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery(query, null);
            if (cursor.moveToNext()) {
                String getdata = cursor.getString(0).trim();
                try {
                    return Integer.parseInt(getdata);
                }
                catch (RuntimeException re) {
                    LogUtil.errorLogInfo("", TAG, re);
                    return -999;
                }
                catch (Exception e) {
                    return -999;
                }
            }
            cursor.close();
        }
        return -1000;
    }

    public List<InterlayerNoiseDataClass> GetData() {
        if (this.wdb != null) {
            Cursor cursor = this.wdb.rawQuery("select * from InterlayerNoiseTBL order by regdate desc;", null);
            try {
                this.SyncData.clear();
                String DateStr = null;
                while (cursor.moveToNext()) {
                    InterlayerNoiseDataClass getdata = new InterlayerNoiseDataClass();
                    getdata.seqnum = cursor.getInt(0);
                    getdata.sensorId = cursor.getString(1);
                    DateStr = cursor.getString(2);
                    Log.i((String)TAG, (String)("getdata seqnum : " + getdata.seqnum + " / sensorid : " + getdata.sensorId + " / date : " + DateStr));
                    String Info2 = DateStr;
                    Info2 = Info2.replace('-', '_');
                    Info2 = Info2.replace(' ', '_');
                    Info2 = Info2.replace(':', '_');
                    String[] SplitedInfo = Info2.split("_");
                    if (SplitedInfo.length != 6) {
                        Log.d((String)TAG, (String)"if(SplitedInfo.length != 6)");
                        return null;
                    }
                    if (SplitedInfo != null && SplitedInfo.length >= 6) {
                        getdata.Date.set(Integer.parseInt(SplitedInfo[0]), Integer.parseInt(SplitedInfo[1]) - 1, Integer.parseInt(SplitedInfo[2]), Integer.parseInt(SplitedInfo[3]), Integer.parseInt(SplitedInfo[4]), Integer.parseInt(SplitedInfo[5]));
                    }
                    this.SyncData.add(getdata);
                }
                cursor.close();
            }
            catch (RuntimeException re) {
                LogUtil.errorLogInfo("", TAG, re);
                cursor.close();
                this.SyncData.clear();
                return null;
            }
            catch (Exception e) {
                cursor.close();
                this.SyncData.clear();
                Log.e((String)TAG, (String)"[GetData] Exception Error");
                LogUtil.errorLogInfo("", TAG, e);
                return null;
            }
        }
        return this.SyncData;
    }

    public String ToDebugData(List<InterlayerNoiseDataClass> data) {
        String retstr = "-----------------------------\r\n";
        retstr = retstr + "WallpadInterlayerNoiseData\r\n";
        retstr = retstr + "-----------------------------\r\n";
        if (data == null) {
            retstr = retstr + "null ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        if (data.isEmpty()) {
            retstr = retstr + "Empty ...\r\n";
            retstr = retstr + "-----------------------------\r\n";
            return retstr;
        }
        for (int i = 0; i < data.size(); ++i) {
            InterlayerNoiseDataClass getData = data.get(i);
            if (getData == null) continue;
            retstr = retstr + getData.ToDebugString(i);
        }
        retstr = retstr + "-----------------------------\r\n";
        return retstr;
    }

    public boolean setMaxCount(int ChangeCount) {
        if (ChangeCount < 10 || ChangeCount > 1000) {
            Log.w((String)TAG, (String)("[setMaxCount] Out Of Range Param (ChangeCount:" + ChangeCount + ")"));
            return false;
        }
        this.MAX_COUNT = ChangeCount;
        return true;
    }

    public static class InterlayerNoiseDataClass {
        public int seqnum = -1;
        public String sensorId = "";
        public Calendar Date = Calendar.getInstance();

        public String ToDebugString(int index) {
            String retStr = "==========================\r\nindex  -  " + index + "\r\n==========================\r\nseqnum       : " + this.seqnum + "\r\nsensorId     : " + this.sensorId + "\r\nDate         : " + this.Date.get(1) + "-" + (this.Date.get(2) + 1) + "-" + this.Date.get(5) + "  " + this.Date.get(11) + ":" + this.Date.get(12) + ":" + this.Date.get(13) + "\r\n==========================\r\n\r\n";
            return retStr;
        }
    }

    public static final class KIND {
        public static final byte B4 = -76;
        public static final byte B5 = -75;
        public static final byte B6 = -74;

        public static boolean RangeCheck(byte CheckByte) {
            if (CheckByte == -76) {
                return true;
            }
            if (CheckByte == -75) {
                return true;
            }
            return CheckByte == -74;
        }

        public static String getName(byte CheckByte) {
            if (CheckByte == -76) {
                return "1";
            }
            if (CheckByte == -75) {
                return "2";
            }
            if (CheckByte == -74) {
                return "3";
            }
            return "\uc815\uc758\ub418\uc9c0\uc54a\uc74c";
        }
    }
}

