/*
 * Decompiled with CFR 0.152.
 */
package ceres.utils;

import ceres.utils.printlog;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class IpAddress {
    static String address = null;
    static InetAddress inet_address;
    public static String localIpAddress;
    public static String THIS_FILE;

    IpAddress(InetAddress iaddress) {
        this.init(null, iaddress);
    }

    private void init(String address, InetAddress iaddress) {
        IpAddress.address = address;
        inet_address = iaddress;
    }

    public IpAddress() {
        printlog.i(THIS_FILE, "IpAddress is called...");
    }

    InetAddress getInetAddress() {
        if (inet_address == null) {
            try {
                inet_address = InetAddress.getByName(address);
                printlog.d("IpAddress", "inet_address ---------------------------------------------- : " + inet_address);
            }
            catch (UnknownHostException e) {
                inet_address = null;
            }
        }
        return inet_address;
    }

    public IpAddress(String address) {
        this.init(address, null);
    }

    public IpAddress(IpAddress ipaddr) {
        this.init(address, inet_address);
    }

    public static String getAddress() {
        if (address == null) {
            address = inet_address.getHostAddress();
            printlog.i(THIS_FILE, "getAddress : " + address);
        }
        return address;
    }

    public Object clone() {
        return new IpAddress(this);
    }

    public boolean equals(Object obj) {
        try {
            IpAddress ipaddr = (IpAddress)obj;
            return this.toString().equals(ipaddr.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        if (address == null && inet_address != null) {
            address = inet_address.getHostAddress();
        }
        return address;
    }

    public static IpAddress getByName(String host_addr) throws UnknownHostException {
        InetAddress iaddr = InetAddress.getByName(host_addr);
        return new IpAddress(iaddr);
    }

    public static String deviceIP_get() {
        localIpAddress = "127.0.0.1";
        printlog.d(THIS_FILE, "localIpAddress start : " + localIpAddress);
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    localIpAddress = inetAddress.getHostAddress().toString();
                    printlog.d(THIS_FILE, "localIpAddress : inetAddress.getHostAddress().toString() : " + localIpAddress);
                    return localIpAddress;
                }
            }
        }
        catch (SocketException ex) {
            printlog.e(THIS_FILE, "localIpAddress : SocketException ex : " + localIpAddress);
            return localIpAddress;
        }
        printlog.d(THIS_FILE, "localIpAddress end : " + localIpAddress);
        return localIpAddress;
    }

    static {
        localIpAddress = "127.0.0.1";
        THIS_FILE = "IpAddress";
    }
}

