/*
 * Decompiled with CFR 0.152.
 */
package ceres.srinterface;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import ceres.srinterface.SRInterface;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaDecoder {
    Worker mWorker;
    volatile boolean mRunning;
    MediaCodec mCodec;
    volatile boolean mConfigured;
    long mTimeoutUs;

    public void decodeSample(byte[] data, int offset, int size, long presentationTimeUs, int flags) {
        if (this.mWorker != null) {
            this.mWorker.decodeSample(data, offset, size, presentationTimeUs, flags);
        }
    }

    public void configure(Surface surface, int width, int height) {
        if (this.mWorker != null) {
            this.mWorker.configure(surface, width, height);
        }
    }

    public void start() {
        if (this.mWorker == null) {
            Log.d((String)"KSJ_media", (String)"start");
            this.mWorker = new Worker();
            this.mWorker.setRunning(true);
            this.mWorker.start();
        }
    }

    public void stop() {
        if (this.mWorker != null) {
            Log.d((String)"KSJ_media", (String)"stop");
            this.mWorker.setRunning(false);
            this.mWorker = null;
        }
    }

    public void video_capture(boolean bSet) {
        if (this.mWorker != null) {
            Log.d((String)"KSJ_media", (String)"video_capture");
            this.mWorker.setCapture(bSet);
        }
    }

    class Worker
    extends Thread {
        volatile boolean mRunning;
        MediaCodec mCodec;
        volatile boolean mConfigured;
        long mTimeoutUs = 0L;
        volatile String m_strPATH = "";
        volatile boolean m_bCapture = false;
        Surface m_Surface;

        public void setRunning(boolean running) {
            this.mRunning = running;
        }

        public void setPath(String strPath) {
            this.m_strPATH = strPath;
        }

        public void setCapture(boolean bCapture) {
            this.m_bCapture = bCapture;
        }

        public void configure(Surface surface, int width, int height) {
            Log.d((String)"KSJ_media", (String)"configure");
            if (this.mConfigured) {
                throw new IllegalStateException("Decoder is already configured");
            }
            Log.d((String)"KSJ_media", (String)"configure1");
            MediaFormat format = MediaFormat.createVideoFormat((String)"video/3gpp", (int)width, (int)height);
            Log.d((String)"KSJ_media", (String)"configure2");
            try {
                this.mCodec = MediaCodec.createDecoderByType((String)"video/3gpp");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create codec", e);
            }
            Log.d((String)"KSJ_media", (String)"configure3");
            this.mCodec.configure(format, null, null, 0);
            this.m_Surface = surface;
            this.mCodec.start();
            this.mConfigured = true;
            Log.d((String)"KSJ_media", (String)"configure4");
        }

        public void decodeSample(byte[] data, int offset, int size, long presentationTimeUs, int flags) {
            int index;
            if (this.mConfigured && this.mRunning && (index = this.mCodec.dequeueInputBuffer(this.mTimeoutUs)) >= 0) {
                ByteBuffer buffer;
                if (Build.VERSION.SDK_INT < 21) {
                    buffer = this.mCodec.getInputBuffers()[index];
                    buffer.clear();
                } else {
                    buffer = this.mCodec.getInputBuffer(index);
                }
                if (buffer != null) {
                    buffer.put(data, offset, size);
                    this.mCodec.queueInputBuffer(index, 0, size, presentationTimeUs, flags);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
                while (this.mRunning) {
                    int index;
                    if (!this.mConfigured || (index = this.mCodec.dequeueOutputBuffer(info, this.mTimeoutUs)) < 0) continue;
                    ByteBuffer[] outputBuffers = this.mCodec.getOutputBuffers();
                    ByteBuffer outputBuffer = outputBuffers[index];
                    byte[] outData = new byte[info.size];
                    outputBuffer.get(outData);
                    SRInterface.MediaCodec_buf(outData, outData.length);
                    this.mCodec.releaseOutputBuffer(index, true);
                    if ((info.flags & 4) != 4) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
            finally {
                if (this.mConfigured) {
                    this.mCodec.stop();
                    this.mCodec.release();
                }
            }
        }
    }
}

