/*
 * Decompiled with CFR 0.152.
 */
package ceres.pcminterface;

import android.content.Context;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Handler;
import ceres.api.SipManager;
import ceres.cminterface.CMInterface;
import ceres.cminterface.NPMetrics;
import ceres.utils.printlog;

public class PCMInterface {
    private static CMInterface m_CMIF;
    private static final String THIS_FILE = "PcmInterface";
    private Handler mHandler = new Handler();
    private myThread mThread;
    private static PCMRecord m_PCMRecord;
    private static PCMTrack m_PCMTrack;
    private static PCMSetting m_Setting;
    private static int frequency;
    private static int audioEncoding;
    private static int channelConfiguration;

    native void PCMIF_Initialize();

    static native int PCMIF_SetAECParams();

    native int PCMIF_LoopbackConnect(int var1, int var2, int var3, int var4, int var5, int var6);

    native int PCMIF_LoopbackDisconnect(int var1);

    static native int PCMIF_AECDelayCheck(int var0);

    static native int PCMIF_SystemDelay_set();

    static native int PCMIF_JBVCheck(int var0);

    static native int PCMIF_NPMetrics(int var0);

    static native void PCMIF_Close();

    static native void PCMIF_GetJavaVM();

    static native void PCMIF_GetData();

    public static native boolean PCMIF_OnMediaStart(int var0, int var1);

    public static native boolean PCMIF_OnMediaStop(int var0, int var1);

    public static native void MMIF_IsVideoReady(int var0);

    public static int getFrequency() {
        return frequency;
    }

    public static int getAudioEncoding() {
        return audioEncoding;
    }

    public static int getChannelConfiguration() {
        return channelConfiguration;
    }

    public static int SetAECParams() {
        return PCMInterface.PCMIF_SetAECParams();
    }

    public int PCMI_LoopbackConnect(int callType, int AcodecNum, int VcodecNum, int ptime, int videoSize, int frameRate) {
        return this.PCMIF_LoopbackConnect(callType, AcodecNum, VcodecNum, ptime, videoSize, frameRate);
    }

    public int PCMI_LoopbackDisconnect(int mediaType) {
        return this.PCMIF_LoopbackDisconnect(mediaType);
    }

    public int AECDelayCheck(int start) {
        return PCMInterface.PCMIF_AECDelayCheck(start);
    }

    public int SystemDelay_set() {
        return PCMInterface.PCMIF_SystemDelay_set();
    }

    public int JBVCheck(int start) {
        return PCMInterface.PCMIF_JBVCheck(start);
    }

    public int NPMetrics(int start) {
        if (start == 1) {
            this.ThreadStart();
        } else {
            this.ThreadStop();
        }
        return PCMInterface.PCMIF_NPMetrics(start);
    }

    public static void jAECDelayCheck(int delay, int max) {
        printlog.d(THIS_FILE, "delay : " + delay);
        CMInterface.dispatchSysDelayEvent(delay, max);
    }

    public static void jJBVCheck(int currMS, int var) {
        printlog.d(THIS_FILE, "currMS : " + currMS);
        CMInterface.dispatchCheckCBEvent(currMS, var);
    }

    private void ThreadStart() {
        if (this.mThread == null) {
            this.mThread = new myThread(true);
            this.mThread.start();
        }
    }

    private void ThreadStop() {
        if (this.mThread != null) {
            this.mThread.stopThread();
            this.mThread = null;
        }
    }

    public static void jNPMetrics(int param1, int param2) {
        NPMetrics npMetrics = new NPMetrics();
        printlog.w(THIS_FILE, "> jNPMetrics Debug : ------------------------------------");
        printlog.w(THIS_FILE, "npMetrics. ------------------------------------");
        printlog.w(THIS_FILE, "npMetrics.getTPC()      : " + npMetrics.getTPC());
        printlog.w(THIS_FILE, "npMetrics.getPLC()      : " + npMetrics.getPLC());
        printlog.w(THIS_FILE, "npMetrics.getJCL()      : " + npMetrics.getJCL());
        printlog.w(THIS_FILE, "npMetrics.getPIU5MC()   : " + npMetrics.getPIU5MC());
        printlog.w(THIS_FILE, "npMetrics.getPIU12MC()  : " + npMetrics.getPIU12MC());
        printlog.w(THIS_FILE, "npMetrics.getPIU22MC()  : " + npMetrics.getPIU22MC());
        printlog.w(THIS_FILE, "npMetrics.getPIU32MC()  : " + npMetrics.getPIU32MC());
        printlog.w(THIS_FILE, "npMetrics.getPIU50MC()  : " + npMetrics.getPIU50MC());
        printlog.w(THIS_FILE, "npMetrics.getPIU70MC()  : " + npMetrics.getPIU70MC());
        printlog.w(THIS_FILE, "npMetrics.getPIU100MC() : " + npMetrics.getPIU100MC());
        printlog.w(THIS_FILE, "npMetrics.getPIO100MC() : " + npMetrics.getPIO100MC());
        CMInterface.dispatchNPMetricsCBEvent(npMetrics);
    }

    public static void MatrixTime(int delayTime) {
        long saveTime = System.currentTimeMillis();
        long currTime = 0L;
        while (currTime - saveTime < (long)delayTime) {
            currTime = System.currentTimeMillis();
        }
    }

    public static void Close() {
        PCMInterface.PCMIF_Close();
    }

    public PCMInterface() {
        printlog.i(THIS_FILE, "PCMInterface empty constructor...");
    }

    public PCMInterface(Context context) {
        frequency = 8000;
        audioEncoding = 2;
        channelConfiguration = 2;
        this.PCMIF_Initialize();
        m_Setting = new PCMSetting();
    }

    public static void jOpenRec(int samplerate) {
        m_PCMRecord = new PCMRecord(m_Setting);
        m_PCMRecord.Open(samplerate);
    }

    public static void jStopRec(int i) {
        m_PCMRecord.Close(i);
    }

    public static int jReadPcmData(byte[] buf, int size) {
        return m_PCMRecord.Read(buf, size);
    }

    public static void jOpenPlay(int samplerate) {
        m_PCMTrack = new PCMTrack(m_Setting);
        m_PCMTrack.Open(samplerate);
    }

    public static synchronized void jStopPlay(int i) {
        m_PCMTrack.Close(i);
    }

    public static int jWritePcmData(byte[] buf, int size) {
        return m_PCMTrack.Write(buf, size);
    }

    public void jsetCorrectInformation(int sizeTrackCorrectBase, int sizeTrackCorrect, int sizeRecordCorrectBase, int sizeRecordCorrect) {
        PCMInterface.m_Setting.sizeTrackCorrectBase = sizeTrackCorrectBase;
        PCMInterface.m_Setting.sizeTrackCorrect = sizeTrackCorrect;
        PCMInterface.m_Setting.sizeRecordCorrectBase = sizeRecordCorrectBase;
        PCMInterface.m_Setting.sizeRecordCorrect = sizeRecordCorrect;
        printlog.d(THIS_FILE, "m_Setting.sizeTrackCorrectBase : " + PCMInterface.m_Setting.sizeTrackCorrectBase);
        printlog.d(THIS_FILE, "m_Setting.sizeTrackCorrect : " + PCMInterface.m_Setting.sizeTrackCorrect);
        printlog.d(THIS_FILE, "m_Setting.sizeRecordCorrectBase : " + PCMInterface.m_Setting.sizeRecordCorrectBase);
        printlog.d(THIS_FILE, "m_Setting.sizeRecordCorrect : " + PCMInterface.m_Setting.sizeRecordCorrect);
    }

    public PCMQueueInformation[] jgetDataInformation() {
        PCMQueueInformation[] aINF = new PCMQueueInformation[2];
        if (m_PCMTrack == null || m_PCMRecord == null) {
            return null;
        }
        aINF[0] = m_PCMTrack.m_Queue.getInformation();
        aINF[0].m_sizeQFill = m_PCMTrack.m_Track.getPlaybackHeadPosition() * 2;
        aINF[0].m_sizeQFill -= aINF[0].m_sizeQPass;
        aINF[1] = m_PCMRecord.m_Queue.getInformation();
        return aINF;
    }

    public static String byteArrayToHex(byte[] a, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("%02x ", a[i] & 0xFF));
        }
        return sb.toString();
    }

    static {
        m_PCMRecord = null;
        m_PCMTrack = null;
        m_Setting = null;
    }

    public static class PCMTrack
    extends Thread {
        private AudioTrack m_Track = null;
        private PCMSetting m_Setting = null;
        private boolean m_bFirstWrite = false;
        private PCMQueue m_Queue = null;
        private boolean m_bRunThread = false;
        int aaa = 0;
        private byte[] tempBUF = new byte[15000];

        public PCMTrack(PCMSetting Setting) {
            this.m_Setting = new PCMSetting();
            this.m_Setting.Copyfrom(Setting);
        }

        public void Open(int samplerate) {
            int sizeBUFMIM = AudioTrack.getMinBufferSize((int)samplerate, (int)4, (int)2);
            int sizeBUF = sizeBUFMIM > this.m_Setting.sizeTrackBUF ? sizeBUFMIM : this.m_Setting.sizeTrackBUF;
            printlog.i(PCMInterface.THIS_FILE, "flashmir Track sizeBUF = " + sizeBUF);
            this.m_Track = new AudioTrack(0, samplerate, 4, 2, sizeBUFMIM, 1);
            this.m_Track.flush();
            if (!SipManager.DEVICE_NAME.equalsIgnoreCase("SHV-E120K")) {
                this.m_Track.write(this.tempBUF, 0, sizeBUFMIM);
                this.m_Track.setPlaybackHeadPosition(sizeBUFMIM / 2);
            }
            this.aaa += sizeBUFMIM;
            this.m_Queue = new PCMQueue(this.m_Setting.sizeTrackBUF, this.m_Setting.sizeTrackCorrectBase, this.m_Setting.sizeTrackCorrect);
            this.m_bRunThread = true;
            this.start();
        }

        public void Close(int i) {
            this.m_bRunThread = false;
            this.m_Track.stop();
            this.m_Track.flush();
            this.m_Track.release();
            this.m_Track = null;
        }

        public int Write(byte[] buf, int size) {
            int sizeReturn = !this.m_bRunThread ? this.m_Track.write(buf, 0, size) : this.m_Queue.write(buf, 0, size);
            if (!this.m_bFirstWrite) {
                this.m_bFirstWrite = true;
            }
            return sizeReturn;
        }

        @Override
        public void run() {
            byte[] BUF = new byte[5120];
            printlog.i(PCMInterface.THIS_FILE, "flashmir Track run 1");
            this.m_Track.play();
            printlog.i(PCMInterface.THIS_FILE, "flashmir Track run 2");
            while (this.m_bRunThread) {
                int sizeQueue = this.m_Queue.getsizeFill();
                if (sizeQueue == 0) continue;
                int sizeRead = this.m_Queue.read(BUF, sizeQueue);
                this.m_Track.write(BUF, 0, sizeQueue);
            }
        }
    }

    public static class PCMRecord
    extends Thread {
        private AudioRecord m_Record = null;
        private PCMSetting m_Setting = new PCMSetting();
        private boolean m_bFirstRead = false;
        private PCMQueue m_Queue = null;
        private boolean m_bRunThread = false;

        public PCMRecord(PCMSetting Setting) {
            this.m_Setting.Copyfrom(Setting);
        }

        public void Open(int samplerate) {
            int sizeBUFMIM = AudioRecord.getMinBufferSize((int)samplerate, (int)16, (int)2);
            int sizeBUF = sizeBUFMIM > this.m_Setting.sizeRecordBUF ? sizeBUFMIM : this.m_Setting.sizeRecordBUF;
            this.m_Record = new AudioRecord(1, samplerate, 16, 2, sizeBUFMIM * 2);
            printlog.i(PCMInterface.THIS_FILE, "flashmir Record run 1");
            this.m_Record.startRecording();
            printlog.i(PCMInterface.THIS_FILE, "flashmir Record run 2");
            this.m_Queue = new PCMQueue(this.m_Setting.sizeRecordBUF, this.m_Setting.sizeRecordCorrectBase, this.m_Setting.sizeRecordCorrect);
            this.m_bRunThread = true;
            this.start();
        }

        public void Close(int i) {
            this.m_bRunThread = false;
            this.m_Record.stop();
            this.m_Record.release();
            this.m_Record = null;
        }

        public int Read(byte[] buf, int size) {
            int sizeReturn;
            if (!this.m_bRunThread) {
                sizeReturn = this.m_Record.read(buf, 0, size);
            } else {
                if (!this.m_bFirstRead) {
                    if (this.m_Queue.getsizeFill() <= 512) {
                        return -1;
                    }
                    this.m_bFirstRead = true;
                }
                if ((sizeReturn = this.m_Queue.read(buf, size)) == 0) {
                    sizeReturn = -1;
                }
            }
            return sizeReturn;
        }

        @Override
        public void run() {
            byte[] BUF = new byte[512];
            while (this.m_bRunThread) {
                int sizeRead = this.m_Record.read(BUF, 0, 512);
                if (sizeRead == 0) continue;
                this.m_Queue.write(BUF, 0, sizeRead);
            }
        }
    }

    public static class PCMSetting {
        public int sizeTrackCorrectBase = 0;
        public int sizeTrackCorrect = 0;
        public int sizeRecordCorrectBase = 0;
        public int sizeRecordCorrect = 0;
        public int sizeRecordBUF = 5120;
        public int sizeTrackBUF = 5120;

        public void Copyfrom(PCMSetting src) {
            this.sizeTrackCorrectBase = src.sizeTrackCorrectBase;
            this.sizeTrackCorrect = src.sizeTrackCorrect;
            this.sizeRecordCorrectBase = src.sizeRecordCorrectBase;
            this.sizeRecordCorrect = src.sizeRecordCorrect;
            this.sizeRecordBUF = src.sizeRecordBUF;
            this.sizeTrackBUF = src.sizeTrackBUF;
        }
    }

    public static class PCMQueue {
        private byte[] m_BUF = null;
        private int m_sizeBUF;
        private int m_ir;
        private int m_iw;
        private int m_sizeQMin;
        private int m_sizeQMax;
        private int m_sizeQPass;
        private int m_sizeCorrectBase;
        private int m_sizeCorrect;
        private int m_sizeProcess;

        public PCMQueue(int sizeBUF, int sizeCorrectBase, int sizeCorrect) {
            this.m_BUF = new byte[sizeBUF];
            this.m_sizeBUF = sizeBUF;
            this.m_ir = 0;
            this.m_iw = 0;
            this.m_sizeQMin = 0;
            this.m_sizeQMax = 0;
            this.m_sizeQPass = 0;
            this.m_sizeCorrectBase = sizeCorrectBase;
            this.m_sizeCorrect = sizeCorrect;
            this.m_sizeProcess = 0;
        }

        public int read(byte[] buf, int size) {
            int sizeQueue = (this.m_iw + this.m_sizeBUF - this.m_ir) % this.m_sizeBUF;
            if (sizeQueue < this.m_sizeQMin) {
                this.m_sizeQMin = sizeQueue;
            }
            if (this.m_sizeQMax < sizeQueue) {
                this.m_sizeQMax = sizeQueue;
            }
            if (sizeQueue < size) {
                return 0;
            }
            if (this.m_sizeBUF - this.m_ir < size) {
                System.arraycopy(this.m_BUF, this.m_ir, buf, 0, this.m_sizeBUF - this.m_ir);
                System.arraycopy(this.m_BUF, 0, buf, this.m_sizeBUF - this.m_ir, size - (this.m_sizeBUF - this.m_ir));
            } else {
                System.arraycopy(this.m_BUF, this.m_ir, buf, 0, size);
            }
            this.m_ir = (this.m_ir + size + this.m_sizeBUF) % this.m_sizeBUF;
            this.m_sizeQPass += size;
            return size;
        }

        public int write2(byte[] buf, int offset, int size) {
            int sizeFree = (this.m_ir + this.m_sizeBUF - this.m_iw) % this.m_sizeBUF;
            if (sizeFree == 0) {
                sizeFree = this.m_sizeBUF;
            }
            if (--sizeFree < size) {
                return 0;
            }
            if (size < 0) {
                return 0;
            }
            if (this.m_sizeBUF - this.m_iw < size) {
                System.arraycopy(buf, offset, this.m_BUF, this.m_iw, this.m_sizeBUF - this.m_iw);
                System.arraycopy(buf, offset + this.m_sizeBUF - this.m_iw, this.m_BUF, 0, size - (this.m_sizeBUF - this.m_iw));
            } else {
                System.arraycopy(buf, offset, this.m_BUF, this.m_iw, size);
            }
            this.m_iw = (this.m_iw + size + this.m_sizeBUF) % this.m_sizeBUF;
            return size;
        }

        public int write(byte[] buf, int offset, int size) {
            this.m_sizeProcess += size;
            if (0 < this.m_sizeCorrectBase && this.m_sizeCorrect != 0 && this.m_sizeCorrectBase <= this.m_sizeProcess) {
                if (0 < this.m_sizeCorrect) {
                    this.write2(buf, 0, this.m_sizeCorrect);
                    this.write2(buf, 0, size);
                } else {
                    this.write2(buf, 0, size + this.m_sizeCorrect);
                }
                this.m_sizeProcess -= this.m_sizeCorrectBase;
            } else {
                this.write2(buf, 0, size);
            }
            return size;
        }

        public void Flush() {
            this.m_ir = 0;
            this.m_iw = 0;
        }

        public int getsizeFill() {
            return (this.m_iw + this.m_sizeBUF - this.m_ir) % this.m_sizeBUF;
        }

        public PCMQueueInformation getInformation() {
            PCMQueueInformation INF = new PCMQueueInformation();
            INF.m_sizeQMin = this.m_sizeQMin;
            INF.m_sizeQMax = this.m_sizeQMax;
            INF.m_sizeQPass = this.m_sizeQPass;
            INF.m_sizeQFill = (this.m_iw + this.m_sizeBUF - this.m_ir) % this.m_sizeBUF;
            return INF;
        }
    }

    public static class PCMQueueInformation {
        public int m_sizeQMin;
        public int m_sizeQMax;
        public int m_sizeQPass;
        public int m_sizeQFill;
    }

    class myThread
    extends Thread {
        private boolean isPlay = false;

        public myThread(boolean isPlay) {
            this.isPlay = isPlay;
        }

        public void stopThread() {
            this.isPlay = !this.isPlay;
        }

        public boolean isPlayThread() {
            return this.isPlay;
        }

        @Override
        public void run() {
            super.run();
            while (this.isPlay) {
                PCMInterface.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PCMInterface.jNPMetrics(0, 0);
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    printlog.e(PCMInterface.THIS_FILE, "myThread, Run, Thread.sleep : Error.");
                    e.printStackTrace();
                }
            }
        }
    }
}

