/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadKNXSystem;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.artncore.WallPadDataMgr.WallpadStatusData;

public class WallPadKNX {
    private static final String TAG = "WallPadKNX";
    Context ctx;
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_ALARM = 1;
    public static final String STR_STATUS_NORMAL = "normal";
    public static final String STR_STATUS_ALARM = "alarm";
    public static final int DEVICE_MASTER_CONTROLLER = 0;
    public static final int DEVICE_KNX_GATEWAY = 1;
    public static final int DEVICE_BEDROOM_EM = 2;
    public static final int DEVICE_NETWORK_SWITCH = 3;
    public static final int DEVICE_LIVINGROOM_EM = 4;
    public static final int DEVICE_VALVE_CONTROLLER = 5;
    public static final int CAUSE_SET = 0;
    public static final int CAUSE_COMMUNICATION = 1;
    public static final int CAUSE_OUTDOORFANCOMM = 2;
    public static final int CAUSE_OUTDOORFANSET = 3;
    public static final int CAUSE_BUTTON = 4;
    public static final int CAUSE_PROXYSENSOR = 5;
    public static final int CAUSE_TEMPSENSOR = 6;
    public static final int CAUSE_LIGHTBALLAST = 7;
    public static final String STR_CAUSE_SET = "setting";
    public static final String STR_CAUSE_COMMUNICATION = "communication";
    public static final String STR_CAUSE_OUTDOORFANCOMM = "outdoorfan_comm";
    public static final String STR_CAUSE_OUTDOORFANSET = "outdoorfan_setting";
    public static final String STR_CAUSE_BUTTON = "button";
    public static final String STR_CAUSE_PROXYSENSOR = "proxi_sensor";
    public static final String STR_CAUSE_TEMPSENSOR = "temp_sensor";
    public static final String STR_CAUSE_LIGHTBALLAST = "lightballast_controller";
    public static final String BR_DEVICE = "DEVICE";
    public static final String BR_STATUS = "STATUS";
    public static final String BR_CAUSE_TYPE = "CAUSE_TYPE";
    public static final String BR_CAUSE_DETAIL = "CAUSE_DETAIL";
    public static final String BT_CAUSE_TIME = "CAUSE_TIME";

    public WallPadKNX(Context context) {
        this.ctx = context;
    }

    public KNX_HEARTBEAT GetHeartBeatAlarmStatus(int index) {
        Log.d((String)TAG, (String)("[GetHeartBeatAlarmStatus] index [" + index + "]"));
        KNX_HEARTBEAT knxHeartbeat = KNX_HEARTBEAT.NONE;
        try {
            WallpadStatusData DBMGR = new WallpadStatusData(this.ctx);
            String tempStatus = DBMGR.GetKNXAlarmStatus(index);
            String tempCause = DBMGR.GetKNXAlarmCause(index);
            DBMGR.closeDB();
            switch (index) {
                case 0: {
                    knxHeartbeat = KNX_HEARTBEAT.MASTER_CONTROLLER;
                    break;
                }
                case 1: {
                    knxHeartbeat = KNX_HEARTBEAT.KNX_GATEWAY;
                    break;
                }
                case 2: {
                    knxHeartbeat = KNX_HEARTBEAT.BEDROOM_EM;
                    break;
                }
                case 3: {
                    knxHeartbeat = KNX_HEARTBEAT.NETWORK_SWITCH;
                    break;
                }
                case 4: {
                    knxHeartbeat = KNX_HEARTBEAT.LIVINGROOM_EM;
                    break;
                }
                case 5: {
                    knxHeartbeat = KNX_HEARTBEAT.VALVE_CONTROLLER;
                    break;
                }
                default: {
                    knxHeartbeat = KNX_HEARTBEAT.NONE;
                }
            }
            knxHeartbeat.Status = tempStatus;
            knxHeartbeat.Cause = tempCause;
            Log.d((String)TAG, (String)("[GetHeartBeatAlarmStatus] Status [" + knxHeartbeat.Status + "], Cause [" + knxHeartbeat.Cause + "]"));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"[Exception] GetHeartBeatAlarmStatus(int index)");
            e.printStackTrace();
        }
        return knxHeartbeat;
    }

    public boolean BR_SendKNXDeviceEvent(int Device2, int Status2, int Cause, String CauseDetail, String CauseTime) {
        try {
            String strCause;
            if (Device2 < 0 || Device2 > 5) {
                Log.w((String)TAG, (String)("[BR_SendKNXDeviceEvent] - Device error [" + Device2 + "]"));
                return false;
            }
            String strStatus = STR_STATUS_ALARM;
            if (Status2 <= 0 || Status2 > 1) {
                Log.w((String)TAG, (String)("[BR_SendKNXDeviceEvent] - Status error [" + Status2 + "]"));
                return false;
            }
            if (Cause < 0 || Cause > 7) {
                Log.w((String)TAG, (String)("[BR_SendKNXDeviceEvent] - Cause error [" + Cause + "]"));
                return false;
            }
            switch (Cause) {
                case 0: {
                    strCause = STR_CAUSE_SET;
                    break;
                }
                case 1: {
                    strCause = STR_CAUSE_COMMUNICATION;
                    break;
                }
                case 2: {
                    strCause = STR_CAUSE_OUTDOORFANCOMM;
                    break;
                }
                case 3: {
                    strCause = STR_CAUSE_OUTDOORFANSET;
                    break;
                }
                case 4: {
                    strCause = STR_CAUSE_BUTTON;
                    break;
                }
                case 5: {
                    strCause = STR_CAUSE_PROXYSENSOR;
                    break;
                }
                case 6: {
                    strCause = STR_CAUSE_TEMPSENSOR;
                    break;
                }
                case 7: {
                    strCause = STR_CAUSE_LIGHTBALLAST;
                    break;
                }
                default: {
                    strCause = "null";
                }
            }
            Intent intent = new Intent();
            intent.setAction("WALLPAD_NOTIFY");
            intent.putExtra("KIND", 1302);
            intent.putExtra(BR_DEVICE, Device2);
            intent.putExtra(BR_STATUS, strStatus);
            intent.putExtra(BR_CAUSE_TYPE, strCause);
            intent.putExtra(BR_CAUSE_DETAIL, CauseDetail);
            intent.putExtra(BT_CAUSE_TIME, CauseTime);
            this.ctx.sendBroadcast(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static enum KNX_HEARTBEAT {
        MASTER_CONTROLLER(0, "normal", "null"),
        KNX_GATEWAY(1, "normal", "null"),
        BEDROOM_EM(2, "normal", "null"),
        NETWORK_SWITCH(3, "normal", "null"),
        LIVINGROOM_EM(4, "normal", "null"),
        VALVE_CONTROLLER(5, "normal", "null"),
        NONE(-1, "normal", "null");

        private int DeviceIdx;
        private String Status;
        private String Cause;

        private KNX_HEARTBEAT(int devIdx, String status, String cause) {
            this.DeviceIdx = devIdx;
            this.Status = status;
            this.Cause = cause;
        }

        public int getDeviceIndex() {
            return this.DeviceIdx;
        }

        public String getStatus() {
            return this.Status;
        }

        public String getCause() {
            return this.Cause;
        }
    }
}

