/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.wallpadapi;

import android.util.Log;
import com.artncore.commons.APIErrorCode;
import com.artncore.commons.KNX_DataClasses;
import com.artncore.wallpadapi.WallPadDevAPI;
import com.artncore.wallpaddevservice.DevCtrCMD;

public class KnxAPI
extends WallPadDevAPI {
    private final String TAG = "KnxAPI";
    private final boolean DEBUG_LOG_ON = false;
    public static byte EM_INDEX_LIVING = 1;
    public static byte MAX_LIGHT_COUNT = (byte)4;
    public static byte MAX_EM_COUNT = (byte)15;
    public static byte MAX_CONCENT_COUNT = (byte)4;
    public Data data;
    private EmCountDataClass EmCountData;

    private void DebugLogOutput(String s) {
    }

    public KnxAPI(DevCtrCMD devctrcmd) {
        this.DebugLogOutput("KnxAPI create " + devctrcmd);
        this.ErrorCode = new APIErrorCode();
        this.DevctrCMD = devctrcmd;
        this.TitleStr = "KNX_DISTRIBUTION_BD";
        this.data = new Data();
        int ret = this.EmCountData_Load();
        if (ret < 0) {
            Log.w((String)"KnxAPI", (String)("[create] EmCountData_Load Error (ret:" + ret + ")"));
        }
    }

    public int Refresh(byte DeviceIndex, byte EmIndex) {
        int iret;
        int ret;
        String FUNC_NAME = "[Refresh]";
        this.DebugLogOutput(FUNC_NAME + "(DeviceIndex:" + DeviceIndex + ", EmIndex:" + EmIndex + ")");
        if ((DeviceIndex == DEVICE_INDEX.ALL || DeviceIndex == DEVICE_INDEX.ENERGY_METER) && (ret = this.EmCountData_Load()) < 0) {
            Log.w((String)"KnxAPI", (String)("[Refresh] EmCountData_Load Error (ret:" + ret + ")"));
            return -101;
        }
        if (DeviceIndex == DEVICE_INDEX.ALL) {
            if (EmIndex != -1) {
                Log.w((String)"KnxAPI", (String)("[Refresh] Param : EmIndex - Out Of Range !!! For DeviceIndex:DEVICE_INDEX.ALL, EmIndex must be define.DEVICE_ALL_OR_NOTHING.  (EmIndex:" + EmIndex + ")"));
                return -300;
            }
        } else if (!DEVICE_INDEX.CheckRange(DeviceIndex)) {
            Log.w((String)"KnxAPI", (String)("[Refresh] Param : DeviceIndex - Out Of Range !!!  (DeviceIndex:" + DeviceIndex + ")"));
            return -300;
        }
        if (DeviceIndex == DEVICE_INDEX.ENERGY_METER && EmIndex != -1 && (iret = this.IndexRangeCheck(EmIndex, (byte)-1, (byte)-1)) < 0) {
            Log.w((String)"KnxAPI", (String)("[Refresh] IndexRangeCheck Error (ret:" + iret + ")"));
            return iret;
        }
        String MainCMD = "NOSINKCTRL";
        String SubCMD = "Refresh";
        String ret2 = null;
        int iret2 = -1;
        if (DeviceIndex == DEVICE_INDEX.ALL) {
            byte j;
            byte i;
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.MASTER_CONT, 0, 0, 0, 0);
            iret2 = this.Parsing_MasterCont(ret2);
            if (iret2 < 0) {
                Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_MasterCont Error !!! (iret:" + iret2 + ")"));
                return iret2;
            }
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.ENERGY_METER, EM_TYPE.LIVING_ENERGY_METER, 0, 0, 0);
            iret2 = this.Parsing_EnergyMeter(ret2, EM_TYPE.LIVING_ENERGY_METER, EM_INDEX_LIVING);
            if (iret2 != 0) {
                Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_EnergyMeter Error !!! (EM_INDEX_LIVING) (iret:" + iret2 + ")"));
                return -111;
            }
            for (i = 0; i < this.EmCountData.BadRoom_Em_Count && this.Parsing_EnergyMeter(ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.ENERGY_METER, EM_TYPE.BAD_ENERGY_METER, i, 0, 0), EM_TYPE.BAD_ENERGY_METER, i) == 0; i = (byte)(i + 1)) {
            }
            if (i < this.EmCountData.BadRoom_Em_Count) {
                Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_EnergyMeter Error !!! (i:" + i + ")"));
                return -111;
            }
            for (j = 0; j < this.EmCountData.LightSwitch_Count && this.Parsing_LightSwitch(ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.LIGHT_SWITCH, EM_TYPE.LIGHT_SWITCH, j, 0, 0), EM_TYPE.LIGHT_SWITCH, j) == 0; j = (byte)(j + 1)) {
            }
            if (j < this.EmCountData.LightSwitch_Count) {
                Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_LightSwitch Error !!! (i:" + j + ")"));
                return -111;
            }
            return 0;
        }
        if (DeviceIndex == DEVICE_INDEX.MASTER_CONT) {
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DeviceIndex, 0, 0, 0, 0);
            return this.Parsing_MasterCont(ret2);
        }
        if (DeviceIndex == DEVICE_INDEX.ENERGY_METER) {
            if (EmIndex == -1) {
                byte i;
                ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.ENERGY_METER, EM_TYPE.LIVING_ENERGY_METER, 0, 0, 0);
                iret2 = this.Parsing_EnergyMeter(ret2, EM_TYPE.LIVING_ENERGY_METER, EM_INDEX_LIVING);
                if (iret2 != 0) {
                    Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_EnergyMeter Error !!! (EM_INDEX_LIVING) (iret:" + iret2 + ")"));
                    return -111;
                }
                for (i = 0; i < this.EmCountData.BadRoom_Em_Count && this.Parsing_EnergyMeter(ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.ENERGY_METER, EM_TYPE.BAD_ENERGY_METER, i, 0, 0), EM_TYPE.BAD_ENERGY_METER, i) == 0; i = (byte)(i + 1)) {
                }
                if (i < this.EmCountData.BadRoom_Em_Count) {
                    Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ENERGY_METER - Parsing_EnergyMeter Error !!! (i:" + i + ")"));
                    return -111;
                }
                return 0;
            }
            ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, EmIndex, 0, 0, 0, 0);
            return this.Parsing_EnergyMeter(ret2, EM_TYPE.BAD_ENERGY_METER, EmIndex);
        }
        if (DeviceIndex == DEVICE_INDEX.LIGHT_SWITCH) {
            byte j;
            for (j = 0; j < this.EmCountData.LightSwitch_Count && this.Parsing_LightSwitch(ret2 = this.SendNReadCMD_str(MainCMD, SubCMD, DEVICE_INDEX.LIGHT_SWITCH, EM_TYPE.LIGHT_SWITCH, j, 0, 0), EM_TYPE.LIGHT_SWITCH, j) == 0; j = (byte)(j + 1)) {
            }
            if (j < this.EmCountData.LightSwitch_Count) {
                Log.w((String)"KnxAPI", (String)("[Refresh] DEVICE_INDEX.ALL - Parsing_LightSwitch Error !!! (i:" + j + ")"));
                return -111;
            }
            return 0;
        }
        Log.w((String)"KnxAPI", (String)("[Refresh] Param (Index) Out Of Range #2 !!! (" + DeviceIndex + ")"));
        return -300;
    }

    private int Parsing_MasterCont(String ret) {
        String FUNC_NAME = "[Parsing_MasterCont]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        try {
            if (ret == null) {
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            KNX_DataClasses.MasterControllerClass MasterController = new KNX_DataClasses.MasterControllerClass();
            int index = 1;
            MasterController.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!MasterController.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 8;
            MasterController.Info.Liv_EnergyMeterCount = Byte.parseByte(retData[index++]);
            MasterController.Info.Bad_EnergyMeterCount = Byte.parseByte(retData[index++]);
            MasterController.Info.Light_SwitchCount = Byte.parseByte(retData[index++]);
            MasterController.Data.PowerFault_Status = Boolean.parseBoolean(retData[index++]);
            MasterController.Data.Fault_KnxGwComm = Boolean.parseBoolean(retData[index++]);
            MasterController.Data.Fault_KnxGwSet = Boolean.parseBoolean(retData[index++]);
            MasterController.Data.Fault_EmComm = Boolean.parseBoolean(retData[index++]);
            MasterController.Data.Fault_LightSwitchComm = Boolean.parseBoolean(retData[index++]);
            MasterController.Data.OutingStatus = Byte.parseByte(retData[index++]);
            MasterController.Data.BatchOffStatus = Byte.parseByte(retData[index++]);
            MasterController.Data.AllConcentStatus = Byte.parseByte(retData[index++]);
            this.data.MasterController = MasterController;
        }
        catch (Exception e) {
            Log.e((String)"KnxAPI", (String)(FUNC_NAME + " Exception Error"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int Parsing_EnergyMeter(String ret, byte EmType, byte EmIndex) {
        String FUNC_NAME = "[Parsing_EnergyMeter]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        int index = 0;
        try {
            byte i;
            if (ret == null) {
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            KNX_DataClasses.EnergyMeterClass EnergyMeter2 = new KNX_DataClasses.EnergyMeterClass();
            index = 1;
            EnergyMeter2.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!EnergyMeter2.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 8;
            EnergyMeter2.Info.LightCount = Byte.parseByte(retData[index++]);
            EnergyMeter2.Info.LightType_1 = Byte.parseByte(retData[index++]);
            EnergyMeter2.Info.LightType_2 = Byte.parseByte(retData[index++]);
            EnergyMeter2.Info.LightType_3 = Byte.parseByte(retData[index++]);
            EnergyMeter2.Info.LightType_4 = Byte.parseByte(retData[index++]);
            EnergyMeter2.Info.ConcentCount = Byte.parseByte(retData[index++]);
            EnergyMeter2.Data.setConcent(EnergyMeter2.Info.ConcentCount);
            if (EmType == EM_TYPE.LIVING_ENERGY_METER) {
                EnergyMeter2.Data.setLivingLight(EnergyMeter2.Info.LightCount);
            } else if (EmType == EM_TYPE.BAD_ENERGY_METER) {
                EnergyMeter2.Data.setBadLight(EnergyMeter2.Info.LightCount);
            }
            EnergyMeter2.Data.CommFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.AlmostSenFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.WifiModuleFault = Boolean.parseBoolean(retData[index++]);
            EnergyMeter2.Data.TempSenFault = Boolean.parseBoolean(retData[index++]);
            if (EmType == EM_TYPE.LIVING_ENERGY_METER) {
                for (i = 0; i < EnergyMeter2.Info.LightCount; i = (byte)(i + 1)) {
                    EnergyMeter2.Data.LivingLight[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Info.Support.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Info.Support.Dimming = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Info.Support.Color = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Data.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Data.Dimming = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.LivingLight[i].Data.Color = Byte.parseByte(retData[index++]);
                }
            } else if (EmType == EM_TYPE.BAD_ENERGY_METER) {
                for (i = 0; i < EnergyMeter2.Info.LightCount; i = (byte)(i + 1)) {
                    EnergyMeter2.Data.BadLight[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Info.Support.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Info.Support.Dimming = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Info.Support.Color = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Data.OnOff = Boolean.parseBoolean(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Data.Dimming = Byte.parseByte(retData[index++]);
                    EnergyMeter2.Data.BadLight[i].Data.Color = Byte.parseByte(retData[index++]);
                }
            }
            for (i = 0; i < EnergyMeter2.Info.ConcentCount; i = (byte)(i + 1)) {
                EnergyMeter2.Data.Concent[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                if (!EnergyMeter2.Data.Concent[i].Info.Version.setData(retData, index)) {
                    return -2;
                }
                index += 8;
                EnergyMeter2.Data.Concent[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.Status = Byte.parseByte(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.Mode = Byte.parseByte(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.NowPw = Double.parseDouble(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.AccPw = Integer.parseInt(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.CutOffConcent.CutOffVal = Double.parseDouble(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.AlwaysConcent.NowPw = Double.parseDouble(retData[index++]);
                EnergyMeter2.Data.Concent[i].Data.AlwaysConcent.AccPw = Integer.parseInt(retData[index++]);
            }
            if (EmType == EM_TYPE.LIVING_ENERGY_METER) {
                this.data.LivingRoom_EnergyMeter = EnergyMeter2;
            } else if (EmType == EM_TYPE.BAD_ENERGY_METER) {
                this.data.BadRoom_EnergyMeter[EmIndex] = EnergyMeter2;
            }
        }
        catch (Exception e) {
            Log.e((String)"KnxAPI", (String)(FUNC_NAME + " Exception Error (index:" + index + ")"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    private int Parsing_LightSwitch(String ret, byte EmType, byte EmIndex) {
        String FUNC_NAME = "[Parsing_LightSwitch]";
        this.DebugLogOutput(FUNC_NAME + " START - (ret:" + ret + ")");
        int index = 0;
        try {
            if (ret == null) {
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " ret return value is null !!!"));
                return -101;
            }
            String[] retData = ret.split(";");
            this.DebugLogOutput(FUNC_NAME + " Parsing Length = " + retData.length);
            if (retData == null) {
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData value is null !!!"));
                return -101;
            }
            if (!retData[0].equals("SUCCESS")) {
                if (retData.length >= 2) {
                    Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData[0] No Success #1 (" + Integer.parseInt(retData[1]) + ")"));
                    return Integer.parseInt(retData[1]);
                }
                Log.w((String)"KnxAPI", (String)(FUNC_NAME + " retData[0] No Success #2 (" + retData[0] + ")"));
                return -101;
            }
            KNX_DataClasses.LightSwithcClass LightSwitch = new KNX_DataClasses.LightSwithcClass();
            index = 1;
            LightSwitch.Info.Install = Boolean.parseBoolean(retData[index++]);
            if (!LightSwitch.Info.Version.setData(retData, index)) {
                return -2;
            }
            index += 8;
            LightSwitch.Info.LightCount = Byte.parseByte(retData[index++]);
            if (EmType == EM_TYPE.LIGHT_SWITCH) {
                LightSwitch.Data.setLightSwitch(LightSwitch.Info.LightCount);
            }
            LightSwitch.Info.LightType_1 = Byte.parseByte(retData[index++]);
            LightSwitch.Info.LightType_2 = Byte.parseByte(retData[index++]);
            LightSwitch.Info.LightType_3 = Byte.parseByte(retData[index++]);
            LightSwitch.Info.LightType_4 = Byte.parseByte(retData[index++]);
            LightSwitch.Data.CommFault = Boolean.parseBoolean(retData[index++]);
            if (EmType == EM_TYPE.LIGHT_SWITCH) {
                for (byte i = 0; i < LightSwitch.Info.LightCount; i = (byte)(i + 1)) {
                    LightSwitch.Data.LightSwitch[i].Info.Install = Boolean.parseBoolean(retData[index++]);
                    LightSwitch.Data.LightSwitch[i].Info.Support.OnOff = Boolean.parseBoolean(retData[index++]);
                    LightSwitch.Data.LightSwitch[i].Data.CommFault = Boolean.parseBoolean(retData[index++]);
                    LightSwitch.Data.LightSwitch[i].Data.OnOff = Boolean.parseBoolean(retData[index++]);
                }
            }
            if (EmType == EM_TYPE.LIGHT_SWITCH) {
                this.data.Light_Switch[EmIndex] = LightSwitch;
            }
        }
        catch (Exception e) {
            Log.e((String)"KnxAPI", (String)(FUNC_NAME + " Exception Error (index:" + index + ")"));
            e.printStackTrace();
            return -100000;
        }
        return 0;
    }

    public int AllLightOnOff(boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "AllLightOnOff", OnOff ? 1 : 0, 0, 0, 0, 0);
    }

    public int SetLight(byte EmIndex, byte LightIndex, boolean OnOff, byte Dimming, byte Color) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"KnxAPI", (String)("[SetLight] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"KnxAPI", (String)("[SetLight] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"KnxAPI", (String)("[SetLight] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLight", EmIndex, LightIndex, OnOff ? 1 : 0, Dimming, Color);
    }

    public int SetLightOnOff(byte EmIndex, byte LightIndex, boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetLightOnOff", EmIndex, LightIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetLightSwitchOnOff(byte EmIndex, byte LightIndex, boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetLightSwitchOnOff", EmIndex, LightIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetLivingLightOnOff(byte LightIndex, boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetLivingLightOnOff", LightIndex, OnOff ? 1 : 0, 0, 0, 0);
    }

    public int SetLightDimming(byte LightIndex, byte Dimming) {
        if (!this.LightIndexRangeCheck(LightIndex)) {
            Log.w((String)"KnxAPI", (String)"[SetLightDimming] LightIndexRangeCheck Error");
            return -300;
        }
        if (!this.DimmingNColorRangeCheck(Dimming)) {
            Log.w((String)"KnxAPI", (String)("[SetLightDimming] Param : Dimming Out Of Range !!! (Dimming:" + Dimming + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightDimming", LightIndex, Dimming, 0, 0, 0);
    }

    public int SetLightColor(byte EmIndex, byte LightIndex, byte Color) {
        int ret = this.IndexRangeCheck(EmIndex, LightIndex, (byte)-1);
        if (ret < 0) {
            Log.w((String)"KnxAPI", (String)("[SetLightColor] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        if (!this.DimmingNColorRangeCheck(Color)) {
            Log.w((String)"KnxAPI", (String)("[SetLightColor] Param : Color Out Of Range !!! (Color:" + Color + ")"));
            return -300;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetLightColor", EmIndex, LightIndex, Color, 0, 0);
    }

    public int SetConcentOnOff(byte EmIndex, byte ConcentIndex, boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentOnOff", EmIndex, ConcentIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetLivingConcentOnOff(byte ConcentIndex, boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetLivingConcentOnOff", ConcentIndex, OnOff ? 1 : 0, 0, 0, 0);
    }

    public int SetConcentMode(byte EmIndex, byte ConcentIndex, boolean OnOff) {
        int ret = this.IndexRangeCheck(EmIndex, (byte)-1, ConcentIndex);
        if (ret < 0) {
            Log.w((String)"KnxAPI", (String)("[SetConcentMode] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentMode", EmIndex, ConcentIndex, OnOff ? 1 : 0, 0, 0);
    }

    public int SetLivingConcentMode(byte ConcentIndex, boolean OnOff) {
        return this.SendNReadCMD_int("SINKCTRL", "SetLivingConcentMode", ConcentIndex, OnOff ? 1 : 0, 0, 0, 0);
    }

    public int SetConcentCutOff(byte EmIndex, byte ConcentIndex) {
        int ret = this.IndexRangeCheck(EmIndex, (byte)-1, ConcentIndex);
        if (ret < 0) {
            Log.w((String)"KnxAPI", (String)("[SetConcentCutOff] IndexRangeCheck Error (ret:" + ret + ")"));
            return ret;
        }
        return this.SendNReadCMD_int("SINKCTRL", "SetConcentCutOff", EmIndex, ConcentIndex, 0, 0, 0);
    }

    private int GetEnergyMeterCount() {
        String ret = this.SendNReadCMD_str("NOSINKCTRL", "GetEnergyMeterCount", 0, 0, 0, 0, 0);
        if (ret == null) {
            return -101;
        }
        String[] retlist = ret.split(";");
        if (retlist == null) {
            return -101;
        }
        if (retlist.length < 2) {
            return -102;
        }
        if (retlist[0].equals("SUCCESS")) {
            int index = 0;
            try {
                byte Light_Switch_Count;
                EmCountDataClass emCountData = new EmCountDataClass();
                index = 1;
                emCountData.LivingRoom_Em_LightCount = Byte.parseByte(retlist[index++]);
                emCountData.LivingRoom_Em_ConcentCount = Byte.parseByte(retlist[index++]);
                byte BadRoom_Em_Count = Byte.parseByte(retlist[index++]);
                if (BadRoom_Em_Count <= 0) {
                    Log.w((String)"KnxAPI", (String)("[GetEnergyMeterCount] BadRoom_Em_Count Error ...(Count:" + BadRoom_Em_Count + ")"));
                    return -1;
                }
                emCountData.BadRoom_Em_Count = BadRoom_Em_Count;
                emCountData.BadRoom_Em_LightCount = new byte[BadRoom_Em_Count];
                emCountData.BadRoom_Em_ConcentCount = new byte[BadRoom_Em_Count];
                for (byte i = 0; i < BadRoom_Em_Count; i = (byte)(i + 1)) {
                    emCountData.BadRoom_Em_LightCount[i] = Byte.parseByte(retlist[index++]);
                    emCountData.BadRoom_Em_ConcentCount[i] = Byte.parseByte(retlist[index++]);
                }
                if ((Light_Switch_Count = Byte.parseByte(retlist[index++])) <= 0) {
                    Log.w((String)"KnxAPI", (String)("[GetEnergyMeterCount] Light_Switch_Count Error ...(Count:" + Light_Switch_Count + ")"));
                    return -1;
                }
                emCountData.LightSwitch_Count = Light_Switch_Count;
                emCountData.LightSwitch_LightCount = new byte[Light_Switch_Count];
                for (byte i = 0; i < Light_Switch_Count; i = (byte)(i + 1)) {
                    emCountData.LightSwitch_LightCount[i] = Byte.parseByte(retlist[index++]);
                }
                this.EmCountData = emCountData;
                return 0;
            }
            catch (Exception e) {
                Log.e((String)"KnxAPI", (String)("[GetEnergyMeterCount] - [Exception Error] Parse (" + index + ")"));
                e.printStackTrace();
                this.EmCountData = null;
                return -100;
            }
        }
        this.ErrorCode.Set_Error_Code(Integer.parseInt(retlist[1]));
        this.EmCountData = null;
        return -1;
    }

    private int EmCountData_Load() {
        if (this.EmCountData == null || this.EmCountData.BadRoom_Em_Count == 0) {
            int ret = this.GetEnergyMeterCount();
            if (ret < 0) {
                Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - GetEnergyMeterCount Error#1 !!!(ret:" + ret + ")"));
                return -101;
            }
            this.data.BadRoom_Em_Count = this.EmCountData.BadRoom_Em_Count;
            this.data.Light_Switch_Count = this.EmCountData.LightSwitch_Count;
        }
        if (this.data.BadRoom_EnergyMeter == null) {
            this.data.BadRoom_EnergyMeter = new KNX_DataClasses.EnergyMeterClass[this.EmCountData.BadRoom_Em_Count];
        }
        if (this.data.Light_Switch == null) {
            this.data.Light_Switch = new KNX_DataClasses.LightSwithcClass[this.EmCountData.LightSwitch_Count];
        }
        return 0;
    }

    private boolean DimmingNColorRangeCheck(byte DimmingNColor) {
        return DimmingNColor >= 1 && DimmingNColor <= 10;
    }

    private int IndexRangeCheck(byte EmIndex, byte LightIndex, byte ConcentIndex) {
        if (EmIndex < 0 || EmIndex > MAX_EM_COUNT) {
            Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : EmIndex - Default Check Error !!!(EmIndex:" + EmIndex + ")"));
            return -300;
        }
        if (LightIndex != -1 && (LightIndex < 0 || LightIndex >= MAX_LIGHT_COUNT)) {
            Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : LightIndex - Default Check Error !!!(LightIndex:" + LightIndex + ")"));
            return -300;
        }
        if (ConcentIndex != -1 && (ConcentIndex < 0 || ConcentIndex >= MAX_CONCENT_COUNT)) {
            Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : ConcentIndex - Default Check Error !!!(ConcentIndex:" + ConcentIndex + ")"));
            return -300;
        }
        int ret = this.EmCountData_Load();
        if (ret < 0) {
            Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] EmCountData_Load Error (ret:" + ret + ")"));
            return -101;
        }
        if (EmIndex == EM_INDEX_LIVING) {
            byte ConcentCount;
            byte LightCount;
            if (LightIndex != -1 && LightIndex >= (LightCount = this.EmCountData.LivingRoom_Em_LightCount)) {
                Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : LivingRoom LightIndex - Out Of Range !!!(LightIndex:" + LightIndex + ", LightCount:" + LightCount + ")"));
                return -300;
            }
            if (ConcentIndex != -1 && ConcentIndex >= (ConcentCount = this.EmCountData.LivingRoom_Em_ConcentCount)) {
                Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : LivingRoom ConcentIndex - Out Of Range !!!(ConcentIndex:" + ConcentIndex + ", ConcentCount:" + ConcentCount + ")"));
                return -300;
            }
        } else {
            byte ConcentCount;
            byte LightCount;
            if (EmIndex >= this.EmCountData.BadRoom_Em_Count) {
                Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : EmIndex - Out Of Range !!!(EmIndex:" + EmIndex + ", BadRoom_Em_Count:" + this.EmCountData.BadRoom_Em_Count + ")"));
                return -300;
            }
            if (LightIndex != -1 && LightIndex >= (LightCount = this.EmCountData.BadRoom_Em_LightCount[EmIndex])) {
                Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : BadRoom LightIndex - Out Of Range !!!(LightIndex:" + LightIndex + ", LightCount:" + LightCount + ")"));
                return -300;
            }
            if (ConcentIndex != -1 && ConcentIndex >= (ConcentCount = this.EmCountData.BadRoom_Em_ConcentCount[EmIndex])) {
                Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : BadRoom ConcentIndex - Out Of Range !!!(ConcentIndex:" + ConcentIndex + ", ConcentCount:" + ConcentCount + ")"));
                return -300;
            }
        }
        return 0;
    }

    private boolean LightIndexRangeCheck(byte LightIndex) {
        if (LightIndex != -1 && (LightIndex < 0 || LightIndex >= MAX_LIGHT_COUNT)) {
            Log.w((String)"KnxAPI", (String)("[IndexRangeCheck] - Param : LightIndex - Default Check Error !!!(LightIndex:" + LightIndex + ")"));
            return false;
        }
        return true;
    }

    private class EmCountDataClass {
        public byte LivingRoom_Em_LightCount = 0;
        public byte LivingRoom_Em_ConcentCount = 0;
        public byte BadRoom_Em_Count = 0;
        public byte[] BadRoom_Em_LightCount = null;
        public byte[] BadRoom_Em_ConcentCount = null;
        public byte LightSwitch_Count = 0;
        public byte[] LightSwitch_LightCount = null;

        private EmCountDataClass() {
        }
    }

    public static class Data {
        public byte BadRoom_Em_Count = 0;
        public byte Light_Switch_Count = 0;
        public KNX_DataClasses.MasterControllerClass MasterController = null;
        public KNX_DataClasses.EnergyMeterClass LivingRoom_EnergyMeter = null;
        public KNX_DataClasses.EnergyMeterClass[] BadRoom_EnergyMeter = null;
        public KNX_DataClasses.LightSwithcClass[] Light_Switch = null;
    }

    public static class EM_TYPE {
        public static byte LIVING_ENERGY_METER = 0;
        public static byte BAD_ENERGY_METER = 1;
        public static byte LIGHT_SWITCH = (byte)2;

        public static boolean CheckRange(byte nDeviceType) {
            return nDeviceType >= 0 && nDeviceType <= LIGHT_SWITCH;
        }

        public static String ToString(byte nDeviceType) {
            if (nDeviceType >= 0 && nDeviceType <= LIGHT_SWITCH) {
                return "ENERGY_METER TYPE #" + nDeviceType;
            }
            return "UnDefined";
        }
    }

    public static class DEVICE_INDEX {
        public static byte ENERGY_METER = 0;
        public static byte MASTER_CONT = (byte)16;
        public static byte LIGHT_SWITCH = (byte)48;
        public static byte ALL = (byte)-1;

        public static boolean CheckRange(byte nDeviceIndex) {
            if (nDeviceIndex >= 0 && nDeviceIndex <= EM_INDEX_LIVING) {
                return true;
            }
            return nDeviceIndex == MASTER_CONT;
        }

        public static String ToString(byte nDeviceIndex) {
            if (nDeviceIndex >= 0 && nDeviceIndex <= EM_INDEX_LIVING) {
                return "ENERGY_METER #" + nDeviceIndex;
            }
            if (nDeviceIndex == MASTER_CONT) {
                return "MASTER_CONT";
            }
            return "UnDefined";
        }
    }
}

