/*
 * Decompiled with CFR 0.152.
 */
package com.artncore.WallPadDataMgr;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.artncore.WallPadDataMgr.wallpaddbmgr;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class WallpadScheduleData
extends wallpaddbmgr {
    String TAG = "WallpadScheduleData";
    protected List<ScheduleData> ScData = new ArrayList<ScheduleData>();

    public WallpadScheduleData(Context ctx) {
        super(ctx);
        if (!this.CheckTableExist("ScheduleDB")) {
            try {
                this.wdb.execSQL("create table ScheduleDB (seqnum INTEGER PRIMARY KEY AUTOINCREMENT, inqnum INTEGER,  inqttype  text, inqctype  text, inqatype  text, inqitype  text, inqyear INTEGER, inqmonth INTEGER, inqday INTEGER, inqhour INTEGER, inqmsg text);");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean CheckLunarTable() {
        String dbpath = dblocation + "LunaDB.db";
        SQLiteDatabase wdb_Luna = null;
        int getCount = 0;
        try {
            wdb_Luna = SQLiteDatabase.openDatabase((String)dbpath, null, (int)1);
            if (wdb_Luna != null) {
                String query = "select * from LunarTBL;";
                Cursor cursor = wdb_Luna.rawQuery(query, null);
                if (cursor != null) {
                    getCount = cursor.getCount();
                }
                Log.d((String)"WallpadScheduleData", (String)("LunarTable's Row Count : " + getCount));
                cursor.close();
                wdb_Luna.close();
            } else {
                Log.e((String)"WallpadScheduleData", (String)"LunarTable's not exist");
                Log.e((String)"WallpadScheduleData", (String)("LunarTable's path: " + dbpath));
            }
            return getCount > 8000;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String GetLunarDate(String SolarDate) {
        String dbpath = dblocation + "LunaDB.db";
        SQLiteDatabase wdb_Luna = null;
        String ReturnTemp = null;
        try {
            wdb_Luna = SQLiteDatabase.openDatabase((String)dbpath, null, (int)1);
            if (wdb_Luna != null) {
                String query = "select  lunar from LunarTBL where solar = " + SolarDate + " ;";
                Cursor cursor = wdb_Luna.rawQuery(query, null);
                if (cursor.moveToNext()) {
                    ReturnTemp = String.valueOf(cursor.getInt(0));
                }
                cursor.close();
                wdb_Luna.close();
            } else {
                Log.e((String)"WallpadScheduleData", (String)"LunarTable's not exist");
                Log.e((String)"WallpadScheduleData", (String)("LunarTable's path: " + dbpath));
            }
        }
        catch (SQLiteCantOpenDatabaseException e) {
            if (wdb_Luna != null) {
                wdb_Luna.close();
            }
            e.printStackTrace();
        }
        return ReturnTemp;
    }

    public String GetSolarDate(String LunarDate) {
        String dbpath = dblocation + "LunaDB.db";
        SQLiteDatabase wdb_Luna = null;
        String ReturnTemp = null;
        try {
            wdb_Luna = SQLiteDatabase.openDatabase((String)dbpath, null, (int)1);
            if (wdb_Luna != null) {
                String query = "select  solar from LunarTBL where lunar = " + LunarDate + " ;";
                Cursor cursor = wdb_Luna.rawQuery(query, null);
                if (cursor.moveToNext()) {
                    ReturnTemp = String.valueOf(cursor.getInt(0));
                }
                cursor.close();
                wdb_Luna.close();
            } else {
                Log.e((String)"WallpadScheduleData", (String)"LunarTable's not exist");
                Log.e((String)"WallpadScheduleData", (String)("LunarTable's path: " + dbpath));
            }
        }
        catch (SQLiteCantOpenDatabaseException e) {
            if (wdb_Luna != null) {
                wdb_Luna.close();
            }
            e.printStackTrace();
        }
        return ReturnTemp;
    }

    public List<ScheduleData> NewGetScheduleData(int year, int month) {
        ArrayList<ScheduleData> DataList = new ArrayList<ScheduleData>();
        ArrayList<ScheduleData> ReturnList = new ArrayList<ScheduleData>();
        try {
            String query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqyear, inqmonth, inqday, inqhour, inqmsg from ScheduleDB order by seqnum asc;";
            Cursor cursor = this.wdb.rawQuery(query, null);
            while (cursor.moveToNext()) {
                ScheduleData getdata = new ScheduleData();
                getdata.seqnum = cursor.getInt(0);
                getdata.inqnum = 0;
                getdata.inqttype = cursor.getString(2);
                getdata.inqctype = cursor.getString(3);
                getdata.inqatype = cursor.getString(4);
                getdata.inqitype = cursor.getString(5);
                getdata.inqyear = cursor.getInt(6);
                getdata.inqmonth = cursor.getInt(7);
                getdata.inqday = cursor.getInt(8);
                getdata.inqhour = cursor.getInt(9);
                getdata.inqmsg = cursor.getString(10);
                DataList.add(getdata);
            }
            for (int i = 0; i < DataList.size(); ++i) {
                if (((ScheduleData)DataList.get((int)i)).inqttype.equals("moon")) {
                    int Stday;
                    int Stmonth;
                    int Styear;
                    String lunarDay;
                    if (((ScheduleData)DataList.get((int)i)).inqctype.equals("month")) {
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", year, month, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)"API", (String)(year + "." + month + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                            continue;
                        }
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                        ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                        ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                        ReturnList.add((ScheduleData)DataList.get(i));
                        continue;
                    }
                    if (((ScheduleData)DataList.get((int)i)).inqctype.equals("year")) {
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", year, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)"API", (String)(year + "." + month + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                            continue;
                        }
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        if (month != Stmonth) continue;
                        ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                        ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                        ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                        ReturnList.add((ScheduleData)DataList.get(i));
                        continue;
                    }
                    lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", ((ScheduleData)DataList.get((int)i)).inqyear, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                    if (lunarDay == null) {
                        Log.e((String)"API", (String)(year + "." + month + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                        continue;
                    }
                    Styear = 0;
                    Stmonth = 0;
                    Stday = 0;
                    Styear = Integer.parseInt(lunarDay.substring(0, 4));
                    Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                    Stday = Integer.parseInt(lunarDay.substring(6, 8));
                    if (month != Stmonth || year != Styear) continue;
                    ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                    ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                    ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqctype.equals("month")) {
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqctype.equals("year")) {
                    if (((ScheduleData)DataList.get((int)i)).inqmonth != month) continue;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqmonth != month || ((ScheduleData)DataList.get((int)i)).inqyear != year) continue;
                ReturnList.add((ScheduleData)DataList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ReturnList;
    }

    public List<ScheduleData> NewGetScheduleDataForMainActivity(int year, int month, int day) {
        ArrayList<ScheduleData> DataList = new ArrayList<ScheduleData>();
        ArrayList<ScheduleData> ReturnList = new ArrayList<ScheduleData>();
        try {
            String query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqyear, inqmonth, inqday, inqhour, inqmsg from ScheduleDB order by seqnum asc;";
            Cursor cursor = this.wdb.rawQuery(query, null);
            while (cursor.moveToNext()) {
                ScheduleData getdata = new ScheduleData();
                getdata.seqnum = cursor.getInt(0);
                getdata.inqnum = 0;
                getdata.inqttype = cursor.getString(2);
                getdata.inqctype = cursor.getString(3);
                getdata.inqatype = cursor.getString(4);
                getdata.inqitype = cursor.getString(5);
                getdata.inqyear = cursor.getInt(6);
                getdata.inqmonth = cursor.getInt(7);
                getdata.inqday = cursor.getInt(8);
                getdata.inqhour = cursor.getInt(9);
                getdata.inqmsg = cursor.getString(10);
                DataList.add(getdata);
            }
            for (int i = 0; i < DataList.size(); ++i) {
                if (((ScheduleData)DataList.get((int)i)).inqttype.equals("moon")) {
                    int Stday;
                    int Stmonth;
                    int Styear;
                    String lunarDay;
                    if (((ScheduleData)DataList.get((int)i)).inqctype.equals("month")) {
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", year, month, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)"API", (String)(year + "." + month + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                            continue;
                        }
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        if (day != Stday) continue;
                        ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                        ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                        ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                        ReturnList.add((ScheduleData)DataList.get(i));
                        continue;
                    }
                    if (((ScheduleData)DataList.get((int)i)).inqctype.equals("year")) {
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", year, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)"API", (String)(year + "." + month + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                            continue;
                        }
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        if (month != Stmonth || day != Stday) continue;
                        ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                        ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                        ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                        ReturnList.add((ScheduleData)DataList.get(i));
                        continue;
                    }
                    lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", ((ScheduleData)DataList.get((int)i)).inqyear, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                    if (lunarDay == null) {
                        Log.e((String)"API", (String)(year + "." + month + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                        continue;
                    }
                    Styear = 0;
                    Stmonth = 0;
                    Stday = 0;
                    Styear = Integer.parseInt(lunarDay.substring(0, 4));
                    Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                    Stday = Integer.parseInt(lunarDay.substring(6, 8));
                    if (month != Stmonth || year != Styear || day != Stday) continue;
                    ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                    ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                    ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqctype.equals("month")) {
                    if (day != ((ScheduleData)DataList.get((int)i)).inqday) continue;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqctype.equals("year")) {
                    if (((ScheduleData)DataList.get((int)i)).inqmonth != month || day != ((ScheduleData)DataList.get((int)i)).inqday) continue;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqyear != year || ((ScheduleData)DataList.get((int)i)).inqmonth != month || day != ((ScheduleData)DataList.get((int)i)).inqday) continue;
                ReturnList.add((ScheduleData)DataList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ReturnList;
    }

    public List<ScheduleData> getScheduledInfoforMainActivity() {
        ArrayList<ScheduleData> DataList = new ArrayList<ScheduleData>();
        ArrayList<ScheduleData> ReturnList = new ArrayList<ScheduleData>();
        Calendar todayCal = Calendar.getInstance();
        Calendar tomorrowCal = Calendar.getInstance();
        tomorrowCal.add(5, 1);
        int todayYear = todayCal.get(1);
        int todayMonth = todayCal.get(2) + 1;
        int todayDay = todayCal.get(5);
        int tomorrowYear = tomorrowCal.get(1);
        int tomorrowMonth = tomorrowCal.get(2) + 1;
        int tomorrowDay = tomorrowCal.get(5);
        try {
            String query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqyear, inqmonth, inqday, inqhour, inqmsg from ScheduleDB order by seqnum asc;";
            Cursor cursor = this.wdb.rawQuery(query, null);
            while (cursor.moveToNext()) {
                ScheduleData getdata = new ScheduleData();
                getdata.seqnum = cursor.getInt(0);
                getdata.inqnum = 0;
                getdata.inqttype = cursor.getString(2);
                getdata.inqctype = cursor.getString(3);
                getdata.inqatype = cursor.getString(4);
                getdata.inqitype = cursor.getString(5);
                getdata.inqyear = cursor.getInt(6);
                getdata.inqmonth = cursor.getInt(7);
                getdata.inqday = cursor.getInt(8);
                getdata.inqhour = cursor.getInt(9);
                getdata.inqmsg = cursor.getString(10);
                DataList.add(getdata);
            }
            for (int i = 0; i < DataList.size(); ++i) {
                if (((ScheduleData)DataList.get((int)i)).inqttype.equals("moon")) {
                    int Stday;
                    int Stmonth;
                    int Styear;
                    String lunarDay;
                    if (((ScheduleData)DataList.get((int)i)).inqctype.equals("month")) {
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", todayYear, todayMonth, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)this.TAG, (String)(todayYear + "." + todayMonth + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                        } else {
                            Styear = 0;
                            Stmonth = 0;
                            Stday = 0;
                            Styear = Integer.parseInt(lunarDay.substring(0, 4));
                            Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                            Stday = Integer.parseInt(lunarDay.substring(6, 8));
                            if (todayDay == Stday) {
                                ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                                ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                                ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                                ReturnList.add((ScheduleData)DataList.get(i));
                            }
                        }
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", tomorrowYear, tomorrowMonth, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)this.TAG, (String)(tomorrowYear + "." + tomorrowMonth + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                            continue;
                        }
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        if (tomorrowDay != Stday) continue;
                        ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                        ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                        ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                        ReturnList.add((ScheduleData)DataList.get(i));
                        continue;
                    }
                    if (((ScheduleData)DataList.get((int)i)).inqctype.equals("year")) {
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", todayYear, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)this.TAG, (String)(todayYear + "." + todayMonth + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                        } else {
                            Styear = 0;
                            Stmonth = 0;
                            Stday = 0;
                            Styear = Integer.parseInt(lunarDay.substring(0, 4));
                            Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                            Stday = Integer.parseInt(lunarDay.substring(6, 8));
                            if (todayMonth == Stmonth && todayDay == Stday) {
                                ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                                ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                                ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                                ReturnList.add((ScheduleData)DataList.get(i));
                            }
                        }
                        lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", tomorrowYear, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                        if (lunarDay == null) {
                            Log.e((String)this.TAG, (String)(tomorrowYear + "." + tomorrowMonth + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                            continue;
                        }
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        if (todayMonth != Stmonth || todayDay != Stday) continue;
                        ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                        ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                        ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                        ReturnList.add((ScheduleData)DataList.get(i));
                        continue;
                    }
                    lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", ((ScheduleData)DataList.get((int)i)).inqyear, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                    if (lunarDay == null) {
                        Log.e((String)this.TAG, (String)(todayYear + "." + todayMonth + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                    } else {
                        Styear = 0;
                        Stmonth = 0;
                        Stday = 0;
                        Styear = Integer.parseInt(lunarDay.substring(0, 4));
                        Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                        Stday = Integer.parseInt(lunarDay.substring(6, 8));
                        if (todayMonth == Stmonth && todayYear == Styear && todayDay == Stday) {
                            ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                            ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                            ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                            ReturnList.add((ScheduleData)DataList.get(i));
                        }
                    }
                    lunarDay = this.GetSolarDate(String.format("%04d%02d%02d", ((ScheduleData)DataList.get((int)i)).inqyear, ((ScheduleData)DataList.get((int)i)).inqmonth, ((ScheduleData)DataList.get((int)i)).inqday));
                    if (lunarDay == null) {
                        Log.e((String)this.TAG, (String)(tomorrowYear + "." + tomorrowMonth + "." + ((ScheduleData)DataList.get((int)i)).inqday + " is not exist in Moon Table"));
                        continue;
                    }
                    Styear = 0;
                    Stmonth = 0;
                    Stday = 0;
                    Styear = Integer.parseInt(lunarDay.substring(0, 4));
                    Stmonth = Integer.parseInt(lunarDay.substring(4, 6));
                    Stday = Integer.parseInt(lunarDay.substring(6, 8));
                    if (todayMonth != Stmonth || todayYear != Styear || todayDay != Stday) continue;
                    ((ScheduleData)DataList.get((int)i)).inqyear = Styear;
                    ((ScheduleData)DataList.get((int)i)).inqmonth = Stmonth;
                    ((ScheduleData)DataList.get((int)i)).inqday = Stday;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqctype.equals("month")) {
                    if (todayDay == ((ScheduleData)DataList.get((int)i)).inqday) {
                        ReturnList.add((ScheduleData)DataList.get(i));
                    }
                    if (tomorrowDay != ((ScheduleData)DataList.get((int)i)).inqday) continue;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqctype.equals("year")) {
                    if (((ScheduleData)DataList.get((int)i)).inqmonth == todayMonth && todayDay == ((ScheduleData)DataList.get((int)i)).inqday) {
                        ReturnList.add((ScheduleData)DataList.get(i));
                    }
                    if (((ScheduleData)DataList.get((int)i)).inqmonth != tomorrowMonth || tomorrowDay != ((ScheduleData)DataList.get((int)i)).inqday) continue;
                    ReturnList.add((ScheduleData)DataList.get(i));
                    continue;
                }
                if (((ScheduleData)DataList.get((int)i)).inqyear == todayYear && ((ScheduleData)DataList.get((int)i)).inqmonth == todayMonth && todayDay == ((ScheduleData)DataList.get((int)i)).inqday) {
                    ReturnList.add((ScheduleData)DataList.get(i));
                }
                if (((ScheduleData)DataList.get((int)i)).inqyear != tomorrowYear || ((ScheduleData)DataList.get((int)i)).inqmonth != tomorrowMonth || tomorrowDay != ((ScheduleData)DataList.get((int)i)).inqday) continue;
                ReturnList.add((ScheduleData)DataList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)this.TAG, (String)"[Exception] getScheduledInfoforMainActivity(Calendar todayCal)");
            return null;
        }
        return ReturnList;
    }

    public List<ScheduleData> GetScheduleData(int year, int month) {
        ScheduleData getdata;
        int Edday;
        int Edmonth;
        int Edyear;
        int Stday;
        int Stmonth;
        int Styear;
        String query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqday, inqhour, inqmsg from ScheduleDB where inqyear = " + year + " AND inqmonth = " + month + " order by seqnum asc;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        this.ScData.clear();
        while (cursor.moveToNext()) {
            ScheduleData getdata2 = new ScheduleData();
            getdata2.inqttype = cursor.getString(2);
            if (getdata2.inqttype.equals("moon")) continue;
            getdata2.seqnum = cursor.getInt(0);
            getdata2.inqnum = 0;
            getdata2.inqctype = cursor.getString(3);
            getdata2.inqatype = cursor.getString(4);
            getdata2.inqitype = cursor.getString(5);
            getdata2.inqday = cursor.getInt(6);
            getdata2.inqhour = cursor.getInt(7);
            getdata2.inqmsg = cursor.getString(8);
            getdata2.inqyear = year;
            getdata2.inqmonth = month;
            this.ScData.add(getdata2);
        }
        cursor.close();
        GregorianCalendar Cal = new GregorianCalendar();
        Cal.set(2, month);
        Cal.set(5, 1);
        ((Calendar)Cal).add(5, -1);
        String StartlunarDay = this.GetLunarDate(String.format("%04d%02d%02d", year, month, 1));
        String EndlunarDay = this.GetLunarDate(String.format("%04d%02d%02d", year, Cal.get(2) + 1, Cal.get(5)));
        try {
            Styear = Integer.parseInt(StartlunarDay.substring(0, 4));
            Stmonth = Integer.parseInt(StartlunarDay.substring(4, 6));
            Stday = Integer.parseInt(StartlunarDay.substring(6, 8));
            Edyear = Integer.parseInt(EndlunarDay.substring(0, 4));
            Edmonth = Integer.parseInt(EndlunarDay.substring(4, 6));
            Edday = Integer.parseInt(EndlunarDay.substring(6, 8));
        }
        catch (Exception e) {
            e.printStackTrace();
            ContentValues values = new ContentValues();
            for (int i = 0; i < this.ScData.size(); ++i) {
                ScheduleData getdata3 = this.ScData.get(i);
                values.put("inqnum", Integer.valueOf(getdata3.inqnum));
                String condi = "seqnum = " + getdata3.seqnum;
                this.wdb.update("ScheduleDB", values, condi, null);
            }
            return this.ScData;
        }
        query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqday, inqhour, inqmsg, inqyear, inqmonth from ScheduleDB where ";
        query = Styear != Edyear ? query + "(inqyear = " + Styear + " OR inqyear = " + Edyear + ") AND " : query + "inqyear = " + Styear + " AND ";
        query = Stmonth != Edmonth ? query + "(inqmonth = " + Stmonth + " OR inqmonth = " + Edmonth + " ) order by seqnum asc;" : query + "inqmonth = " + month + " order by seqnum asc;";
        Log.w((String)"API", (String)("\uc77c\uc815 \uc74c\ub825 \uac80\uc0c9  Query : " + query));
        cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            getdata = new ScheduleData();
            getdata.inqttype = cursor.getString(2);
            if (getdata.inqttype.equals("sun")) continue;
            getdata.inqday = cursor.getInt(6);
            getdata.inqyear = cursor.getInt(9);
            getdata.inqmonth = cursor.getInt(10);
            if (getdata.inqmonth == Stmonth && getdata.inqday < Stday || getdata.inqmonth == Edmonth && getdata.inqday > Edday) continue;
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = 0;
            getdata.inqctype = cursor.getString(3);
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            this.ScData.add(getdata);
        }
        query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqday, inqhour, inqmsg, inqyear, inqmonth from ScheduleDB where (inqctype = \"year\" AND inqmonth = " + month + ") OR (inqctype = \"month\") order by seqnum asc";
        Log.w((String)"API", (String)("\uc591\ub825 \uc8fc\uae30 \uac80\uc0c9  Query : " + query));
        cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            getdata = new ScheduleData();
            getdata.inqttype = cursor.getString(2);
            if (getdata.inqttype.equals("moon")) continue;
            getdata.inqday = cursor.getInt(6);
            getdata.inqyear = cursor.getInt(9);
            getdata.inqmonth = cursor.getInt(10);
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = 0;
            getdata.inqctype = cursor.getString(3);
            if (getdata.inqctype.equals("year") && getdata.inqyear == year || getdata.inqmonth == month) continue;
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            this.ScData.add(getdata);
        }
        query = "select seqnum, inqnum, inqttype,  inqctype, inqatype, inqitype, inqday, inqhour, inqmsg, inqyear, inqmonth from ScheduleDB where ";
        query = query + "( inqctype = \"year\" AND ";
        query = Stmonth != Edmonth ? query + "(inqmonth = " + Stmonth + " OR inqmonth = " + Edmonth + " )) OR inqctype = \"month\" order by seqnum asc;" : query + "inqmonth = " + month + " ) OR inqctype = \"month\" order by seqnum asc;";
        Log.w((String)"API", (String)("\uc77c\uc815 \uc74c\ub825 \uc8fc\uae30 \uac80\uc0c9  Query : " + query));
        cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            getdata = new ScheduleData();
            getdata.inqttype = cursor.getString(2);
            if (getdata.inqttype.equals("sun")) continue;
            getdata.inqday = cursor.getInt(6);
            getdata.inqyear = cursor.getInt(9);
            getdata.inqmonth = cursor.getInt(10);
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = 0;
            getdata.inqctype = cursor.getString(3);
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            if (this.ScData.contains(getdata)) continue;
            this.ScData.add(getdata);
        }
        ContentValues values = new ContentValues();
        for (int i = 0; i < this.ScData.size(); ++i) {
            ScheduleData getdata4 = this.ScData.get(i);
            getdata4.inqnum = i + 1;
            this.ScData.set(i, getdata4);
            values.put("inqnum", Integer.valueOf(getdata4.inqnum));
            String condi = "seqnum = " + getdata4.seqnum;
            this.wdb.update("ScheduleDB", values, condi, null);
            Log.w((String)"API", (String)("GetScheduleData Year : " + getdata4.inqyear + " Month : " + getdata4.inqmonth + " day : " + getdata4.inqday + " Ctype : " + getdata4.inqctype));
        }
        return this.ScData;
    }

    public void AddSchedule(ScheduleData data) {
        ContentValues values = new ContentValues();
        values.put("inqnum", Integer.valueOf(data.inqnum));
        values.put("inqttype", data.inqttype);
        values.put("inqctype", data.inqctype);
        values.put("inqatype", data.inqatype);
        values.put("inqitype", data.inqitype);
        values.put("inqyear", Integer.valueOf(data.inqyear));
        values.put("inqmonth", Integer.valueOf(data.inqmonth));
        values.put("inqday", Integer.valueOf(data.inqday));
        values.put("inqhour", Integer.valueOf(data.inqhour));
        values.put("inqmsg", data.inqmsg);
        this.wdb.insert("ScheduleDB", null, values);
    }

    public void DeleteSchedule(ScheduleData data) {
        String query = "delete from ScheduleDB where inqyear = " + data.inqyear + " AND inqmonth = " + data.inqmonth + " AND inqday = " + data.inqday + " AND inqhour = " + data.inqhour + ";";
        this.wdb.execSQL(query);
    }

    public void UpdateSchedule(ScheduleData data) {
        ContentValues values = new ContentValues();
        values.put("inqnum", Integer.valueOf(data.inqnum));
        values.put("inqttype", data.inqttype);
        values.put("inqctype", data.inqctype);
        values.put("inqatype", data.inqatype);
        values.put("inqitype", data.inqitype);
        values.put("inqyear", Integer.valueOf(data.inqyear));
        values.put("inqmonth", Integer.valueOf(data.inqmonth));
        values.put("inqday", Integer.valueOf(data.inqday));
        values.put("inqhour", Integer.valueOf(data.inqhour));
        values.put("inqmsg", data.inqmsg);
        String condi = "inqyear = " + data.inqyear + " AND inqmonth=" + data.inqmonth + " AND inqday=" + data.inqday;
        long ret = this.wdb.update("ScheduleDB", values, condi, null);
        if (ret > -1L) {
            return;
        }
        this.AddSchedule(data);
    }

    public List<ScheduleData> GetTodaySchedule() {
        ScheduleData getdata;
        GregorianCalendar Cal = new GregorianCalendar();
        int year = Cal.get(1);
        int month = Cal.get(2) + 1;
        int day = Cal.get(5);
        String query = "select seqnum, inqnum, inqttype, inqctype, inqatype, inqitype, inqday, inqhour, inqmsg from ScheduleDB where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " order by inqnum asc;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            getdata = new ScheduleData();
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = cursor.getInt(1);
            getdata.inqttype = cursor.getString(2);
            getdata.inqctype = cursor.getString(3);
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqday = cursor.getInt(6);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            getdata.inqyear = year;
            getdata.inqmonth = month;
            this.ScData.add(getdata);
        }
        cursor.close();
        query = "select seqnum, inqnum, inqttype, inqctype, inqatype, inqitype, inqday, inqhour, inqmsg from ScheduleDB where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + ++day + " AND inqatype = \"day\" order by inqnum asc;";
        cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            getdata = new ScheduleData();
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = cursor.getInt(1);
            getdata.inqttype = cursor.getString(2);
            getdata.inqctype = cursor.getString(3);
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqday = cursor.getInt(6);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            getdata.inqyear = year;
            getdata.inqmonth = month;
            this.ScData.add(getdata);
        }
        return this.ScData;
    }

    public List<ScheduleData> GetThisTimeSchedule(boolean before10) {
        String lunarDay;
        this.ScData.clear();
        GregorianCalendar Cal = new GregorianCalendar();
        if (before10) {
            ((Calendar)Cal).add(10, 1);
        }
        int year = Cal.get(1);
        int month = Cal.get(2) + 1;
        int day = Cal.get(5);
        int hour = Cal.get(11);
        String query = before10 ? " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype=\"min\" AND inqctype = \"no\" order by inqnum asc;" : " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype=\"intime\" AND inqctype = \"no\" order by inqnum asc;";
        this.GetScheduleByCondition(query);
        query = before10 ? " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype=\"min\" AND inqctype = \"year\" order by inqnum asc;" : " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype=\"intime\" AND inqctype = \"year\" order by inqnum asc;";
        this.GetScheduleByCondition(query);
        query = before10 ? " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype=\"min\" AND inqctype = \"month\" order by inqnum asc;" : " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype=\"intime\" AND inqctype = \"month\" order by inqnum asc;";
        this.GetScheduleByCondition(query);
        if (!before10) {
            ((Calendar)Cal).add(10, 1);
            hour = Cal.get(11);
            query = " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype = \"hour\" AND inqctype = \"no\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype = \"hour\" AND inqctype = \"year\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype = \"hour\" AND inqctype = \"month\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            ((Calendar)Cal).add(10, 23);
            day = Cal.get(5);
            hour = Cal.get(11);
            query = " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype = \"day\" AND inqctype = \"no\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype = \"day\" AND inqctype = \"year\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"sun\" AND inqatype = \"day\" AND inqctype = \"month\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
        }
        Cal = new GregorianCalendar();
        if (before10) {
            ((Calendar)Cal).add(10, 1);
        }
        if ((lunarDay = this.GetLunarDate(String.format("%04d%02d%02d", Cal.get(1), Cal.get(2) + 1, Cal.get(5)))) == null) {
            return this.ScData;
        }
        try {
            year = Integer.parseInt(lunarDay.substring(0, 4));
            month = Integer.parseInt(lunarDay.substring(4, 6));
            day = Integer.parseInt(lunarDay.substring(6, 8));
            hour = Cal.get(11);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.ScData;
        }
        query = before10 ? " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype=\"min\" AND inqctype = \"no\" order by inqnum asc;" : " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype=\"intime\" AND inqctype = \"no\" order by inqnum asc;";
        this.GetScheduleByCondition(query);
        query = before10 ? " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype=\"min\" AND inqctype = \"year\" order by inqnum asc;" : " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype=\"intime\" AND inqctype = \"year\" order by inqnum asc;";
        this.GetScheduleByCondition(query);
        query = before10 ? " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype=\"min\" AND inqctype = \"month\" order by inqnum asc;" : " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype=\"intime\" AND inqctype = \"month\" order by inqnum asc;";
        this.GetScheduleByCondition(query);
        if (!before10) {
            Cal = new GregorianCalendar();
            ((Calendar)Cal).add(10, 1);
            lunarDay = this.GetLunarDate(String.format("%04d%02d%02d", Cal.get(1), Cal.get(2) + 1, Cal.get(5)));
            if (lunarDay == null) {
                return this.ScData;
            }
            try {
                year = Integer.parseInt(lunarDay.substring(0, 4));
                month = Integer.parseInt(lunarDay.substring(4, 6));
                day = Integer.parseInt(lunarDay.substring(6, 8));
                hour = Cal.get(11);
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.ScData;
            }
            hour = Cal.get(11);
            query = " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype = \"hour\" AND inqctype = \"no\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype = \"hour\" AND inqctype = \"year\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype = \"hour\" AND inqctype = \"month\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            ((Calendar)Cal).add(10, 23);
            lunarDay = this.GetLunarDate(String.format("%04d%02d%02d", Cal.get(1), Cal.get(2) + 1, Cal.get(5)));
            if (lunarDay == null) {
                return this.ScData;
            }
            try {
                year = Integer.parseInt(lunarDay.substring(0, 4));
                month = Integer.parseInt(lunarDay.substring(4, 6));
                day = Integer.parseInt(lunarDay.substring(6, 8));
                hour = Cal.get(11);
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.ScData;
            }
            day = Cal.get(5);
            hour = Cal.get(11);
            query = " where inqyear = " + year + " AND inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype = \"day\" AND inqctype = \"no\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqmonth = " + month + " AND inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype = \"day\" AND inqctype = \"year\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
            query = " where inqday = " + day + " AND inqhour = " + hour + " AND inqttype = \"moon\" AND inqatype = \"day\" AND inqctype = \"month\" order by inqnum asc;";
            this.GetScheduleByCondition(query);
        }
        return this.ScData;
    }

    public void GetScheduleByCondition(String Condition) {
        String query = "select seqnum, inqnum, inqttype, inqctype, inqatype, inqitype, inqday, inqhour, inqmsg, inqyear, inqmonth from ScheduleDB " + Condition;
        Cursor cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            ScheduleData getdata = new ScheduleData();
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = cursor.getInt(1);
            getdata.inqttype = cursor.getString(2);
            getdata.inqctype = cursor.getString(3);
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqday = cursor.getInt(6);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            getdata.inqyear = cursor.getInt(9);
            getdata.inqmonth = cursor.getInt(10);
            this.ScData.add(getdata);
        }
        cursor.close();
    }

    public List<ScheduleData> GetScheduleByCtype(boolean isYear) {
        ArrayList<ScheduleData> ReturnData = new ArrayList<ScheduleData>();
        String Qctype = isYear ? "year" : "month";
        String query = "select seqnum, inqnum, inqttype, inqctype, inqatype, inqitype, inqday, inqhour, inqmsg, inqyear, inqmonth from ScheduleDB where inqctype = \"" + Qctype + "\" order by seqnum asc;";
        Cursor cursor = this.wdb.rawQuery(query, null);
        while (cursor.moveToNext()) {
            ScheduleData getdata = new ScheduleData();
            getdata.seqnum = cursor.getInt(0);
            getdata.inqnum = cursor.getInt(1);
            getdata.inqttype = cursor.getString(2);
            getdata.inqctype = cursor.getString(3);
            getdata.inqatype = cursor.getString(4);
            getdata.inqitype = cursor.getString(5);
            getdata.inqday = cursor.getInt(6);
            getdata.inqhour = cursor.getInt(7);
            getdata.inqmsg = cursor.getString(8);
            getdata.inqyear = cursor.getInt(9);
            getdata.inqmonth = cursor.getInt(10);
            ReturnData.add(getdata);
        }
        cursor.close();
        return ReturnData;
    }

    public static class ScheduleData {
        public int inqnum;
        public int seqnum;
        public String inqttype;
        public String inqctype;
        public String inqatype;
        public String inqitype;
        public int inqyear;
        public int inqmonth;
        public int inqday;
        public int inqhour;
        public String inqmsg;
    }
}

